/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class SoundPlayer {
    static final byte INTRO_SOUND = 0;
    static final byte RIGHT_SOUND = 1;
    static String[] m_strArrsounds = new String[]{"/funny3.mid", "/RightJump.mid"};
    static String[] m_strArrSndType = new String[]{"audio/midi", "audio/midi"};
    static final int TOTAL_SOUNDS = m_strArrsounds.length;
    private static Player[] objPlyr = new Player[TOTAL_SOUNDS];
    public static InputStream[] objInputstream = new InputStream[TOTAL_SOUNDS];

    public static void InitialiseSounds() {
        for (int i = 0; i < TOTAL_SOUNDS; ++i) {
            try {
                SoundPlayer.objInputstream[i] = new Object().getClass().getResourceAsStream(m_strArrsounds[i]);
                SoundPlayer.objPlyr[i] = Manager.createPlayer((InputStream)objInputstream[i], (String)m_strArrSndType[i]);
                objPlyr[i].realize();
                objPlyr[i].prefetch();
                continue;
            }
            catch (Exception exception) {
                System.out.println("SoundPlayer.InitialiseSounds() error = " + exception);
            }
        }
        SoundPlayer.setVolumeControl(MenuScreen.intVol);
    }

    public static void playSound(int n) {
        try {
            SoundPlayer.stopSound(n);
            if (MainCanvas.soundON && objPlyr[n].getState() != 400) {
                SoundPlayer.stopSound(n);
                objPlyr[n].prefetch();
                objPlyr[n].start();
            }
        }
        catch (MediaException mediaException) {
            System.out.println("SoundPlayer.playSound(int i) error = " + (Object)((Object)mediaException));
        }
    }

    public static void playSound(int n, int n2) {
        try {
            SoundPlayer.stopSound(n);
            if (MainCanvas.soundON && objPlyr[n].getState() != 400) {
                SoundPlayer.stopSound(n);
                objPlyr[n].prefetch();
                objPlyr[n].setLoopCount(n2);
                objPlyr[n].start();
            }
        }
        catch (MediaException mediaException) {
            System.out.println("SoundPlayer.playSound(int i, int loopcount) error = " + (Object)((Object)mediaException));
        }
    }

    public static void setVolumeControl(int n) {
        try {
            for (int i = 0; i < TOTAL_SOUNDS; ++i) {
                if (objPlyr[i] == null) continue;
                VolumeControl volumeControl = (VolumeControl)objPlyr[i].getControl("VolumeControl");
                volumeControl.setLevel(n);
            }
        }
        catch (Exception exception) {
            System.out.println("SoundPlayer.setVolumeControl() error = " + exception);
        }
    }

    public static final boolean isPlaying(int n) {
        return objPlyr[n].getState() == 400;
    }

    public static void stopSound(int n) {
        try {
            objPlyr[n].stop();
        }
        catch (Exception exception) {
            System.out.println("SoundPlayer.stopSound() error = " + exception);
        }
    }

    public static void stopSounds() {
        try {
            for (int i = 0; i < TOTAL_SOUNDS; ++i) {
                objPlyr[i].stop();
            }
        }
        catch (Exception exception) {
            System.out.println("SoundPlayer.stopSounds() error = " + exception);
        }
    }

    public static void stopAllSounds() {
        try {
            for (int i = 0; i < TOTAL_SOUNDS; ++i) {
                objPlyr[i].stop();
                objPlyr[i].deallocate();
                objPlyr[i].close();
                SoundPlayer.objPlyr[i] = null;
            }
        }
        catch (Exception exception) {
            System.out.println("SoundPlayer.stopAllSounds() error = " + exception);
        }
    }
}

