/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;

class SoundBank {
    public static final int NO_SOUND_AVAILABLE = -1;
    public static final int AMT_FILE_FORMATS = 5;
    public static final String[] SOUND_FILE_FORMAT = new String[]{".mid", ".wav", ".qcp", ".mmf", ".amr"};
    public static final String[] SOUND_TYPE = new String[]{"audio/midi", "audio/x-wav", "audio/vnd.qcelp", "audio/x-mmf", "audio/amr"};
    public static final int SOUND_NONE = -1;
    public static int[] soundTypes;
    private static String[] soundBank;

    public SoundBank(String[] stringArray) {
        soundBank = stringArray;
    }

    public String getSound(int n) {
        int n2 = -1;
        if (soundBank[n] == null) {
            return null;
        }
        if (soundBank[n].indexOf(46) != -1) {
            return soundBank[n];
        }
        n2 = this.findFileType(soundBank[n]);
        if (n2 == -1) {
            SoundBank.soundBank[n] = null;
            return null;
        }
        SoundBank.soundBank[n] = soundBank[n] + SOUND_FILE_FORMAT[n2];
        return soundBank[n];
    }

    public int getNumberOfSounds() {
        return 8;
    }

    public int getNumberOfTunes() {
        return 1;
    }

    public String getTune(int n) {
        return this.getSound(n);
    }

    public byte[] getSoundData(int n) {
        return null;
    }

    public int findFileType(String string) {
        if (string == null) {
            return -1;
        }
        for (int i = 0; i < 5; ++i) {
            try {
                InputStream inputStream = this.getClass().getResourceAsStream(string + SOUND_FILE_FORMAT[i]);
                if (inputStream == null) continue;
                inputStream.close();
                inputStream = null;
                return i;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }

    public String getSoundMIMEType(int n) {
        int n2 = -1;
        if (soundBank[n].indexOf(46) != -1) {
            for (int i = 0; i < 5; ++i) {
                if (!soundBank[n].endsWith(SOUND_FILE_FORMAT[i])) continue;
                return SOUND_TYPE[i];
            }
        } else {
            n2 = this.findFileType(soundBank[n]);
            if (n2 == -1) {
                return null;
            }
            return SOUND_TYPE[n2];
        }
        return null;
    }
}

