/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreNotFoundException;

public class Frontend
implements data,
Constants {
    private static int lang;
    private static boolean[] langAvailable;
    private static int numLanguagesAvailable;
    public static int currentTune;
    static boolean startDelayedTune;
    static long tuneResumeTime;
    private static final int TUNE_DELAY_TIME = 3000;
    private static boolean bHasIntroTune;
    private static int introSplashLoadCount;
    static byte storyLevel;
    public static boolean bEnGBUSswapped;
    private static int shake;
    private static long lastSFXTime;
    static int editIdx;
    static int editingScore;
    private static final String saveName = "hulksave";
    static boolean soundFlag;
    private static char[][] hiscoreName;
    private static int[] hiscoreVal;
    private static char[] lastInitials;
    private static final String hiscoreAllowed = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.*!?";
    private static short loadCount;
    private static final String[] imageNames;
    private static final int NUM_IMGS;
    public static Image[] images;
    private static final byte[][] loadData;
    public static long tuneRestartDelay;
    public static long screenDelay;
    public static int currentScreen;
    private static int currentOption;
    private static int topOption;
    private static int screenTitle;
    private static int numViewableMenuItems;
    public static Font fontSys;
    public static Font fontSysSmall;
    public static short[][] paragraphOffsets;
    public static int fontS_H;
    public static int fontM_H;
    public static int fontH;
    public static int numParagraphStrings;
    static String paragraphString;
    static int paragraphStringWidth;
    public static boolean redrawOnScreenText;
    private static int[] menuStrings;
    private static int paragraphY;
    private static int paragraphLimit;
    private static boolean isScrollablePage;
    private static boolean upArrow;
    private static boolean downArrow;
    private static String lskStr;
    private static String rskStr;
    private static boolean wasPaused;
    public static String exitURL;
    private static boolean handsonExit;
    static String[] tileNames;
    private static int titleH;
    private static boolean beFlag;
    private static int helpOption;
    static boolean fePaused;
    private static int[] selectableLevels;
    private static boolean presetFE;

    public static void init() {
        fePaused = false;
        tuneRestartDelay = 0L;
        Frontend.initHandson(false);
    }

    static void initFonts() {
        fontSys = Font.getFont((int)0, (int)0, (int)0);
        fontH = fontSys.getHeight();
        fontM_H = fontSys.getHeight();
        fontSysSmall = Font.getFont((int)0, (int)0, (int)8);
        fontS_H = fontSysSmall.getHeight();
    }

    static void selectPress() {
    }

    public static void process() {
        if (fePaused) {
            redrawOnScreenText = true;
            Game.refreshFrontEndScreenGFX = true;
            if (Game.readPad(0x200000)) {
                fePaused = false;
                if (Game.bWatchdog) {
                    Game.clearPad();
                }
                if (bHasIntroTune) {
                    Frontend.playMusic(0);
                }
            }
        } else if (currentScreen == 55) {
            int n = langAvailable.length;
            if (Game.readPad(8196)) {
                do {
                    if (--lang >= 0) continue;
                    lang = n - 1;
                } while (!langAvailable[lang]);
                Game.refreshFrontEndScreenGFX = true;
                redrawOnScreenText = true;
            } else if (Game.readPad(33024)) {
                do {
                    if (++lang < n) continue;
                    lang = 0;
                } while (!langAvailable[lang]);
                Game.refreshFrontEndScreenGFX = true;
                redrawOnScreenText = true;
            } else if (Game.readPad(0x201020)) {
                Game.bab_init("/language", null, lang);
                Frontend.initMarvelScreen();
            }
        } else {
            Frontend.processMenu();
            switch (currentScreen) {
                case 54: {
                    if (!Game.readPad(0x280000)) break;
                    soundFlag = Game.padPressed(0x201020);
                    Frontend.selectPress();
                    Frontend.initScrMain(9);
                    break;
                }
                case 14: {
                    if (Game.readPad(0x200000) && Game.buymoreURL != null) {
                        Game.running = false;
                        exitURL = Game.buymoreURL;
                        break;
                    }
                    if (Game.currentMillisecs - screenDelay <= 5000L && !Game.readPad(524288)) break;
                    Frontend.initHandson(true);
                    break;
                }
                case 6: {
                    if (!Game.readPad(524288)) break;
                    Frontend.initScrHelpChoice(helpOption);
                    break;
                }
                case 52: {
                    Game.refreshFrontEndScreenGFX = true;
                    if (loadCount == 0) {
                        Frontend.loadImage(0);
                        loadCount = (short)(loadCount + 1);
                        break;
                    }
                    if (Game.currentMillisecs - screenDelay <= 2000L) break;
                    Frontend.initSplash();
                    break;
                }
                case 9: {
                    if (Game.readPad(524288)) {
                        Frontend.initScrMain(9);
                        break;
                    }
                    if (!Game.readPad(0x201020)) break;
                    Frontend.selectPress();
                    Game.currentLevel = Game.cheatActive ? currentOption : selectableLevels[currentOption];
                    System.gc();
                    Frontend.initScrLoading();
                    break;
                }
                case 53: {
                    if (loadCount == 0) {
                        Game.getJADParameters();
                        Game.initAttackPosTab();
                        Frontend.readSaveGame();
                        Hulk2.snd.loadSounds();
                        bHasIntroTune = SoundPlayer.bHasIntroTune;
                        Frontend.loadImage(4);
                        Frontend.loadImage(6);
                        Frontend.loadImage(7);
                        Frontend.loadImage(20);
                        Frontend.preCalcFE();
                        loadCount = (short)(loadCount + 1);
                        break;
                    }
                    if (Game.currentMillisecs - screenDelay <= 3000L) break;
                    Frontend.images[2] = null;
                    Frontend.images[0] = null;
                    Frontend.images[1] = null;
                    System.gc();
                    Frontend.initSoundQuestion();
                    break;
                }
                case 51: {
                    if (!presetFE) {
                        Frontend.initFonts();
                        Game.loadDataFiles();
                        presetFE = true;
                    }
                    if (Game.readPad(0x200000) && handsonExit && Game.buymoreOnExit && !Game.buymoreForceOff && Game.fullVersion) {
                        Game.running = false;
                        exitURL = Game.buymoreURL;
                    } else if (Game.readPad(524288) && handsonExit && Game.buymoreOnExit && !Game.buymoreForceOff && Game.fullVersion) {
                        Game.running = false;
                    }
                    if (handsonExit) {
                        if (Game.currentMillisecs - screenDelay <= 3500L) break;
                        Game.running = false;
                        break;
                    }
                    if (Game.currentMillisecs - screenDelay <= 2000L) break;
                    int n = Frontend.checkForceLocale();
                    if (n >= 0) {
                        Game.bab_init("/language", null, n);
                        Frontend.initMarvelScreen();
                        break;
                    }
                    lang = 0;
                    while (!langAvailable[lang]) {
                        ++lang;
                    }
                    fePaused = false;
                    currentScreen = 55;
                    Game.refreshFrontEndScreenGFX = true;
                    redrawOnScreenText = true;
                    break;
                }
                case 3: {
                    if (Game.readPad(524288)) {
                        if (beFlag) {
                            Frontend.initScrPause(10);
                            break;
                        }
                        Frontend.initScrMain(10);
                        break;
                    }
                    if (!Game.readPad(0x201020)) break;
                    switch (currentOption) {
                        case 0: {
                            Game.refreshFrontEndScreenGFX = true;
                            redrawOnScreenText = true;
                            boolean bl = soundFlag = !soundFlag;
                            if (soundFlag) {
                                Frontend.playMusic(0);
                                Frontend.menuStrings[0] = 28;
                            } else {
                                Frontend.stopAllSounds();
                                Frontend.menuStrings[0] = 29;
                            }
                            Frontend.writeSaveGame();
                            break;
                        }
                        case 1: {
                            Frontend.splitText(Game.dictionary(110), Game.canvasWidth, 0);
                            Frontend.screenDefault(15, 18, 19, 109);
                        }
                    }
                    Frontend.selectPress();
                    break;
                }
                case 4: 
                case 5: {
                    Frontend.processScrHiscore();
                    break;
                }
                case 12: {
                    if (!Game.readPad(0x201020)) break;
                    Frontend.selectPress();
                    Frontend.initScrMain(9);
                    break;
                }
                case 13: {
                    if (Game.readPad(524288)) {
                        System.gc();
                        if (beFlag) {
                            Frontend.initScrPause(12);
                            break;
                        }
                        Frontend.initScrMain(12);
                        break;
                    }
                    if (!Game.readPad(0x201020)) break;
                    Frontend.selectPress();
                    helpOption = currentOption;
                    Frontend.initScrHelp(currentOption);
                    break;
                }
                case 1: {
                    if (!Game.fullVersion) {
                        redrawOnScreenText = true;
                        Game.refreshFrontEndScreenGFX = true;
                    }
                    if (!Game.readPad(0x201020)) break;
                    Frontend.selectPress();
                    int n = menuStrings[currentOption];
                    if (n == 9) {
                        if (Game.cheatActive || Game.fullVersion && storyLevel > 1) {
                            Frontend.initScrLevelSelect();
                            break;
                        }
                        Game.currentLevel = 0;
                        Frontend.initScrLoading();
                        break;
                    }
                    if (n == 10) {
                        Frontend.initScrOptions(0);
                        break;
                    }
                    if (n == 11) {
                        Frontend.initScrHiscore(false);
                        break;
                    }
                    if (n == 12) {
                        Frontend.initScrHelpChoice(0);
                        break;
                    }
                    if (n == 13) {
                        Frontend.initScrAbout();
                        break;
                    }
                    if (n == 14) {
                        Frontend.splitText(Game.dictionary(34), Game.canvasWidth, 0);
                        Frontend.screenDefault(8, 18, 19, 4);
                        break;
                    }
                    if (n != 43) break;
                    Frontend.initScrBuyMore();
                    break;
                }
                case 10: {
                    if (!Game.readPad(0x201020)) break;
                    Frontend.selectPress();
                    int n = menuStrings[currentOption];
                    if (n == 10) {
                        Frontend.initScrOptions(0);
                        break;
                    }
                    if (n == 12) {
                        Frontend.initScrHelpChoice(0);
                        break;
                    }
                    if (n == 22) {
                        Game.unpauseGame();
                        break;
                    }
                    if (n != 23) break;
                    Frontend.screenDefault(11, 18, 19, 23);
                    Frontend.splitText(Game.dictionary(81), Game.canvasWidth, 0);
                    break;
                }
                case 7: {
                    Frontend.processAbout();
                    break;
                }
                case 11: {
                    if (Game.readPad(524288)) {
                        Frontend.initScrPause(23);
                        break;
                    }
                    if (!Game.readPad(0x200000)) break;
                    Frontend.initScrMain(9);
                    break;
                }
                case 2: {
                    if (Game.readPad(524288)) {
                        Frontend.initScrMain(43);
                        break;
                    }
                    if (!Game.readPad(0x200000)) break;
                    Game.running = false;
                    exitURL = Game.buymoreURL;
                    break;
                }
                case 8: {
                    if (Game.readPad(524288)) {
                        Frontend.initScrMain(14);
                        break;
                    }
                    if (!Game.readPad(0x200000)) break;
                    if (Game.fullVersion) {
                        Frontend.initHandson(true);
                        break;
                    }
                    Frontend.initBuyFullScreen();
                    break;
                }
                case 15: {
                    if (Game.readPad(524288)) {
                        Frontend.initScrOptions(1);
                        break;
                    }
                    if (!Game.readPad(0x200000)) break;
                    Frontend.setSaveGameDefaults();
                    Frontend.writeSaveGame();
                    Frontend.initScrOptions(1);
                    break;
                }
                case 50: {
                    Game.refreshFrontEndScreenGFX = true;
                    redrawOnScreenText = true;
                    if (loadCount < loadData[Game.currentLevel].length) {
                        byte by = loadData[Game.currentLevel][loadCount];
                        if (by == 127) {
                            boolean bl = Game.loadMap();
                        } else if (by == 5) {
                            if (images[5] != null) {
                                Frontend.images[5] = null;
                                System.gc();
                            }
                            try {
                                Frontend.images[5] = Game.create_image("/" + tileNames[Game.currentLevel] + "16x16.png");
                                boolean bl = true;
                            }
                            catch (Exception exception) {
                                boolean bl = false;
                            }
                        } else {
                            boolean bl = Frontend.loadImage(by);
                        }
                        loadCount = (short)(loadCount + 1);
                        break;
                    }
                    Game.initLevel();
                }
            }
            if (isScrollablePage) {
                if (downArrow && Game.padPressed(33024)) {
                    paragraphY -= 8;
                    Game.refreshFrontEndScreenGFX = true;
                    redrawOnScreenText = true;
                } else if (upArrow && Game.padPressed(8196)) {
                    paragraphY += 8;
                    Game.refreshFrontEndScreenGFX = true;
                    redrawOnScreenText = true;
                }
                if (Game.padPressed(0x800000)) {
                    Game.clearPad();
                }
            }
        }
    }

    private static void initSplash() {
        currentScreen = 53;
        screenDelay = Game.currentMillisecs;
        Game.refreshFrontEndScreenGFX = true;
        loadCount = 0;
        if (images[0] == null) {
            Frontend.splitText(Game.dictionary(30), Game.canvasWidth - 2, 2);
        }
    }

    static void initScrBuyMore() {
        Frontend.screenDefault(2, 18, 19, -1);
        Frontend.splitText(Game.dictionary(26), Game.canvasWidth, 0);
    }

    public static void paint(Graphics graphics) {
        Game.setFullClip(graphics);
        if (fePaused) {
            Frontend.drawBG(graphics);
            Frontend.fontPrint(graphics, Game.dictionary(21), Game.hscrW, Game.canvasHeight - fontH >> 1, 17, 0);
        } else if (currentScreen == 55) {
            graphics.setClip(0, 0, Game.canvasWidth, Game.canvasHeight);
            graphics.setColor(1060896);
            graphics.fillRect(0, 0, Game.canvasWidth, Game.canvasHeight);
            int n = fontH + 2;
            int n2 = langAvailable.length;
            int n3 = Game.canvasHeight - fontH - n * numLanguagesAvailable >> 1;
            if (n3 < 0) {
                n3 = 0;
            }
            for (int i = 0; i < n2; ++i) {
                if (!langAvailable[i]) continue;
                if (i == lang) {
                    graphics.setColor(8437824);
                    graphics.fillRect(0, n3 - 1, Game.canvasWidth, fontH + 2);
                }
                Game.babdialect = (byte)i;
                Frontend.fontPrint(graphics, Game.dictionary(1), Game.hscrW, n3, 17, 0);
                n3 += n;
            }
            Game.babdialect = (byte)lang;
            Frontend.fontPrint(graphics, Game.dictionary(2), 1, Game.canvasHeight - 1, 36, 2);
        } else {
            switch (currentScreen) {
                case 52: {
                    Game.setFullClip(graphics);
                    graphics.setColor(0);
                    graphics.fillRect(0, 0, Game.canvasWidth, Game.canvasHeight);
                    graphics.drawImage(images[2], Game.hscrW, Game.hscrH, 3);
                    break;
                }
                case 53: {
                    Game.setFullClip(graphics);
                    graphics.setColor(0);
                    graphics.fillRect(0, 0, Game.canvasWidth, Game.canvasHeight);
                    if (images[0] != null) {
                        if (Game.canvasHeight < images[0].getHeight()) {
                            graphics.drawImage(images[0], Game.hscrW, Game.canvasHeight, 33);
                            break;
                        }
                        graphics.drawImage(images[0], Game.hscrW, Game.canvasHeight >> 1, 3);
                        break;
                    }
                    Game.refreshFrontEndScreenGFX = true;
                    redrawOnScreenText = true;
                    int n = Game.canvasHeight - fontM_H * numParagraphStrings >> 1;
                    Frontend.fontPrintParagraph(graphics, Game.hscrW, n, 0, -1, 2);
                    break;
                }
                case 51: {
                    graphics.setClip(0, 0, Game.canvasWidth, Game.canvasHeight);
                    graphics.drawImage(Game.backBuffer, 0, 0, 20);
                    break;
                }
                case 1: 
                case 3: 
                case 9: 
                case 10: 
                case 13: {
                    Frontend.drawBG(graphics);
                    break;
                }
                case 12: {
                    Frontend.drawBG(graphics);
                    Frontend.fontPrint(graphics, Game.dictionary(15), Game.hscrW, Game.hscrH - 4, 33, 0);
                    Frontend.fontPrint(graphics, Integer.toString(Game.score), Game.hscrW, Game.hscrH + 4, 17, 0);
                    break;
                }
                case 2: 
                case 8: 
                case 11: 
                case 15: 
                case 54: {
                    Frontend.drawBG(graphics);
                    Frontend.fontPrintParagraph(graphics, Game.hscrW, Game.canvasHeight - numParagraphStrings * fontH >> 1, 0, -1, 0);
                    break;
                }
                case 4: 
                case 5: {
                    int n;
                    Frontend.drawBG(graphics);
                    int n4 = Game.canvasHeight - 5 * (fontH + 2) >> 1;
                    if (images[6] != null && n4 <= (n = images[6].getHeight())) {
                        n4 += 10;
                    }
                    int n5 = Game.canvasWidth >> 4;
                    for (n = 0; n < 5; ++n) {
                        if (n != editingScore) {
                            Frontend.fontPrint(graphics, String.valueOf(hiscoreName[n]), n5, n4, 20, 2);
                            Frontend.fontPrint(graphics, String.valueOf(hiscoreVal[n]), Game.canvasWidth - n5, n4, 24, 2);
                        } else {
                            int n6 = n5;
                            int n7 = Frontend.fontStringWidth("W", 0) + 2;
                            Frontend.fontPrint(graphics, String.valueOf(hiscoreVal[n]), Game.canvasWidth - n5, n4, 24, 2);
                            for (int i = 0; i < 3; ++i) {
                                if (i != currentOption || (Game.frameCount & 4) != 0) {
                                    Frontend.fontPrint(graphics, String.valueOf(hiscoreName[editingScore][i]), n6, n4, 20, 2);
                                }
                                if (i == currentOption) {
                                    Game.setFullClip(graphics);
                                    int n8 = n6 + 3;
                                    for (int j = 0; j < 4; ++j) {
                                        graphics.setColor(0xFFFFFF);
                                        graphics.fillRect(n8 - j, n4 - 5 + j, (j << 1) + 1, 1);
                                        graphics.setColor(0xFFFFFF);
                                        graphics.fillRect(n8 - j, n4 + fontM_H + 1 - j, (j << 1) + 1, 1);
                                    }
                                }
                                n6 += n7;
                            }
                        }
                        n4 += fontM_H + 4;
                    }
                    break;
                }
                case 6: 
                case 14: 
                case 56: {
                    Frontend.printParagraphPage(graphics, true);
                    break;
                }
                case 7: {
                    Frontend.printParagraphPage(graphics, false);
                    if (paragraphY <= paragraphLimit) break;
                    Frontend.drawDownArrow(graphics, Game.canvasHeight - 2);
                    break;
                }
                case 50: {
                    int n = Game.canvasHeight / 20;
                    int n9 = Game.canvasHeight - n >> 1;
                    int n10 = (Game.canvasWidth - 16 << 10) / loadData[Game.currentLevel].length;
                    n10 *= loadCount;
                    if ((n10 >>= 10) > Game.canvasWidth - 16 || loadCount == loadData[Game.currentLevel].length) {
                        n10 = Game.canvasWidth - 16;
                    }
                    Frontend.drawBG(graphics);
                    graphics.setColor(16770075);
                    graphics.drawRect(7, n9 - 1, Game.canvasWidth - 15, n + 1);
                    graphics.setColor(0xFFFFFF);
                    graphics.fillRect(8, n9, n10, n);
                }
            }
        }
        Game.setFullClip(graphics);
    }

    static void initSoundQuestion() {
        Frontend.screenDefault(54, 18, 19, -1);
        Frontend.splitText(Game.dictionary(104), Game.canvasWidth, 0);
    }

    private static void preCalcFE() {
        titleH = images[6] != null ? images[6].getHeight() : fontH + 2;
        for (int i = Game.canvasHeight - (titleH << 1) - 12 - (4 + fontH); i > 1 && numViewableMenuItems < 5; i -= 4) {
            if ((i -= fontH) <= 1) continue;
            ++numViewableMenuItems;
        }
    }

    private static void processMenu() {
        int n;
        if (menuStrings != null && (n = menuStrings.length) > 1) {
            if (Game.readPad(33024)) {
                if (!bHasIntroTune) {
                    Frontend.sfx(1);
                }
                Game.refreshFrontEndScreenGFX = true;
                redrawOnScreenText = true;
                if (currentOption == n - 1) {
                    currentOption = 0;
                    topOption = 0;
                } else if (++currentOption - topOption >= numViewableMenuItems) {
                    ++topOption;
                }
            } else if (Game.readPad(8196)) {
                if (!bHasIntroTune) {
                    Frontend.sfx(1);
                }
                Game.refreshFrontEndScreenGFX = true;
                redrawOnScreenText = true;
                if (currentOption == 0) {
                    currentOption = n - 1;
                    topOption = n - numViewableMenuItems;
                    if (topOption < 0) {
                        topOption = 0;
                    }
                } else if (--currentOption < topOption) {
                    --topOption;
                }
            }
        }
    }

    private static void drawMenu(Graphics graphics) {
        int n = Game.hscrW;
        int n2 = numViewableMenuItems;
        if (n2 > menuStrings.length) {
            n2 = menuStrings.length;
        }
        int n3 = Game.canvasHeight - (n2 - 1) * (4 + fontH) >> 1;
        if (menuStrings.length > 1) {
            Frontend.drawUpArrow(graphics, n3 - fontH - 6);
        }
        for (int i = 0; i < n2; ++i) {
            int n4 = i + topOption;
            Game.setFullClip(graphics);
            int n5 = 2;
            int n6 = 0;
            if (n4 == currentOption) {
                if (images[20] != null) {
                    graphics.drawImage(images[20], Game.hscrW, n3, 3);
                } else {
                    int n7 = fontH + 4;
                    graphics.setColor(8437824);
                    graphics.fillRect(0, n3 - (n7 >> 1), Game.canvasWidth, n7);
                }
                n5 = 0;
                n6 = 2;
            }
            Frontend.fontPrint(graphics, menuStrings[n4] == 43 ? Game.moreGamesText : Game.dictionary(menuStrings[n4]), n, n3 - n6, 3, n5);
            n3 += 4 + fontH;
        }
        if (menuStrings.length > 1) {
            Frontend.drawDownArrow(graphics, n3);
        }
    }

    private static void processScrHiscore() {
        if (currentScreen == 5) {
            redrawOnScreenText = true;
            Game.refreshFrontEndScreenGFX = true;
            if (Game.readPad(65552) && currentOption > 0) {
                editIdx = hiscoreAllowed.indexOf(hiscoreName[editingScore][--currentOption]);
            } else if (Game.readPad(16448) && currentOption < 2) {
                editIdx = hiscoreAllowed.indexOf(hiscoreName[editingScore][++currentOption]);
            } else if (Game.readPad(0x200000)) {
                Frontend.lastInitials[0] = hiscoreName[editingScore][0];
                Frontend.lastInitials[1] = hiscoreName[editingScore][1];
                Frontend.lastInitials[2] = hiscoreName[editingScore][2];
                Frontend.writeSaveGame();
                Frontend.initScrMain(9);
            } else if (Game.readPad(8196)) {
                editIdx = editIdx > 0 ? --editIdx : hiscoreAllowed.length() - 1;
                Frontend.hiscoreName[Frontend.editingScore][Frontend.currentOption] = hiscoreAllowed.charAt(editIdx);
            } else if (Game.readPad(33024)) {
                editIdx = editIdx < hiscoreAllowed.length() - 1 ? ++editIdx : 0;
                Frontend.hiscoreName[Frontend.editingScore][Frontend.currentOption] = hiscoreAllowed.charAt(editIdx);
            }
        } else if (Game.readPad(524288)) {
            Frontend.initScrMain(11);
        }
    }

    private static void initScrOptions(int n) {
        Frontend.screenDefault(3, 3, 17, 10);
        menuStrings = beFlag ? new int[]{soundFlag ? 28 : 29} : new int[]{soundFlag ? 28 : 29, 109};
        currentOption = n;
        Frontend.setTopOption();
    }

    private static void initScrHiscore(boolean bl) {
        if (bl) {
            Frontend.screenDefault(5, 22, -1, 82);
            editIdx = hiscoreAllowed.indexOf(hiscoreName[editingScore][0]);
            currentOption = 0;
        } else {
            editingScore = -1;
            Frontend.screenDefault(4, -1, 17, 11);
        }
    }

    private static void screenDefault(int n, int n2, int n3, int n4) {
        Game.refreshFrontEndScreenGFX = true;
        redrawOnScreenText = true;
        isScrollablePage = false;
        menuStrings = null;
        System.gc();
        screenTitle = n4;
        currentScreen = n;
        Game.clearPad();
        Game.gameState = 1;
        lskStr = n2 == -1 ? null : Game.dictionary(n2);
        rskStr = n3 == -1 ? null : Game.dictionary(n3);
        screenDelay = Game.currentMillisecs;
        topOption = 0;
    }

    private static void clearFE() {
        menuStrings = null;
        Game.lastTime = System.currentTimeMillis();
        Game.clearPad();
    }

    public static void initScrLoading() {
        Frontend.stopAllSounds();
        Frontend.screenDefault(50, -1, -1, 35);
        Frontend.clearFE();
        Frontend.clearImages();
        loadCount = 0;
    }

    private static void initScrHelp(int n) {
        Frontend.screenDefault(6, -1, 17, 12);
        String string = "";
        switch (n) {
            case 0: {
                string = Game.dictionary(94);
                break;
            }
            case 1: {
                string = Game.dictionary(36);
                break;
            }
            case 2: {
                string = Game.dictionary(95);
                string = string + Game.dictionary(96);
                string = string + Game.dictionary(97);
                if (Game.buymoreMenu && !Game.buymoreForceOff) {
                    string = string + "\n\n" + Game.moreGamesText + Game.dictionary(Game.fullVersion ? 99 : 103);
                }
                string = string + Game.dictionary(98);
            }
        }
        Frontend.splitText(string, Game.canvasWidth - 4, 2);
        paragraphY = titleH + 4;
        paragraphLimit = -(numParagraphStrings * fontM_H) + (Game.canvasHeight - titleH - 4);
    }

    static void initScrPause(int n) {
        Frontend.screenDefault(10, 3, -1, 21);
        menuStrings = new int[]{22, 10, 12, 23};
        currentOption = Frontend.findMenuOption(n);
        Frontend.setTopOption();
        beFlag = true;
    }

    private static void printParagraphPage(Graphics graphics, boolean bl) {
        isScrollablePage = bl;
        int n = Game.hscrW;
        int n2 = paragraphY;
        Game.setFullClip(graphics);
        Frontend.drawBGImage(graphics);
        redrawOnScreenText = true;
        Game.refreshFrontEndScreenGFX = true;
        Frontend.fontPrintParagraph(graphics, n, n2, 0, numParagraphStrings, 2);
        Frontend.drawTitleBars(graphics);
        if (currentScreen == 14) {
            Frontend.fontPrint(graphics, Game.moreGamesText, Game.hscrW, 2, 17, 0);
        } else if (screenTitle != -1) {
            Frontend.fontPrint(graphics, Game.dictionary(screenTitle), Game.hscrW, 2, 17, 0);
        }
        Frontend.softKeys(graphics);
        if (isScrollablePage) {
            upArrow = paragraphY < titleH + 2;
            boolean bl2 = downArrow = paragraphY > paragraphLimit;
            if (upArrow) {
                Frontend.drawUpArrow(graphics, Game.canvasHeight - 12 - 2);
            }
            if (downArrow) {
                Frontend.drawDownArrow(graphics, Game.canvasHeight - 2);
            }
        }
    }

    private static void drawUpArrow(Graphics graphics, int n) {
        graphics.setColor(0xFFFFFF);
        for (int i = 0; i < 6; ++i) {
            graphics.fillRect(Game.hscrW - i, n + i, (i << 1) + 1, 1);
        }
        graphics.setColor(0x606060);
        graphics.fillRect(Game.hscrW - 5, n + 6, 11, 1);
    }

    private static void drawDownArrow(Graphics graphics, int n) {
        graphics.setColor(0xFFFFFF);
        for (int i = 0; i < 6; ++i) {
            graphics.fillRect(Game.hscrW - i, n - i, (i << 1) + 1, 1);
        }
        graphics.setColor(0x606060);
        graphics.fillRect(Game.hscrW - 5, n - 6, 11, 1);
    }

    public static void initScrMain(int n) {
        Frontend.screenDefault(1, 3, -1, 8);
        Game.score = 0;
        Game.energy = 122880;
        beFlag = false;
        int n2 = 6;
        int n3 = 0;
        if (Game.moreGamesText == null) {
            Game.moreGamesText = Game.dictionary(Game.fullVersion ? 43 : 44);
        }
        if (Game.buymoreMenu && !Game.buymoreForceOff) {
            ++n2;
        }
        menuStrings = new int[n2];
        Frontend.menuStrings[n3++] = 9;
        Frontend.menuStrings[n3++] = 10;
        Frontend.menuStrings[n3++] = 11;
        Frontend.menuStrings[n3++] = 12;
        Frontend.menuStrings[n3++] = 13;
        if (Game.buymoreMenu && !Game.buymoreForceOff) {
            Frontend.menuStrings[n3++] = 43;
        }
        Frontend.menuStrings[n3] = 14;
        currentOption = Frontend.findMenuOption(n);
        Frontend.setTopOption();
        Game.gameState = 1;
        Frontend.playMusic(0);
    }

    private static void setTopOption() {
        int n = menuStrings.length;
        if (n <= numViewableMenuItems) {
            topOption = 0;
        } else {
            topOption = currentOption - (numViewableMenuItems >> 1);
            if (topOption < 0) {
                topOption = 0;
            } else if (topOption + numViewableMenuItems > n) {
                topOption = n - numViewableMenuItems;
            }
        }
    }

    private static int findMenuOption(int n) {
        int n2 = 0;
        while (menuStrings[n2] != n) {
            if (++n2 < menuStrings.length) continue;
            return 0;
        }
        return n2;
    }

    public static void splitText(String string, int n, int n2) {
        int n3 = string.length();
        numParagraphStrings = 0;
        paragraphString = string;
        paragraphStringWidth = n;
        int n4 = 0;
        int n5 = 0;
        int n6 = string.indexOf("\n", 0);
        while (n4 < n3 && numParagraphStrings < paragraphOffsets.length) {
            int n7;
            if (n5 >= n3) {
                Frontend.paragraphOffsets[Frontend.numParagraphStrings][0] = (short)n4;
                Frontend.paragraphOffsets[Frontend.numParagraphStrings][1] = (short)n5;
                ++numParagraphStrings;
                n4 = n3;
                continue;
            }
            int n8 = string.indexOf(" ", n5);
            if (n8 == -1) {
                n8 = n3;
            }
            if (n6 != -1 && n8 > n6) {
                n7 = Frontend.fontStringWidth(string.substring(n4, n6), n2);
                if (n7 > n) {
                    if (n5 <= n4) {
                        n5 = n8;
                    }
                    Frontend.paragraphOffsets[Frontend.numParagraphStrings][0] = (short)n4;
                    Frontend.paragraphOffsets[Frontend.numParagraphStrings][1] = (short)(n5 - 1);
                    ++numParagraphStrings;
                    n4 = n5;
                }
                if (n4 <= n6) {
                    Frontend.paragraphOffsets[Frontend.numParagraphStrings][0] = (short)n4;
                    Frontend.paragraphOffsets[Frontend.numParagraphStrings][1] = (short)n6;
                    ++numParagraphStrings;
                }
                n5 = n4 = n6 + 1;
                n6 = string.indexOf("\n", n4);
                continue;
            }
            n7 = Frontend.fontStringWidth(string.substring(n4, n8), n2);
            if (n7 > n) {
                if (n5 == n4) {
                    n5 = n8;
                }
                Frontend.paragraphOffsets[Frontend.numParagraphStrings][0] = (short)n4;
                Frontend.paragraphOffsets[Frontend.numParagraphStrings][1] = (short)(n5 - 1);
                ++numParagraphStrings;
                n4 = n5;
                continue;
            }
            n5 = n8 == n3 ? n8 : n8 + 1;
        }
        if (Game.bWatchdog) {
            Game.watchdogCounter = System.currentTimeMillis();
        }
    }

    private static void initScrAbout() {
        String string = Game.dictionary(111) + " " + Hulk2.version + "\n\n";
        if (!Game.fullVersion) {
            string = string + Game.dictionary(108) + "\n\n";
        }
        string = string + Game.dictionary(0);
        Frontend.screenDefault(7, -1, 17, 13);
        Frontend.splitText(string, Game.canvasWidth - 2, 2);
        paragraphY = titleH + 4;
        paragraphLimit = -(numParagraphStrings * fontM_H) + (Game.canvasHeight - titleH - 4);
    }

    private static void processAbout() {
        if (Game.readPad(524288)) {
            System.gc();
            Frontend.initScrMain(13);
        } else if (paragraphY > paragraphLimit) {
            if (Game.currentMillisecs - screenDelay > 3000L) {
                paragraphY = Game.padPressed(33024) ? (paragraphY -= 4) : --paragraphY;
                if (paragraphY <= paragraphLimit) {
                    screenDelay = Game.currentMillisecs;
                } else {
                    Game.refreshFrontEndScreenGFX = true;
                    redrawOnScreenText = true;
                }
            } else if (Game.padPressed(33024)) {
                screenDelay = Game.currentMillisecs - 3000L;
            }
        } else if (Game.currentMillisecs - screenDelay > 3000L) {
            System.gc();
            Frontend.initScrMain(13);
        }
    }

    public static void initHandson(boolean bl) {
        handsonExit = bl;
        Frontend.loadImage(1);
        Game.gBackBuffer.setClip(0, 0, Game.canvasWidth, Game.canvasHeight);
        Game.gBackBuffer.setColor(0);
        Game.gBackBuffer.fillRect(0, 0, Game.canvasWidth, Game.canvasHeight);
        Frontend.screenDefault(51, -1, -1, -1);
        int n = Game.canvasHeight - images[1].getHeight() >> 1;
        if (bl) {
            Frontend.stopAllSounds();
            Frontend.splitText("(c) 2008 Hands-On Mobile, Inc.", Game.canvasWidth - 2, 2);
            Game.gBackBuffer.setColor(0xFFFFFF);
            Game.gBackBuffer.setClip(0, 0, Game.canvasWidth, Game.canvasHeight);
            Frontend.fontPrintParagraph(Game.gBackBuffer, Game.hscrW, 1, 0, numParagraphStrings, 2);
            Game.gBackBuffer.setClip(0, 0, Game.canvasWidth, Game.canvasHeight);
            Frontend.fontPrint(Game.gBackBuffer, "www.HandsOn.com", Game.hscrW, Game.canvasHeight - fontM_H, 33, 2);
            if (Game.buymoreOnExit && !Game.buymoreForceOff && Game.fullVersion) {
                Frontend.fontPrint(Game.gBackBuffer, Game.moreGamesText, 1, Game.canvasHeight, 36, 2);
                Frontend.fontPrint(Game.gBackBuffer, Game.dictionary(14), Game.canvasWidth - 1, Game.canvasHeight, 40, 2);
            }
        } else {
            Game.frameCount = 0;
        }
        Game.gBackBuffer.drawImage(images[1], Game.hscrW, n, 17);
        Frontend.images[1] = null;
    }

    private static void initMarvelScreen() {
        currentScreen = 52;
        screenDelay = Game.currentMillisecs;
        Frontend.loadImage(2);
        loadCount = 0;
        Game.refreshFrontEndScreenGFX = true;
    }

    public static boolean loadImage(int n) {
        if (images[n] == null) {
            try {
                if (n == 0) {
                    String string = "";
                    string = Game.canvasHeight > 128 ? "128x160/" : (Game.canvasHeight <= 98 ? "128x96/" : "128x128/");
                    try {
                        Frontend.images[n] = Game.create_image("/" + string + imageNames[n] + ".png");
                    }
                    catch (Exception exception) {
                        Frontend.images[n] = Game.create_image("/" + imageNames[n] + ".png");
                    }
                } else {
                    Frontend.images[n] = Game.create_image("/" + imageNames[n] + ".png");
                }
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    public static void clearImages() {
        for (int i = 0; i < loadData.length; ++i) {
            for (int j = 0; j < loadData[i].length; ++j) {
                if (loadData[i][j] == 127) continue;
                Frontend.images[Frontend.loadData[i][j]] = null;
            }
        }
        System.gc();
    }

    private static void drawBG(Graphics graphics) {
        Frontend.drawBGImage(graphics);
        Frontend.drawTitleBars(graphics);
        Frontend.softKeys(graphics);
        if (!fePaused) {
            if (currentScreen == 2) {
                Frontend.fontPrint(graphics, Game.moreGamesText, Game.hscrW, 2, 17, 0);
            } else if (screenTitle != -1) {
                Frontend.fontPrint(graphics, Game.dictionary(screenTitle), Game.hscrW, 2, 17, 0);
            }
            if (menuStrings != null) {
                Frontend.drawMenu(graphics);
            }
        }
    }

    private static void drawTitleBars(Graphics graphics) {
        Game.setFullClip(graphics);
        if (images[7] != null) {
            int n = images[7].getWidth();
            int n2 = (Game.canvasWidth - n) / 2;
            graphics.drawImage(images[7], n2, Game.canvasHeight, 36);
            graphics.drawImage(images[6], n2, 0, 20);
        } else {
            graphics.setColor(32768);
            graphics.fillRect(0, 0, Game.canvasWidth, titleH);
            graphics.fillRect(0, Game.canvasHeight - titleH, Game.canvasWidth, titleH);
        }
    }

    private static void drawBGImage(Graphics graphics) {
        Game.setFullClip(graphics);
        if (images[4] != null) {
            int n = images[4].getWidth();
            int n2 = images[4].getHeight();
            int n3 = (Game.canvasWidth - n) / 2;
            int n4 = (Game.canvasHeight - n2) / 2;
            graphics.drawImage(images[4], n3, n4, 20);
        } else {
            graphics.setColor(1060896);
            graphics.fillRect(0, 0, Game.canvasWidth, Game.canvasHeight);
        }
    }

    private static void softKeys(Graphics graphics) {
        int n = Game.canvasWidth / 24;
        int n2 = Game.canvasHeight - (titleH - fontM_H >> 1);
        if (fePaused) {
            Frontend.fontPrint(graphics, Game.dictionary(22), n, n2, 36, 2);
        } else {
            if (lskStr != null) {
                Frontend.fontPrint(graphics, lskStr, n, n2, 36, 2);
            }
            if (rskStr != null) {
                Frontend.fontPrint(graphics, rskStr, Game.canvasWidth - n, n2, 40, 2);
            }
            if (!Game.fullVersion && currentScreen == 1 && (Game.frameCount & 4) == 0) {
                n = Frontend.fontStringWidth(Game.dictionary(3) + "  ", 2) + Game.canvasWidth / 24;
                Frontend.fontPrint(graphics, Game.dictionary(108), n, n2, 36, 2);
            }
        }
    }

    private static void initScrLevelSelect() {
        Frontend.screenDefault(9, 3, 17, 3);
        currentOption = 0;
        menuStrings = Game.cheatActive ? new int[]{38, 45, 48, 39, 47} : (storyLevel < 3 ? new int[]{38, 48} : new int[]{38, 48, 39});
    }

    private static void readSaveGame() {
        byte[] byArray = null;
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)saveName, (boolean)false);
            if (recordStore != null) {
                int n = recordStore.getNumRecords();
                if (n > 0) {
                    byArray = recordStore.getRecord(1);
                }
                recordStore.closeRecordStore();
                if (byArray[0] != 4) {
                    Frontend.setSaveGameDefaults();
                } else {
                    soundFlag = byArray[1] == 1;
                    storyLevel = byArray[2];
                    Frontend.lastInitials[0] = (char)byArray[3];
                    Frontend.lastInitials[1] = (char)byArray[4];
                    Frontend.lastInitials[2] = (char)byArray[5];
                    int n2 = 6;
                    for (int i = 0; i < 5; ++i) {
                        Frontend.hiscoreName[i][0] = (char)byArray[n2];
                        Frontend.hiscoreName[i][1] = (char)byArray[n2 + 1];
                        Frontend.hiscoreName[i][2] = (char)byArray[n2 + 2];
                        int n3 = byArray[n2 + 3] & 0xFF;
                        n3 |= (byArray[n2 + 4] & 0xFF) << 8;
                        Frontend.hiscoreVal[i] = n3 |= (byArray[n2 + 5] & 0xFF) << 16;
                        n2 += 6;
                    }
                }
            } else {
                Frontend.setSaveGameDefaults();
            }
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            Frontend.setSaveGameDefaults();
        }
        catch (Exception exception) {
            Frontend.setSaveGameDefaults();
        }
    }

    private static void setSaveGameDefaults() {
        storyLevel = 0;
        Game.currentLevel = 0;
        for (int i = 0; i < 5; ++i) {
            Frontend.hiscoreName[i][0] = (char)(65 + i);
            Frontend.hiscoreName[i][1] = (char)(65 + i);
            Frontend.hiscoreName[i][2] = (char)(65 + i);
            Frontend.hiscoreVal[i] = 5000 - i * 1000;
        }
        Frontend.lastInitials[0] = 65;
        Frontend.lastInitials[1] = 65;
        Frontend.lastInitials[2] = 65;
        Frontend.writeSaveGame();
    }

    public static void writeSaveGame() {
        byte[] byArray = new byte[36];
        byArray[0] = 4;
        byArray[1] = (byte)(soundFlag ? 1 : 0);
        byArray[2] = storyLevel;
        byArray[3] = (byte)lastInitials[0];
        byArray[4] = (byte)lastInitials[1];
        byArray[5] = (byte)lastInitials[2];
        int n = 6;
        for (int i = 0; i < 5; ++i) {
            byArray[n] = (byte)hiscoreName[i][0];
            byArray[n + 1] = (byte)hiscoreName[i][1];
            byArray[n + 2] = (byte)hiscoreName[i][2];
            byArray[n + 3] = (byte)(hiscoreVal[i] & 0xFF);
            byArray[n + 4] = (byte)(hiscoreVal[i] >> 8 & 0xFF);
            byArray[n + 5] = (byte)(hiscoreVal[i] >> 16 & 0xFF);
            n += 6;
        }
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)saveName, (boolean)true);
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(byArray, 0, byArray.length);
            } else {
                recordStore.closeRecordStore();
                RecordStore.deleteRecordStore((String)saveName);
                recordStore = RecordStore.openRecordStore((String)saveName, (boolean)true);
                recordStore.addRecord(byArray, 0, byArray.length);
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Game.watchdogCounter = System.currentTimeMillis();
    }

    public static void pauseFE() {
        if (currentScreen < 51) {
            fePaused = true;
            Frontend.stopAllSounds();
        }
    }

    public static void fontPrint(Graphics graphics, String string, int n, int n2, int n3, int n4) {
        if (redrawOnScreenText) {
            if ((n3 & 2) != 0) {
                n3 &= 0xFFFFFFFD;
                n3 |= 0x10;
                n2 -= n4 == 1 ? fontS_H >> 1 : fontH >> 1;
            }
            if (n4 == 1) {
                graphics.setFont(fontSysSmall);
                graphics.setColor(0);
            } else {
                graphics.setFont(fontSys);
                graphics.setColor(0xFFFFFF);
            }
            graphics.drawString(string, n, n2, n3);
        }
    }

    public static int fontStringWidth(String string, int n) {
        Font font = n == 1 ? fontSysSmall : fontSys;
        return font.stringWidth(string);
    }

    public static int fontPrintParagraph(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        if (redrawOnScreenText) {
            int n7;
            int n8 = n7 = n5 == 1 ? fontS_H : fontH;
            if (n4 == -1) {
                n4 = numParagraphStrings;
            }
            while (n4 > 0 && n3 < numParagraphStrings) {
                int n9 = Frontend.fontStringWidth(paragraphString.substring(paragraphOffsets[n3][0], paragraphOffsets[n3][1]), n5);
                if (n9 > n6) {
                    n6 = n9;
                }
                Frontend.fontPrint(graphics, paragraphString.substring(paragraphOffsets[n3][0], paragraphOffsets[n3][1]), n, n2, 17, n5);
                n2 += n7;
                ++n3;
                --n4;
            }
        }
        return n6;
    }

    public static void initScrGameOver() {
        for (int i = 0; i < 5; ++i) {
            if (Game.score <= hiscoreVal[i]) continue;
            editingScore = i;
            for (int j = 4; j > i; --j) {
                Frontend.hiscoreVal[j] = hiscoreVal[j - 1];
                for (int k = 0; k < 3; ++k) {
                    Frontend.hiscoreName[j][k] = hiscoreName[j - 1][k];
                }
            }
            Frontend.hiscoreVal[i] = Game.score;
            Frontend.hiscoreName[i][0] = lastInitials[0];
            Frontend.hiscoreName[i][1] = lastInitials[1];
            Frontend.hiscoreName[i][2] = lastInitials[2];
            Frontend.initScrHiscore(true);
            return;
        }
        Frontend.screenDefault(12, 22, -1, 40);
    }

    private static void initScrHelpChoice(int n) {
        Frontend.screenDefault(13, 3, 17, 12);
        menuStrings = new int[]{101, 100, 102};
        currentOption = n;
        Frontend.setTopOption();
    }

    static void sfx(int n) {
        if (soundFlag) {
            Hulk2.snd.playSound(n);
        }
    }

    static boolean playMusic(int n) {
        if ((currentScreen < 50 || currentScreen > 54) && soundFlag && n != currentTune && Game.gameState == 1 && currentScreen < 50) {
            currentTune = n;
            if (bHasIntroTune) {
                Hulk2.snd.playTune(n, 1);
                if (Game.bWatchdog) {
                    Game.watchdogCounter = System.currentTimeMillis();
                }
            }
        }
        return false;
    }

    static void stopAllSounds() {
        currentTune = -1;
        Hulk2.snd.stopAllSounds();
    }

    static void stopTune() {
        Hulk2.snd.stopTune();
    }

    public static void initBuyFullScreen() {
        if (Game.buymoreURL != null) {
            Frontend.screenDefault(14, 107, 4, -1);
            Frontend.splitText(Game.dictionary(106), Game.canvasWidth - 4, 2);
        } else {
            Frontend.screenDefault(14, -1, 4, -1);
            Frontend.splitText(Game.dictionary(112), Game.canvasWidth - 4, 2);
        }
        paragraphY = titleH + 4;
        paragraphLimit = -(numParagraphStrings * fontM_H) + (Game.canvasHeight - titleH - 4);
    }

    private static int checkForceLocale() {
        int n;
        int n2 = Game.babble_languages.length;
        langAvailable = new boolean[n2];
        numLanguagesAvailable = 0;
        int n3 = -1;
        String string = Game.midlet.getAppProperty("HO-LangList");
        if (string != null) {
            for (n = 0; n < n2; ++n) {
                if (string.indexOf(Game.babble_languages[n]) >= 0) {
                    Frontend.langAvailable[n] = true;
                    n3 = n;
                    ++numLanguagesAvailable;
                    continue;
                }
                if ((Game.babble_languages[n].compareTo("en-GB") != 0 || string.indexOf("en-US") < 0) && (Game.babble_languages[n].compareTo("en-US") != 0 || string.indexOf("en-GB") < 0)) continue;
                bEnGBUSswapped = true;
                Frontend.langAvailable[n] = true;
                n3 = n;
                ++numLanguagesAvailable;
            }
        }
        if (numLanguagesAvailable == 1) {
            return n3;
        }
        if (numLanguagesAvailable == 0) {
            numLanguagesAvailable = n2;
            for (n = 0; n < n2; ++n) {
                Frontend.langAvailable[n] = true;
            }
        }
        return -1;
    }

    static {
        currentTune = -1;
        startDelayedTune = false;
        tuneResumeTime = -1L;
        introSplashLoadCount = 0;
        bEnGBUSswapped = false;
        hiscoreName = new char[5][3];
        hiscoreVal = new int[5];
        lastInitials = new char[3];
        imageNames = new String[]{"splash", "handsonlogo", "marvelpunch", "banner", "menubg", "level_", "menubartop", "menubarbot", "rifle", "hud", "hulk", "particles", "explosion", "energy", "tank", "turrets", "helicopter_02", "blonsky", "abomination", "rock", "option_panel", "soundeffects", "rocket_01", "bomb"};
        NUM_IMGS = imageNames.length;
        images = new Image[NUM_IMGS];
        loadData = new byte[][]{{127, 10, 5, 3, 8, 9, 12, 21, 11, 23, 22, 13}, {127, 10, 5, 8, 9, 12, 21, 17, 22, 13}, {127, 10, 5, 3, 8, 9, 12, 21, 11, 14, 15, 19, 23, 22, 13}, {127, 10, 5, 3, 8, 9, 11, 12, 21, 14, 15, 16, 23, 22, 13}, {127, 10, 5, 3, 8, 9, 11, 12, 21, 18, 19, 23, 22, 13}};
        paragraphOffsets = new short[300][2];
        redrawOnScreenText = true;
        isScrollablePage = false;
        upArrow = false;
        downArrow = false;
        tileNames = new String[]{"bottle", "bottle", "campus", "urban", "urban"};
        selectableLevels = new int[]{0, 2, 3};
        presetFE = false;
    }
}

