/*
 * Decompiled with CFR 0.152.
 */
final class DebugConsole {
    private static final int DEBUG_FONT = 0;
    private int pos;
    private int count;
    private char[] buffer = new char[1024];
    private static final int MAX_NUMBERS = 32;
    private int numberCount;
    private int[] numberValues = new int[32];
    private char[] numberNames = new char[32];
    private int lastX;
    private int lastY;
    private int startX;
    private int startY;
    private int debugFontWidth;
    private int debugFontHeight;
    private char[] debugText = new char[32];
    static int debugConsoleScroll;
    static boolean debugConsoleShow;

    DebugConsole() {
    }

    public void append(String string) {
        if (string == null) {
            return;
        }
        int n = string.length();
        if (n >= this.buffer.length) {
            string.getChars(n - this.buffer.length, n, this.buffer, 0);
            this.pos = 0;
        } else {
            int n2 = this.buffer.length - this.pos;
            if (n <= n2) {
                string.getChars(0, n, this.buffer, this.pos);
                this.pos = (this.pos + n) % this.buffer.length;
            } else {
                string.getChars(0, n2, this.buffer, this.pos);
                string.getChars(n2, n, this.buffer, 0);
                this.pos = n - n2;
            }
        }
        this.count = Math.min(this.count + n, this.buffer.length);
    }

    public void paint(PlatformGraphics platformGraphics, int n, int n2, int n3) {
        this.lastX = this.startX = n;
        this.lastY = this.startY = n2;
        int n4 = Math.min(this.count, this.buffer.length);
        if (n4 <= this.pos) {
            this.paint(platformGraphics, this.buffer, this.pos - n4, n4, n3);
        } else {
            int n5 = n4 - this.pos;
            this.paint(platformGraphics, this.buffer, this.buffer.length - n5, n5, n3);
            this.paint(platformGraphics, this.buffer, 0, this.pos, n3);
        }
    }

    private void paint(PlatformGraphics platformGraphics, char[] cArray, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = this.lastX;
        int n7 = this.lastY;
        int n8 = this.debugFontHeight;
        int n9 = n;
        for (n5 = 0; n5 < n2; ++n5) {
            n4 = cArray[n];
            int n10 = Platform.getFontTextWidth(0, cArray, n9, n - n9);
            if (n4 == 10 || n10 > n3) {
                platformGraphics.drawChars(0, cArray, n9, n - n9, n6, n7, 0);
                n9 = n;
                n6 = this.startX;
                n7 += n8;
                if (n4 == 10) {
                    ++n9;
                }
            }
            ++n;
        }
        n5 = n - n9;
        if (n5 > 0) {
            platformGraphics.drawChars(0, cArray, n9, n5, n6, n7, 0);
            n4 = Platform.getFontTextWidth(0, cArray, n9, n5);
            this.lastX = n6 + n4;
            this.lastY = n7;
        } else {
            this.lastX = n6;
            this.lastY = n7;
        }
    }

    public void addNumber(char c, int n) {
        Platform.assertTrue(this.numberCount < 32);
        this.numberValues[this.numberCount] = n;
        this.numberNames[this.numberCount] = c;
        ++this.numberCount;
    }

    public void clearNumbers() {
        this.numberCount = 0;
    }

    public void paint() {
        if (this.debugFontHeight == 0) {
            this.debugFontWidth = Platform.getFontTextWidth(0, "0") + 1;
            this.debugFontHeight = Platform.getFontHeight(0);
            this.debugText[1] = 58;
        }
        PlatformGraphics platformGraphics = Platform.getDisplayGraphics();
        int n = GMain.canvasWidth;
        int n2 = GMain.canvasHeight;
        platformGraphics.setClip(0, 0, n, n2);
        if (debugConsoleShow) {
            platformGraphics.setColor(0);
            platformGraphics.fillRect(0, 0, n, n2);
            platformGraphics.setColor(0xFFFFFF);
            this.paint(platformGraphics, 0, 0 - debugConsoleScroll, n);
        } else {
            platformGraphics.setColor(0xFFFFFF);
            this.paintNumbers();
        }
        this.clearNumbers();
    }

    private void paintNumbers() {
        for (int i = 0; i < this.numberCount; ++i) {
            this.paintNumber(this.numberValues[i], this.numberNames[i], i);
        }
    }

    private void paintNumber(int n, char c, int n2) {
        this.debugText[0] = c;
        int n3 = Utils.itoa(n, 10, this.debugText, 2);
        int n4 = 0;
        int n5 = n2 * this.debugFontHeight;
        PlatformGraphics platformGraphics = Platform.getDisplayGraphics();
        platformGraphics.setColor(0);
        platformGraphics.fillRect(n4, n5, this.debugFontWidth * (n3 + 3), this.debugFontHeight);
        platformGraphics.setColor(0xFFFFFF);
        platformGraphics.drawChars(0, this.debugText, 0, n3 + 2, n4, n5, 0);
    }
}

