/*
 * Decompiled with CFR 0.152.
 */
public class Creature
extends GameItem {
    public static final int CREATURE_STATE_IDLE = 0;
    public static final int CREATURE_STATE_ACTION = 1;
    public static final int CREATURE_STATE_SCARED = 2;
    public static final int CREATURE_STATE_DEATH = 3;
    public static final int CREATURE_STATE_DIED = 4;
    public static final int CREATURE_STATE_BORN = 5;
    public static final int CREATURE_STATE_AWAY = 6;
    public static final int CREATURE_TYPE_SUCKER = 30;
    public static final int CREATURE_TYPE_MOVER = 32;
    public static final int CREATURE_TYPE_PREDATOR = 33;
    public static final int CREATURE_TYPE_SHOOTER = 36;
    public static final int CREATURE_TYPE_FEEDER = 31;
    public static final int CREATURE_TYPE_SEEKER = 34;
    public static final int CREATURE_TYPE_EMITTER = 35;
    private int directionDG;
    private int moveLength;
    private int moveCounter;
    private boolean escaping;
    private boolean extreme;
    public int state;
    private int nextState;
    private int nextStateIn;
    private int stateCount;
    public int target;
    public int targetPlace;
    private int lastTargetX;
    private int lastTargetY;
    private boolean leeching;
    private boolean pickup;
    private boolean returning;
    private int tailAnim;
    private int fed;
    public int lives;
    protected int prevRouter;
    protected int tarRouter;

    public Creature(int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4, n5, 0);
        if (GameItem.dirTable == null) {
            this.genDirectionTable();
        }
        this.state = 0;
        this.escaping = false;
        this.extreme = false;
        this.target = -1;
        this.lastTargetX = 0;
        this.lastTargetY = 0;
        this.leeching = false;
        this.pickup = false;
        this.returning = false;
        this.tailAnim = 0;
        this.fed = 0;
        this.lives = 3;
        this.prevRouter = -1;
        this.tarRouter = -1;
        this.enterState(0);
    }

    protected void update() {
        if (this.projectile > 0) {
            if (GameItem.gameItems[this.projectile].state == 2 && GameItem.gameItems[this.projectile].shootTimeout > 0) {
                --GameItem.gameItems[this.projectile].shootTimeout;
                if (GameItem.gameItems[this.projectile].shootTimeout == 0) {
                    GameItem.gameItems[this.projectile].state = 0;
                    GameItem.gameItems[this.projectile].stopItemMove();
                }
            } else if (GameItem.gameItems[this.projectile].state == 2 && !GameItem.gameItems[this.projectile].sprite.isPlaying()) {
                GameItem.gameItems[this.projectile].state = 0;
            }
        }
        if (this.state != 4) {
            super.update();
            this.processAI();
        }
    }

    private void processAI() {
        ++this.stateCount;
        if (this.numActions == 9 && (this.itemType == 34 || this.itemType == 33)) {
            this.enterState(6);
        } else if (this.numActions == 3 && this.state == 0 && (this.itemType == 31 || this.itemType == 30)) {
            this.enterState(6);
        } else if (this.numActions == 10 && this.state == 0 && (this.itemType == 35 || this.itemType == 36)) {
            this.enterState(6);
        }
        if (this.state != 3 && this.nextStateIn != -1 && this.stateCount >= this.nextStateIn) {
            if (this.pickup) {
                if (this.targetPlace != -1) {
                    this.setMove(GameItem.gameItems[this.targetPlace].posX, GameItem.gameItems[this.targetPlace].posY);
                } else {
                    this.setMove(this.lastTargetX, this.lastTargetY);
                }
                this.returning = true;
            } else {
                this.enterState(this.nextState);
            }
        }
        switch (this.state) {
            case 5: {
                if (this.sprite.isPlaying()) break;
                this.enterState(0);
                break;
            }
            case 0: 
            case 2: {
                if (this.itemType == 32 && this.pickup) {
                    GameItem.gameItems[this.target].posX = this.posX;
                    GameItem.gameItems[this.target].posY = this.posY;
                }
                if (!this.isMoving()) {
                    if (this.prevRouter == -1) {
                        this.prevRouter = this.tarRouter = 0;
                    } else {
                        this.prevRouter = this.tarRouter;
                        this.tarRouter = NewGame.cRouterTargets[this.prevRouter][Utils.randomInterval(0, NewGame.cRouterTargets[this.prevRouter].length - 1)];
                    }
                    this.setMove(NewGame.cRouterData[this.tarRouter][1], NewGame.cRouterData[this.tarRouter][2]);
                    this.moveCounter = 0;
                    this.velocity = this.state == 2 ? 10 : 2;
                    this.escaping = false;
                }
                if (this.sprite.isPlaying()) break;
                this.sprite.playPath(0);
                break;
            }
            case 1: {
                int n;
                if (this.lastTargetX != GameItem.gameItems[this.target].posX || this.lastTargetY != GameItem.gameItems[this.target].posY) {
                    if (this.isMoving()) {
                        this.lastTargetX = GameItem.gameItems[this.target].posX;
                        this.lastTargetY = GameItem.gameItems[this.target].posY;
                        this.setMove(this.lastTargetX, this.lastTargetY);
                    } else if (this.itemType == 30) {
                        this.enterState(2);
                    } else {
                        this.posX = GameItem.gameItems[this.target].posX;
                        this.posY = GameItem.gameItems[this.target].posY;
                    }
                }
                if (this.itemType == 30 || this.itemType == 31) {
                    if (!this.leeching) break;
                    if (this.itemType == 31) {
                        boolean bl = NewGame.ballDocked;
                        NewGame.ballDocked = false;
                        GameItem.gameItems[this.target].addEnergy(10, true);
                        NewGame.ballDocked = bl;
                        this.fed += 2;
                        if (this.fed < 140 && GameItem.gameItems[this.target].state <= 7 && GameItem.gameItems[this.target].state != -1) break;
                        this.enterState(0);
                        break;
                    }
                    this.fed += 2;
                    if (this.fed < 60) break;
                    if (GameItem.gameItems[this.target].state > 0) {
                        if (GameItem.gameItems[this.target].lives < 800) {
                            GameItem.gameItems[this.target].setLives(GameItem.gameItems[this.target].lives + 100);
                        }
                        GameItem.gameItems[this.target].setPhase(GameItem.gameItems[this.target].state - 1);
                        GameItem.gameItems[this.target].energy = 0;
                    }
                    this.enterState(0);
                    break;
                }
                if (this.itemType != 33 && this.itemType != 34 || (n = Utils.distance(this.posX, this.posY, GameItem.gameItems[this.target].posX, GameItem.gameItems[this.target].posY)) >= 8) break;
                this.sprite.startPath(0);
                GameItem.gameItems[this.target].actionPerformed(this.myId);
                this.enterState(0);
                break;
            }
            case 3: {
                if (this.sprite.isPlaying()) break;
                this.state = 4;
            }
        }
    }

    public void enterState(int n) {
        this.state = n;
        this.leeching = false;
        if (this.target != -1 && !this.pickup) {
            GameItem.gameItems[this.target].creature = -1;
            this.target = -1;
        }
        switch (this.state) {
            case 6: {
                this.setMove(-30, this.posY);
                break;
            }
            case 0: {
                this.nextState = 1;
                this.nextStateIn = Utils.randomInterval(30, 60);
                this.stateCount = 0;
                break;
            }
            case 1: {
                if (this.itemType == 36 || this.itemType == 35) {
                    if (this.projectile < 0) {
                        if (this.itemType == 36) {
                            GameItem.addItem(100, this.posX, this.posY, 8, Main.gem_sprites[BreakConstants.PROJECTILE_SPRITE], 0);
                        } else {
                            GameItem.addItem(100, this.posX, this.posY, 8, Main.gem_sprites[BreakConstants.PROJECTILE2_SPRITE], 0);
                        }
                        this.projectile = GameItem.gameItems[GameItem.numItems - 1].myId;
                    }
                    if (GameItem.gameItems[this.projectile].state > 0) {
                        n = 1;
                        this.nextStateIn = 30;
                        this.stateCount = 0;
                        this.enterState(0);
                        return;
                    }
                    this.shoot();
                    ++this.numActions;
                    GameItem.gameItems[this.projectile].sprite.visible = true;
                    n = 1;
                    this.nextStateIn = Utils.randomInterval(110, 150);
                    this.stateCount = 0;
                    this.enterState(0);
                    return;
                }
                this.target = this.findTarget();
                if (this.target == -1) {
                    n = 1;
                    this.nextStateIn = Utils.randomInterval(60, 100);
                    this.stateCount = 0;
                    this.enterState(0);
                    return;
                }
                this.nextStateIn = -1;
                this.lastTargetX = GameItem.gameItems[this.target].posX;
                this.lastTargetY = GameItem.gameItems[this.target].posY;
                this.setMove(this.lastTargetX, this.lastTargetY);
                break;
            }
            case 2: {
                this.nextState = 0;
                this.nextStateIn = Utils.randomInterval(30, 60);
                this.stateCount = 0;
                this.velocity = 10;
                break;
            }
            case 3: {
                if (this.itemType == 34) {
                    this.sprite.startPath(8);
                    break;
                }
                if (this.itemType == 30 || this.itemType == 31) {
                    this.sprite.startPath(4);
                    break;
                }
                if (this.itemType == 35) {
                    this.sprite.startPath(2);
                    break;
                }
                if (this.itemType != 36) break;
                this.sprite.startPath(10);
            }
        }
    }

    public void setMoveDirectional(int n, int n2) {
        super.setMoveDirectional(n, n2);
    }

    public void setMove(int n, int n2) {
        super.setMove(n, n2);
        if (this.itemType == 34) {
            this.sprite.startPath(9);
        } else {
            this.sprite.startPath(0);
        }
    }

    protected void finishMove() {
        super.finishMove();
        if (this.state == 6) {
            this.state = 4;
            return;
        }
        if (this.state == 4 || this.state == 3) {
            return;
        }
        if ((this.itemType == 31 || this.itemType == 30) && this.target != -1 && GameItem.gameItems[this.target].isAllive() && GameItem.gameItems[this.target].state < 8) {
            GameItem.gameItems[this.target].creature = this.myId;
            this.sprite.startPath(2);
            this.leeching = true;
            this.fed = 0;
            ++this.numActions;
        } else if (this.itemType != 36 && this.itemType != 35) {
            if (this.itemType == 32) {
                if (this.returning) {
                    if (this.targetPlace > 0) {
                        GameItem.gameItems[this.targetPlace].ghost = -1;
                        GameItem.gameItems[this.target].ghost = 1;
                        this.targetPlace = -1;
                    }
                    GameItem.gameItems[this.target].creature = -1;
                    this.target = -1;
                    this.returning = false;
                    this.pickup = false;
                    this.enterState(0);
                } else if (!this.pickup && this.target != -1) {
                    this.pickup = true;
                    GameItem.gameItems[this.target].creature = this.myId;
                    this.enterState(0);
                }
            } else if (this.target != -1 && !GameItem.gameItems[this.target].isAllive()) {
                this.enterState(0);
            }
        }
    }

    private int findTarget() {
        if (this.itemType == 30 || this.itemType == 31) {
            return this.findGem();
        }
        if (this.itemType == 33 || this.itemType == 34) {
            return this.findCreature();
        }
        if (this.itemType == 32) {
            this.targetPlace = this.findTargetPlace();
            System.out.println("TargetPlace : " + this.targetPlace);
            return this.findGem();
        }
        return -1;
    }

    private int findTargetPlace() {
        int n = -1;
        for (int i = 0; i < NewGame.gemCount; ++i) {
            if (GameItem.gameItems[NewGame.firstGem + i].creature != -1 || GameItem.gameItems[NewGame.firstGem + i].state != 10 || GameItem.gameItems[NewGame.firstGem + i].ghost == -1 || GameItem.gameItems[NewGame.firstGem + i].ghost != 1) continue;
            n = GameItem.gameItems[NewGame.firstGem + i].myId;
            break;
        }
        return n;
    }

    private int findCreature() {
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < NewGame.creatureCount; ++i) {
            if (NewGame.creatures[i].lives >= n2 && n2 != -1 || !NewGame.creatures[i].isAllive() || NewGame.creatures[i].creature != -1) continue;
            if (this.itemType == 34 && (NewGame.creatures[i].itemType == 33 || NewGame.creatures[i].itemType == 30 || NewGame.creatures[i].itemType == 36)) {
                n2 = NewGame.creatures[i].lives;
                n = NewGame.creatures[i].myId;
                continue;
            }
            if (this.itemType != 33 || NewGame.creatures[i].itemType != 34 && NewGame.creatures[i].itemType != 31 && NewGame.creatures[i].itemType != 35) continue;
            n2 = NewGame.creatures[i].lives;
            n = NewGame.creatures[i].myId;
        }
        if (n != -1) {
            GameItem.gameItems[n].creature = -2;
        }
        return n;
    }

    private int findGem() {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        boolean bl = false;
        if (this.itemType == 30) {
            for (int i = 0; i < NewGame.gemCount; ++i) {
                if (GameItem.gameItems[NewGame.firstGem + i].router != -1 || GameItem.gameItems[NewGame.firstGem + i].creature != -1) continue;
                if (!bl && GameItem.gameItems[NewGame.firstGem + i].state > n && GameItem.gameItems[NewGame.firstGem + i].itemType < 10 && GameItem.gameItems[NewGame.firstGem + i].isAllive() && GameItem.gameItems[NewGame.firstGem + i].state < 8) {
                    n2 = i;
                    n = GameItem.gameItems[NewGame.firstGem + i].state;
                }
                if (GameItem.gameItems[NewGame.firstGem + i].targetData <= 0 || GameItem.gameItems[NewGame.firstGem + i].itemType >= 10 || !GameItem.gameItems[NewGame.firstGem + i].isAllive() || bl && GameItem.gameItems[NewGame.firstGem + i].targetData <= n3) continue;
                n3 = GameItem.gameItems[NewGame.firstGem + i].targetData;
                n2 = i;
                bl = true;
            }
        } else if (this.itemType == 31) {
            if (NewGame.ballDocked) {
                return n2;
            }
            for (int i = 0; i < NewGame.gemCount; ++i) {
                if (GameItem.gameItems[NewGame.firstGem + i].router != -1 || GameItem.gameItems[NewGame.firstGem + i].creature != -1) continue;
                if (!bl) {
                    if (n == -1 && GameItem.gameItems[NewGame.firstGem + i].itemType < 10 && GameItem.gameItems[NewGame.firstGem + i].isAllive() && GameItem.gameItems[NewGame.firstGem + i].state < 8) {
                        n2 = i;
                        n = GameItem.gameItems[NewGame.firstGem + i].energy;
                    } else if (GameItem.gameItems[NewGame.firstGem + i].energy <= n && GameItem.gameItems[NewGame.firstGem + i].itemType < 10 && GameItem.gameItems[NewGame.firstGem + i].isAllive() && GameItem.gameItems[NewGame.firstGem + i].state < 8) {
                        n2 = i;
                        n = GameItem.gameItems[NewGame.firstGem + i].energy;
                    }
                }
                if (GameItem.gameItems[NewGame.firstGem + i].targetData <= 0 || GameItem.gameItems[NewGame.firstGem + i].itemType >= 10 || !GameItem.gameItems[NewGame.firstGem + i].isAllive() || GameItem.gameItems[NewGame.firstGem + i].state >= 8 || bl && GameItem.gameItems[NewGame.firstGem + i].targetData <= n3) continue;
                n3 = GameItem.gameItems[NewGame.firstGem + i].targetData;
                n2 = i;
                bl = true;
            }
        } else if (this.itemType == 32) {
            for (int i = 0; i < NewGame.gemCount; ++i) {
                if (GameItem.gameItems[NewGame.firstGem + i].router != -1 || GameItem.gameItems[NewGame.firstGem + i].creature != -1 || GameItem.gameItems[NewGame.firstGem + i].itemType > 9 || !GameItem.gameItems[NewGame.firstGem + i].isAllive() || GameItem.gameItems[NewGame.firstGem + i].state < 0 || GameItem.gameItems[NewGame.firstGem + i].ghost <= 1 || GameItem.gameItems[NewGame.firstGem + i].ghost <= n) continue;
                n = GameItem.gameItems[NewGame.firstGem + i].ghost;
                n2 = i;
            }
        }
        if (n2 != -1) {
            GameItem.gameItems[NewGame.firstGem + n2].creature = -2;
            n2 = NewGame.firstGem + n2;
        }
        return n2;
    }

    protected void draw() {
        if (this.state == 4) {
            return;
        }
        super.draw();
        if (this.g == null) {
            this.g = Platform.getDisplayGraphics();
        }
        if (this.leeching) {
            this.g.setColor(0xFFFFFF);
        }
    }

    protected void actionPerformed(int n) {
        if (this.state == 4 || this.state == 3) {
            return;
        }
        if (this.target != n) {
            GameItem.gameItems[n].creature = -1;
        } else if (this.leeching && this.itemType == 30) {
            ++NewGame.leachHiting;
            this.enterState(2);
        }
        if (GameItem.gameItems[n].itemType == 34 || GameItem.gameItems[n].itemType == 33) {
            ++GameItem.gameItems[n].numActions;
            this.enterState(2);
            this.hit(1);
        }
    }

    protected void shoot() {
        GameItem.gameItems[this.projectile].posX = this.posX;
        GameItem.gameItems[this.projectile].posY = this.posY;
        GameItem.gameItems[this.projectile].setVelocity(3, 0);
        GameItem.gameItems[this.projectile].state = 1;
        GameItem.gameItems[this.projectile].sprite.startPath(0);
        int n = Utils.randomInterval(0, 7);
        int n2 = 0;
        if (NewGame.gameType == 0) {
            n = 0;
        }
        switch (n) {
            case 0: {
                GameItem.gameItems[this.projectile].setMoveDirectional(0, 1);
                n2 = 6;
                break;
            }
            case 1: {
                GameItem.gameItems[this.projectile].setMoveDirectional(-1, 0);
                n2 = 8;
                break;
            }
            case 2: {
                GameItem.gameItems[this.projectile].setMoveDirectional(0, -1);
                n2 = 2;
                break;
            }
            case 3: {
                GameItem.gameItems[this.projectile].setMoveDirectional(1, 0);
                n2 = 4;
                break;
            }
            case 4: {
                GameItem.gameItems[this.projectile].setMoveDirectional(-1, 1);
                n2 = 7;
                break;
            }
            case 5: {
                GameItem.gameItems[this.projectile].setMoveDirectional(1, 1);
                n2 = 5;
                break;
            }
            case 6: {
                GameItem.gameItems[this.projectile].setMoveDirectional(-1, -1);
                n2 = 9;
                break;
            }
            case 7: {
                GameItem.gameItems[this.projectile].setMoveDirectional(1, -1);
                n2 = 3;
            }
        }
        if (this.itemType == 36) {
            this.sprite.startPath(n2);
        }
        GameItem.gameItems[this.projectile].processMoveDirection();
        GameItem.gameItems[this.projectile].processMoveDirection();
    }

    protected void hit(int n) {
        this.lives -= n;
        if (this.lives < 1) {
            if (this.itemType == 30 || this.itemType == 32 || this.itemType == 33 || this.itemType == 36) {
                ++NewGame.killedCreatures;
            }
            this.enterState(3);
        }
    }

    public boolean isAllive() {
        return this.lives > 0 && this.state != 3 && this.state != 4 && this.state != 5 && this.state != 6;
    }
}

