/*
 * Decompiled with CFR 0.152.
 */
package com.foxmobile.ghostcamera.framework.device;

import com.foxmobile.ghostcamera.framework.Log;
import com.foxmobile.ghostcamera.framework.Threads;
import com.foxmobile.ghostcamera.graphics.Canvas;

public final class DeviceTraits {
    private static final String TAG;
    private int canvasWidth;
    private int canvasHeight;
    private long heapSize;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.foxmobile.ghostcamera.framework.device.DeviceTraits");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TAG = Log.tag(clazz);
    }

    public static DeviceTraits initFrom(Canvas canvas) {
        DeviceTraits traits = new DeviceTraits();
        Threads.sleep(100L);
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start <= 500L && !canvas.isFirstSizeChanged()) {
            Threads.sleep(50L);
        }
        if (!canvas.isFirstSizeChanged()) {
            Log.log(TAG, "Warning: did not get the first size change event on the canvas");
        }
        traits.canvasWidth = canvas.getWidth();
        traits.canvasHeight = canvas.getHeight();
        traits.heapSize = Runtime.getRuntime().totalMemory();
        String nokiaRam = System.getProperty("com.nokia.memoryramfree");
        if (nokiaRam != null && !"".equals(nokiaRam)) {
            try {
                traits.heapSize = Long.parseLong(nokiaRam);
            }
            catch (NumberFormatException e) {
                Log.log(TAG, "warning: unexpected nokia RAM property value: {0}", nokiaRam);
            }
        }
        return traits;
    }

    private DeviceTraits() {
    }

    public final int getCanvasWidth() {
        return this.canvasWidth;
    }

    public final int getCanvasHeight() {
        return this.canvasHeight;
    }

    public final boolean isLowResolution() {
        return this.canvasWidth <= 128;
    }

    public final boolean isWeakCpu() {
        return this.isLowResolution();
    }

    public final boolean isLeftSoftKeyCode(int code) {
        return code == -6 || code == -21 || code == 21;
    }

    public final boolean isRightSoftKeyCode(int code) {
        return code == -7 || code == -22 || code == 22;
    }

    public final boolean isScreenWiderThanTaller() {
        return this.getCanvasWidth() >= this.getCanvasHeight();
    }

    public String toString() {
        return "cW=" + this.canvasWidth + " cH=" + this.canvasHeight + " lR=" + this.isLowResolution() + " heap=" + this.heapSize / 1024L + " sH=" + this.isSmallHeap();
    }

    public boolean isDownKeyCode(int keyCode) {
        return keyCode == -2;
    }

    public boolean isUpKeyCode(int keyCode) {
        return keyCode == -1;
    }

    public boolean isSelectKeyCode(int keyCode) {
        return keyCode == -5;
    }

    public boolean isSmallHeap() {
        return this.heapSize <= 921600L;
    }

    public boolean isCompatible() {
        return true;
    }

    public boolean isCaptureSupported() {
        return System.getProperty("supports.video.capture").equals("true");
    }

    public boolean isLeftKeyCode(int keyCode) {
        return keyCode == -3;
    }

    public boolean isRightKeyCode(int keyCode) {
        return keyCode == -4;
    }
}

