/*
 * Decompiled with CFR 0.152.
 */
package com.zenops.gts;

import com.zenops.gts.Floor;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class Particle {
    private static int GRAVITY = 47872;
    private static int MULTIPLIER = 3;
    public static final byte TYPE_SOFTWARE = 0;
    public static final byte TYPE_IMAGE = 1;
    private int color;
    private int size;
    private byte animIndex;
    private int animTime;
    private Image[] img;
    byte type;
    private int posX;
    private int posY;
    private int dx;
    private int dy;
    private int life;
    private int deathTime;
    boolean isAlive = true;

    public Particle(int x, int y, int dx, int dy, int deathTime, int color, int size) {
        this.type = 0;
        this.posX = x;
        this.posY = y;
        this.dx = dx * MULTIPLIER >> 2;
        this.dy = dy * MULTIPLIER >> 2;
        this.deathTime = deathTime;
        this.color = color;
        this.size = size;
    }

    public Particle(int x, int y, int dx, int dy, int deathTime, Image[] img, int animTime) {
        this.type = 1;
        this.posX = x;
        this.posY = y;
        this.dx = dx * MULTIPLIER >> 2;
        this.dy = dy * MULTIPLIER >> 2;
        this.deathTime = deathTime;
        this.img = img;
        this.animTime = animTime;
    }

    public Particle(int x, int y, int dx, int dy, int deathTime, Image[] img) {
        this(x, y, dx, dy, deathTime, img, deathTime);
    }

    public boolean simulate(int timeDelta) {
        if (!this.isAlive) {
            return false;
        }
        this.life += timeDelta;
        if (this.life >= this.deathTime) {
            this.isAlive = false;
        } else {
            this.posX += this.dx * timeDelta >> 10;
            this.posY += this.dy * timeDelta >> 10;
            if (this.type == 1) {
                this.animIndex = (byte)(this.life * this.img.length / this.animTime % this.img.length);
            }
        }
        return this.isAlive;
    }

    public void draw(Graphics g, int x, int y) {
        if (!this.isAlive) {
            return;
        }
        if (this.type == 0) {
            g.setColor(this.color);
            g.fillRect(Floor.getScreenX(x, this.posX >> 8) - (this.size >> 1), Floor.getScreenY(y, this.posY >> 8) - (this.size >> 1), this.size, this.size);
        } else {
            g.drawImage(this.img[this.animIndex], Floor.getScreenX(x, this.posX >> 8), Floor.getScreenY(y, this.posY >> 8), 3);
        }
    }

    public void addGravity(int timeDelta) {
        this.dy += GRAVITY * timeDelta >> 10;
    }
}

