/*
 * Decompiled with CFR 0.152.
 */
package com.zenops.gts;

import com.zenops.gts.Base;
import com.zenops.gts.Character;
import com.zenops.gts.Effect;
import com.zenops.gts.Floor;
import com.zenops.gts.Game;
import com.zenops.gts.Moveable;
import com.zenops.gts.Placeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;

class ScriptEvent {
    private final int encodedValue;
    final byte eventType;
    final boolean isBreakPoint;
    boolean isObjectIDFromFloor = false;
    byte objectID;
    short dialogIndex;
    byte objectType;
    short waitTime;
    int positionX;
    int positionY;
    byte faceIndex;
    byte objectCategory;
    byte lookingDir;
    byte animationType;
    boolean isComputed = false;
    boolean isPrepared = false;
    private static final byte PHASE_INSULT = 0;
    private static final byte PHASE_FINISHED = 1;
    static final byte MOVE_OBJECT = 0;
    static final byte MOVE_CAMERA = 1;
    static final byte DISPLAY_DIALOG = 2;
    static final byte CREATE_OBJECT = 3;
    static final byte DESTROY_OBJECT = 4;
    static final byte SET_LOOKING_DIR = 5;
    static final byte SET_ANIMATION = 6;
    static final byte TOGGLE_POINT = 7;
    static final byte DISPLAY_TRANSITION = 8;
    static final byte TRIGGER_TIMER = 9;
    static final byte TRIGGER_PHASE = 10;
    static final byte WAIT = 11;
    static final byte DISPLAY_EFFECT = 12;
    private static final byte IS_BREAK_POINT_SHIFT = 31;
    private static final byte IS_BREAK_POINT_MASK = 1;
    private static final byte EVENT_TYPE_SHIFT = 27;
    private static final byte EVENT_TYPE_MASK = 15;
    private static final int EVENT_INFORMATION_MASK = 0x7FFFFFF;
    private static final byte OBJECT_ID_SHIFT = 18;
    private static final short OBJECT_ID_MASK = 255;
    private static final byte OBJECT_IS_CREATED_SHIFT = 26;
    private static final byte OBJECT_IS_CREATED_MASK = 1;
    private static final byte DIALOG_INDEX_SHIFT = 11;
    private static final int DIALOG_INDEX_MASK = 65535;
    private static final short DIALOG_FACE_INDEX_MASK = 255;
    private static final byte OBJECT_TYPE_SHIFT = 19;
    private static final short OBJECT_TYPE_MASK = 255;
    private static final int WAIT_TIME_MASK = 65535;
    private static final byte DESTINATION_DIRECTION_SHIFT = 8;
    private static final byte DESTINATION_DIRECTION_MASK = 1;
    private static final short DESTINATION_DISPLACEMENT_MASK = 255;
    private static final short CREATE_POSITION_TILE_MASK = 255;
    private static final byte CREATE_POSITION_PLANE_SHIFT = 8;
    private static final byte CREATE_POSITION_PLANE_MASK = 7;
    private static final byte OBJECT_CATEGORY_SHIFT = 11;
    private static final short OBJECT_CATEGORY_MASK = 255;
    private static final byte LOOKING_DIRECTION_MASK = 1;
    private static final short ANIMATION_TYPE_MASK = 255;
    private static boolean[] existingMoveablesSimulated;
    private static Moveable[] existingMoveables;
    private static boolean[] createdMoveablesSimulated;
    private static Placeable[] createdPlaceables;
    static int scriptIndex;
    private static int scriptEventStartIndex;
    private static int scriptEventEndIndex;
    static String[][] scriptTexts;
    private static Vector dialogIndexList;
    static byte phaseNextScript;
    static int scriptDialogScrolling;
    static int scriptDialogProgress;
    static byte scriptDialogFace;
    static short scriptDialogIndex;
    static boolean scriptDisplayNoise;
    static byte CUSTOM_SCRIPT;
    static ScriptEvent[][] scriptEvents;

    private ScriptEvent(int encoded_Value) {
        System.out.println("creating script event from " + encoded_Value);
        this.encodedValue = encoded_Value;
        this.isBreakPoint = (encoded_Value >> 31 & 1) == 1;
        System.out.println("\tisBreakPoint: " + this.isBreakPoint);
        this.eventType = (byte)(encoded_Value >> 27 & 0xF);
        System.out.println("\teventType: " + this.eventType);
        this.reset();
    }

    private ScriptEvent(short dialog_Index, byte face_Index) {
        this(0x90000000 | (dialog_Index & 0xFFFF) << 11 | face_Index & 0xFF);
    }

    private void reset() {
        this.isPrepared = false;
        this.isComputed = false;
        switch (this.eventType) {
            case 0: {
                this.objectID = (byte)(this.encodedValue >> 18 & 0xFF);
                this.isObjectIDFromFloor = (this.encodedValue >> 26 & 1) != 1;
            }
            case 1: {
                boolean y_Direction = (this.encodedValue >> 8 & 1) == 1;
                byte displacement = (byte)(this.encodedValue & 0xFF);
                if (y_Direction) {
                    this.positionY = displacement * Floor.TILE_SIZE << 8;
                    break;
                }
                this.positionX = displacement * Floor.TILE_SIZE << 8;
                break;
            }
            case 2: {
                this.dialogIndex = (short)(this.encodedValue >> 11 & 0xFFFF);
                this.faceIndex = (byte)(this.encodedValue & 0xFF);
                if (Game.environment != 0 || this.faceIndex != 5) break;
                this.faceIndex = (byte)2;
                break;
            }
            case 3: {
                this.objectType = (byte)(this.encodedValue >> 19 & 0xFF);
                this.objectCategory = (byte)(this.encodedValue >> 11 & 0xFF);
                this.positionX = (byte)(this.encodedValue & 0xFF);
                this.positionY = (byte)(this.encodedValue >> 8 & 7);
                break;
            }
            case 4: {
                this.objectID = (byte)(this.encodedValue >> 18 & 0xFF);
                this.isObjectIDFromFloor = (this.encodedValue >> 26 & 1) != 1;
                break;
            }
            case 5: {
                this.objectID = (byte)(this.encodedValue >> 18 & 0xFF);
                this.isObjectIDFromFloor = (this.encodedValue >> 26 & 1) != 1;
                this.lookingDir = (byte)((this.encodedValue & 1) == 1 ? 1 : -1);
                break;
            }
            case 6: 
            case 7: 
            case 12: {
                this.objectID = (byte)(this.encodedValue >> 18 & 0xFF);
                this.isObjectIDFromFloor = (this.encodedValue >> 26 & 1) != 1;
            }
            case 8: {
                this.animationType = (byte)(this.encodedValue & 0xFF);
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                this.animationType = (byte)(this.encodedValue & 0xFF);
                if (this.animationType != 0) break;
                this.objectID = (byte)(this.encodedValue >> 18 & 0xFF);
                this.isObjectIDFromFloor = (this.encodedValue >> 26 & 1) != 1;
                break;
            }
            case 11: {
                this.waitTime = (short)(this.encodedValue & 0xFFFF);
            }
        }
        System.out.println("\tobject ID: " + this.objectID + " (" + this.isObjectIDFromFloor + ")");
        System.out.println("\tdialogIndex: " + this.dialogIndex + ", faceIndex: " + this.faceIndex);
        System.out.println("\tobjectCategory: " + this.objectCategory + ", objectType: " + this.objectType);
        System.out.println("\tposition: " + this.positionX + ", " + this.positionY);
        System.out.println("\tlookingDir: " + this.lookingDir);
        System.out.println("\twaitTime: " + this.waitTime);
        System.out.println("\tanimationType: " + this.animationType);
    }

    static void prepare(int script_Index, int reference_Tile) {
        Vector<Moveable> existing_Moveables = new Vector<Moveable>();
        int created_Moveables_Nb = 0;
        scriptDisplayNoise = false;
        scriptEventStartIndex = -1;
        scriptEventEndIndex = -1;
        dialogIndexList = new Vector();
        for (int event_Index = 0; event_Index < scriptEvents[script_Index].length; ++event_Index) {
            ScriptEvent event = scriptEvents[script_Index][event_Index];
            if (event.isPrepared) {
                event.reset();
            }
            if (event.isBreakPoint && scriptEventEndIndex == -1) {
                scriptEventEndIndex = event_Index;
            }
            if (event.eventType == 3) {
                ScriptEvent.scriptEvents[script_Index][event_Index].positionX += reference_Tile;
                ++created_Moveables_Nb;
            } else if (event.isObjectIDFromFloor) {
                Moveable moveable = Game.get(ScriptEvent.scriptEvents[script_Index][event_Index].objectID);
                if (!existing_Moveables.contains(moveable)) {
                    existing_Moveables.addElement(moveable);
                }
                ScriptEvent.scriptEvents[script_Index][event_Index].objectID = (byte)existing_Moveables.indexOf(moveable);
            }
            if (event.eventType == 2) {
                int insert_Index;
                Short dialog_Index = new Short(event.dialogIndex);
                for (insert_Index = 0; insert_Index < dialogIndexList.size(); insert_Index = (int)((byte)(insert_Index + 1))) {
                    Short value = (Short)dialogIndexList.elementAt(insert_Index);
                    if (dialog_Index < value) break;
                }
                dialogIndexList.insertElementAt(dialog_Index, insert_Index);
            }
            event.isPrepared = true;
        }
        createdPlaceables = new Placeable[created_Moveables_Nb];
        createdMoveablesSimulated = new boolean[created_Moveables_Nb];
        existingMoveables = new Moveable[existing_Moveables.size()];
        existingMoveablesSimulated = new boolean[existing_Moveables.size()];
        for (int i = 0; i < existing_Moveables.size(); ++i) {
            ScriptEvent.existingMoveables[i] = (Moveable)existing_Moveables.elementAt(i);
            System.out.println("existing moveables " + i + ": " + existingMoveables[i]);
        }
        existing_Moveables = null;
        scriptIndex = script_Index;
        ScriptEvent.resetState();
        String[] script_Text = Game.loadTxt(dialogIndexList);
        scriptTexts = new String[script_Text.length][];
        int width = Game.getDialogWidth();
        Vector split_Strings = new Vector();
        for (int i = 0; i < script_Text.length; ++i) {
            Game.cutSystemString(script_Text[i], split_Strings, width);
            ScriptEvent.scriptTexts[i] = new String[split_Strings.size()];
            for (int s = 0; s < split_Strings.size(); ++s) {
                ScriptEvent.scriptTexts[i][s] = (String)split_Strings.elementAt(s);
            }
        }
        phaseNextScript = (byte)5;
    }

    private static void resetState() {
        scriptDialogScrolling = 0;
        scriptDialogProgress = -2;
        scriptDialogFace = (byte)-1;
        scriptDialogIndex = (short)-1;
        Game.transitionAnimationMode = 0;
    }

    static boolean update(int time_Delta) {
        boolean script_Over = false;
        Character.processPhysics = false;
        Character.processCollisions = false;
        Character.processAI = false;
        if (scriptIndex != -1) {
            int i;
            boolean next_State = true;
            for (i = 0; i < createdMoveablesSimulated.length; ++i) {
                ScriptEvent.createdMoveablesSimulated[i] = false;
            }
            for (i = 0; i < existingMoveablesSimulated.length; ++i) {
                ScriptEvent.existingMoveablesSimulated[i] = false;
            }
            if (scriptEventStartIndex == -1) {
                for (i = 0; i < Game.currentEffectList.size(); ++i) {
                    Object effect = Game.currentEffectList.elementAt(i);
                    if (Game.displayBuffer[0].contains(effect)) continue;
                    Game.displayBuffer[0].addElement(effect);
                }
                for (i = 0; i < existingMoveables.length; ++i) {
                    if (Game.displayBuffer[0].contains(existingMoveables[i])) continue;
                    Game.displayBuffer[0].addElement(existingMoveables[i]);
                }
                Game.currentEffectList.removeAllElements();
                Game.currentEffectList = Game.displayBuffer[0];
                scriptEventStartIndex = 1;
                if (Game.max.plane == Floor.SECOND_ACTION_PLANE || scriptIndex == CUSTOM_SCRIPT) {
                    scriptEventStartIndex = 0;
                    scriptEventEndIndex = 0;
                }
            }
            for (int script_Event_Index = scriptEventStartIndex; script_Event_Index <= scriptEventEndIndex; ++script_Event_Index) {
                ScriptEvent event = scriptEvents[scriptIndex][script_Event_Index];
                if (event.isComputed) continue;
                switch (event.eventType) {
                    case 0: {
                        Moveable moveable;
                        if (event.isObjectIDFromFloor) {
                            moveable = existingMoveables[event.objectID];
                            if (existingMoveablesSimulated[event.objectID]) break;
                            ScriptEvent.existingMoveablesSimulated[event.objectID] = true;
                        } else {
                            moveable = (Moveable)createdPlaceables[event.objectID];
                            if (createdMoveablesSimulated[event.objectID]) break;
                            ScriptEvent.createdMoveablesSimulated[event.objectID] = true;
                        }
                        if (event.positionX != 0) {
                            ((Character)moveable).move(event.positionX < 0 ? -1 : 1, false);
                            int old_PosX = moveable.posX;
                            moveable.simulate(time_Delta);
                            int diff_X = moveable.posX - old_PosX;
                            if (Math.abs(diff_X) >= Math.abs(event.positionX)) {
                                moveable.posX -= diff_X - event.positionX;
                                diff_X = event.positionX;
                                event.positionX = 0;
                                event.isComputed = true;
                            }
                            event.positionX -= diff_X;
                            break;
                        }
                        ((Character)moveable).changePlane(event.positionY < 0 ? -1 : 1, false);
                        int old_PosY = moveable.posY;
                        moveable.simulate(time_Delta);
                        int diff_Y = moveable.posY - old_PosY;
                        if (Math.abs(diff_Y) >= Math.abs(event.positionY)) {
                            moveable.posY -= diff_Y - event.positionY;
                            diff_Y = event.positionX;
                            event.positionY = 0;
                            event.isComputed = true;
                        }
                        event.positionY -= diff_Y;
                        break;
                    }
                    case 1: {
                        int movement = time_Delta * Character.SPEED[0] >> 10;
                        if (event.positionX < 0) {
                            movement = -movement;
                        }
                        if (Math.abs(movement) >= Math.abs(event.positionX)) {
                            movement = event.positionX;
                            event.isComputed = true;
                        }
                        event.positionX -= movement;
                        Game.cameraPosX += movement;
                        break;
                    }
                    case 2: {
                        if (scriptDialogProgress == -2) {
                            scriptDialogFace = event.faceIndex;
                            scriptDialogIndex = (short)dialogIndexList.indexOf(new Short(event.dialogIndex));
                            scriptDialogProgress = 0;
                            scriptDialogScrolling = 0;
                            break;
                        }
                        if (scriptDialogProgress == -1) {
                            if ((Game.keyEvent & Game.KEY_UP) != 0L) {
                                ++scriptDialogScrolling;
                            }
                            if ((Game.keyEvent & Game.KEY_DOWN) != 0L) {
                                --scriptDialogScrolling;
                                scriptDialogScrolling = Math.max(0, scriptDialogScrolling);
                            }
                            if ((Game.keyEvent & 0x200100L) == 0L) break;
                            event.isComputed = true;
                            break;
                        }
                        if (scriptDialogProgress < 0) break;
                        scriptDialogProgress += 56 * time_Delta;
                        if ((Game.keyEvent & 0x200100L) == 0L) break;
                        scriptDialogProgress = -1;
                        break;
                    }
                    case 3: {
                        Placeable placeable = event.objectCategory == 5 ? new Character(event.objectType, Game.currentFloor, event.positionX, event.positionY) : (event.objectCategory == 4 ? new Moveable(event.objectType, Game.currentFloor, event.positionX, event.positionY) : new Placeable(event.objectCategory, event.objectType, Game.currentFloor, event.positionX, event.positionY));
                        for (int i2 = 0; i2 < createdPlaceables.length; ++i2) {
                            if (createdPlaceables[i2] != null) continue;
                            ScriptEvent.createdPlaceables[i2] = placeable;
                            break;
                        }
                        Game.displayBuffer[0].addElement(placeable);
                        event.isComputed = true;
                        break;
                    }
                    case 4: {
                        Placeable placeable = event.isObjectIDFromFloor ? existingMoveables[event.objectID] : createdPlaceables[event.objectID];
                        Game.removeElement(Game.displayBuffer[0], placeable);
                        event.isComputed = true;
                        break;
                    }
                    case 5: {
                        Character character = event.isObjectIDFromFloor ? (Character)existingMoveables[event.objectID] : (Character)createdPlaceables[event.objectID];
                        character.lookingDir = event.lookingDir;
                        event.isComputed = true;
                        break;
                    }
                    case 6: {
                        Character character = event.isObjectIDFromFloor ? (Character)existingMoveables[event.objectID] : (Character)createdPlaceables[event.objectID];
                        character.setAnim(event.animationType, true, true);
                        event.isComputed = true;
                        break;
                    }
                    case 7: {
                        Character character = event.isObjectIDFromFloor ? (Character)existingMoveables[event.objectID] : (Character)createdPlaceables[event.objectID];
                        character.punctuationPoint = (byte)(character.punctuationPoint < 0 ? (int)event.animationType : -1);
                        event.isComputed = true;
                        break;
                    }
                    case 8: {
                        if (Game.transitionAnimationMode == 0) {
                            Game.initTransitionAnimation(event.animationType, Floor.zoneY, Floor.zoneY + Floor.zoneHeight);
                            break;
                        }
                        if (!Game.updateTransitionAnimation()) break;
                        scriptDisplayNoise = Game.transitionAnimationMode == 1;
                        Game.transitionAnimationMode = 0;
                        event.isComputed = true;
                        break;
                    }
                    case 9: {
                        if (!Game.countDownActivated) {
                            Game.initCountDown();
                        } else {
                            Game.countDownActivated = false;
                        }
                        event.isComputed = true;
                        break;
                    }
                    case 10: {
                        if (event.animationType == 0) {
                            Character character = event.isObjectIDFromFloor ? (Character)existingMoveables[event.objectID] : (Character)createdPlaceables[event.objectID];
                            Game.currentPlaceable = character;
                            phaseNextScript = (byte)8;
                        } else {
                            Game.player.setAnim((byte)13, true, true);
                            Game.hasWon = true;
                            phaseNextScript = Game.currentLevel == 16 ? (byte)22 : (byte)13;
                        }
                        event.isComputed = true;
                        break;
                    }
                    case 11: {
                        event.waitTime = (short)(event.waitTime - time_Delta);
                        if (event.waitTime > 0) break;
                        event.isComputed = true;
                        break;
                    }
                    case 12: {
                        Character character = event.isObjectIDFromFloor ? (Character)existingMoveables[event.objectID] : (Character)createdPlaceables[event.objectID];
                        Effect effect = null;
                        if (event.animationType == 1) {
                            effect = new Effect(event.animationType, Game.currentFloor, character.tile, character.plane, (character.posX >> 8) + character.lookingDir * character.getHandOffsetX(), (character.posY >> 8) - character.getHandOffsetY());
                        } else if (event.animationType == 3) {
                            int shotX = character.posX >> 8;
                            int shotY = Floor.getCharacterPosY(character.plane) - character.getHandOffsetY();
                            effect = new Effect(3, Game.currentFloor, character.tile, character.plane, shotX, shotY);
                        }
                        if (effect != null) {
                            Game.currentEffectList.addElement(effect);
                        }
                        event.isComputed = true;
                    }
                }
                if (event.isComputed) continue;
                next_State = false;
            }
            for (i = 0; i < Game.displayBuffer[0].size(); ++i) {
                int old_Size = Game.displayBuffer[0].size();
                ((Placeable)Game.displayBuffer[0].elementAt(i)).animate(time_Delta);
                if (old_Size == Game.displayBuffer[0].size()) continue;
                --i;
            }
            for (i = 0; i < existingMoveables.length; ++i) {
                byte anim_Type;
                if (existingMoveablesSimulated[i]) continue;
                existingMoveables[i].simulate(time_Delta);
                if (!(existingMoveables[i] instanceof Character) || (anim_Type = ((Character)ScriptEvent.existingMoveables[i]).animType) == 0 || anim_Type == 1 || anim_Type == 9 || anim_Type == 11 || anim_Type == 13 || ScriptEvent.existingMoveables[i].type != 0 && anim_Type == 12) continue;
                ((Character)existingMoveables[i]).resumeAnim();
                next_State = false;
            }
            for (i = 0; i < createdPlaceables.length; ++i) {
                byte anim_Type;
                if (!(createdPlaceables[i] instanceof Moveable) || createdMoveablesSimulated[i]) continue;
                ((Moveable)createdPlaceables[i]).simulate(time_Delta);
                if (!(createdPlaceables[i] instanceof Character) || (anim_Type = ((Character)ScriptEvent.createdPlaceables[i]).animType) == 0 || anim_Type == 1 || anim_Type == 9) continue;
                if (anim_Type != 6) {
                    ((Character)createdPlaceables[i]).resumeAnim();
                    next_State = false;
                    continue;
                }
                if (((Character)createdPlaceables[i]).checkForWait() != -1) continue;
                next_State = false;
            }
            if (next_State) {
                scriptEventStartIndex = scriptEventEndIndex + 1;
                if (scriptEventStartIndex < scriptEvents[scriptIndex].length) {
                    for (i = scriptEventStartIndex; i < scriptEvents[scriptIndex].length; ++i) {
                        if (!ScriptEvent.scriptEvents[ScriptEvent.scriptIndex][i].isBreakPoint) continue;
                        scriptEventEndIndex = i;
                        break;
                    }
                    if (scriptEventEndIndex < scriptEventStartIndex) {
                        scriptEventEndIndex = scriptEvents[scriptIndex].length - 1;
                    }
                    ScriptEvent.resetState();
                    ScriptEvent.update(0);
                } else {
                    script_Over = true;
                }
            }
        } else {
            script_Over = true;
        }
        if (script_Over) {
            existingMoveables = null;
            createdPlaceables = null;
            existingMoveablesSimulated = null;
            createdMoveablesSimulated = null;
            scriptTexts = Game.dispose(scriptTexts);
            dialogIndexList = null;
            scriptIndex = -1;
            ScriptEvent.resetState();
            for (int i = 0; i < Game.displayBuffer[0].size(); ++i) {
                if (Game.get((Vector)Game.displayBuffer[0], (int)i).category != 6) continue;
                Game.effectList.addElement(Game.get(Game.displayBuffer[0], i));
            }
            Game.currentEffectList = Game.effectList;
        }
        Game.sortBuffer(Game.displayBuffer[0], true);
        Character.processPhysics = true;
        Character.processCollisions = true;
        Character.processAI = true;
        return script_Over;
    }

    static void disposeScript(int script_Index) {
        ScriptEvent.scriptEvents[script_Index] = null;
    }

    static void loadScripts(int dir_Index, int current_Level) {
        ScriptEvent.disposeLoadedScripts();
        DataInputStream in = new DataInputStream(Base.getInputStream(dir_Index, current_Level));
        try {
            byte version = in.readByte();
            if (version <= 1) {
                int nb_Scripts = in.readByte();
                scriptEvents = new ScriptEvent[nb_Scripts + 1][];
                CUSTOM_SCRIPT = nb_Scripts;
                ScriptEvent.scriptEvents[ScriptEvent.CUSTOM_SCRIPT] = new ScriptEvent[1];
                for (int script_Index = 0; script_Index < nb_Scripts; ++script_Index) {
                    int nb_Script_Events = in.readShort() + 1;
                    ScriptEvent.scriptEvents[script_Index] = new ScriptEvent[nb_Script_Events];
                    System.out.println("**************** loading script: " + script_Index);
                    ScriptEvent.scriptEvents[script_Index][0] = new ScriptEvent(-2147483391);
                    for (int i = 1; i < nb_Script_Events; ++i) {
                        ScriptEvent.scriptEvents[script_Index][i] = new ScriptEvent(in.readInt());
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static void setCustomScript(short text, byte character_Type) {
        ScriptEvent.scriptEvents[ScriptEvent.CUSTOM_SCRIPT][0] = new ScriptEvent(0x90000000 | (text & 0xFFFF) << 11 | character_Type & 0xFF);
    }

    static void disposeLoadedScripts() {
        if (scriptEvents != null) {
            for (int i = 0; i < scriptEvents.length; ++i) {
                ScriptEvent.disposeScript(i);
            }
        }
        scriptEvents = null;
        scriptIndex = -1;
    }

    static {
        scriptIndex = -1;
    }
}

