/*
 * Decompiled with CFR 0.152.
 */
package com.zenops.gts;

import com.zenops.gts.Floor;
import com.zenops.gts.Game;
import com.zenops.gts.Particle;
import com.zenops.gts.Placeable;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class Effect
extends Placeable {
    static final byte TYPE_IMPACT = 0;
    static final byte TYPE_FLASH = 1;
    static final byte TYPE_HOLE = 2;
    static final byte TYPE_IMPACT_BLOOD = 3;
    static final byte TYPE_DESTRUCTION = 4;
    static final byte TYPE_RADIOACTIVE_DESTRUCTION = 5;
    static final byte TYPE_OPEN_BOX = 6;
    static final byte TYPE_BIG_BLAST = 7;
    static final byte TYPE_FLAME = 8;
    static final byte TYPE_SPLASH = 9;
    static final byte TYPE_FIRE_RIGHT = 10;
    static final byte TYPE_FIRE_LEFT = 11;
    private Vector particles;

    Effect(byte type, Floor floor, int tile, int plane, int x, int y) {
        this.init((byte)6, type, floor, tile, plane);
        this.posX = x << 8;
        this.posY = y << 8;
        switch (type) {
            case 0: 
            case 3: {
                this.particles = new Vector(0);
                break;
            }
            case 1: {
                this.particles = new Vector(1);
                this.particles.addElement(new Particle(this.posX, this.posY, 0, 0, 100, Game.imgFlash));
                break;
            }
            case 2: {
                this.particles = new Vector(0);
                break;
            }
            case 4: 
            case 5: {
                this.particles = new Vector(5);
                Image[] imgArray = type == 4 ? Game.imgSmoke : Game.imgRadioactiveSmoke;
                int zone = Floor.TILE_SIZE << 7;
                this.particles.addElement(new Particle(this.posX - zone + Game.getNextInt(zone), this.posY - zone + Game.getNextInt(zone), 0, 0, 500 + Game.getNextInt(500), imgArray));
                this.particles.addElement(new Particle(this.posX - zone + Game.getNextInt(zone), this.posY + zone - Game.getNextInt(zone), 0, 0, 500 + Game.getNextInt(500), imgArray));
                this.particles.addElement(new Particle(this.posX + zone - Game.getNextInt(zone), this.posY - zone + Game.getNextInt(zone), 0, 0, 500 + Game.getNextInt(500), imgArray));
                this.particles.addElement(new Particle(this.posX + zone - Game.getNextInt(zone), this.posY + zone - Game.getNextInt(zone), 0, 0, 500 + Game.getNextInt(500), imgArray));
                this.particles.addElement(new Particle(this.posX, this.posY, 0, 0, 500 + Game.getNextInt(500), imgArray));
                break;
            }
            case 6: {
                this.particles = new Vector(1);
                this.particles.addElement(new Particle(this.posX, this.posY + (-8 - (Game.imgObject[IMAGE_REFS[2][0][0]].getWidth() >> 1) << 8), 0, 0, 400, Game.imgOpenBox));
                break;
            }
            case 7: {
                this.particles = new Vector(1);
                this.particles.addElement(new Particle(this.posX, this.posY, 0, 0, 300 + Game.getNextInt(200), Game.imgBlast));
                break;
            }
            case 8: {
                this.particles = new Vector(1);
                this.particles.addElement(new Particle(this.posX, this.posY, 0, 0, 1500 + Game.getNextInt(1500), Game.imgFlame, 300));
                break;
            }
            case 9: {
                this.particles = new Vector(1);
                this.particles.addElement(new Particle(this.posX, this.posY, 0, 0, 200, Game.imgSplashed));
                break;
            }
            case 10: 
            case 11: {
                this.particles = new Vector(0);
            }
        }
    }

    void animate(int timeDelta) {
        boolean alive = false;
        for (int i = 0; i < this.particles.size(); ++i) {
            if (this.type == 10 || this.type == 11) {
                ((Particle)this.particles.elementAt(i)).addGravity(timeDelta);
            }
            alive |= ((Particle)this.particles.elementAt(i)).simulate(timeDelta);
        }
        if (!alive) {
            Game.removeElement(Game.currentEffectList, this);
        }
    }

    void draw(Graphics g, int x, int y) {
        for (int i = 0; i < this.particles.size(); ++i) {
            ((Particle)this.particles.elementAt(i)).draw(g, x, y);
        }
    }
}

