/*
 * Decompiled with CFR 0.152.
 */
package com.zenops.gts;

import com.zenops.gts.Base;
import com.zenops.gts.Character;
import com.zenops.gts.Floor;
import com.zenops.gts.Game;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class Placeable {
    static final int TAKEABLE_OFFSET_Y = -8;
    static final int BREAKABLE_OFFSET_Y = -6;
    static final byte[] IMAGE_OFFSETS = new byte[]{0, -1, 0, -6, 0, -6, 0, -6, -6, 0, 6, 0, 12, 0, 9, -9, 18, -18, 4, -18, -12, 0, 0, -3, 0, -8, 0, -8, 0, -8, 0, -8, 0, -8, 0, -8, 0, -8, 0, -8, 0, -8, 0, -8, 11, 7, -11, -13, 0, 4, 10, -36, 19, -48, 6, -15, 0, 7, 0, 14, 0, -7, 0, -2, 0, 7, 0, -1, -1, 1, 8, 15, 1, -14, 1, -2, 0, 7, 0, 7, 0, (byte)(-(Floor.TILE_SIZE + 3)), 0, -10, 6, -28, 0, -13, 0, -13, 0, -13, 0, -13, 0, (byte)(-(Floor.TILE_SIZE >> 1))};
    private static int MIRROR_DIGICODE_OFFSET_X = 15;
    private static int LASER_LINE_OFFSET_X0 = -10;
    private static int LASER_LINE_OFFSET_Y0 = -16;
    private static int LASER_LINE_OFFSET_X1 = 10;
    private static int LASER_LINE_OFFSET_Y1 = 5;
    private static int GLOW_CYAN_OFFSET_X = -2;
    static byte[] TAKEABLE_VALUES = new byte[]{4, 8, 12, 3, 6, 9, 1, 3, 6, 1};
    static final byte CATEGORY_UNMUTABLE = 0;
    static final byte CATEGORY_BREAKABLE = 1;
    static final byte CATEGORY_TAKEABLE = 2;
    static final byte CATEGORY_GRAPHICAL = 3;
    static final byte CATEGORY_MOVEABLE = 4;
    static final byte CATEGORY_CHARACTER = 5;
    static final byte CATEGORY_EFFECT = 6;
    static final byte TYPE_LIFT = 0;
    static final byte TYPE_LOCKED_LIFT = 1;
    static final byte TYPE_WALL = 2;
    static final byte TYPE_CRACKED_WALL = 3;
    static final byte TYPE_DOOR = 4;
    static final byte TYPE_LOCKED_DOOR = 5;
    static final byte TYPE_DIGICODE = 7;
    static final byte TYPE_COMPUTER = 8;
    static final byte TYPE_FRONT_POST = 9;
    static final byte TYPE_FLOOR_INDIC = 10;
    static final byte TYPE_CAMERA_HEAD = 11;
    static final byte TYPE_ROPE = 12;
    static final byte TYPE_CONE_OF_SILENCE = 14;
    static final byte TYPE_FOOTBALL = 15;
    static final byte TYPE_HEALTH_0 = 0;
    static final byte TYPE_HEALTH_1 = 1;
    static final byte TYPE_HEALTH_2 = 2;
    static final byte TYPE_AMMO_0 = 3;
    static final byte TYPE_AMMO_1 = 4;
    static final byte TYPE_AMMO_2 = 5;
    static final byte TYPE_PETROL_0 = 6;
    static final byte TYPE_PETROL_1 = 7;
    static final byte TYPE_PETROL_2 = 8;
    static final byte TYPE_DENTAL_FLOSS = 9;
    static final byte TYPE_GLOW_CYAN = 0;
    static final byte TYPE_GLOW_BLUE = 1;
    static final byte TYPE_GLOW_RED = 2;
    static final byte TYPE_GLOW_CYAN_CENTERED = 3;
    static final byte TYPE_GLOW_CANDLE = 4;
    static final byte TYPE_GLOW_LIGHTBEAM = 5;
    static final byte TYPE_GLOW_GREENPOINTS = 6;
    static final byte TYPE_GLOW_REDPOINT = 7;
    static final byte TYPE_GLOW_THIN_RED = 8;
    static final byte TYPE_GLOW_THIN_GREEN = 9;
    byte category;
    byte type;
    Floor floor;
    short tile;
    byte plane;
    int posX;
    int posY;
    byte animType;
    byte animFrame;
    int animTimer;
    int displayPriority;
    int value;
    private static int DISPLAY_STARTTILE = -Floor.TILE_SIZE >> 1;
    private static int DISPLAY_FOREPLANE = -Floor.TILE_SIZE << 8;
    private static int DISPLAY_FORETILE = -Floor.TILE_SIZE - 1;
    private static int GLOW_PRIORITY = DISPLAY_FOREPLANE + DISPLAY_FORETILE;
    protected static final int[][] DISPLAY_PRIORITY_DELTA = new int[][]{{DISPLAY_STARTTILE, DISPLAY_STARTTILE, -DISPLAY_FORETILE, -DISPLAY_FORETILE, -DISPLAY_FORETILE << 1, -DISPLAY_FORETILE << 1, 0, -DISPLAY_FOREPLANE << 1, -DISPLAY_FOREPLANE << 1, DISPLAY_FOREPLANE >> 1, 0, (DISPLAY_FOREPLANE << 1) + (DISPLAY_FOREPLANE >> 1), DISPLAY_FORETILE, 0, DISPLAY_FORETILE, -DISPLAY_FORETILE}, {DISPLAY_FORETILE >> 1, DISPLAY_FORETILE >> 1, DISPLAY_FORETILE >> 1, DISPLAY_FORETILE >> 1, DISPLAY_FORETILE >> 1, DISPLAY_FORETILE >> 1}, {-DISPLAY_FORETILE, -DISPLAY_FORETILE, -DISPLAY_FORETILE, -DISPLAY_FORETILE, -DISPLAY_FORETILE, -DISPLAY_FORETILE, -DISPLAY_FORETILE, -DISPLAY_FORETILE, -DISPLAY_FORETILE, -DISPLAY_FORETILE}, {GLOW_PRIORITY, DISPLAY_FORETILE, GLOW_PRIORITY, DISPLAY_FORETILE, GLOW_PRIORITY, DISPLAY_FORETILE, GLOW_PRIORITY, GLOW_PRIORITY, DISPLAY_FORETILE, DISPLAY_FORETILE}, {-DISPLAY_FORETILE, -DISPLAY_FORETILE, -DISPLAY_FORETILE, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {-DISPLAY_FORETILE >> 1, 0, 0, -DISPLAY_FORETILE >> 1, 0, 0, -DISPLAY_FORETILE, DISPLAY_FORETILE >> 1, DISPLAY_FORETILE >> 2, DISPLAY_FORETILE, -1, -1}};
    static final byte SHADOW_IMAGE_INDEX = 0;
    static final byte ENV_OBJ_IMAGE_OFFSET = 1;
    static final byte GLOBAL_OBJ_IMAGE_OFFSET = 12;
    static final byte GRAPHICAL_IMAGE_OFFSET = 31;
    static final byte OTHER_IMAGE_OFFSET = 40;
    static final byte CLOSE_DOOR_IMAGE_INDEX = 7;
    static final byte OPEN_DOOR_IMAGE_INDEX = 8;
    static final byte PROFILE_DIGICODE_IMAGE_INDEX = 25;
    static final byte FACE_DIGICODE_IMAGE_INDEX = 26;
    static final byte CONE_OF_SILENCE_IMAGE_NB = 1;
    static final byte[][][] IMAGE_REFS = new byte[][][]{new byte[][]{{4, 5}, {4, 5, 27}, {6}, {6, 0}, {9, 7}, {9, 7, 25}, new byte[0], {28}, {29}, {10}, {11, 11}, {30, 0}, {40}, {39}, {43}, {44}}, new byte[][]{{0, 1}, {0, 1}, {0, 2}, {0, 2}, {0, 3}, {0, 3}}, new byte[][]{{12}, {13}, {14}, {15}, {16}, {17}, {18}, {19}, {20}, {21}}, new byte[][]{{31}, {32}, {33}, {31}, {34}, {35}, {36}, {37}, {38}, {39}}, new byte[][]{{24, 0}, {24, 0}, {24, 0}, {23, 0, 22}, {23, 0, 22}, {23, 0, 22}}};

    protected Placeable() {
    }

    protected Placeable(byte category, byte type, Floor floor, int tile, int plane) {
        this.init(category, type, floor, tile, plane);
    }

    void init(byte category, byte type, Floor floor, int tile, int plane) {
        this.category = category;
        this.type = type;
        this.floor = floor;
        this.tile = (short)tile;
        this.plane = (byte)plane;
        this.posX = tile * Floor.TILE_SIZE + (Floor.TILE_SIZE >> 1) << 8;
        this.posY = (plane + 1) * Floor.TILE_SIZE << 8;
        this.computeDisplayPriority();
    }

    void updatePhysics() {
        switch (this.category) {
            case 0: {
                switch (this.type) {
                    case 0: 
                    case 1: {
                        this.floor.setPhysics(this.tile, this.plane + 1, 2);
                        this.floor.tileMap[this.plane - 1][this.tile] = -1;
                        this.floor.tileMap[this.plane][this.tile] = -1;
                        break;
                    }
                    case 2: {
                        this.floor.setPhysics(this.tile, this.plane, 1);
                        this.floor.setPhysics(this.tile + 1, this.plane, 1);
                        this.floor.setCorner(this.tile, this.plane, 0, true);
                        this.floor.setCorner(this.tile, this.plane, 1, true);
                        this.floor.setCorner(this.tile, this.plane, 3, true);
                        this.floor.setCorner(this.tile + 1, this.plane, 0, true);
                        this.floor.setCorner(this.tile + 1, this.plane, 2, true);
                        this.floor.setCorner(this.tile + 1, this.plane, 3, true);
                        break;
                    }
                    case 3: {
                        this.floor.setPhysics(this.tile, this.plane, 9);
                        this.floor.setPhysics(this.tile + 1, this.plane, 9);
                        this.floor.setCorner(this.tile, this.plane, 0, true);
                        this.floor.setCorner(this.tile, this.plane, 1, true);
                        this.floor.setCorner(this.tile, this.plane, 3, true);
                        this.floor.setCorner(this.tile + 1, this.plane, 0, true);
                        this.floor.setCorner(this.tile + 1, this.plane, 2, true);
                        this.floor.setCorner(this.tile + 1, this.plane, 3, true);
                        break;
                    }
                    case 4: 
                    case 5: {
                        this.floor.setPhysics(this.tile, this.plane, 3);
                        this.floor.setPhysics(this.tile + 1, this.plane, 3);
                        this.animFrame = 0;
                        this.floor.setCorner(this.tile, this.plane, 0, true);
                        this.floor.setCorner(this.tile, this.plane, 1, true);
                        this.floor.setCorner(this.tile, this.plane, 3, true);
                        this.floor.setCorner(this.tile + 1, this.plane, 0, true);
                        this.floor.setCorner(this.tile + 1, this.plane, 2, true);
                        this.floor.setCorner(this.tile + 1, this.plane, 3, true);
                        break;
                    }
                    case 7: 
                    case 8: {
                        this.floor.setPhysics(this.tile, this.plane + 2, 5);
                    }
                }
                break;
            }
            case 1: {
                this.floor.setPhysics(this.tile, this.plane, 4);
                this.floor.setCorner(this.tile, this.plane, 0, true);
                this.floor.setCorner(this.tile, this.plane, 1, true);
                this.floor.setCorner(this.tile, this.plane, 2, true);
                this.floor.setCorner(this.tile, this.plane, 3, true);
                break;
            }
            case 2: {
                this.floor.setPhysics(this.tile, this.plane, 6);
                break;
            }
            case 5: {
                if (Character.AI_TYPE[this.type] == 1) {
                    this.floor.setPhysics(this.tile, this.plane, 10);
                    this.floor.setPhysics(this.tile, Floor.FIRST_ACTION_PLANE + Floor.SECOND_ACTION_PLANE - this.plane, 10);
                    break;
                }
                if (this.type != 11) break;
                this.floor.setPhysics(this.tile, this.plane, 10);
            }
        }
    }

    void animate(int timeDelta) {
        switch (this.category << 8 | this.type) {
            case 4: 
            case 5: {
                if (this.animFrame == 0 || Game.getCharacter(Game.currentMoveableList, -1, -1, this.tile, this.plane, 3, 3, null) != null) break;
                this.floor.setCorner(this.tile, this.plane, 0, true);
                this.floor.setCorner(this.tile, this.plane, 1, true);
                this.floor.setCorner(this.tile, this.plane, 3, true);
                this.floor.setCorner(this.tile + 1, this.plane, 0, true);
                this.animFrame = 0;
                break;
            }
            case 512: 
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 517: 
            case 518: 
            case 519: 
            case 520: 
            case 521: {
                this.animTimer += timeDelta;
                if (this.animTimer <= 50) break;
                this.animFrame = (byte)(this.animFrame + 1);
                this.animFrame = (byte)(this.animFrame & 7);
                this.animTimer = 0;
                break;
            }
            case 1027: 
            case 1028: 
            case 1029: {
                int color = Game.getNextInt(170);
                this.animTimer = 0xFF0000 | color << 8 | color;
                break;
            }
        }
    }

    private void drawImage(Graphics g, Image img, int x, int y) {
        g.drawImage(img, Floor.getScreenX(-x, this.posX >> 8), Floor.getScreenY(-y, this.posY >> 8), 33);
    }

    void draw(Graphics g, int x, int y) {
        int oldClipX = g.getClipX();
        int oldClipY = g.getClipY();
        int oldClipW = g.getClipWidth();
        int oldClipH = g.getClipHeight();
        if ((this.category << 8 | this.type) == 0 || (this.category << 8 | this.type) == 1) {
            int x0 = Floor.getScreenX(x, this.tile * Floor.TILE_SIZE);
            int y0 = Floor.getTileScreenY(y, this.plane + 1) - (Floor.TILE_SIZE << 1);
            g.setClip(x0, y0, Floor.TILE_SIZE, Floor.TILE_SIZE << 1);
        }
        for (int i = 0; i < IMAGE_REFS[this.category][this.type].length; ++i) {
            Image img = Game.imgObject[IMAGE_REFS[this.category][this.type][i]];
            int offsetY = 0;
            int offsetX = 0;
            switch (this.category << 8 | this.type) {
                case 0: 
                case 1: {
                    offsetX = Math.min(1, (i << 1) - 1) * (this.animTimer * Floor.TILE_SIZE >> 10);
                    break;
                }
                case 2: {
                    if (this.plane != Floor.FIRST_ACTION_PLANE || Game.player.plane != Floor.SECOND_ACTION_PLANE || this.tile != Game.player.tile && this.tile != Game.player.tile - 1) break;
                    img = Game.imgWallAlpha;
                    break;
                }
                case 3: {
                    if (i != 1) break;
                    Placeable.IMAGE_REFS[this.category][this.type][i] = Game.environment == 1 || Game.environment == 3 ? 42 : 41;
                    img = Game.imgObject[IMAGE_REFS[this.category][this.type][i]];
                    break;
                }
                case 4: 
                case 5: {
                    if (i == 0) {
                        if ((this.plane != Floor.FIRST_ACTION_PLANE || Game.player.plane != Floor.SECOND_ACTION_PLANE || this.tile != Game.player.tile && this.tile != Game.player.tile - 1) && (this.plane != Game.player.plane || Game.player.tile != this.tile + 1)) break;
                        img = Game.imgDoorAlpha;
                        break;
                    }
                    if (i == 1) {
                        Placeable.IMAGE_REFS[this.category][this.type][i] = this.animFrame == 0 ? 7 : 8;
                        img = Game.imgObject[IMAGE_REFS[this.category][this.type][i]];
                        if (this.animFrame != -1) break;
                        Base.zenDrawImageNokia(g, img, 2, Floor.getScreenX(x, this.tile * Floor.TILE_SIZE) + IMAGE_OFFSETS[IMAGE_REFS[this.category][this.type][i] << 1] + (Floor.TILE_SIZE >> 1) - img.getWidth() + 2, Floor.getTileScreenY(y, this.plane + 1) + IMAGE_OFFSETS[(IMAGE_REFS[this.category][this.type][i] << 1) + 1], 33);
                        img = null;
                        break;
                    }
                    if (i != 2) break;
                    Placeable.IMAGE_REFS[this.category][this.type][i] = this.animFrame == 0 ? 25 : 26;
                    img = Game.imgObject[IMAGE_REFS[this.category][this.type][i]];
                    if (this.animFrame != -1) break;
                    Base.zenDrawImageNokia(g, img, 2, Floor.getScreenX(x, this.tile * Floor.TILE_SIZE) + IMAGE_OFFSETS[IMAGE_REFS[this.category][this.type][i] << 1] + (Floor.TILE_SIZE >> 1) - img.getWidth() + 2 - MIRROR_DIGICODE_OFFSET_X, Floor.getTileScreenY(y, this.plane + 1) + IMAGE_OFFSETS[(IMAGE_REFS[this.category][this.type][i] << 1) + 1], 33);
                    img = null;
                    break;
                }
                case 9: {
                    if ((this.plane != Floor.FIRST_ACTION_PLANE || Game.player.plane != Floor.SECOND_ACTION_PLANE || this.tile - 1 != Game.player.tile && this.tile - 1 != Game.player.tile - 1) && (this.plane != Game.player.plane || Game.player.tile != this.tile && Game.player.tile != this.tile - 1)) break;
                    img = Game.imgFrontPostAlpha;
                    break;
                }
                case 10: {
                    if (i != 1) break;
                    g.setColor(9887231);
                    g.drawString(Game.imgStrFloors[this.floor.level], Floor.getScreenX(x, this.tile * Floor.TILE_SIZE + (Floor.TILE_SIZE >> 1)), Floor.getTileScreenY(y, this.plane) + (Floor.TILE_SIZE + Game.fontCurrentHeight >> 1), 33);
                    img = null;
                    break;
                }
                case 14: {
                    img = Game.imgObject[IMAGE_REFS[this.category][this.type][i]];
                    break;
                }
                case 512: 
                case 513: 
                case 514: 
                case 515: 
                case 516: 
                case 517: 
                case 518: 
                case 519: 
                case 520: 
                case 521: {
                    if (this.animFrame != 0) break;
                    img = Game.imgTakeableMask;
                    break;
                }
                case 11: 
                case 1024: 
                case 1025: 
                case 1026: {
                    if (i != 1) break;
                    this.floor.drawCameraLink(g, x, y, this, this.category << 8 | this.type);
                    return;
                }
                case 1027: 
                case 1028: 
                case 1029: {
                    if (i != 1) break;
                    g.setColor(this.animTimer);
                    g.drawLine(Floor.getScreenX(x, this.posX >> 8) + LASER_LINE_OFFSET_X0, Floor.getScreenY(y, this.posY >> 8) + LASER_LINE_OFFSET_Y0, Floor.getScreenX(x, this.posX >> 8) + LASER_LINE_OFFSET_X1, Floor.getScreenY(y, this.posY >> 8) + LASER_LINE_OFFSET_Y1);
                    img = null;
                }
            }
            if (img == null) continue;
            this.drawImage(g, img, -x + IMAGE_OFFSETS[IMAGE_REFS[this.category][this.type][i] << 1] + offsetX, -y + IMAGE_OFFSETS[(IMAGE_REFS[this.category][this.type][i] << 1) + 1] + offsetY);
        }
        if ((this.category << 8 | this.type) == 0 || (this.category << 8 | this.type) == 1) {
            g.setClip(oldClipX, oldClipY, oldClipW, oldClipH);
        }
    }

    void computeDisplayPriority() {
        this.displayPriority = ((Floor.NB_PLANES - 1 - this.plane) * Floor.TILE_SIZE << 8) + (this.posX >> 8) + DISPLAY_PRIORITY_DELTA[this.category][this.type];
    }
}

