/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class CSFX {
    private MyCanvas myCanvas;
    public static Player player;
    public int soundVolume;
    private int loopCount;
    public int preloadedIndex;
    public String ctype;
    public String loc;
    private boolean audioEnabled = true;
    public static int lastSoundPlayed;
    public static int currentSound;
    public static boolean playerCreated;
    public VolumeControl vc;
    public static int MAX_VOLUME;
    public static final String AUDIO_MIDI = "audio/midi";
    public static final int PLAY_LOOP = -1;
    public static final int PLAY_ONCE = 1;

    CSFX(MyCanvas myCanvas) {
        this.myCanvas = myCanvas;
    }

    public void choosePlayer(String location, String cType, int loopCount, int soundVolume) {
        this.loc = location;
        this.ctype = cType;
        this.loopCount = loopCount;
        this.soundVolume = soundVolume;
    }

    void createPlayer() {
        try {
            InputStream is = this.getClass().getResourceAsStream(this.loc);
            player = Manager.createPlayer((InputStream)is, (String)this.ctype);
            player.setLoopCount(this.loopCount);
            playerCreated = true;
        }
        catch (IOException ioe) {
            System.err.println(ioe);
        }
        catch (MediaException me) {
            System.err.println((Object)me);
        }
        catch (Exception ex) {
            if (player != null) {
                player.close();
                player = null;
            }
            System.err.println("Problem creating player");
            System.err.println(ex);
        }
    }

    public boolean playSound() {
        if (this.audioEnabled) {
            if (player != null) {
                try {
                    player.realize();
                    player.prefetch();
                    this.setSoundVolume(this.soundVolume);
                    player.start();
                    return true;
                }
                catch (Exception ex) {
                    System.err.println("Problem starting player");
                    return false;
                }
            }
            this.createPlayer();
            try {
                player.realize();
                player.prefetch();
                this.setSoundVolume(this.soundVolume);
                player.start();
                return true;
            }
            catch (Exception ex) {
                System.err.println("Problem starting player");
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopSound() {
        try {
            if (player != null) {
                player.close();
            }
        }
        catch (Exception ex) {
            System.err.println("Problem closing player");
        }
        finally {
            player = null;
            playerCreated = false;
        }
    }

    public static int GetState() {
        if (player != null) {
            return player.getState();
        }
        return -1;
    }

    void setSoundVolume(int volume) {
        this.soundVolume = volume;
        try {
            if (player != null) {
                this.vc = (VolumeControl)player.getControl("VolumeControl");
                this.vc.setLevel(this.soundVolume);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println("Problem setting sound volume");
        }
    }

    public void run() {
        try {
            Thread.currentThread();
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        MAX_VOLUME = 100;
    }
}

