/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class CConfigFile {
    private static final String[] SAVE_FILE_NAMES = new String[]{"oitocfg", "oitohscr", "oitocont", "oitostat"};
    public static final int GAME_STATUS = 0;
    public static final int HIGH_SCORE = 1;
    public static final int CONTINUE = 2;
    public static final int STATISTICS = 3;
    public static final int CONFIG_FILE_MAX_HIGHSCORES = 3;
    public static int m_iEndTimer = 0;
    public static int gameMode;
    public static int isChampionshipRound;
    public static boolean m_bEightSeconds;
    public static boolean saved;
    public static boolean firstLoad;
    public static boolean firstLoadingScreen;
    public static int gameState;
    public static int multiplexerState;
    public static int currentCowboy;
    public static int currentBull;
    public static int trainingCowboy;
    public static int trainingBull;
    public static CTypes.Score[][] championshipPoints;
    public static int nextLockedCowboy;
    public static int nextLockedBull;
    public static boolean vibrate;
    public static int volume;
    public static boolean soundOn;
    public static int language;
    public static int w_MainMenu;
    private int numRecords = 0;
    private RecordStore oitoSegundosSave;
    private int totalPoints = 0;
    private CTypes.HighScore[] highscores;
    private int[] cowboyRidesNumber = new int[4];
    private int[][] bullRidesNumber = new int[3][5];

    public CConfigFile() {
        int i;
        volume = CSFX.MAX_VOLUME * 3 / 5;
        language = 0;
        firstLoad = true;
        firstLoadingScreen = true;
        this.highscores = new CTypes.HighScore[3];
        for (i = 0; i < this.highscores.length; ++i) {
            this.highscores[i] = new CTypes.HighScore();
        }
        championshipPoints = new CTypes.Score[3][];
        for (i = 0; i < championshipPoints.length; ++i) {
            CConfigFile.championshipPoints[i] = new CTypes.Score[5];
        }
        for (i = 0; i < championshipPoints.length; ++i) {
            for (int j = 0; j < championshipPoints[i].length; ++j) {
                CConfigFile.championshipPoints[i][j] = new CTypes.Score();
            }
        }
        for (i = 0; i < SAVE_FILE_NAMES.length; ++i) {
            if (this.load(i)) continue;
            this.saveDefault(i);
        }
    }

    private void saveDefault(int type) {
        this.resetStore(type);
        this.resetSave(type);
        this.save(type);
    }

    public void resetSave(int type) {
        switch (type) {
            case 0: {
                vibrate = true;
                volume = CSFX.MAX_VOLUME * 3 / 5;
                nextLockedBull = 3;
                nextLockedCowboy = 3;
                this.totalPoints = 0;
                language = 0;
                soundOn = true;
                firstLoad = true;
                firstLoadingScreen = true;
                break;
            }
            case 1: {
                for (int i = 0; i < this.highscores.length; ++i) {
                    this.highscores[i].name = LocalizedText.HIGH_SCORE_DEFAULT_NAME;
                    this.highscores[i].championshipsPoints = 0;
                    this.highscores[i].usedCowboy = 10;
                }
                break;
            }
            case 2: {
                currentCowboy = 0;
                currentBull = 0;
                trainingCowboy = 0;
                trainingBull = 0;
                isChampionshipRound = -1;
                saved = false;
                multiplexerState = 0;
                for (int i = 0; i < championshipPoints.length; ++i) {
                    for (int j = 0; j < championshipPoints[i].length; ++j) {
                        CConfigFile.championshipPoints[i][j].agilityPoints = 0;
                        CConfigFile.championshipPoints[i][j].bullPoints = 0;
                        CConfigFile.championshipPoints[i][j].timePoints = 0;
                    }
                }
                break;
            }
            case 3: {
                int i;
                for (i = 0; i < this.cowboyRidesNumber.length; ++i) {
                    this.cowboyRidesNumber[i] = 0;
                }
                for (i = 0; i < this.bullRidesNumber.length; ++i) {
                    for (int j = 0; j < this.bullRidesNumber[i].length; ++j) {
                        this.bullRidesNumber[i][j] = 0;
                    }
                }
                break;
            }
        }
    }

    public CTypes.HighScore[] GetHighScores() {
        return this.highscores;
    }

    public void SetHighScores(CTypes.HighScore[] scores) {
        for (int i = 0; i < 3; ++i) {
            this.highscores[i].name = scores[i].name;
            this.highscores[i].championshipsPoints = scores[i].championshipsPoints;
            this.highscores[i].usedCowboy = scores[i].usedCowboy;
        }
    }

    public void SetTotalPoints(long a_iTotalPoints) {
        if (a_iTotalPoints > Integer.MAX_VALUE) {
            a_iTotalPoints = Integer.MAX_VALUE;
        }
        this.totalPoints = (int)a_iTotalPoints;
    }

    public int GetTotalPoints() {
        return this.totalPoints;
    }

    public void IncrementBullRide(int a_iBull, int a_iGameMode) {
        if (this.bullRidesNumber[a_iGameMode - 1][a_iBull] < Integer.MAX_VALUE) {
            int[] nArray = this.bullRidesNumber[a_iGameMode - 1];
            int n = a_iBull;
            nArray[n] = nArray[n] + 1;
        }
    }

    public int GetBullRides(int a_iBull, int a_iGameMode) {
        return this.bullRidesNumber[a_iGameMode - 1][a_iBull];
    }

    public void IncrementCowboyRide(int a_iCowboy) {
        if (this.cowboyRidesNumber[a_iCowboy] < Integer.MAX_VALUE) {
            int n = a_iCowboy;
            this.cowboyRidesNumber[n] = this.cowboyRidesNumber[n] + 1;
        }
    }

    public int GetCowboyRide(int a_iCowboy) {
        return this.cowboyRidesNumber[a_iCowboy];
    }

    public void save(int type) {
        ByteArrayOutputStream byteArrayWriter = new ByteArrayOutputStream();
        DataOutputStream dataWriter = new DataOutputStream(byteArrayWriter);
        byte[] data = null;
        boolean isDataAlreadyExists = false;
        try {
            this.oitoSegundosSave = RecordStore.openRecordStore((String)SAVE_FILE_NAMES[type], (boolean)true);
            switch (type) {
                case 0: {
                    dataWriter.writeBoolean(vibrate);
                    dataWriter.writeInt(volume);
                    dataWriter.writeBoolean(soundOn);
                    dataWriter.writeInt(nextLockedBull);
                    dataWriter.writeInt(nextLockedCowboy);
                    dataWriter.writeInt(this.totalPoints);
                    dataWriter.writeInt(language);
                    dataWriter.writeBoolean(firstLoad);
                    dataWriter.writeBoolean(firstLoadingScreen);
                    break;
                }
                case 1: {
                    for (int i = 0; i < this.highscores.length; ++i) {
                        dataWriter.writeUTF(this.highscores[i].name);
                        dataWriter.writeInt(this.highscores[i].championshipsPoints);
                        dataWriter.writeInt(this.highscores[i].usedCowboy);
                    }
                    break;
                }
                case 2: {
                    dataWriter.writeInt(currentCowboy);
                    dataWriter.writeInt(currentBull);
                    dataWriter.writeInt(isChampionshipRound);
                    dataWriter.writeBoolean(saved);
                    dataWriter.writeInt(multiplexerState);
                    for (int i = 0; i < championshipPoints.length; ++i) {
                        for (int j = 0; j < championshipPoints[i].length; ++j) {
                            dataWriter.writeInt(CConfigFile.championshipPoints[i][j].agilityPoints);
                            dataWriter.writeInt(CConfigFile.championshipPoints[i][j].bullPoints);
                            dataWriter.writeInt(CConfigFile.championshipPoints[i][j].timePoints);
                        }
                    }
                    break;
                }
                case 3: {
                    int i;
                    for (i = 0; i < this.cowboyRidesNumber.length; ++i) {
                        dataWriter.writeInt(this.cowboyRidesNumber[i]);
                    }
                    for (i = 0; i < this.bullRidesNumber.length; ++i) {
                        for (int j = 0; j < this.bullRidesNumber[i].length; ++j) {
                            dataWriter.writeInt(this.bullRidesNumber[i][j]);
                        }
                    }
                    break;
                }
            }
            dataWriter.flush();
            data = byteArrayWriter.toByteArray();
            try {
                this.oitoSegundosSave.getRecord(1);
                isDataAlreadyExists = true;
            }
            catch (Exception e) {
                isDataAlreadyExists = false;
            }
            if (!isDataAlreadyExists) {
                int id = this.oitoSegundosSave.addRecord(data, 0, data.length);
            } else {
                this.oitoSegundosSave.setRecord(1, data, 0, data.length);
            }
            byteArrayWriter.reset();
            dataWriter.close();
            dataWriter = null;
            byteArrayWriter.close();
            byteArrayWriter = null;
            this.oitoSegundosSave.closeRecordStore();
            this.oitoSegundosSave = null;
        }
        catch (RecordStoreException re) {
            re.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean load(int type) {
        boolean isLoadSuccessful = false;
        byte[] loadedData = null;
        try {
            this.oitoSegundosSave = RecordStore.openRecordStore((String)SAVE_FILE_NAMES[type], (boolean)true);
            this.numRecords = this.oitoSegundosSave.getNumRecords();
            loadedData = this.numRecords == 0 ? null : this.oitoSegundosSave.getRecord(1);
            if (loadedData == null) return isLoadSuccessful;
            ByteArrayInputStream byteArrayReader = new ByteArrayInputStream(loadedData);
            DataInputStream dataReader = new DataInputStream(byteArrayReader);
            switch (type) {
                case 0: {
                    vibrate = dataReader.readBoolean();
                    volume = dataReader.readInt();
                    soundOn = dataReader.readBoolean();
                    nextLockedBull = dataReader.readInt();
                    nextLockedCowboy = dataReader.readInt();
                    this.totalPoints = dataReader.readInt();
                    language = dataReader.readInt();
                    firstLoad = dataReader.readBoolean();
                    firstLoadingScreen = dataReader.readBoolean();
                    break;
                }
                case 1: {
                    int i;
                    for (i = 0; i < this.highscores.length; ++i) {
                        this.highscores[i].name = dataReader.readUTF();
                        this.highscores[i].championshipsPoints = dataReader.readInt();
                        this.highscores[i].usedCowboy = dataReader.readInt();
                        if (this.highscores[i].usedCowboy == 0) {
                            this.highscores[i].name = LocalizedText.COWBOYS_NAMES[0];
                            continue;
                        }
                        if (this.highscores[i].usedCowboy == 1) {
                            this.highscores[i].name = LocalizedText.COWBOYS_NAMES[1];
                            continue;
                        }
                        if (this.highscores[i].usedCowboy == 2) {
                            this.highscores[i].name = LocalizedText.COWBOYS_NAMES[2];
                            continue;
                        }
                        if (this.highscores[i].usedCowboy != 3) continue;
                        this.highscores[i].name = LocalizedText.COWBOYS_NAMES[3];
                    }
                    break;
                }
                case 2: {
                    int i;
                    currentCowboy = dataReader.readInt();
                    currentBull = dataReader.readInt();
                    isChampionshipRound = dataReader.readInt();
                    saved = dataReader.readBoolean();
                    multiplexerState = dataReader.readInt();
                    for (i = 0; i < championshipPoints.length; ++i) {
                        for (int j = 0; j < championshipPoints[i].length; ++j) {
                            CConfigFile.championshipPoints[i][j].agilityPoints = dataReader.readInt();
                            CConfigFile.championshipPoints[i][j].bullPoints = dataReader.readInt();
                            CConfigFile.championshipPoints[i][j].timePoints = dataReader.readInt();
                        }
                    }
                    break;
                }
                case 3: {
                    int i;
                    for (i = 0; i < this.cowboyRidesNumber.length; ++i) {
                        this.cowboyRidesNumber[i] = dataReader.readInt();
                    }
                    for (i = 0; i < this.bullRidesNumber.length; ++i) {
                        for (int j = 0; j < this.bullRidesNumber[i].length; ++j) {
                            this.bullRidesNumber[i][j] = dataReader.readInt();
                        }
                    }
                    break;
                }
            }
            isLoadSuccessful = true;
            dataReader.close();
            dataReader = null;
            byteArrayReader.close();
            byteArrayReader = null;
            return isLoadSuccessful;
        }
        catch (RecordStoreException re) {
            System.out.println("ERROR @GameState.load() : " + re.getMessage());
            re.printStackTrace();
            return isLoadSuccessful;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return isLoadSuccessful;
        }
        finally {
            if (this.oitoSegundosSave != null) {
                try {
                    this.oitoSegundosSave.closeRecordStore();
                }
                catch (RecordStoreNotOpenException e) {
                    e.printStackTrace();
                }
                catch (RecordStoreException e) {
                    e.printStackTrace();
                }
                finally {
                    this.oitoSegundosSave = null;
                }
            }
        }
    }

    public boolean hasSavedLang() {
        try {
            this.oitoSegundosSave = RecordStore.openRecordStore((String)SAVE_FILE_NAMES[0], (boolean)true);
            try {
                return this.oitoSegundosSave.getNumRecords() != 0;
            }
            catch (RecordStoreNotOpenException e) {
                e.printStackTrace();
            }
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
        return false;
    }

    public void resetStore(int type) {
        try {
            RecordStore.deleteRecordStore((String)SAVE_FILE_NAMES[type]);
        }
        catch (RecordStoreException recStrExc) {
            System.out.println("ERROR @GameState:resetStore()");
            recStrExc.printStackTrace();
        }
    }

    public void resetTotalPoints() {
        this.totalPoints = 0;
    }

    static {
        isChampionshipRound = -1;
        m_bEightSeconds = false;
        saved = false;
        firstLoad = true;
        firstLoadingScreen = true;
        gameState = 0;
        multiplexerState = 0;
        currentCowboy = 0;
        currentBull = 0;
        trainingCowboy = 0;
        trainingBull = 0;
        nextLockedCowboy = 3;
        nextLockedBull = 3;
        vibrate = true;
        soundOn = true;
        language = 0;
        w_MainMenu = 0;
    }
}

