/*
 * Decompiled with CFR 0.152.
 */
public class CFixedPoint {
    public static final int FP_SHIFT = 16;
    public static final int FP_PI = 205887;
    private static final int FP_SHIFT_VALUE = 65536;
    public long m_iValue;

    public CFixedPoint() {
        this.m_iValue = 0L;
    }

    public CFixedPoint(CFixedPoint a) {
        this.m_iValue = a.m_iValue;
    }

    public CFixedPoint(long a) {
        this.m_iValue = a << 16;
    }

    public static int Fixed2Int(CFixedPoint f) {
        return (int)(f.m_iValue >> 16);
    }

    public static int Int2Fixed(int value) {
        return value << 16;
    }

    public void ResetState() {
        this.m_iValue = 0L;
    }

    public CFixedPoint Copy() {
        return new CFixedPoint(this);
    }

    public byte[] GetBytes() {
        byte[] data = new byte[4];
        for (int i = 0; i < data.length; ++i) {
            data[i] = Long.toString(this.m_iValue).getBytes()[i];
        }
        return data;
    }

    public boolean SetBytes(byte[] data) {
        try {
            this.m_iValue = Integer.parseInt(data.toString());
        }
        catch (NullPointerException np) {
            return false;
        }
        return true;
    }

    public void Attribution(CFixedPoint a) {
        this.m_iValue = a.m_iValue;
    }

    public void Attribution(int a) {
        this.m_iValue = a << 16;
    }

    public void Attribution(long a) {
        this.m_iValue = a;
    }

    public void PlusEqual(CFixedPoint a) {
        this.m_iValue += a.m_iValue;
    }

    public void PlusEqual(int a) {
        this.m_iValue += (long)(a << 16);
    }

    public void MinusEqual(CFixedPoint a) {
        this.m_iValue -= a.m_iValue;
    }

    public void MinusEqual(int a) {
        this.m_iValue -= (long)(a << 16);
    }

    public void MultiplyEqual(CFixedPoint a) {
        this.m_iValue = this.m_iValue * a.m_iValue >> 16;
    }

    public void MultiplyEqual(int a) {
        this.m_iValue *= (long)a;
    }

    public void DivideEqual(CFixedPoint a) {
        this.m_iValue = (this.m_iValue << 16) / a.m_iValue;
    }

    public void DivideEqual(int a) {
        this.m_iValue /= (long)a;
    }

    public void PlusPlus() {
        this.m_iValue += 16L;
    }

    public void MinusMinus() {
        this.m_iValue -= 16L;
    }

    public CFixedPoint Negation() {
        CFixedPoint t = new CFixedPoint();
        t.m_iValue = -this.m_iValue;
        return t;
    }

    public static CFixedPoint Plus(CFixedPoint a, CFixedPoint b) {
        CFixedPoint t = new CFixedPoint();
        t.m_iValue = a.m_iValue + b.m_iValue;
        return t;
    }

    public static CFixedPoint Plus(CFixedPoint a, int b) {
        CFixedPoint t = new CFixedPoint();
        t.m_iValue = a.m_iValue + (long)(b << 16);
        return t;
    }

    public static CFixedPoint Plus(int a, CFixedPoint b) {
        CFixedPoint t = new CFixedPoint();
        t.m_iValue = (long)(a << 16) + b.m_iValue;
        return t;
    }

    public static CFixedPoint Minus(CFixedPoint a, CFixedPoint b) {
        CFixedPoint t = new CFixedPoint();
        t.m_iValue = a.m_iValue - b.m_iValue;
        return t;
    }

    public static CFixedPoint Minus(CFixedPoint a, int b) {
        CFixedPoint t = new CFixedPoint();
        t.m_iValue = a.m_iValue - (long)(b << 16);
        return t;
    }

    public static CFixedPoint Minus(int a, CFixedPoint b) {
        CFixedPoint t = new CFixedPoint();
        t.m_iValue = (long)(a << 16) - b.m_iValue;
        return t;
    }

    public static CFixedPoint Multiply(CFixedPoint a, CFixedPoint b) {
        CFixedPoint t = new CFixedPoint();
        t.m_iValue = a.m_iValue * b.m_iValue >> 16;
        return t;
    }

    public static CFixedPoint Multiply(CFixedPoint a, int b) {
        CFixedPoint t = new CFixedPoint();
        t.m_iValue = a.m_iValue * (long)b;
        return t;
    }

    public static CFixedPoint Multiply(int a, CFixedPoint b) {
        CFixedPoint t = new CFixedPoint();
        t.m_iValue = (long)a * b.m_iValue;
        return t;
    }

    public static CFixedPoint Divide(CFixedPoint a, CFixedPoint b) {
        CFixedPoint t = new CFixedPoint();
        t.m_iValue = (a.m_iValue << 16) / b.m_iValue;
        return t;
    }

    public static CFixedPoint Divide(CFixedPoint a, int b) {
        CFixedPoint t = new CFixedPoint();
        t.m_iValue = a.m_iValue / (long)b;
        return t;
    }

    public static CFixedPoint Divide(int a, CFixedPoint b) {
        CFixedPoint t = new CFixedPoint();
        long temp = a << 16;
        t.m_iValue = (temp << 16) / b.m_iValue;
        return t;
    }

    public static CFixedPoint LeftShift(CFixedPoint a, int b) {
        CFixedPoint returnValue = new CFixedPoint();
        returnValue.m_iValue = a.m_iValue << b;
        return returnValue;
    }

    public boolean Equals(CFixedPoint a) {
        return this.m_iValue == a.m_iValue;
    }

    public boolean Equals(int a) {
        return this.m_iValue == (long)(a << 16);
    }

    public boolean DiffersFrom(CFixedPoint a) {
        return this.m_iValue != a.m_iValue;
    }

    public boolean DiffersFrom(int a) {
        return this.m_iValue != (long)(a << 16);
    }

    public boolean GreaterThen(CFixedPoint a) {
        return this.m_iValue > a.m_iValue;
    }

    public boolean GreaterThen(int a) {
        return this.m_iValue > (long)(a << 16);
    }

    public boolean MinorThen(CFixedPoint a) {
        return this.m_iValue < a.m_iValue;
    }

    public boolean MinorThen(int a) {
        return this.m_iValue >> 16 < (long)a;
    }

    public boolean GreaterOrEqualThen(CFixedPoint a) {
        return this.m_iValue >= a.m_iValue;
    }

    public boolean GreaterOrEqualThen(int a) {
        return this.m_iValue >= (long)(a << 16);
    }

    public boolean MinorOrEqualThen(CFixedPoint a) {
        return this.m_iValue <= a.m_iValue;
    }

    public boolean MinorOrEqualThen(int a) {
        return this.m_iValue <= (long)(a << 16);
    }

    public int FixedCeil() {
        int l_iResult;
        int l_iNumerator = (int)this.m_iValue - 1 + 65536;
        if (l_iNumerator >= 0) {
            l_iResult = l_iNumerator / 65536;
        } else {
            l_iResult = -(-l_iNumerator / 65536);
            l_iResult = -l_iNumerator % 65536 != 0 ? --l_iResult : (l_iResult += 0);
        }
        return l_iResult;
    }

    public int[] FixedFloorDivMod(int a_iNumerator, int a_iDenominator, int a_iFloor, int a_iMod) {
        int[] l_aiFloorAndMod = new int[2];
        if (a_iNumerator >= 0) {
            a_iFloor = a_iNumerator / a_iDenominator;
            a_iMod = a_iNumerator % a_iDenominator;
        } else {
            a_iFloor = -(-a_iNumerator / a_iDenominator);
            a_iMod = -a_iNumerator % a_iDenominator;
            if (a_iMod != 0) {
                a_iMod = a_iDenominator - a_iMod;
            }
        }
        l_aiFloorAndMod[0] = --a_iFloor;
        l_aiFloorAndMod[1] = a_iMod;
        return l_aiFloorAndMod;
    }
}

