/*
 * Decompiled with CFR 0.152.
 */
public class CGameController
extends CBasicController {
    private CGameScreen m_GameScreen = null;
    private CMainController m_MainController;
    private boolean m_bIsInitiated;

    public CGameController(MyCanvas a_MyCanvas, CMainController a_MainController, CConfigFile a_ConfigFile) {
        super(a_MyCanvas, a_MainController, a_ConfigFile);
        this.m_MainController = a_MainController;
        this.m_bIsInitiated = false;
        this.m_GameScreen = new CGameScreen(this.m_MyCanvas, this, a_ConfigFile);
    }

    private void HandleKeyEvent() {
        this.m_GameScreen.HandleKeyPress();
        this.m_GameScreen.HandleKeyRelease();
    }

    protected void keyPressed() {
        this.m_GameScreen.HandleKeyPress();
    }

    protected void keyReleased() {
        this.m_GameScreen.HandleKeyRelease();
    }

    public void Vibrate(int length) {
        CMainController.Vibrate(length);
    }

    public int Run() {
        this.HandleKeyEvent();
        if (this.m_bIsInitiated) {
            this.m_GameScreen.Draw();
        }
        return 0;
    }

    public int Init() {
        this.m_GameScreen.SetGameStateInit();
        this.m_bIsInitiated = true;
        return 0;
    }

    public void Resume() {
        this.m_bIsInitiated = true;
        this.m_GameScreen.SetGameStateResume();
    }

    public void Unpause() {
        this.m_GameScreen.SetGameStateUnpaused();
    }

    public void SaveCurrentGameState() {
        this.m_GameScreen.GetGameStateForSaving();
        this.m_ConfigFile.save(2);
    }

    public void Pause() {
        this.m_GameScreen.SetGameStatePaused();
    }

    public boolean isPaused() {
        return this.m_GameScreen.m_bGamePaused;
    }

    public boolean CowboyFall() {
        return this.m_GameScreen.CowboyFall();
    }

    public boolean EightSeconds() {
        return this.m_GameScreen.EightSeconds();
    }

    public boolean TimeRunning() {
        return this.m_GameScreen.TimeRunning();
    }
}

