/*
 * Decompiled with CFR 0.152.
 */
public class CGameScreen {
    private static final int ARENA_POINTS = 24;
    public static final int MAX_FACES = 48;
    public static int EIGHT_SECONDS_TIMER = 0;
    public static int COWBOYHAT_TIMER = 0;
    private static final int FRAME_SKIP = 0;
    private static final int LOADING_TIME = 3;
    private static int pauseSoftkeyPosX = -1;
    private static int pauseSoftkeyPosY;
    private static int menuSoftkeyPosX;
    private static int menuSoftkeyPosY;
    private MyCanvas m_MyCanvas;
    private C2DArena m_Arena = null;
    private CConfigFile m_ConfigFile;
    private CEntranceScene m_EntranceScene = null;
    private CRidingLogic m_RidingLogic = null;
    private CRidingTimer m_RidingTimer = null;
    private CMainController m_MainController;
    public boolean m_bGamePaused = false;
    private CTypes.Score m_Score;
    private int m_iFinalTimer = 0;
    private boolean m_bUpKeyPressed = false;
    private boolean m_bLeftKeyPressed = false;
    private boolean m_bRightKeyPressed = false;
    private boolean m_bCheatKeyPressed = false;
    private boolean m_bSoft1KeyPressed = false;
    private boolean m_bSoft2KeyPressed = false;
    private boolean musicStart = false;
    private int m_iTicks = 0;
    private int m_iState;
    private int m_bGameScreenLoaded = 0;

    public CGameScreen(MyCanvas a_MyCanvas, CGameController a_GameController, CConfigFile a_ConfigFile) {
        Utils.getImage((byte)60);
        Utils.getImage((byte)70);
        Utils.getImage((byte)69);
        Utils.getImage((byte)73);
        Utils.getImage((byte)74);
        this.m_MyCanvas = a_MyCanvas;
        this.m_ConfigFile = a_ConfigFile;
        this.m_Arena = new C2DArena(this.m_MyCanvas);
        this.m_RidingLogic = CConfigFile.gameMode == 0 ? new CRidingLogic(this.m_MyCanvas, a_GameController, CConfigFile.trainingCowboy, CConfigFile.trainingBull, this.m_ConfigFile) : new CRidingLogic(this.m_MyCanvas, a_GameController, CConfigFile.currentCowboy, CConfigFile.currentBull, this.m_ConfigFile);
        if (pauseSoftkeyPosX < 0) {
            this.InitStaticVariables();
        }
        this.m_RidingTimer = new CRidingTimer(this.m_MyCanvas);
        this.m_Score = new CTypes.Score();
        this.m_EntranceScene = new CEntranceScene();
        EIGHT_SECONDS_TIMER = 90;
        COWBOYHAT_TIMER = 90;
    }

    private void InitStaticVariables() {
        Utils.getImage((byte)60);
        Utils.getImage((byte)69);
        Utils.getImage((byte)70);
        Utils.getImage((byte)73);
        Utils.getImage((byte)74);
        pauseSoftkeyPosX = Utils.stringWidth(" ", CTypes.FONT_CHAR_MAP);
        pauseSoftkeyPosY = CTypes.iCanvasHeight - ((CMenuDefaultController.BOTTOMBAR_HEIGHT >> 2) + CTypes.IMAGE_PLAY.getHeight());
        menuSoftkeyPosX = CTypes.iCanvasWidth - CTypes.IMAGE_OPTIONS.getWidth() - Utils.stringWidth(" ", CTypes.FONT_CHAR_MAP);
        menuSoftkeyPosY = CTypes.iCanvasHeight - ((CMenuDefaultController.BOTTOMBAR_HEIGHT >> 2) + CTypes.IMAGE_OPTIONS.getHeight());
    }

    void Update() {
        if (!this.m_bGamePaused) {
            if (!this.musicStart || CSFX.GetState() == 200) {
                if (CRidingLogic.bullState != 5) {
                    MyCanvas.pMainController.PlaySound(4);
                }
                this.musicStart = true;
            }
            switch (this.m_iState) {
                case 0: {
                    this.UpdateGameStateInit();
                    break;
                }
                case 1: {
                    this.UpdateGameStateReinit();
                    break;
                }
                case 2: {
                    this.UpdateGameStateResume();
                    break;
                }
                case 4: {
                    this.UpdateGameStatePlaying();
                    break;
                }
                case 5: {
                    this.UpdateGameStateFinal();
                    break;
                }
            }
        } else {
            this.musicStart = false;
            this.m_RidingLogic.SetPause(true);
        }
    }

    void SetGameStateInit() {
        this.m_iState = 0;
        this.m_RidingTimer.SetVisible(false);
    }

    void UpdateGameStateInit() {
        this.m_RidingLogic.Update();
        this.m_RidingLogic.UpdateCamera();
        this.m_EntranceScene.Update();
        if (this.m_EntranceScene.HasEnded()) {
            this.SetGameStatePlaying();
        }
    }

    void SetGameStateReinit() {
        this.m_iState = 1;
    }

    void UpdateGameStateReinit() {
    }

    void SetGameStateResume() {
        this.ResumeSavedGameState();
    }

    void UpdateGameStateResume() {
    }

    void SetGameStatePaused() {
        this.m_bGamePaused = true;
    }

    void SetGameStateUnpaused() {
        this.m_bGamePaused = false;
        this.m_RidingLogic.SetPause(false);
    }

    void UpdateGameStatePaused() {
    }

    boolean CowboyFall() {
        return this.m_RidingLogic.HasError();
    }

    boolean EightSeconds() {
        return this.m_RidingTimer.GetEightSeconds();
    }

    boolean TimeRunning() {
        return this.m_RidingTimer.TimeRunning();
    }

    void SetGameStatePlaying() {
        this.m_iState = 4;
        CRidingLogic.bullState = 1;
        this.m_RidingLogic.SetSpriteState(1);
        this.m_RidingTimer.SetVisible(true);
    }

    void UpdateGameStatePlaying() {
        this.m_Arena.Update();
        this.m_RidingLogic.UpdateCamera();
        this.m_RidingLogic.Update();
        this.m_RidingTimer.Update();
        if (this.m_RidingLogic.HasError() || this.m_RidingTimer.GetEightSeconds()) {
            this.SetGameStateFinal();
            if (this.m_RidingTimer.GetEightSeconds()) {
                this.m_RidingLogic.isEightSeconds = this.m_RidingTimer.GetEightSeconds();
                System.gc();
                if (CConfigFile.volume != 0) {
                    MyCanvas.pMainController.PlaySound(2);
                }
            } else if (this.m_RidingLogic.HasError()) {
                this.m_RidingTimer.SetCowboyFall(this.m_RidingLogic.HasError());
                System.gc();
                if (CConfigFile.gameMode != 0) {
                    this.m_ConfigFile.save(2);
                }
                if (CConfigFile.volume != 0) {
                    MyCanvas.pMainController.PlaySound(3);
                }
            }
        }
    }

    void SetGameStateFinal() {
        this.m_iState = 5;
        if (CConfigFile.gameMode != 0) {
            this.m_Score.timePoints = this.m_RidingTimer.GetEndTimer() * CTypes.BULL_PTB[CConfigFile.currentBull] / 8000;
            if (this.m_RidingTimer.GetEightSeconds()) {
                this.m_Score.bullPoints = CTypes.BULL_PTB[CConfigFile.currentBull];
                this.m_Score.agilityPoints = (this.m_RidingLogic.errorNumMax - this.m_RidingLogic.errorNum) * CTypes.BULL_PTB[CConfigFile.currentBull] / this.m_RidingLogic.errorNumMax;
            } else {
                this.m_Score.bullPoints = 0;
                this.m_Score.agilityPoints = 0;
            }
        }
        if (CConfigFile.gameMode == 1) {
            CConfigFile.championshipPoints[0][CConfigFile.currentBull] = this.m_Score;
            this.m_ConfigFile.IncrementBullRide(CConfigFile.currentBull, CConfigFile.gameMode);
            this.m_ConfigFile.IncrementCowboyRide(CConfigFile.currentCowboy);
            this.m_ConfigFile.save(2);
            this.m_ConfigFile.save(3);
        }
        if (CConfigFile.gameMode == 2) {
            CConfigFile.championshipPoints[1][CConfigFile.currentBull] = this.m_Score;
            this.m_ConfigFile.IncrementBullRide(CConfigFile.currentBull, CConfigFile.gameMode);
            this.m_ConfigFile.IncrementCowboyRide(CConfigFile.currentCowboy);
            this.m_ConfigFile.save(2);
            this.m_ConfigFile.save(3);
        }
        if (CConfigFile.gameMode == 3) {
            CConfigFile.championshipPoints[2][CConfigFile.currentBull] = this.m_Score;
            this.m_ConfigFile.IncrementBullRide(CConfigFile.currentBull, CConfigFile.gameMode);
            this.m_ConfigFile.IncrementCowboyRide(CConfigFile.currentCowboy);
            this.m_ConfigFile.save(2);
            this.m_ConfigFile.save(3);
        }
    }

    void UpdateGameStateFinal() {
        this.m_RidingLogic.UpdateCamera();
        this.m_RidingLogic.Update();
        this.m_RidingTimer.Update();
        if (this.m_RidingLogic.HasError() && this.m_iFinalTimer >= COWBOYHAT_TIMER && !this.m_RidingLogic.isEightSeconds) {
            if (CConfigFile.gameMode != 0) {
                CConfigFile.multiplexerState = 11;
                this.GetGameStateForSaving();
                MyCanvas.pMainController.SetInternalEvent(11);
            } else {
                MyCanvas.pMainController.SetInternalEvent(5);
            }
        }
        if (this.m_RidingTimer.GetEightSeconds() && this.m_iFinalTimer >= EIGHT_SECONDS_TIMER) {
            if (CConfigFile.gameMode != 0) {
                CConfigFile.multiplexerState = 11;
                this.GetGameStateForSaving();
                MyCanvas.pMainController.SetInternalEvent(11);
            } else {
                MyCanvas.pMainController.SetInternalEvent(5);
            }
        }
        ++this.m_iFinalTimer;
    }

    void ResumeCallGameState() {
        this.m_bGamePaused = true;
    }

    void ResumeSavedGameState() {
        this.m_iState = CConfigFile.gameState;
        this.m_bGamePaused = false;
        this.m_RidingTimer.LoadGameData();
    }

    void GetGameStateForSaving() {
        this.m_RidingTimer.SaveGameData();
        CConfigFile.gameState = this.m_iState;
        if (!this.m_RidingLogic.HasError()) {
            CConfigFile.multiplexerState = 2;
            CConfigFile.saved = true;
        } else if (CConfigFile.saved) {
            CConfigFile.saved = false;
        }
    }

    void HandleDirecionalRightReleased() {
    }

    void HandleDirecionalLeftReleased() {
    }

    void HandleDirecionalRightPressed() {
    }

    void HandleDirecionalLeftPressed() {
    }

    void HandleKeyPress() {
        if (MyCanvas.blockControl) {
            return;
        }
        if (CTypes.KEY_UP) {
            if (!this.m_bUpKeyPressed) {
                this.m_bUpKeyPressed = true;
                this.m_RidingLogic.SetReactionKey(1);
            }
            return;
        }
        if (CTypes.KEY_LEFT) {
            if (!this.m_bLeftKeyPressed) {
                this.m_bLeftKeyPressed = true;
                this.m_RidingLogic.SetReactionKey(2);
            }
            return;
        }
        if (CTypes.KEY_RIGHT) {
            if (!this.m_bRightKeyPressed) {
                this.m_bRightKeyPressed = true;
                this.m_RidingLogic.SetReactionKey(5);
            }
            return;
        }
        if (CTypes.KEY_SOFT1) {
            if (!this.m_bSoft1KeyPressed) {
                this.m_bSoft1KeyPressed = true;
                if (!this.m_bGamePaused) {
                    this.GetGameStateForSaving();
                    MyCanvas.pMainController.StopSound();
                    this.SetGameStatePaused();
                } else {
                    this.ResumeSavedGameState();
                    if (CRidingLogic.bullState != 5) {
                        MyCanvas.pMainController.PlaySound(4);
                    }
                    this.SetGameStateUnpaused();
                }
            }
            return;
        }
        if (CTypes.KEY_SOFT2) {
            if (!this.m_bSoft2KeyPressed) {
                this.m_bSoft2KeyPressed = true;
                if (this.m_bGamePaused) {
                    MyCanvas.pMainController.SetInternalEvent(19);
                }
            }
            return;
        }
    }

    void HandleKeyRelease() {
        if (CTypes.KEY_UP) {
            this.m_bUpKeyPressed = false;
            return;
        }
        if (CTypes.KEY_DOWN) {
            return;
        }
        if (CTypes.KEY_LEFT) {
            this.m_bLeftKeyPressed = false;
            return;
        }
        if (CTypes.KEY_RIGHT) {
            this.m_bRightKeyPressed = false;
            return;
        }
        if (CTypes.KEY_CHEAT) {
            this.m_bCheatKeyPressed = false;
            return;
        }
        if (CTypes.KEY_SOFT1) {
            if (this.m_bSoft1KeyPressed) {
                this.m_bSoft1KeyPressed = false;
            }
            if (!this.m_bGamePaused) {
                // empty if block
            }
            return;
        }
        if (CTypes.KEY_SELECT) {
            if (this.m_bGamePaused) {
                // empty if block
            }
            return;
        }
        if (CTypes.KEY_SOFT2) {
            this.m_bSoft2KeyPressed = false;
            return;
        }
    }

    void Draw() {
        if (this.m_bGameScreenLoaded > 3) {
            this.Update();
        }
        if (this.m_iTicks == 0) {
            this.m_Arena.Draw();
            this.m_RidingTimer.Draw();
            this.m_EntranceScene.Draw();
            this.m_RidingLogic.Draw();
            if (!this.m_bGamePaused) {
                Utils.DrawImage(CTypes.IMAGE_PAUSE, pauseSoftkeyPosX, pauseSoftkeyPosY, 20);
            } else if (!this.m_RidingLogic.isEightSeconds) {
                this.DrawPausedScreen();
            }
        }
        ++this.m_bGameScreenLoaded;
        this.m_iTicks = this.m_iTicks == 0 ? 0 : ++this.m_iTicks;
    }

    public void DrawPausedScreen() {
        Utils.DrawImage(CTypes.IMAGE_PLAY, pauseSoftkeyPosX, pauseSoftkeyPosY, 20);
        Utils.DrawImage(CTypes.IMAGE_OPTIONS, menuSoftkeyPosX, menuSoftkeyPosY, 20);
        if (CConfigFile.language == 2) {
            Utils.DrawImage(CTypes.IMAGE_PAUSED_WARNING_EN, CTypes.iCanvasWidth >> 1, CTypes.iCanvasHeight >> 1, 3);
        } else {
            Utils.DrawImage(CTypes.IMAGE_PAUSED_WARNING, CTypes.iCanvasWidth >> 1, CTypes.iCanvasHeight >> 1, 3);
        }
    }

    static {
        menuSoftkeyPosX = -1;
        menuSoftkeyPosY = -1;
    }
}

