/*
 * Decompiled with CFR 0.152.
 */
public class CMainMenuController
extends CMenuDefaultController {
    private static final int MAIN_MENU_INDEX_CONTINUE = 0;
    private static final int MAIN_MENU_INDEX_TOURNAMENT = 1;
    private static final int MAIN_MENU_INDEX_TRAINING = 2;
    private static final int MAIN_MENU_INDEX_OPTIONS = 3;
    private static final int MAIN_MENU_INDEX_HIGH_SCORES = 4;
    private static final int MAIN_MENU_INDEX_HELP = 5;
    private static final int MAIN_MENU_INDEX_RESET = 6;
    private static final int MAIN_MENU_INDEX_ABOUT = 7;
    private static final int MAIN_MENU_INDEX_EXIT = 8;
    private static final int LOGO_POS_Y_OFFSET = 55;
    private static final int TITLE_POS_Y_OFFSET = 15;
    private static final int MENU_ITEM_BACKGROUND_Y_OFFSET = 58;
    public static final int MENU_TITLE_BACKGROUND_Y_OFFSET = 9;
    private static int logoPosX = -1;
    private static int logoPosY;
    private static int titlePosX;
    private static int titlePosY;
    private static int itemBackgroundPosX;
    private static int itemBackgroundPosY;
    private static int leftArrowPosX;
    private static int rightArrowPosX;
    private static int arrowPosY;
    private static int itemTextPosCentralX;
    private static int itemTextPosY;
    private String selectedComponentText;
    private int firstOption;
    private int currentOption;
    private CMainController mController;
    private long chkSoundBugTimer;

    public CMainMenuController(MyCanvas a_MyCanvas, CMainController a_MainController, CConfigFile a_ConfigFile, boolean a_bIconArrowSpriteShow) {
        super(a_MyCanvas, a_MainController, a_ConfigFile, "", "", "", false, false, false, false);
        this.ResetController();
        this.mController = a_MainController;
    }

    public void ResetController() {
        super.ResetController();
        this.currentOption = 1;
        this.firstOption = 1;
        if (CConfigFile.saved) {
            this.currentOption = 0;
            this.firstOption = 0;
        }
        this.selectedComponentText = this.getOptionText(this.currentOption);
        if (logoPosX < 0) {
            this.InitStaticVariables();
        }
        this.ReloadController();
    }

    public void ReloadController() {
        super.ReloadController(null);
        Utils.getImage((byte)53);
        Utils.getImage((byte)54);
        Utils.getImage((byte)71);
        Utils.getImage((byte)58);
        Utils.getImage((byte)24);
        Utils.getImage((byte)46);
        if (!CConfigFile.saved) {
            this.firstOption = 1;
            if (this.currentOption == 0) {
                this.currentOption = 1;
            }
            this.selectedComponentText = this.getOptionText(this.currentOption);
        } else if (CConfigFile.saved) {
            if (this.firstOption == 1) {
                this.currentOption = 0;
                this.firstOption = 0;
            }
            this.selectedComponentText = this.getOptionText(this.currentOption);
        }
    }

    private void InitStaticVariables() {
        Utils.getImage((byte)53);
        Utils.getImage((byte)54);
        Utils.getImage((byte)71);
        Utils.getImage((byte)58);
        Utils.getImage((byte)24);
        if (CTypes.iCanvasHeight < 132) {
            titlePosX = 0;
            titlePosY = 15;
            logoPosX = CTypes.iCanvasWidth - CTypes.IMAGE_MAIN_MENU_LOGO.getWidth();
            logoPosY = 55;
        } else {
            titlePosX = CTypes.iCanvasWidth - CTypes.IMAGE_MAIN_MENU_TITLE.getWidth() >> 1;
            logoPosX = titlePosX + CTypes.IMAGE_MAIN_MENU_TITLE.getWidth() - CTypes.IMAGE_MAIN_MENU_LOGO.getWidth();
            titlePosY = 15;
            logoPosY = 55;
        }
        itemBackgroundPosX = CTypes.iCanvasWidth - CTypes.IMAGE_MENU_ITEM_BACKGROUND.getWidth() >> 1;
        int lowestTitleLogoPosY = logoPosY + CTypes.IMAGE_MAIN_MENU_LOGO.getHeight() > titlePosY + CTypes.IMAGE_MAIN_MENU_TITLE.getHeight() ? logoPosY + CTypes.IMAGE_MAIN_MENU_LOGO.getHeight() : titlePosY + CTypes.IMAGE_MAIN_MENU_TITLE.getHeight();
        itemBackgroundPosY = lowestTitleLogoPosY + (CTypes.iCanvasHeight - lowestTitleLogoPosY - CTypes.IMAGE_MENU_ITEM_BACKGROUND.getHeight() >> 1);
        int tileBeginningAboveItemBackground = itemBackgroundPosY - itemBackgroundPosY % CTypes.IMAGE_MENU_BACKGROUND_TILE.getHeight() + 58;
        int tileBeginningBelowItemBackground = tileBeginningAboveItemBackground + CTypes.IMAGE_MENU_BACKGROUND_TILE.getHeight();
        boolean useAboveTile = true;
        if (tileBeginningBelowItemBackground - itemBackgroundPosY < itemBackgroundPosY - tileBeginningAboveItemBackground) {
            if (tileBeginningBelowItemBackground + CTypes.IMAGE_MENU_BACKGROUND_TILE.getHeight() > CTypes.iCanvasHeight) {
                if (tileBeginningAboveItemBackground < lowestTitleLogoPosY && CTypes.iCanvasHeight - (tileBeginningBelowItemBackground + CTypes.IMAGE_MENU_BACKGROUND_TILE.getHeight()) < lowestTitleLogoPosY - tileBeginningAboveItemBackground) {
                    useAboveTile = false;
                }
            } else {
                useAboveTile = false;
            }
        }
        itemBackgroundPosY = useAboveTile ? tileBeginningAboveItemBackground : tileBeginningBelowItemBackground;
        int longestNameWidth = 0;
        for (int i = 0; i < 8; ++i) {
            int width = Utils.stringWidth(this.getOptionText(i), CTypes.FONT_CHAR_MAP);
            if (width <= longestNameWidth) continue;
            longestNameWidth = width;
        }
        leftArrowPosX = itemBackgroundPosX + (CTypes.IMAGE_MENU_ITEM_BACKGROUND.getWidth() - (longestNameWidth += Utils.stringWidth("  ", CTypes.FONT_CHAR_MAP)) >> 1);
        itemTextPosCentralX = leftArrowPosX + (CTypes.IMAGE_ARROWS_SIDE_SCROLLING_OCHRE.getWidth() + longestNameWidth >> 1);
        rightArrowPosX = leftArrowPosX + (CTypes.IMAGE_ARROWS_SIDE_SCROLLING_OCHRE.getWidth() >> 1) + longestNameWidth;
        itemTextPosY = itemBackgroundPosY + (CTypes.IMAGE_MENU_ITEM_BACKGROUND.getHeight() - CTypes.FONT_HEIGHT >> 1);
        arrowPosY = itemTextPosY + 6;
    }

    void MenuOptionSelected() {
        switch (this.currentOption) {
            case 0: {
                CConfigFile.gameMode = CConfigFile.isChampionshipRound;
                CConfigFile.m_bEightSeconds = true;
                m_MainController.SetInternalEvent(CConfigFile.multiplexerState);
                break;
            }
            case 1: {
                if (CConfigFile.saved) {
                    m_MainController.SetInternalEvent(53);
                    break;
                }
                this.m_ConfigFile.resetSave(2);
                this.m_ConfigFile.save(2);
                CConfigFile.gameMode = 1;
                CConfigFile.isChampionshipRound = 1;
                m_MainController.SetInternalEvent(3);
                break;
            }
            case 2: {
                CConfigFile.gameMode = 0;
                m_MainController.SetInternalEvent(3);
                break;
            }
            case 3: {
                m_MainController.SetInternalEvent(4);
                break;
            }
            case 4: {
                m_MainController.SetInternalEvent(10);
                break;
            }
            case 5: {
                m_MainController.SetInternalEvent(12);
                break;
            }
            case 6: {
                m_MainController.SetInternalEvent(54);
                break;
            }
            case 7: {
                m_MainController.SetInternalEvent(13);
                break;
            }
            case 8: {
                m_MainController.SetInternalEvent(21);
            }
        }
    }

    void HandleSelectReleased() {
        this.MenuOptionSelected();
    }

    void BottomRightButtonReleased() {
        this.MenuOptionSelected();
    }

    void BottomLeftButtonReleased() {
    }

    void drawMainMenu() {
        this.selectedComponentText = this.getOptionText(this.currentOption);
        if (CConfigFile.language == 2) {
            Utils.DrawImage(CTypes.IMAGE_MAIN_MENU_TITLE_EN, titlePosX, titlePosY, 20);
        } else {
            Utils.DrawImage(CTypes.IMAGE_MAIN_MENU_TITLE, titlePosX, titlePosY, 20);
        }
        Utils.DrawImage(CTypes.IMAGE_MAIN_MENU_LOGO, logoPosX, logoPosY, 20);
        Utils.DrawImage(CTypes.IMAGE_MENU_ITEM_BACKGROUND, itemBackgroundPosX, itemBackgroundPosY, 20);
        Utils.drawString(this.selectedComponentText, itemTextPosCentralX, itemTextPosY, 17, CTypes.IMAGE_FONT_OCHRE, CTypes.FONT_CHAR_MAP, CTypes.FONT_HEIGHT);
        int oldClipX = Utils.getClipX();
        int oldClipY = Utils.getClipY();
        int oldClipWidth = Utils.getClipWidth();
        int oldClipHeight = Utils.getClipHeight();
        int arrowSingleWidth = CTypes.IMAGE_ARROWS_SIDE_SCROLLING_OCHRE.getWidth() >> 1;
        if (this.currentOption != 8) {
            Utils.SetClip(rightArrowPosX, 0, arrowSingleWidth, CTypes.iCanvasHeight);
            Utils.DrawImage(CTypes.IMAGE_ARROWS_SIDE_SCROLLING_OCHRE, rightArrowPosX - arrowSingleWidth, arrowPosY, 20);
        }
        if (this.currentOption != this.firstOption) {
            Utils.SetClip(leftArrowPosX, 0, arrowSingleWidth, CTypes.iCanvasHeight);
            Utils.DrawImage(CTypes.IMAGE_ARROWS_SIDE_SCROLLING_OCHRE, leftArrowPosX, arrowPosY, 20);
        }
        Utils.SetClip(oldClipX, oldClipY, oldClipWidth, oldClipHeight);
    }

    String getOptionText(int currentItem) {
        String optionText = null;
        switch (currentItem) {
            case 0: {
                optionText = LocalizedText.CONTINUE.toLowerCase();
                break;
            }
            case 1: {
                optionText = LocalizedText.TOURNAMENT.toLowerCase();
                break;
            }
            case 2: {
                optionText = LocalizedText.TRAINING.toLowerCase();
                break;
            }
            case 3: {
                optionText = LocalizedText.OPTIONS_MENU.toLowerCase();
                break;
            }
            case 4: {
                optionText = LocalizedText.HIGH_SCORES.toLowerCase();
                break;
            }
            case 5: {
                optionText = LocalizedText.HELP.toLowerCase();
                break;
            }
            case 6: {
                optionText = LocalizedText.RESET.toLowerCase();
                break;
            }
            case 7: {
                optionText = LocalizedText.ABOUT.toLowerCase();
                break;
            }
            case 8: {
                optionText = LocalizedText.EXIT_MENU_OPTION.toLowerCase();
            }
        }
        return optionText;
    }

    void HandleKeyEvent() {
        this.selectedComponentText = this.getOptionText(this.currentOption);
        if (CTypes.KEY_LEFT) {
            if (this.currentOption > this.firstOption) {
                --this.currentOption;
                this.selectedComponentText = this.getOptionText(this.currentOption);
            }
            return;
        }
        if (CTypes.KEY_RIGHT) {
            if (this.currentOption < 8) {
                ++this.currentOption;
                this.selectedComponentText = this.getOptionText(this.currentOption);
            }
            return;
        }
        if (CTypes.KEY_SELECT) {
            this.HandleSelectReleased();
        }
        if (CTypes.KEY_SELECT) {
            this.HandleSelectReleased();
        }
    }

    void HandleDirecionalUpReleased() {
    }

    void HandleDirecionalDownReleased() {
    }

    int Run() {
        super.Run();
        this.drawMainMenu();
        return 0;
    }
}

