/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Image;

public class CSimpleSprite {
    private Image m_Image = null;
    private Image m_Bitmap = null;
    private int m_iSpeedCounter = 0;
    private int m_iXPos = 0;
    private int m_iYPos = 0;
    public CFixedPoint m_fpXVel;
    public CFixedPoint m_fpYVel;
    public CFixedPoint m_fpXAccel;
    public CFixedPoint m_fpYAccel;
    private int m_nSpeed = 0;
    private int m_nFrameWidth = 0;
    private int m_nFrameHeight = 0;
    private int m_nCurrentFrame = 0;
    private int m_nNumFrames = 0;
    private boolean m_bVisible = false;
    private int m_iFrameway;

    public CSimpleSprite(MyCanvas a_MyCanvas, Image a_Image, int a_iSpeed, int a_iXPos, int a_iYPos, int nNumFrames, int nFrameWidth, int nFrameHeight) {
        this.m_nNumFrames = nNumFrames;
        this.m_nFrameWidth = nFrameWidth;
        this.m_nFrameHeight = nFrameHeight;
        this.ResetVelAccelVars();
        this.m_nSpeed = a_iSpeed;
        this.m_iXPos = a_iXPos;
        this.m_iYPos = a_iYPos;
        this.m_Image = a_Image;
        this.m_iFrameway = 0;
    }

    protected void Paint() {
        int oldClipX = Utils.getClipX();
        int oldClipY = Utils.getClipY();
        int oldClipWidth = Utils.getClipWidth();
        int oldClipHeight = Utils.getClipHeight();
        if (this.m_bVisible) {
            if (this.m_Bitmap != null) {
                Utils.SetClip(this.m_iXPos, this.m_iYPos, this.m_nFrameWidth, this.m_nFrameHeight);
                Utils.DrawImage(this.m_Bitmap, this.m_nFrameWidth * this.m_nCurrentFrame, 0, 0);
            } else if (this.m_Image != null) {
                Utils.SetClip(this.m_iXPos, this.m_iYPos, this.m_nFrameWidth, this.m_nFrameHeight);
                Utils.DrawImage(this.m_Image, this.m_iXPos - this.m_nFrameWidth * this.m_nCurrentFrame, this.m_iYPos, 0);
            }
        }
        Utils.SetClip(oldClipX, oldClipY, oldClipWidth, oldClipHeight);
    }

    protected void SetVisible(boolean bVisible) {
        this.m_bVisible = bVisible;
    }

    protected boolean GetVisible() {
        return this.m_bVisible;
    }

    protected void SetX(int iNewX) {
        this.m_iXPos = iNewX;
    }

    protected void SetY(int iNewY) {
        this.m_iYPos = iNewY;
    }

    protected int GetFrame() {
        return this.m_nCurrentFrame;
    }

    protected void SetFrame(int sequenceIndex) {
        this.m_nCurrentFrame = sequenceIndex < this.m_nNumFrames ? sequenceIndex : 0;
    }

    protected void Accelerate() {
        this.m_fpXVel.PlusEqual(this.m_fpXAccel);
        this.m_fpYVel.PlusEqual(this.m_fpYAccel);
        this.m_iXPos += CFixedPoint.Fixed2Int(CFixedPoint.LeftShift(this.m_fpXVel, 1));
        this.m_iYPos += CFixedPoint.Fixed2Int(CFixedPoint.LeftShift(this.m_fpYVel, 1));
    }

    protected void Run() {
        ++this.m_iSpeedCounter;
        if (this.m_iSpeedCounter >= this.m_nSpeed) {
            this.m_iSpeedCounter = 0;
            if (this.m_nCurrentFrame == this.m_nNumFrames - 1) {
                this.m_iFrameway = 1;
            } else if (this.m_nCurrentFrame <= 0) {
                this.m_iFrameway = 0;
            }
            this.m_nCurrentFrame = this.m_iFrameway == 0 ? ++this.m_nCurrentFrame : --this.m_nCurrentFrame;
        }
        this.Accelerate();
    }

    protected void ResetVelAccelVars() {
        this.m_fpXVel = new CFixedPoint();
        this.m_fpYVel = new CFixedPoint();
        this.m_fpXAccel = new CFixedPoint();
        this.m_fpYAccel = new CFixedPoint();
    }

    protected CFixedPoint GetXSpeed() {
        return this.m_fpXVel;
    }

    protected CFixedPoint GetYSpeed() {
        return this.m_fpYVel;
    }

    protected CFixedPoint GetXAccel() {
        return this.m_fpXAccel;
    }

    protected CFixedPoint GetYAccel() {
        return this.m_fpYAccel;
    }

    protected void SetXVel(CFixedPoint nNewX) {
        this.m_fpXVel = nNewX;
    }

    protected void SetYVel(CFixedPoint nNewY) {
        this.m_fpYVel = nNewY;
    }

    protected void SetYVel(int value) {
        CFixedPoint.Int2Fixed(value);
    }

    protected void SetXAccel(CFixedPoint nNewX) {
        this.m_fpXAccel = nNewX;
    }

    protected void SetYAccel(CFixedPoint nNewY) {
        this.m_fpYAccel = nNewY;
    }

    protected void SetYAccel(int value) {
        CFixedPoint.Int2Fixed(value);
    }
}

