/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Image;

public class PaletteConverter {
    public static final short NO_PALETTE_CHANGE = -1;
    public static final short FONT_BLACK = -1;
    public static final short FONT_OCHRE = 0;
    public static final short FONT_RED = 1;
    public static final short ARROWS_BLACK = -1;
    public static final short ARROWS_OCHRE = 0;
    public static final short TIMER_OVER_YELLOW = -1;
    public static final short TIMER_OVER_RED = 2;
    public static final short ARROWS_INGAME_LEFT_YELLOW = -1;
    public static final short ARROWS_INGAME_LEFT_GREEN = 3;
    public static final short ARROWS_INGAME_LEFT_RED = 4;
    public static final short ARROWS_INGAME_RIGHT_YELLOW = -1;
    public static final short ARROWS_INGAME_RIGHT_GREEN = 5;
    public static final short ARROWS_INGAME_RIGHT_RED = 6;
    public static final short ARROWS_INGAME_UP_YELLOW = -1;
    public static final short ARROWS_INGAME_UP_GREEN = 7;
    public static final short ARROWS_INGAME_UP_RED = 8;
    public static final short LAST = 8;
    private static final int[][] palettes = new int[][]{{0xFFFFFF, 14333316}, {0xFFFFFF, 0xB00000}, {0xFFFFFF, 10818571, 0x991109, 7473667, 0xCB1B11, 9047559, 14951191, 11408909, 15481391, 16622751, 15883347, 16763589, 0xFFFEFE, 16771555, 16286075, 5702656}, {0xFFFFFF, 2728704, 2594304, 1996800, 2661632, 2927360, 2195456, 4521731, 14221258, 2527744, 2395136, 13302457, 4058112, 8584536, 3853062, 10878854, 2328064, 10026868, 3259648, 6474558, 7076411, 7850842, 0xFEFFFD, 0xEDFEED, 14874332}, {0xFFFFFF, 10685696, 9833216, 7866880, 10292224, 11209984, 0x800900, 16717315, 16764618, 9571072, 9177600, 16432825, 15471104, 16606552, 13308934, 0xFF8F86, 8784128, 16744052, 12389888, 13322302, 16403003, 13329242, 0xFFFDFE, 16708589, 16178908}, {0xFFFFFF, 2927360, 2728704, 2527488, 1996288, 2195456, 4455938, 2727424, 2394880, 2594560, 2595584, 11009928, 8902252, 3591680, 2328064, 3925504, 7995210, 12976049, 3192832, 3724801, 6084145, 2395648, 7460431, 15007202, 6487851}, {0xFFFFFF, 11209984, 10685696, 9505280, 7735552, 0x800900, 16651522, 10357760, 9112064, 9898752, 10161152, 16748936, 14054508, 0xCE0E00, 8784128, 15077632, 16734026, 16758705, 12061952, 14029057, 14040369, 9308928, 14047823, 16640482, 16726827}, {0xFFFFFF, 2927104, 2594304, 0x207700, 2661632, 2527744, 2195456, 2860032, 4587268, 3524867, 2394880, 3126784, 12254370, 13893316, 6749234, 3925248, 8912733, 0xEBFEEB, 6540095, 14939613, 7850842, 0xFEFFFD, 3059712, 3659264, 9960818}, {0xFFFFFF, 0xAA0D00, 9833216, 0x770800, 10292224, 9571072, 0x800900, 10750976, 16717572, 13177347, 9112064, 11931136, 16558242, 16697540, 16531762, 15012096, 16738653, 16708075, 13322559, 0xF5DFDD, 13329242, 0xFFFDFE, 0xB00C00, 14028800, 16612210}};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readAsByteArray(String fileName) {
        byte[] rawFileAsByteArray;
        try {
            InputStream rawFile = this.getClass().getResourceAsStream(fileName);
            ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();
            int data = rawFile.read();
            while (data >= 0) {
                byteArrayStream.write(data);
                data = rawFile.read();
            }
            rawFile.close();
            rawFileAsByteArray = byteArrayStream.toByteArray();
            byteArrayStream.close();
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
            rawFileAsByteArray = null;
        }
        catch (Exception ex) {
            System.out.println("@readAsByteArray(String " + fileName + "): " + ex.getMessage());
            rawFileAsByteArray = null;
        }
        finally {
            Object byteArrayStream = null;
            Object rawFile = null;
            System.gc();
        }
        return rawFileAsByteArray;
    }

    private int readLengthAsInt(byte[] fileAsByteArray, int pos) {
        return (fileAsByteArray[pos] & 0xFF) << 24 | (fileAsByteArray[pos + 1] & 0xFF) << 16 | (fileAsByteArray[pos + 2] & 0xFF) << 8 | fileAsByteArray[pos + 3] & 0xFF;
    }

    public Image loadImage(String fileName, int paletteNumber) {
        if (paletteNumber < 0) {
            return Utils.loadImage(fileName);
        }
        return this.loadImage(fileName, palettes[paletteNumber]);
    }

    public Image loadImage(String fileName, int[] paletteColors) {
        Image finalImage = null;
        byte[] imageByteArray = this.readAsByteArray(fileName);
        int pos = 8;
        byte[] palette = null;
        ByteArrayOutputStream paletteStream = new ByteArrayOutputStream();
        for (int i = 0; i < paletteColors.length; ++i) {
            paletteStream.write(paletteColors[i] >> 16 & 0xFF);
            paletteStream.write(paletteColors[i] >> 8 & 0xFF);
            paletteStream.write(paletteColors[i] & 0xFF);
        }
        palette = paletteStream.toByteArray();
        paletteStream.reset();
        paletteStream = null;
        try {
            while (!new String(imageByteArray, pos + 4, 4).equals("PLTE")) {
                pos += this.readLengthAsInt(imageByteArray, pos) + 12;
            }
        }
        catch (StringIndexOutOfBoundsException ex) {
            System.out.println("@loadImage(String " + fileName + "): " + ex.getMessage() + "\nError: The image must be indexed to have a palette that can be changed. PLTE field not found on " + fileName);
        }
        int paletteLength = palette.length;
        if (paletteLength > this.readLengthAsInt(imageByteArray, pos)) {
            paletteLength = this.readLengthAsInt(imageByteArray, pos);
        }
        System.arraycopy(palette, 0, imageByteArray, pos + 8, paletteLength);
        CRC crc = new CRC();
        crc.update_CRC(imageByteArray, pos + 8);
        crc = null;
        try {
            finalImage = Image.createImage((byte[])imageByteArray, (int)0, (int)imageByteArray.length);
        }
        catch (Exception e) {
            System.out.println("@loadImage(String " + fileName + ", int[] " + paletteColors + "): " + e.getMessage());
        }
        palette = null;
        imageByteArray = null;
        paletteColors = null;
        System.gc();
        return finalImage;
    }
}

