/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class Utils {
    private static final int FONT_SPACING = 1;

    static final short[] loadFontMap(String fontDataName) {
        short[] charMap = null;
        try {
            DataInputStream dis = new DataInputStream(((Object)((Object)OitoSegundos.myMIDlet)).getClass().getResourceAsStream("/" + fontDataName));
            int size = 2 * dis.readShort();
            charMap = new short[size];
            for (int i = 0; i < size; ++i) {
                charMap[i] = dis.readShort();
            }
        }
        catch (IOException ioe) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return charMap;
    }

    static final int stringWidth(String str, short[] charMap) {
        int strWidth = 0;
        for (int i = 0; i < str.length(); ++i) {
            int c = str.charAt(i);
            if (c == 10) continue;
            if ((c -= 32) >= 160) {
                c -= 65;
            }
            strWidth += charMap[2 * c + 1] + 1;
        }
        return strWidth;
    }

    static final int drawString(String str, int x, int y, int anchor, Image fontImg, short[] charMap, int fontHeight) {
        int c;
        int i;
        int oldClipX = Utils.getClipX();
        int oldClipY = Utils.getClipY();
        int oldClipWidth = Utils.getClipWidth();
        int oldClipHeight = Utils.getClipHeight();
        int xClip = 0;
        int yClip = 0;
        int strWidth = 0;
        for (i = 0; i < str.length(); ++i) {
            c = str.charAt(i) - 32;
            if (c == 138) {
                c = 156;
            } else if (c == 202) {
                c = 157;
            }
            if (c >= 160) {
                c -= 65;
            }
            strWidth += charMap[2 * c + 1] + 1;
        }
        xClip = (anchor & 4) != 0 ? x : ((anchor & 1) != 0 ? x - (strWidth >> 1) : ((anchor & 8) != 0 ? x - strWidth : x));
        yClip = (anchor & 0x10) != 0 ? y : ((anchor & 0x40) != 0 ? y - (fontHeight >> 1) : ((anchor & 0x20) != 0 ? y - fontHeight : y));
        for (i = 0; i < str.length(); ++i) {
            c = str.charAt(i) - 32;
            if (c == 138) {
                c = 156;
            } else if (c == 202) {
                c = 157;
            }
            if (c >= 160) {
                c -= 65;
            }
            CTypes.offScreenGraphics.setClip(xClip, yClip, (int)charMap[2 * c + 1], fontHeight);
            CTypes.offScreenGraphics.drawImage(fontImg, xClip - charMap[2 * c], yClip, 0);
            xClip += charMap[2 * c + 1] + 1;
        }
        Utils.SetClip(oldClipX, oldClipY, oldClipWidth, oldClipHeight);
        return strWidth;
    }

    public static int getClipX() {
        return CTypes.offScreenGraphics.getClipX();
    }

    public static int getClipY() {
        return CTypes.offScreenGraphics.getClipY();
    }

    public static int getClipWidth() {
        return CTypes.offScreenGraphics.getClipWidth();
    }

    public static int getClipHeight() {
        return CTypes.offScreenGraphics.getClipHeight();
    }

    public static void SetClip(int x, int y, int dx, int dy) {
        CTypes.offScreenGraphics.setClip(x, y, dx, dy);
    }

    public static void SetColor(int color) {
        CTypes.offScreenGraphics.setColor(color);
    }

    public static void DrawString(String string, int x, int y, int anchor) {
        CTypes.offScreenGraphics.drawString(string, x, y, anchor);
    }

    public static void DrawImage(Image image, int x, int y, int anchor) {
        CTypes.offScreenGraphics.drawImage(image, x, y, anchor);
    }

    public static void DrawRGB(int[] rgbData, int offset, int scanlength, int x, int y, int width, int height, boolean processAlpha) {
        CTypes.offScreenGraphics.drawRGB(rgbData, offset, scanlength, x, y, width, height, processAlpha);
    }

    public static void DrawRect(int x, int y, int dx, int dy) {
        CTypes.offScreenGraphics.drawRect(x, y, dx, dy);
    }

    public static void FillRect(int x, int y, int dx, int dy) {
        CTypes.offScreenGraphics.fillRect(x, y, dx, dy);
    }

    public static void DrawLine(int x1, int y1, int x2, int y2) {
        CTypes.offScreenGraphics.drawLine(x1, y1, x2, y2);
    }

    public static void DisplayUpdate() {
        MyCanvas.bRedrawNeeded = true;
        try {
            OitoSegundos.myCanvas.repaint();
            OitoSegundos.myCanvas.serviceRepaints();
        }
        catch (NullPointerException np) {
            System.out.println("Error repaint()");
        }
    }

    public static void BackLight(int duration) {
        Display.getDisplay((MIDlet)OitoSegundos.myMIDlet).flashBacklight(duration);
    }

    public static void ClearScreen() {
        Utils.SetColor(0xFEFEFE);
        Utils.FillRect(0, 0, CTypes.iCanvasWidth, CTypes.iCanvasHeight);
    }

    public static Image getImage(byte imageID) {
        switch (imageID) {
            case 0: {
                if (CTypes.IMAGE_ARENA_BACKGROUND_CROWD_LARGE == null) {
                    CTypes.IMAGE_ARENA_BACKGROUND_CROWD_LARGE = Utils.loadImage("arenaBackgroundCrowdLarge.png");
                }
                return CTypes.IMAGE_ARENA_BACKGROUND_CROWD_LARGE;
            }
            case 1: {
                if (CTypes.IMAGE_ARENA_BACKGROUND_CROWD_LARGE_2 == null) {
                    CTypes.IMAGE_ARENA_BACKGROUND_CROWD_LARGE_2 = Utils.loadImage("arenaBackgroundCrowdLarge2.png");
                }
                return CTypes.IMAGE_ARENA_BACKGROUND_CROWD_LARGE_2;
            }
            case 6: {
                if (CTypes.IMAGE_ARENA_BACKGROUND_GATE_LARGE_1 == null) {
                    CTypes.IMAGE_ARENA_BACKGROUND_GATE_LARGE_1 = Utils.loadImage("arenaBackgroundGateLarge1.png");
                }
                return CTypes.IMAGE_ARENA_BACKGROUND_GATE_LARGE_1;
            }
            case 7: {
                if (CTypes.IMAGE_ARENA_BACKGROUND_GATE_LARGE_2 == null) {
                    CTypes.IMAGE_ARENA_BACKGROUND_GATE_LARGE_2 = Utils.loadImage("arenaBackgroundGateLarge2.png");
                }
                return CTypes.IMAGE_ARENA_BACKGROUND_GATE_LARGE_2;
            }
            case 8: {
                if (CTypes.IMAGE_ARENA_BACKGROUND_GATE_LARGE_3 == null) {
                    CTypes.IMAGE_ARENA_BACKGROUND_GATE_LARGE_3 = Utils.loadImage("arenaBackgroundGateLarge3.png");
                }
                return CTypes.IMAGE_ARENA_BACKGROUND_GATE_LARGE_3;
            }
            case 9: {
                if (CTypes.IMAGE_ARENA_BACKGROUND_GATE_LARGE_4 == null) {
                    CTypes.IMAGE_ARENA_BACKGROUND_GATE_LARGE_4 = Utils.loadImage("arenaBackgroundGateLarge4.png");
                }
                return CTypes.IMAGE_ARENA_BACKGROUND_GATE_LARGE_4;
            }
            case 10: {
                if (CTypes.IMAGE_ARENA_BACKGROUND_GATE_LARGE_5 == null) {
                    CTypes.IMAGE_ARENA_BACKGROUND_GATE_LARGE_5 = Utils.loadImage("arenaBackgroundGateLarge5.png");
                }
                return CTypes.IMAGE_ARENA_BACKGROUND_GATE_LARGE_5;
            }
            case 11: {
                if (CTypes.IMAGE_ARENA_BACKGROUND_GATE_LARGE_6 == null) {
                    CTypes.IMAGE_ARENA_BACKGROUND_GATE_LARGE_6 = Utils.loadImage("arenaBackgroundGateLarge6.png");
                }
                return CTypes.IMAGE_ARENA_BACKGROUND_GATE_LARGE_6;
            }
            case 12: {
                if (CTypes.IMAGE_ARENA_BACKGROUND_GATE_LARGE_7 == null) {
                    CTypes.IMAGE_ARENA_BACKGROUND_GATE_LARGE_7 = Utils.loadImage("arenaBackgroundGateLarge6.png");
                }
                return CTypes.IMAGE_ARENA_BACKGROUND_GATE_LARGE_7;
            }
            case 13: {
                if (CTypes.IMAGE_ARROWS_INGAME_LEFT == null) {
                    CTypes.IMAGE_ARROWS_INGAME_LEFT = new PaletteConverter().loadImage("arrowsIngameLeft.png", 3);
                }
                return CTypes.IMAGE_ARROWS_INGAME_LEFT;
            }
            case 14: {
                if (CTypes.IMAGE_ARROWS_INGAME_LEFT_2 == null) {
                    CTypes.IMAGE_ARROWS_INGAME_LEFT_2 = Utils.loadImage("arrowsIngameLeft.png");
                }
                return CTypes.IMAGE_ARROWS_INGAME_LEFT_2;
            }
            case 15: {
                if (CTypes.IMAGE_ARROWS_INGAME_LEFT_3 == null) {
                    CTypes.IMAGE_ARROWS_INGAME_LEFT_3 = new PaletteConverter().loadImage("arrowsIngameLeft.png", 4);
                }
                return CTypes.IMAGE_ARROWS_INGAME_LEFT_3;
            }
            case 16: {
                if (CTypes.IMAGE_ARROWS_INGAME_RIGHT == null) {
                    CTypes.IMAGE_ARROWS_INGAME_RIGHT = new PaletteConverter().loadImage("arrowsIngameRight.png", 5);
                }
                return CTypes.IMAGE_ARROWS_INGAME_RIGHT;
            }
            case 17: {
                if (CTypes.IMAGE_ARROWS_INGAME_RIGHT_2 == null) {
                    CTypes.IMAGE_ARROWS_INGAME_RIGHT_2 = Utils.loadImage("arrowsIngameRight.png");
                }
                return CTypes.IMAGE_ARROWS_INGAME_RIGHT_2;
            }
            case 18: {
                if (CTypes.IMAGE_ARROWS_INGAME_RIGHT_3 == null) {
                    CTypes.IMAGE_ARROWS_INGAME_RIGHT_3 = new PaletteConverter().loadImage("arrowsIngameRight.png", 6);
                }
                return CTypes.IMAGE_ARROWS_INGAME_RIGHT_3;
            }
            case 19: {
                if (CTypes.IMAGE_ARROWS_INGAME_UP == null) {
                    CTypes.IMAGE_ARROWS_INGAME_UP = new PaletteConverter().loadImage("arrowsIngameUp.png", 7);
                }
                return CTypes.IMAGE_ARROWS_INGAME_UP;
            }
            case 20: {
                if (CTypes.IMAGE_ARROWS_INGAME_UP_2 == null) {
                    CTypes.IMAGE_ARROWS_INGAME_UP_2 = Utils.loadImage("arrowsIngameUp.png");
                }
                return CTypes.IMAGE_ARROWS_INGAME_UP_2;
            }
            case 21: {
                if (CTypes.IMAGE_ARROWS_INGAME_UP_3 == null) {
                    CTypes.IMAGE_ARROWS_INGAME_UP_3 = new PaletteConverter().loadImage("arrowsIngameUp.png", 8);
                }
                return CTypes.IMAGE_ARROWS_INGAME_UP_3;
            }
            case 22: {
                if (CTypes.IMAGE_ARROWS_SCROLLING_OCHRE == null) {
                    CTypes.IMAGE_ARROWS_SCROLLING_OCHRE = new PaletteConverter().loadImage("arrowsScrolling.png", 0);
                }
                return CTypes.IMAGE_ARROWS_SCROLLING_OCHRE;
            }
            case 23: {
                if (CTypes.IMAGE_ARROWS_SIDE_SCROLLING_BLACK == null) {
                    CTypes.IMAGE_ARROWS_SIDE_SCROLLING_BLACK = new PaletteConverter().loadImage("arrowsSideScrolling.png", -1);
                }
                return CTypes.IMAGE_ARROWS_SIDE_SCROLLING_BLACK;
            }
            case 24: {
                if (CTypes.IMAGE_ARROWS_SIDE_SCROLLING_OCHRE == null) {
                    CTypes.IMAGE_ARROWS_SIDE_SCROLLING_OCHRE = new PaletteConverter().loadImage("arrowsSideScrolling.png", 0);
                }
                return CTypes.IMAGE_ARROWS_SIDE_SCROLLING_OCHRE;
            }
            case 25: {
                if (CTypes.IMAGE_BALANCE_BAR_BACKGROUND == null) {
                    CTypes.IMAGE_BALANCE_BAR_BACKGROUND = Utils.loadImage("balanceBarBackground.png");
                }
                return CTypes.IMAGE_BALANCE_BAR_BACKGROUND;
            }
            case 26: {
                if (CTypes.IMAGE_BALANCE_BAR_FILLING_BOTTOM == null) {
                    CTypes.IMAGE_BALANCE_BAR_FILLING_BOTTOM = Utils.loadImage("BalanceBarFillingBottom.png");
                }
                return CTypes.IMAGE_BALANCE_BAR_FILLING_BOTTOM;
            }
            case 27: {
                if (CTypes.IMAGE_BALANCE_BAR_FILLING_MIDDLE == null) {
                    CTypes.IMAGE_BALANCE_BAR_FILLING_MIDDLE = Utils.loadImage("BalanceBarFillingMiddle.png");
                }
                return CTypes.IMAGE_BALANCE_BAR_FILLING_MIDDLE;
            }
            case 28: {
                if (CTypes.IMAGE_BALANCE_BAR_FILLING_TOP == null) {
                    CTypes.IMAGE_BALANCE_BAR_FILLING_TOP = Utils.loadImage("balanceBarFillingTop.png");
                }
                return CTypes.IMAGE_BALANCE_BAR_FILLING_TOP;
            }
            case 30: {
                if (CTypes.IMAGE_BULL_BACK_1 == null) {
                    CTypes.IMAGE_BULL_BACK_1 = Utils.loadImage("bullBack1.png");
                }
                return CTypes.IMAGE_BULL_BACK_1;
            }
            case 31: {
                if (CTypes.IMAGE_BULL_BACK_2 == null) {
                    CTypes.IMAGE_BULL_BACK_2 = Utils.loadImage("bullBack2.png");
                }
                return CTypes.IMAGE_BULL_BACK_2;
            }
            case 32: {
                if (CTypes.IMAGE_BULL_BACK_3 == null) {
                    CTypes.IMAGE_BULL_BACK_3 = Utils.loadImage("bullBack3.png");
                }
                return CTypes.IMAGE_BULL_BACK_3;
            }
            case 33: {
                if (CTypes.IMAGE_BULL_BACK_4 == null) {
                    CTypes.IMAGE_BULL_BACK_4 = Utils.loadImage("bullBack4.png");
                }
                return CTypes.IMAGE_BULL_BACK_4;
            }
            case 34: {
                if (CTypes.IMAGE_BULL_BACK_5 == null) {
                    CTypes.IMAGE_BULL_BACK_5 = Utils.loadImage("bullBack5.png");
                }
                return CTypes.IMAGE_BULL_BACK_5;
            }
            case 35: {
                if (CTypes.IMAGE_BULL_HEAD_FRAMES_1 == null) {
                    CTypes.IMAGE_BULL_HEAD_FRAMES_1 = Utils.loadImage("bullHeadFrames1.png");
                }
                return CTypes.IMAGE_BULL_HEAD_FRAMES_1;
            }
            case 36: {
                if (CTypes.IMAGE_BULL_HEAD_FRAMES_2 == null) {
                    CTypes.IMAGE_BULL_HEAD_FRAMES_2 = Utils.loadImage("bullHeadFrames2.png");
                }
                return CTypes.IMAGE_BULL_HEAD_FRAMES_2;
            }
            case 37: {
                if (CTypes.IMAGE_BULL_HEAD_FRAMES_3 == null) {
                    CTypes.IMAGE_BULL_HEAD_FRAMES_3 = Utils.loadImage("bullHeadFrames3.png");
                }
                return CTypes.IMAGE_BULL_HEAD_FRAMES_3;
            }
            case 38: {
                if (CTypes.IMAGE_BULL_HEAD_FRAMES_4 == null) {
                    CTypes.IMAGE_BULL_HEAD_FRAMES_4 = Utils.loadImage("bullHeadFrames4.png");
                }
                return CTypes.IMAGE_BULL_HEAD_FRAMES_4;
            }
            case 39: {
                if (CTypes.IMAGE_BULL_HEAD_FRAMES_5 == null) {
                    CTypes.IMAGE_BULL_HEAD_FRAMES_5 = Utils.loadImage("bullHeadFrames5.png");
                }
                return CTypes.IMAGE_BULL_HEAD_FRAMES_5;
            }
            case 40: {
                if (CTypes.IMAGE_BULLS == null) {
                    CTypes.IMAGE_BULLS = Utils.loadImage("bulls.png");
                }
                return CTypes.IMAGE_BULLS;
            }
            case 41: {
                if (CTypes.IMAGE_CLOUDS == null) {
                    CTypes.IMAGE_CLOUDS = Utils.loadImage("clouds.png");
                }
                return CTypes.IMAGE_CLOUDS;
            }
            case 42: {
                if (CTypes.IMAGE_COWBOY_HAND == null) {
                    CTypes.IMAGE_COWBOY_HAND = Utils.loadImage("cowboyHand.png");
                }
                return CTypes.IMAGE_COWBOY_HAND;
            }
            case 43: {
                if (CTypes.IMAGE_COWBOY_HAT_FRAMES == null) {
                    CTypes.IMAGE_COWBOY_HAT_FRAMES = Utils.loadImage("cowboyHatFrames.png");
                }
                return CTypes.IMAGE_COWBOY_HAT_FRAMES;
            }
            case 44: {
                if (CTypes.IMAGE_COWBOYS == null) {
                    CTypes.IMAGE_COWBOYS = Utils.loadImage("cowboys.png");
                }
                return CTypes.IMAGE_COWBOYS;
            }
            case 45: {
                if (CTypes.IMAGE_FONT_BLACK == null) {
                    CTypes.IMAGE_FONT_BLACK = new PaletteConverter().loadImage("font.png", -1);
                }
                return CTypes.IMAGE_FONT_BLACK;
            }
            case 46: {
                if (CTypes.IMAGE_FONT_OCHRE == null) {
                    CTypes.IMAGE_FONT_OCHRE = new PaletteConverter().loadImage("font.png", 0);
                }
                return CTypes.IMAGE_FONT_OCHRE;
            }
            case 47: {
                if (CTypes.IMAGE_FONT_RED == null) {
                    CTypes.IMAGE_FONT_RED = new PaletteConverter().loadImage("font.png", 1);
                }
                return CTypes.IMAGE_FONT_RED;
            }
            case 48: {
                if (CTypes.IMAGE_GATE_CLOSED == null) {
                    CTypes.IMAGE_GATE_CLOSED = Utils.loadImage("gateClosed.png");
                }
                return CTypes.IMAGE_GATE_CLOSED;
            }
            case 49: {
                if (CTypes.IMAGE_GATE_OPENED == null) {
                    CTypes.IMAGE_GATE_OPENED = Utils.loadImage("gateOpened.png");
                }
                return CTypes.IMAGE_GATE_OPENED;
            }
            case 50: {
                if (CTypes.IMAGE_GATE_OPENING_1 == null) {
                    CTypes.IMAGE_GATE_OPENING_1 = Utils.loadImage("gateOpening1.png");
                }
                return CTypes.IMAGE_GATE_OPENING_1;
            }
            case 51: {
                if (CTypes.IMAGE_GATE_OPENING_2 == null) {
                    CTypes.IMAGE_GATE_OPENING_2 = Utils.loadImage("gateOpening2.png");
                }
                return CTypes.IMAGE_GATE_OPENING_2;
            }
            case 52: {
                if (CTypes.IMAGE_GATE_OPENING_3 == null) {
                    CTypes.IMAGE_GATE_OPENING_3 = Utils.loadImage("gateOpening3.png");
                }
                return CTypes.IMAGE_GATE_OPENING_3;
            }
            case 53: {
                if (CTypes.IMAGE_MAIN_MENU_LOGO == null) {
                    CTypes.IMAGE_MAIN_MENU_LOGO = Utils.loadImage("mainMenuLogo.png");
                }
                return CTypes.IMAGE_MAIN_MENU_LOGO;
            }
            case 54: {
                if (CTypes.IMAGE_MAIN_MENU_TITLE == null) {
                    CTypes.IMAGE_MAIN_MENU_TITLE = Utils.loadImage("mainMenuTitle.png");
                }
                return CTypes.IMAGE_MAIN_MENU_TITLE;
            }
            case 71: {
                if (CTypes.IMAGE_MAIN_MENU_TITLE_EN == null) {
                    CTypes.IMAGE_MAIN_MENU_TITLE_EN = Utils.loadImage("mainMenuTitle_en.png");
                }
                return CTypes.IMAGE_MAIN_MENU_TITLE_EN;
            }
            case 55: {
                if (CTypes.IMAGE_MENU_BACKGROUND_TILE == null) {
                    CTypes.IMAGE_MENU_BACKGROUND_TILE = Utils.loadImage("menuBackgroundTile.png");
                }
                return CTypes.IMAGE_MENU_BACKGROUND_TILE;
            }
            case 57: {
                if (CTypes.IMAGE_MENU_FRAME_BACKGROUND == null) {
                    CTypes.IMAGE_MENU_FRAME_BACKGROUND = Utils.loadImage("menuFrameBackground.png");
                }
                return CTypes.IMAGE_MENU_FRAME_BACKGROUND;
            }
            case 58: {
                if (CTypes.IMAGE_MENU_ITEM_BACKGROUND == null) {
                    CTypes.IMAGE_MENU_ITEM_BACKGROUND = Utils.loadImage("menuItemBackground.png");
                }
                return CTypes.IMAGE_MENU_ITEM_BACKGROUND;
            }
            case 59: {
                if (CTypes.IMAGE_MENU_TITLE_BACKGROUND == null) {
                    CTypes.IMAGE_MENU_TITLE_BACKGROUND = Utils.loadImage("menuTitleBackground.png");
                }
                return CTypes.IMAGE_MENU_TITLE_BACKGROUND;
            }
            case 60: {
                if (CTypes.IMAGE_PAUSE == null) {
                    CTypes.IMAGE_PAUSE = Utils.loadImage("softkeyPause.png");
                }
                return CTypes.IMAGE_PAUSE;
            }
            case 61: {
                if (CTypes.IMAGE_SOUND_VOLUME == null) {
                    CTypes.IMAGE_SOUND_VOLUME = Utils.loadImage("soundVolume.png");
                }
                return CTypes.IMAGE_SOUND_VOLUME;
            }
            case 62: {
                if (CTypes.IMAGE_SPLASH_DEVELOPERS == null) {
                    CTypes.IMAGE_SPLASH_DEVELOPERS = Utils.loadImage("splashDevelopers.png");
                }
                return CTypes.IMAGE_SPLASH_DEVELOPERS;
            }
            case 63: {
                if (CTypes.IMAGE_SPLASH_GAME == null) {
                    CTypes.IMAGE_SPLASH_GAME = Utils.loadImage("splashGame.png");
                }
                return CTypes.IMAGE_SPLASH_GAME;
            }
            case 72: {
                if (CTypes.IMAGE_SPLASH_GAME_EN == null) {
                    CTypes.IMAGE_SPLASH_GAME_EN = Utils.loadImage("splashGame_en.png");
                }
                return CTypes.IMAGE_SPLASH_GAME_EN;
            }
            case 64: {
                if (CTypes.IMAGE_STAR == null) {
                    CTypes.IMAGE_STAR = Utils.loadImage("star.png");
                }
                return CTypes.IMAGE_STAR;
            }
            case 65: {
                if (CTypes.IMAGE_TIMER_NUMBERS == null) {
                    CTypes.IMAGE_TIMER_NUMBERS = Utils.loadImage("timerNumbers.png");
                }
                return CTypes.IMAGE_TIMER_NUMBERS;
            }
            case 66: {
                if (CTypes.IMAGE_TIMER_OVER_YELLOW == null) {
                    CTypes.IMAGE_TIMER_OVER_YELLOW = new PaletteConverter().loadImage("timerOver.png", -1);
                }
                return CTypes.IMAGE_TIMER_OVER_YELLOW;
            }
            case 67: {
                if (CTypes.IMAGE_TIMER_OVER_RED == null) {
                    CTypes.IMAGE_TIMER_OVER_RED = new PaletteConverter().loadImage("timerOver.png", 2);
                }
                return CTypes.IMAGE_TIMER_OVER_RED;
            }
            case 68: {
                if (CTypes.IMAGE_VERSUS_SYMBOL == null) {
                    CTypes.IMAGE_VERSUS_SYMBOL = Utils.loadImage("versusSymbol.png");
                }
                return CTypes.IMAGE_VERSUS_SYMBOL;
            }
            case 69: {
                if (CTypes.IMAGE_PAUSED_WARNING == null) {
                    CTypes.IMAGE_PAUSED_WARNING = Utils.loadImage("pause.png");
                }
                return CTypes.IMAGE_PAUSED_WARNING;
            }
            case 70: {
                if (CTypes.IMAGE_PAUSED_WARNING_EN == null) {
                    CTypes.IMAGE_PAUSED_WARNING_EN = Utils.loadImage("pause_en.png");
                }
                return CTypes.IMAGE_PAUSED_WARNING_EN;
            }
            case 73: {
                if (CTypes.IMAGE_OPTIONS == null) {
                    CTypes.IMAGE_OPTIONS = Utils.loadImage("softkeyOptions.png");
                }
                return CTypes.IMAGE_OPTIONS;
            }
            case 74: {
                if (CTypes.IMAGE_PLAY == null) {
                    CTypes.IMAGE_PLAY = Utils.loadImage("softkeyPlay.png");
                }
                return CTypes.IMAGE_PLAY;
            }
        }
        return null;
    }

    public static boolean freeImage(byte imageID) {
        boolean returnValue = false;
        switch (imageID) {
            case 0: {
                if (CTypes.IMAGE_ARENA_BACKGROUND_CROWD_LARGE == null) break;
                CTypes.IMAGE_ARENA_BACKGROUND_CROWD_LARGE = null;
                returnValue = true;
                break;
            }
            case 1: {
                if (CTypes.IMAGE_ARENA_BACKGROUND_CROWD_LARGE_2 == null) break;
                CTypes.IMAGE_ARENA_BACKGROUND_CROWD_LARGE_2 = null;
                returnValue = true;
                break;
            }
            case 6: {
                if (CTypes.IMAGE_ARENA_BACKGROUND_GATE_LARGE_1 == null) break;
                CTypes.IMAGE_ARENA_BACKGROUND_GATE_LARGE_1 = null;
                returnValue = true;
                break;
            }
            case 7: {
                if (CTypes.IMAGE_ARENA_BACKGROUND_GATE_LARGE_2 == null) break;
                CTypes.IMAGE_ARENA_BACKGROUND_GATE_LARGE_2 = null;
                returnValue = true;
                break;
            }
            case 8: {
                if (CTypes.IMAGE_ARENA_BACKGROUND_GATE_LARGE_3 == null) break;
                CTypes.IMAGE_ARENA_BACKGROUND_GATE_LARGE_3 = null;
                returnValue = true;
                break;
            }
            case 9: {
                if (CTypes.IMAGE_ARENA_BACKGROUND_GATE_LARGE_4 == null) break;
                CTypes.IMAGE_ARENA_BACKGROUND_GATE_LARGE_4 = null;
                returnValue = true;
                break;
            }
            case 10: {
                if (CTypes.IMAGE_ARENA_BACKGROUND_GATE_LARGE_5 == null) break;
                CTypes.IMAGE_ARENA_BACKGROUND_GATE_LARGE_5 = null;
                returnValue = true;
                break;
            }
            case 11: {
                if (CTypes.IMAGE_ARENA_BACKGROUND_GATE_LARGE_6 == null) break;
                CTypes.IMAGE_ARENA_BACKGROUND_GATE_LARGE_6 = null;
                returnValue = true;
                break;
            }
            case 12: {
                if (CTypes.IMAGE_ARENA_BACKGROUND_GATE_LARGE_7 == null) break;
                CTypes.IMAGE_ARENA_BACKGROUND_GATE_LARGE_7 = null;
                returnValue = true;
                break;
            }
            case 13: {
                if (CTypes.IMAGE_ARROWS_INGAME_LEFT == null) break;
                CTypes.IMAGE_ARROWS_INGAME_LEFT = null;
                returnValue = true;
                break;
            }
            case 14: {
                if (CTypes.IMAGE_ARROWS_INGAME_LEFT_2 == null) break;
                CTypes.IMAGE_ARROWS_INGAME_LEFT_2 = null;
                returnValue = true;
                break;
            }
            case 15: {
                if (CTypes.IMAGE_ARROWS_INGAME_LEFT_3 == null) break;
                CTypes.IMAGE_ARROWS_INGAME_LEFT_3 = null;
                returnValue = true;
                break;
            }
            case 16: {
                if (CTypes.IMAGE_ARROWS_INGAME_RIGHT == null) break;
                CTypes.IMAGE_ARROWS_INGAME_RIGHT = null;
                returnValue = true;
                break;
            }
            case 17: {
                if (CTypes.IMAGE_ARROWS_INGAME_RIGHT_2 == null) break;
                CTypes.IMAGE_ARROWS_INGAME_RIGHT_2 = null;
                returnValue = true;
                break;
            }
            case 18: {
                if (CTypes.IMAGE_ARROWS_INGAME_RIGHT_3 == null) break;
                CTypes.IMAGE_ARROWS_INGAME_RIGHT_3 = null;
                returnValue = true;
                break;
            }
            case 19: {
                if (CTypes.IMAGE_ARROWS_INGAME_UP == null) break;
                CTypes.IMAGE_ARROWS_INGAME_UP = null;
                returnValue = true;
                break;
            }
            case 20: {
                if (CTypes.IMAGE_ARROWS_INGAME_UP_2 == null) break;
                CTypes.IMAGE_ARROWS_INGAME_UP_2 = null;
                returnValue = true;
                break;
            }
            case 21: {
                if (CTypes.IMAGE_ARROWS_INGAME_UP_3 == null) break;
                CTypes.IMAGE_ARROWS_INGAME_UP_3 = null;
                returnValue = true;
                break;
            }
            case 22: {
                if (CTypes.IMAGE_ARROWS_SCROLLING_OCHRE == null) break;
                CTypes.IMAGE_ARROWS_SCROLLING_OCHRE = null;
                returnValue = true;
                break;
            }
            case 23: {
                if (CTypes.IMAGE_ARROWS_SIDE_SCROLLING_BLACK == null) break;
                CTypes.IMAGE_ARROWS_SIDE_SCROLLING_BLACK = null;
                returnValue = true;
                break;
            }
            case 24: {
                if (CTypes.IMAGE_ARROWS_SIDE_SCROLLING_OCHRE == null) break;
                CTypes.IMAGE_ARROWS_SIDE_SCROLLING_OCHRE = null;
                returnValue = true;
                break;
            }
            case 25: {
                if (CTypes.IMAGE_BALANCE_BAR_BACKGROUND == null) break;
                CTypes.IMAGE_BALANCE_BAR_BACKGROUND = null;
                returnValue = true;
                break;
            }
            case 26: {
                if (CTypes.IMAGE_BALANCE_BAR_FILLING_BOTTOM == null) break;
                CTypes.IMAGE_BALANCE_BAR_FILLING_BOTTOM = null;
                returnValue = true;
                break;
            }
            case 27: {
                if (CTypes.IMAGE_BALANCE_BAR_FILLING_MIDDLE == null) break;
                CTypes.IMAGE_BALANCE_BAR_FILLING_MIDDLE = null;
                returnValue = true;
                break;
            }
            case 28: {
                if (CTypes.IMAGE_BALANCE_BAR_FILLING_TOP == null) break;
                CTypes.IMAGE_BALANCE_BAR_FILLING_TOP = null;
                returnValue = true;
                break;
            }
            case 30: {
                if (CTypes.IMAGE_BULL_BACK_1 == null) break;
                CTypes.IMAGE_BULL_BACK_1 = null;
                returnValue = true;
                break;
            }
            case 31: {
                if (CTypes.IMAGE_BULL_BACK_2 == null) break;
                CTypes.IMAGE_BULL_BACK_2 = null;
                returnValue = true;
                break;
            }
            case 32: {
                if (CTypes.IMAGE_BULL_BACK_3 == null) break;
                CTypes.IMAGE_BULL_BACK_3 = null;
                returnValue = true;
                break;
            }
            case 33: {
                if (CTypes.IMAGE_BULL_BACK_4 == null) break;
                CTypes.IMAGE_BULL_BACK_4 = null;
                returnValue = true;
                break;
            }
            case 34: {
                if (CTypes.IMAGE_BULL_BACK_5 == null) break;
                CTypes.IMAGE_BULL_BACK_5 = null;
                returnValue = true;
                break;
            }
            case 35: {
                if (CTypes.IMAGE_BULL_HEAD_FRAMES_1 == null) break;
                CTypes.IMAGE_BULL_HEAD_FRAMES_1 = null;
                returnValue = true;
                break;
            }
            case 36: {
                if (CTypes.IMAGE_BULL_HEAD_FRAMES_2 == null) break;
                CTypes.IMAGE_BULL_HEAD_FRAMES_2 = null;
                returnValue = true;
                break;
            }
            case 37: {
                if (CTypes.IMAGE_BULL_HEAD_FRAMES_3 == null) break;
                CTypes.IMAGE_BULL_HEAD_FRAMES_3 = null;
                returnValue = true;
                break;
            }
            case 38: {
                if (CTypes.IMAGE_BULL_HEAD_FRAMES_4 == null) break;
                CTypes.IMAGE_BULL_HEAD_FRAMES_4 = null;
                returnValue = true;
                break;
            }
            case 39: {
                if (CTypes.IMAGE_BULL_HEAD_FRAMES_5 == null) break;
                CTypes.IMAGE_BULL_HEAD_FRAMES_5 = null;
                returnValue = true;
                break;
            }
            case 40: {
                if (CTypes.IMAGE_BULLS == null) break;
                CTypes.IMAGE_BULLS = null;
                returnValue = true;
                break;
            }
            case 41: {
                if (CTypes.IMAGE_CLOUDS == null) break;
                CTypes.IMAGE_CLOUDS = null;
                returnValue = true;
                break;
            }
            case 42: {
                if (CTypes.IMAGE_COWBOY_HAND == null) break;
                CTypes.IMAGE_COWBOY_HAND = null;
                returnValue = true;
                break;
            }
            case 43: {
                if (CTypes.IMAGE_COWBOY_HAT_FRAMES == null) break;
                CTypes.IMAGE_COWBOY_HAT_FRAMES = null;
                returnValue = true;
                break;
            }
            case 44: {
                if (CTypes.IMAGE_COWBOYS == null) break;
                CTypes.IMAGE_COWBOYS = null;
                returnValue = true;
                break;
            }
            case 45: {
                if (CTypes.IMAGE_FONT_BLACK == null) break;
                CTypes.IMAGE_FONT_BLACK = null;
                returnValue = true;
                break;
            }
            case 46: {
                if (CTypes.IMAGE_FONT_OCHRE == null) break;
                CTypes.IMAGE_FONT_OCHRE = null;
                returnValue = true;
                break;
            }
            case 47: {
                if (CTypes.IMAGE_FONT_RED == null) break;
                CTypes.IMAGE_FONT_RED = null;
                returnValue = true;
                break;
            }
            case 48: {
                if (CTypes.IMAGE_GATE_CLOSED == null) break;
                CTypes.IMAGE_GATE_CLOSED = null;
                returnValue = true;
                break;
            }
            case 49: {
                if (CTypes.IMAGE_GATE_OPENED == null) break;
                CTypes.IMAGE_GATE_OPENED = null;
                returnValue = true;
                break;
            }
            case 50: {
                if (CTypes.IMAGE_GATE_OPENING_1 == null) break;
                CTypes.IMAGE_GATE_OPENING_1 = null;
                returnValue = true;
                break;
            }
            case 51: {
                if (CTypes.IMAGE_GATE_OPENING_2 == null) break;
                CTypes.IMAGE_GATE_OPENING_2 = null;
                returnValue = true;
                break;
            }
            case 52: {
                if (CTypes.IMAGE_GATE_OPENING_3 == null) break;
                CTypes.IMAGE_GATE_OPENING_3 = null;
                returnValue = true;
                break;
            }
            case 53: {
                if (CTypes.IMAGE_MAIN_MENU_LOGO == null) break;
                CTypes.IMAGE_MAIN_MENU_LOGO = null;
                returnValue = true;
                break;
            }
            case 54: {
                if (CTypes.IMAGE_MAIN_MENU_TITLE == null) break;
                CTypes.IMAGE_MAIN_MENU_TITLE = null;
                returnValue = true;
                break;
            }
            case 71: {
                if (CTypes.IMAGE_MAIN_MENU_TITLE_EN == null) break;
                CTypes.IMAGE_MAIN_MENU_TITLE_EN = null;
                returnValue = true;
                break;
            }
            case 55: {
                if (CTypes.IMAGE_MENU_BACKGROUND_TILE == null) break;
                CTypes.IMAGE_MENU_BACKGROUND_TILE = null;
                returnValue = true;
                break;
            }
            case 57: {
                if (CTypes.IMAGE_MENU_FRAME_BACKGROUND == null) break;
                CTypes.IMAGE_MENU_FRAME_BACKGROUND = null;
                returnValue = true;
                break;
            }
            case 58: {
                if (CTypes.IMAGE_MENU_ITEM_BACKGROUND == null) break;
                CTypes.IMAGE_MENU_ITEM_BACKGROUND = null;
                returnValue = true;
                break;
            }
            case 59: {
                if (CTypes.IMAGE_MENU_TITLE_BACKGROUND == null) break;
                CTypes.IMAGE_MENU_TITLE_BACKGROUND = null;
                returnValue = true;
                break;
            }
            case 60: {
                if (CTypes.IMAGE_PAUSE == null) break;
                CTypes.IMAGE_PAUSE = null;
                returnValue = true;
                break;
            }
            case 61: {
                if (CTypes.IMAGE_SOUND_VOLUME == null) break;
                CTypes.IMAGE_SOUND_VOLUME = null;
                returnValue = true;
                break;
            }
            case 62: {
                if (CTypes.IMAGE_SPLASH_DEVELOPERS == null) break;
                CTypes.IMAGE_SPLASH_DEVELOPERS = null;
                returnValue = true;
                break;
            }
            case 63: {
                if (CTypes.IMAGE_SPLASH_GAME == null) break;
                CTypes.IMAGE_SPLASH_GAME = null;
                returnValue = true;
                break;
            }
            case 72: {
                if (CTypes.IMAGE_SPLASH_GAME_EN == null) break;
                CTypes.IMAGE_SPLASH_GAME_EN = null;
                returnValue = true;
                break;
            }
            case 64: {
                if (CTypes.IMAGE_STAR == null) break;
                CTypes.IMAGE_STAR = null;
                returnValue = true;
                break;
            }
            case 65: {
                if (CTypes.IMAGE_TIMER_NUMBERS == null) break;
                CTypes.IMAGE_TIMER_NUMBERS = null;
                returnValue = true;
                break;
            }
            case 66: {
                if (CTypes.IMAGE_TIMER_OVER_YELLOW == null) break;
                CTypes.IMAGE_TIMER_OVER_YELLOW = null;
                returnValue = true;
                break;
            }
            case 67: {
                if (CTypes.IMAGE_TIMER_OVER_RED == null) break;
                CTypes.IMAGE_TIMER_OVER_RED = null;
                returnValue = true;
                break;
            }
            case 68: {
                if (CTypes.IMAGE_VERSUS_SYMBOL == null) break;
                CTypes.IMAGE_VERSUS_SYMBOL = null;
                returnValue = true;
                break;
            }
            case 69: {
                if (CTypes.IMAGE_PAUSED_WARNING == null) break;
                CTypes.IMAGE_PAUSED_WARNING = null;
                returnValue = true;
                break;
            }
            case 70: {
                if (CTypes.IMAGE_PAUSED_WARNING_EN == null) break;
                CTypes.IMAGE_PAUSED_WARNING_EN = null;
                returnValue = true;
                break;
            }
            case 73: {
                if (CTypes.IMAGE_OPTIONS == null) break;
                CTypes.IMAGE_OPTIONS = null;
                returnValue = true;
                break;
            }
            case 74: {
                if (CTypes.IMAGE_PLAY == null) break;
                CTypes.IMAGE_PLAY = null;
                returnValue = true;
            }
        }
        return returnValue;
    }

    public static Image loadImage(String imgName) {
        Image retImg = null;
        try {
            retImg = Image.createImage((String)("/" + imgName));
        }
        catch (IOException ioe) {
            System.out.println("IOException loading Image " + imgName);
        }
        catch (Exception e) {
            System.out.println("Error loading Image " + imgName);
        }
        return retImg;
    }

    public static void Swap(int a, int b, int t) {
        t = a;
        a = b;
        b = t;
    }

    public static int Top2Bits(int x) {
        return x >> 30;
    }

    public static int MaxOf(int x, int y) {
        if (x > y) {
            return x;
        }
        return y;
    }

    public static int MinOf(int x, int y) {
        if (x < y) {
            return x;
        }
        return y;
    }

    public static int AbsOf(int x) {
        return Math.abs(x);
    }

    public static CFixedPoint AbsOf(CFixedPoint x) {
        CFixedPoint point = new CFixedPoint();
        point.m_iValue = Math.abs(x.m_iValue);
        return point;
    }

    public static byte[] NextData(byte[] data, int offSet, int numBytes) {
        byte[] singleData = new byte[numBytes];
        int i = offSet;
        int j = 0;
        while (i < offSet + numBytes) {
            singleData[j] = data[i];
            ++i;
            ++j;
        }
        return singleData;
    }
}

