/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DCApe
extends DChocMIDlet
implements ApplicationControl {
    private FlowProcessor mGameFlowProcessor;
    private FlowProcessor mCurrentFlowProcessor;
    private FlowProcessor mNextFlowProcessor;
    private boolean mInitialized;
    private boolean mLoading;
    private int mMaxLoadingCount;
    private int mLoadingCounter;
    private int mInitialFlowLoadingPercentage;
    private boolean mSoftKeysInitialized;
    private ImageFont mTextImageFont;
    private ImageFont mSelectionImageFont;
    private ImageFont mTitleBarImageFont;

    public void logicUpdate(int n) {
        if (!this.mInitialized) {
            this.initialize();
            return;
        }
        if (this.mNextFlowProcessor != this.mCurrentFlowProcessor) {
            this.mCurrentFlowProcessor = this.mNextFlowProcessor;
        }
        if (this.mCurrentFlowProcessor != null) {
            this.mCurrentFlowProcessor.logicUpdate(n);
            if (this.mInitialFlowLoadingPercentage != -1) {
                this.mInitialFlowLoadingPercentage = this.mCurrentFlowProcessor.getLoadingPercentage();
            }
        }
    }

    private void initialize() {
        if (!this.mLoading) {
            this.mMaxLoadingCount = 6;
            this.mLoadingCounter = 0;
            this.mLoading = true;
            return;
        }
        if (this.mLoadingCounter < this.mMaxLoadingCount) {
            switch (this.mLoadingCounter) {
                case 0: {
                    this.initializeGraphics();
                    break;
                }
                case 1: {
                    this.initializeFonts();
                    break;
                }
                case 2: {
                    this.initializeScrollArrows();
                    break;
                }
                case 3: {
                    this.mGameFlowProcessor = new FlowProcessor(65549, new Game(this, this.mTitleBarImageFont, this.mTextImageFont, this.mSelectionImageFont));
                    break;
                }
                case 4: {
                    this.initializeSoftkeys();
                    break;
                }
                case 5: {
                    for (int i = 0; i < DavinciUtilities.getAdditionalLoadingCount(); ++i) {
                        DavinciUtilities.loadNext();
                    }
                    break;
                }
            }
            ++this.mLoadingCounter;
        } else {
            this.mInitialized = true;
            this.mLoading = false;
            this.mNextFlowProcessor = this.mGameFlowProcessor;
            this.resetTimer();
        }
    }

    private void initializeGraphics() {
        DavinciUtilities.initialize();
    }

    private void initializeFonts() {
        try {
            Image image = null;
            Image image2 = null;
            Image image3 = null;
            Font font = Font.getFont((int)32, (int)0, (int)8);
            Font font2 = Font.getFont((int)32, (int)1, (int)8);
            Font font3 = Font.getFont((int)32, (int)1, (int)0);
            image = Toolkit.getImage(65541);
            image2 = Toolkit.getImage(65539);
            image3 = Toolkit.getImage(65537);
            this.mTextImageFont = new ImageFont(image, Toolkit.getResourceStream(65542), font, 0, -1);
            this.mSelectionImageFont = new ImageFont(image2, Toolkit.getResourceStream(65540), font2, 0xFFFFFF, 0);
            this.mTitleBarImageFont = new ImageFont(image3, Toolkit.getResourceStream(65538), font3, 0xFFFF00, 0);
            MenuObject.setDefaultImageFonts(this.mTitleBarImageFont, this.mTextImageFont, this.mSelectionImageFont);
            Toolkit.setSoftkeyImageFont(this.mSelectionImageFont);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void initializeScrollArrows() {
        Animation[] animationArray = DavinciUtilities.loadAnimations(new int[]{196633, 196635, 196634});
        Animation[] animationArray2 = DavinciUtilities.loadAnimations(new int[]{196636, 196638, 196637});
        MenuObject.setScrollArrowsDvc(new SpriteObject(animationArray, true), new SpriteObject(animationArray2, true));
        Animation[] animationArray3 = DavinciUtilities.loadAnimations(new int[]{196639, 196640});
        Animation[] animationArray4 = DavinciUtilities.loadAnimations(new int[]{196641, 196642});
        MenuObject.setHorizontalScrollArrows(new SpriteObject(animationArray3, true), new SpriteObject(animationArray4, true));
    }

    private void initializeSoftkeys() {
        if (this.mSoftKeysInitialized) {
            return;
        }
        byte[] byArray = Toolkit.getResourceBytes(589836);
        int n = 1;
        for (int i = byArray[0]; i > 0; --i) {
            byte by = byArray[n++];
            int n2 = FlowProcessor.loadResourceID(byArray, n);
            int n3 = FlowProcessor.loadResourceID(byArray, n += 4);
            n += 4;
            byte by2 = byArray[n++];
            Image image = null;
            if (n3 != -1 && (image = DavinciUtilities.getImage(n3)) == null) {
                image = Toolkit.getImage(n3);
            }
            Toolkit.createSoftKey(by, n2, image, by2);
        }
        this.mSoftKeysInitialized = true;
    }

    public void doDraw(Graphics graphics) {
        if (this.mLoading) {
            this.drawLoadingScreen(graphics, this.mLoadingCounter * 50 / this.mMaxLoadingCount);
        } else if (this.mCurrentFlowProcessor != null) {
            if (this.mInitialFlowLoadingPercentage != -1) {
                this.drawLoadingScreen(graphics, 50 + this.mInitialFlowLoadingPercentage / 2);
            } else {
                this.mCurrentFlowProcessor.doDraw(graphics);
            }
        }
    }

    public void keyEventOccurred(int n, int n2) {
        if (this.mLoading) {
            return;
        }
        if (this.mCurrentFlowProcessor != null) {
            this.mCurrentFlowProcessor.keyEventOccurred(n, n2);
        }
    }

    public void appEventOccurred(int n) {
        if (this.mLoading) {
            return;
        }
        if (this.mCurrentFlowProcessor != null) {
            if (n == 1) {
                this.mCurrentFlowProcessor.pause();
            } else if (n == 5) {
                this.mCurrentFlowProcessor.licenseManagerActivated();
            }
        }
    }

    public void setLanguage(int n) {
        if (this.mInitialized) {
            this.mGameFlowProcessor.languageChanged();
        }
        Toolkit.setSelectedLanguage(n);
        this.mSoftKeysInitialized = false;
        this.initializeSoftkeys();
    }

    private void drawLoadingScreen(Graphics graphics, int n) {
        VisualEngine.drawLoadingScreen(graphics, n, true);
    }
}

