/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class FlowProcessor {
    private FlowHandler mFlowHandler;
    private byte[] mFlowBinary;
    private short[] mEventTargets;
    private int mWildEventCount;
    private short[] mStateOffsets;
    private byte[] mStateGroups;
    private int mCurrentState = -1;
    private int mNextState = -1;
    private MenuObject mCurrentMenu;
    private short[] mCurrentGameScreen;
    private short[] mCurrentBranch;
    private MenuObject[] mLoadedMenus;
    private short[][] mMenuSoftkeyEvents;
    private short[][] mLoadedGameScreens;
    private short[][] mLoadedBranches;
    private int mMenuScreenCount;
    private int mGameScreenStartIndex;
    private int mGameScreenCount;
    private int mBranchStartIndex;
    private int mBranchCount;
    private boolean mGoingForward;
    private boolean mStoreStateToHistory;
    private short[] mStateHistory;
    private int mStateHistoryPointer;
    private boolean mLoading;
    private int mMaxLoadingCount;
    private int mLoadingCounter;
    private int mStateGroupLoadingCount;
    private int mStateLoadingCount;
    private int mDavinciLoadingPercentage;
    private boolean mDavinciLoading;
    private short[] mMenusToLoad;
    private byte[] mMenuSelectedItems;
    private boolean[] mStateGroupInMemory;

    public FlowProcessor(int n, FlowHandler flowHandler) {
        this.initializeFlow(n, flowHandler);
    }

    public void logicUpdate(int n) {
        if (this.mNextState != -1) {
            this.changeState();
            return;
        }
        int n2 = this.mFlowHandler.logicUpdate(this.mCurrentState, n);
        this.processEvent(n2);
        if (this.mCurrentMenu != null) {
            int[] nArray = this.mCurrentMenu.logicUpdate(n);
            this.mMenuSelectedItems[this.mCurrentState] = (byte)this.mCurrentMenu.getSelectedItem();
            if (nArray != null) {
                if (nArray[0] == 1) {
                    this.processEvent(nArray[1]);
                } else if (nArray[0] == 0) {
                    boolean bl = false;
                    short[] sArray = this.mMenuSoftkeyEvents[this.mCurrentState];
                    if (sArray != null) {
                        int n3 = 0;
                        while (n3 < sArray.length) {
                            short s = sArray[n3++];
                            short s2 = sArray[n3++];
                            if (s != nArray[1]) continue;
                            this.processEvent(s2);
                            bl = true;
                        }
                    }
                    if (!bl) {
                        this.processSoftkeyEvent(nArray[1]);
                    }
                }
            }
        }
    }

    public void doDraw(Graphics graphics) {
        if (this.mLoading) {
            this.mFlowHandler.drawLoadingScreen(graphics, this.getLoadingPercentage());
            return;
        }
        if (HeapReaderAndApplicationPauser.isPaused()) {
            // empty if block
        }
        this.mFlowHandler.doDraw(this.mCurrentState, graphics);
        if (this.mCurrentMenu != null) {
            this.mFlowHandler.drawMenu(this.mCurrentState, graphics, this.mCurrentMenu);
        }
    }

    public void keyEventOccurred(int n, int n2) {
        if (this.mLoading) {
            return;
        }
        if (this.mCurrentMenu != null) {
            this.mCurrentMenu.keyEventOccurred(n, n2);
        }
        if (this.mFlowHandler != null) {
            this.mFlowHandler.keyEventOccurred(this.mCurrentState, n, n2);
        }
    }

    private void clearMenuCache() {
        int n = this.mMenuScreenCount;
        while (--n >= 0) {
            this.removeFromMenuCache(n);
        }
        if (this.mNextState == -1) {
            this.mNextState = this.mCurrentState;
        }
        this.mCurrentState = -1;
        this.mCurrentMenu = null;
        this.mLoading = false;
    }

    public void languageChanged() {
        this.clearMenuCache();
    }

    public void pause() {
        this.mFlowHandler.pauseGame();
    }

    public void licenseManagerActivated() {
        this.mFlowHandler.licenseManagerActivated();
    }

    private void initializeFlow(int n, FlowHandler flowHandler) {
        int n2;
        int n3;
        this.mFlowHandler = flowHandler;
        byte[] byArray = Toolkit.getResourceBytes(n);
        this.mFlowBinary = byArray;
        int n4 = byArray[0] & 0xFF;
        this.mWildEventCount = byArray[1] & 0xFF;
        int n5 = 2;
        this.mEventTargets = new short[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            this.mEventTargets[n3] = (short)((byArray[n5++] & 0xFF) << 8 | byArray[n5++] & 0xFF);
        }
        n3 = byArray[n5++] & 0xFF;
        this.mStateGroupInMemory = new boolean[n3];
        this.mGameScreenStartIndex = this.mMenuScreenCount = byArray[n5++] & 0xFF;
        this.mGameScreenCount = byArray[n5++] & 0xFF;
        this.mBranchStartIndex = this.mGameScreenStartIndex + this.mGameScreenCount;
        int n6 = byArray[n5++] & 0xFF;
        int n7 = this.mMenuScreenCount + this.mGameScreenCount + n6;
        this.mStateGroups = new byte[n7];
        for (n2 = 0; n2 < n7; ++n2) {
            this.mStateGroups[n2] = byArray[n5++];
        }
        this.mStateOffsets = new short[n7];
        for (n2 = 0; n2 < n7; ++n2) {
            this.mStateOffsets[n2] = (short)((byArray[n5++] & 0xFF) << 8 | byArray[n5++] & 0xFF);
        }
        this.mNextState = byArray[n5] & 0xFF;
        this.mLoadedMenus = new MenuObject[this.mMenuScreenCount];
        this.mMenuSoftkeyEvents = new short[this.mMenuScreenCount][];
        this.mLoadedGameScreens = new short[this.mGameScreenCount][];
        this.mLoadedBranches = new short[n6][];
        this.mMenuSelectedItems = new byte[this.mMenuScreenCount];
        n2 = this.mMenuScreenCount;
        int n8 = 0;
        while (n8 < this.mGameScreenCount) {
            this.loadGameScreen(n2);
            ++n8;
            ++n2;
        }
        n8 = 0;
        while (n8 < n6) {
            this.loadBranch(n2);
            ++n8;
            ++n2;
        }
        this.mBranchCount = n6;
        this.mStateHistory = new short[this.mMenuScreenCount + n6 + this.mGameScreenCount];
        this.mStateHistoryPointer = 0;
        this.mStoreStateToHistory = false;
    }

    private void changeState() {
        DChocMIDlet.skipTimer();
        while (this.mNextState != -1) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            if (!this.mLoading) {
                n5 = this.mCurrentState != -1 ? this.mStateGroups[this.mCurrentState] : -1;
                n4 = this.mStateGroups[this.mNextState];
                if (this.mCurrentState != -1) {
                    if (n5 != -1) {
                        if (n5 != n4 && !this.mFlowHandler.isChildGroup(n5, n4)) {
                            n3 = this.mStateGroupInMemory.length;
                            while (--n3 >= 0) {
                                if (!this.mStateGroupInMemory[n3] || n3 == n4) continue;
                                this.mFlowHandler.unloadStateGroup(n3, n4);
                                n2 = this.mStateGroups.length;
                                while (--n2 >= 0) {
                                    if (this.mStateGroups[n2] != n3 || !this.isMenuState(n2)) continue;
                                    if (this.mLoadedMenus[n2] != null) {
                                        // empty if block
                                    }
                                    this.removeFromMenuCache(n2);
                                }
                                this.mStateGroupInMemory[n3] = false;
                            }
                        }
                    } else if (this.isMenuState(this.mCurrentState)) {
                        if (this.mLoadedMenus[this.mCurrentState] != null) {
                            // empty if block
                        }
                        this.removeFromMenuCache(this.mCurrentState);
                    }
                    this.mFlowHandler.unloadState(this.mCurrentState, this.mNextState);
                    this.deactivateState();
                }
                this.mStateGroupLoadingCount = 0;
                if (n4 != -1 && n4 != n5) {
                    if (!this.mFlowHandler.isChildGroup(n4, n5)) {
                        this.mStateGroupLoadingCount = this.mFlowHandler.getStateGroupLoadingCount(n4);
                    }
                    n3 = 0;
                    for (n2 = 0; n2 < this.mStateGroups.length; ++n2) {
                        if (this.mStateGroups[n2] != n4 || !this.isMenuState(n2) || this.mLoadedMenus[n2] != null) continue;
                        ++n3;
                    }
                    this.mMenusToLoad = new short[n3];
                    n2 = 0;
                    for (n = 0; n < this.mStateGroups.length; ++n) {
                        if (this.mStateGroups[n] != n4 || !this.isMenuState(n) || this.mLoadedMenus[n] != null) continue;
                        this.mMenusToLoad[n2++] = (short)n;
                    }
                } else {
                    n3 = this.mNextState;
                    this.mMenusToLoad = this.isMenuState(n3) && this.mLoadedMenus[n3] == null ? new short[]{(short)n3} : new short[0];
                }
                this.mStateLoadingCount = this.mFlowHandler.getStateLoadingCount(this.mNextState);
                this.mMaxLoadingCount = this.mStateGroupLoadingCount + this.mStateLoadingCount + this.mMenusToLoad.length;
                this.mDavinciLoadingPercentage = this.mFlowHandler.getDavinciLoadingPercentage(this.mNextState);
                if (this.mMaxLoadingCount > 0) {
                    this.mFlowHandler.setLoading(this.mNextState, true);
                    this.mLoadingCounter = 0;
                    this.mLoading = true;
                    this.mDavinciLoading = false;
                    Toolkit.removeAllSoftKeys();
                    return;
                }
            } else {
                if (this.mLoadingCounter < this.mMaxLoadingCount) {
                    long l = System.currentTimeMillis();
                    do {
                        if (this.mDavinciLoading) {
                            DavinciUtilities.loadNext();
                        } else {
                            n2 = this.mLoadingCounter;
                            if (n2 < this.mStateGroupLoadingCount) {
                                n = this.mStateGroups[this.mNextState];
                                this.mFlowHandler.loadStateGroup(n, n2);
                            } else if ((n2 -= this.mStateGroupLoadingCount) < this.mStateLoadingCount) {
                                this.mFlowHandler.loadState(this.mNextState, n2);
                            } else {
                                n = this.mMenusToLoad[n2 -= this.mStateLoadingCount];
                                this.loadMenu(n);
                            }
                        }
                        ++this.mLoadingCounter;
                        n3 = (int)(System.currentTimeMillis() - l);
                    } while (this.mLoadingCounter < this.mMaxLoadingCount && n3 < 50);
                    return;
                }
                if (!this.mDavinciLoading) {
                    this.mMaxLoadingCount = DavinciUtilities.getAdditionalLoadingCount();
                    if (this.mMaxLoadingCount > 0) {
                        this.mLoadingCounter = 0;
                        this.mDavinciLoading = true;
                        return;
                    }
                }
                if ((n5 = this.mStateGroups[this.mNextState]) != -1) {
                    this.mStateGroupInMemory[n5] = true;
                }
                this.mFlowHandler.setLoading(this.mNextState, false);
                this.mLoading = false;
            }
            n5 = this.mCurrentState;
            this.mCurrentState = this.mNextState;
            this.mNextState = -1;
            n4 = this.mStateHistoryPointer;
            while (--n4 >= 0) {
                if (this.mStateHistory[n4] != this.mCurrentState) continue;
                this.mStateHistoryPointer = n4;
                break;
            }
            this.activateState(this.mCurrentState);
            this.mFlowHandler.switchState(n5, this.mCurrentState, this.mCurrentMenu);
            if (this.mCurrentBranch == null) continue;
            this.processBranch(this.mCurrentState);
        }
    }

    private void deactivateState() {
        this.mCurrentMenu = null;
        this.mCurrentGameScreen = null;
        this.mCurrentBranch = null;
        Toolkit.removeAllSoftKeys();
    }

    private void activateState(int n) {
        if (n < this.mMenuScreenCount) {
            this.activateMenuScreen(n);
        } else if (n < this.mMenuScreenCount + this.mGameScreenCount) {
            this.activateGameScreen(n);
        } else {
            this.activateBranch(n);
        }
    }

    private boolean isMenuState(int n) {
        return n < this.mMenuScreenCount;
    }

    private void activateMenuScreen(int n) {
        this.mCurrentMenu = this.mLoadedMenus[n];
        if (this.mGoingForward) {
            this.mCurrentMenu.setSelectedItem(0);
        } else {
            this.mCurrentMenu.setSelectedItem(this.mMenuSelectedItems[this.mCurrentState] & 0xFF);
        }
        this.mFlowHandler.processMenu(n, this.mCurrentMenu, 2);
        this.mCurrentMenu.setVisible();
        this.mFlowHandler.processMenu(n, this.mCurrentMenu, 3);
        this.mStoreStateToHistory = this.mFlowHandler.shouldStoreStateToHistory(n);
    }

    private void activateGameScreen(int n) {
        if (this.mLoadedGameScreens[n - this.mGameScreenStartIndex] == null) {
            this.loadGameScreen(n);
        }
        this.mCurrentGameScreen = this.mLoadedGameScreens[n - this.mGameScreenStartIndex];
        this.mStoreStateToHistory = this.mFlowHandler.shouldStoreStateToHistory(n);
    }

    private void activateBranch(int n) {
        if (this.mLoadedBranches[n - this.mBranchStartIndex] == null) {
            this.loadBranch(n);
        }
        this.mCurrentBranch = this.mLoadedBranches[n - this.mBranchStartIndex];
        this.mStoreStateToHistory = false;
    }

    private void processBranch(int n) {
        if (this.mFlowHandler.evaluateBranchCondition(n)) {
            this.processEvent(this.mCurrentBranch[0]);
        } else {
            this.processEvent(this.mCurrentBranch[1]);
        }
    }

    private void loadMenu(int n) {
        int n2;
        int n3;
        if (!this.mFlowHandler.isMenuNeeded(n)) {
            return;
        }
        byte[] byArray = this.mFlowBinary;
        int n4 = this.mStateOffsets[n];
        int n5 = byArray[n4++];
        Vector<Integer> vector = new Vector<Integer>();
        Image[][] imageArrayArray = new Image[1][];
        SpriteObject[] spriteObjectArray = new SpriteObject[1];
        byte by = byArray[n4++];
        byte by2 = byArray[n4++];
        MenuObject menuObject = new MenuObject();
        this.mFlowHandler.processMenu(n, menuObject, 0);
        this.mFlowHandler.menuSetScreen(n, menuObject, by, n5, by2);
        byte by3 = byArray[n4++];
        this.mFlowHandler.menuSetStyle(n, menuObject, by3);
        int n6 = FlowProcessor.loadResourceID(byArray, n4);
        n4 += 4;
        String string = this.mFlowHandler.processText(n, n6, -1);
        n4 = FlowProcessor.loadImagesOrAnimations(byArray, n4, 1, imageArrayArray, spriteObjectArray);
        Image image = imageArrayArray[0] == null ? null : imageArrayArray[0][0];
        SpriteObject spriteObject = spriteObjectArray[0];
        by2 = byArray[n4++];
        if (string != null && string.length() != 0 || spriteObject != null || image != null) {
            if (spriteObject != null) {
                this.mFlowHandler.menuSetTitleBarDvc(n, menuObject, string, spriteObject, by2);
            } else {
                this.mFlowHandler.menuSetTitleBar(n, menuObject, string, image, by2);
            }
        }
        byte by4 = byArray[n4++];
        if ((n3 = byArray[n4++] & 0xFF) != 255) {
            vector.addElement(new Integer(by4));
            vector.addElement(new Integer(n3));
        }
        this.mFlowHandler.menuSetSoftkey(n, menuObject, by4, 0);
        byte by5 = byArray[n4++];
        int n7 = byArray[n4++] & 0xFF;
        if (n7 != 255) {
            vector.addElement(new Integer(by5));
            vector.addElement(new Integer(n7));
        }
        this.mFlowHandler.menuSetSoftkey(n, menuObject, by5, 1);
        block7: for (int i = 0; i < n5; ++i) {
            n2 = byArray[n4++];
            switch (n2) {
                case 0: {
                    n6 = FlowProcessor.loadResourceID(byArray, n4);
                    n4 += 4;
                    string = this.mFlowHandler.processText(n, n6, i);
                    n4 = FlowProcessor.loadImagesOrAnimations(byArray, n4, 3, imageArrayArray, spriteObjectArray);
                    Image[] imageArray = imageArrayArray[0];
                    spriteObject = spriteObjectArray[0];
                    short s = FlowProcessor.loadEvent(byArray[n4++]);
                    this.mFlowHandler.menuSetItem(n, menuObject, i, n2, string, spriteObject, imageArray, s);
                    continue block7;
                }
                case 1: {
                    n6 = FlowProcessor.loadResourceID(byArray, n4);
                    n4 += 4;
                    string = this.mFlowHandler.processText(n, n6, i);
                    n4 = FlowProcessor.loadImagesOrAnimations(byArray, n4, 4, imageArrayArray, spriteObjectArray);
                    Image[] imageArray = imageArrayArray[0];
                    spriteObject = spriteObjectArray[0];
                    int n8 = byArray[n4++];
                    String[] stringArray = new String[n8];
                    for (int j = 0; j < n8; ++j) {
                        n6 = FlowProcessor.loadResourceID(byArray, n4);
                        n4 += 4;
                        stringArray[j] = this.mFlowHandler.processText(n, n6, i);
                    }
                    n4 = FlowProcessor.loadImagesOrAnimations(byArray, n4, n8, imageArrayArray, spriteObjectArray);
                    Image[] imageArray2 = imageArrayArray[0];
                    SpriteObject spriteObject2 = spriteObjectArray[0];
                    short s = FlowProcessor.loadEvent(byArray[n4++]);
                    this.mFlowHandler.menuSetSwitchItem(n, menuObject, i, string, spriteObject, imageArray, stringArray, spriteObject2, imageArray2, s);
                    continue block7;
                }
                case 2: {
                    n6 = FlowProcessor.loadResourceID(byArray, n4);
                    n4 += 4;
                    string = this.mFlowHandler.processText(n, n6, i);
                    n4 = FlowProcessor.loadImagesOrAnimations(byArray, n4, 4, imageArrayArray, spriteObjectArray);
                    Image[] imageArray = imageArrayArray[0];
                    spriteObject = spriteObjectArray[0];
                    int n9 = byArray[n4++] & 0xFF;
                    int n10 = byArray[n4++] & 0xFF;
                    short s = FlowProcessor.loadEvent(byArray[n4++]);
                    this.mFlowHandler.menuSetSliderItem(n, menuObject, i, string, spriteObject, imageArray, n9, n10, s);
                    continue block7;
                }
                case 3: {
                    n4 += 9;
                    n4 = FlowProcessor.loadImagesOrAnimations(byArray, n4, 3, imageArrayArray, spriteObjectArray);
                    n4 += 2;
                    continue block7;
                }
                case 4: {
                    n6 = FlowProcessor.loadResourceID(byArray, n4);
                    n4 += 4;
                    string = this.mFlowHandler.processText(n, n6, i);
                    n4 = FlowProcessor.loadImagesOrAnimations(byArray, n4, 1, imageArrayArray, spriteObjectArray);
                    Image[] imageArray = imageArrayArray[0];
                    spriteObject = spriteObjectArray[0];
                    this.mFlowHandler.menuSetItem(n, menuObject, i, 1, string, spriteObject, imageArray, -1);
                }
            }
        }
        this.mFlowHandler.processMenu(n, menuObject, 1);
        this.mFlowHandler.menuSetSize(n, menuObject);
        menuObject.setSelectedItem(0);
        this.mLoadedMenus[n] = menuObject;
        if (vector.size() > 0) {
            short[] sArray = new short[vector.size()];
            for (n2 = 0; n2 < vector.size(); ++n2) {
                sArray[n2] = (short)((Integer)vector.elementAt(n2)).intValue();
            }
            this.mMenuSoftkeyEvents[n] = sArray;
        }
    }

    private static int loadImagesOrAnimations(byte[] byArray, int n, int n2, Image[][] imageArray, SpriteObject[] spriteObjectArray) {
        int n3;
        imageArray[0] = null;
        spriteObjectArray[0] = null;
        int[] nArray = new int[n2];
        byte[] byArray2 = new byte[n2];
        boolean bl = false;
        boolean bl2 = false;
        for (n3 = 0; n3 < n2; ++n3) {
            nArray[n3] = FlowProcessor.loadResourceID(byArray, n);
            n += 4;
            bl2 = bl2 || nArray[n3] != -1;
            byArray2[n3] = byArray[n++];
            bl = bl || byArray2[n3] == 2 || byArray2[n3] == 3;
        }
        if (bl2) {
            if (bl) {
                spriteObjectArray[0] = new SpriteObject(DavinciUtilities.loadAnimations(nArray), true);
            } else {
                imageArray[0] = new Image[n2];
                for (n3 = 0; n3 < n2; ++n3) {
                    Image image = null;
                    if (byArray2[n3] == 0) {
                        image = Toolkit.getImage(nArray[n3]);
                    } else if (byArray2[n3] == 1) {
                        image = DavinciUtilities.getImage(nArray[n3]);
                    }
                    imageArray[0][n3] = image;
                }
            }
        }
        return n;
    }

    private void loadGameScreen(int n) {
        byte[] byArray = this.mFlowBinary;
        int n2 = this.mStateOffsets[this.mMenuScreenCount + (n - this.mGameScreenStartIndex)];
        int n3 = byArray[n2++] & 0xFF;
        short[] sArray = new short[n3];
        for (int i = 0; i < n3; ++i) {
            sArray[i] = FlowProcessor.loadEvent(byArray[n2++]);
        }
        this.mLoadedGameScreens[n - this.mGameScreenStartIndex] = sArray;
    }

    private static short loadEvent(byte by) {
        short s = (short)(by & 0xFF);
        return s == 255 ? (short)-1 : (short)s;
    }

    public static int loadResourceID(byte[] byArray, int n) {
        return byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
    }

    private void loadBranch(int n) {
        byte[] byArray = this.mFlowBinary;
        int n2 = this.mStateOffsets[this.mMenuScreenCount + this.mGameScreenCount + (n - this.mBranchStartIndex)];
        short[] sArray = new short[]{FlowProcessor.loadEvent(byArray[n2++]), FlowProcessor.loadEvent(byArray[n2])};
        this.mLoadedBranches[n - this.mBranchStartIndex] = sArray;
    }

    private void processEvent(int n) {
        int n2 = -1;
        if (this.mStateHistoryPointer > 0) {
            n2 = this.mStateHistory[this.mStateHistoryPointer - 1];
        }
        if (n != -1) {
            if (n == -2) {
                if (this.mCurrentGameScreen != null && this.mCurrentGameScreen.length > 0) {
                    this.processEvent(this.mCurrentGameScreen[0]);
                }
            } else if (n == -3) {
                this.mGoingForward = false;
                this.mNextState = n2;
                --this.mStateHistoryPointer;
            } else if (n >= 0) {
                int n3 = this.mEventTargets[n];
                if (n3 != -1) {
                    this.mGoingForward = true;
                    this.mNextState = n3;
                    if (this.isMenuState(this.mCurrentState)) {
                        this.mMenuSelectedItems[this.mCurrentState] = (byte)this.mCurrentMenu.getSelectedItem();
                    }
                    if (n2 == n3) {
                        this.mGoingForward = false;
                        --this.mStateHistoryPointer;
                    } else if (this.mStoreStateToHistory) {
                        this.mStateHistory[this.mStateHistoryPointer++] = (short)this.mCurrentState;
                    }
                }
                this.mFlowHandler.eventOccurred(this.mCurrentState, n);
            }
        }
    }

    private void processSoftkeyEvent(int n) {
        if (n != -1 && Toolkit.getSoftKeyType(n) == 2) {
            this.processEvent(-3);
        }
    }

    private void removeFromMenuCache(int n) {
        if (this.mLoadedMenus[n] != null) {
            this.mLoadedMenus[n].releaseScreen();
            this.mLoadedMenus[n] = null;
        }
    }

    public int getLoadingPercentage() {
        int n = -1;
        if (this.mLoading) {
            int n2 = 100 - this.mDavinciLoadingPercentage;
            if (this.mDavinciLoading) {
                n = n2 + this.mLoadingCounter * this.mDavinciLoadingPercentage / this.mMaxLoadingCount;
            } else {
                n = this.mLoadingCounter * n2 / this.mMaxLoadingCount;
                if (this.mLoadingCounter == this.mMaxLoadingCount && DavinciUtilities.getAdditionalLoadingCount() == 0) {
                    n = 100;
                }
            }
        }
        return n;
    }
}

