/*
 * Decompiled with CFR 0.152.
 */
package GameEngine;

import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class ImageResizer {
    private int iScreenWidth;
    private int iScreenHeight;
    private double iTanAlpha;
    private int iBackgroundWidth;
    private int iBackgroundHeight;
    private double iScaleRatio;

    public ImageResizer(int _screenWidth, int _screenHeight) {
        this.iScreenWidth = _screenWidth;
        this.iScreenHeight = _screenHeight;
        this.iTanAlpha = (double)_screenWidth / (double)_screenHeight;
        this.iScaleRatio = 1.0;
        try {
            this.fixBackgroundImageToScreen(Image.createImage((String)"/resGFX/dummy.png"));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private Image resizeImage(Image _src) {
        int srcWidth = _src.getWidth();
        int srcHeight = _src.getHeight();
        Image tmp = Image.createImage((int)this.iScreenWidth, (int)srcHeight);
        Graphics g = tmp.getGraphics();
        int ratio = (srcWidth << 16) / this.iScreenWidth;
        int pos = ratio / 2;
        for (int x = 0; x < this.iScreenWidth; ++x) {
            g.setClip(x, 0, 1, srcHeight);
            g.drawImage(_src, x - (pos >> 16), 0, 20);
            pos += ratio;
        }
        Image resizedImage = Image.createImage((int)this.iScreenWidth, (int)this.iScreenHeight);
        g = resizedImage.getGraphics();
        ratio = (srcHeight << 16) / this.iScreenHeight;
        pos = ratio / 2;
        for (int y = 0; y < this.iScreenHeight; ++y) {
            g.setClip(0, y, this.iScreenWidth, 1);
            g.drawImage(tmp, 0, y - (pos >> 16), 20);
            pos += ratio;
        }
        return resizedImage;
    }

    public Image fixBackgroundImageToScreen(Image _src) {
        int srcWidth = _src.getWidth();
        int srcHeight = _src.getHeight();
        Image tmp = Image.createImage((int)this.iScreenWidth, (int)srcHeight);
        Graphics g = tmp.getGraphics();
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, this.iScreenWidth, this.iScreenHeight * 2);
        int ratio = (srcWidth << 16) / this.iScreenWidth;
        int pos = ratio / 2;
        this.iScaleRatio = (double)_src.getHeight() / (double)this.iScreenHeight;
        double tanAlpha = (double)srcWidth / (double)srcHeight;
        double newWidth = tanAlpha * (double)this.iScreenHeight;
        double newHeight = (double)this.iScreenWidth / tanAlpha;
        int HeightOrWith = srcHeight - srcWidth;
        this.iBackgroundWidth = (int)newWidth;
        this.iBackgroundHeight = (int)newHeight;
        if (HeightOrWith < 0) {
            int yCoord = this.iScreenHeight - (int)newHeight;
            for (int x = 0; x < this.iScreenWidth; ++x) {
                g.setClip(x, 0, 1, srcHeight);
                g.drawImage(_src, x - (pos >> 16), 0, 20);
                pos += ratio;
            }
            Image resizedImage = Image.createImage((int)this.iScreenWidth, (int)this.iScreenHeight);
            g = resizedImage.getGraphics();
            g.fillRect(0, 0, this.iScreenWidth, this.iScreenHeight);
            ratio = (srcHeight << 16) / (int)newHeight;
            pos = ratio / 2;
            for (int y = 0; y < this.iScreenHeight; ++y) {
                g.setClip(0, y, this.iScreenWidth, 1);
                g.drawImage(tmp, 0, y - (pos >> 16) + yCoord, 20);
                pos += ratio;
            }
            return resizedImage;
        }
        ratio = (srcWidth << 16) / (int)newWidth;
        g.fillRect(0, 0, this.iScreenWidth, this.iScreenHeight * 2);
        for (int x = 0; x < this.iScreenWidth; ++x) {
            g.setClip(x, 0, 1, srcHeight);
            g.drawImage(_src, x - (pos >> 16), 0, 20);
            pos += ratio;
        }
        Image resizedImage = Image.createImage((int)this.iScreenWidth, (int)this.iScreenHeight);
        g = resizedImage.getGraphics();
        g.fillRect(0, 0, this.iScreenWidth, this.iScreenHeight * 2);
        ratio = (srcHeight << 16) / this.iScreenHeight;
        pos = ratio / 2;
        int xCoord = (this.iScreenWidth - (int)newWidth) / 2;
        for (int y = 0; y < this.iScreenHeight; ++y) {
            g.setClip(0, y, this.iScreenWidth, 1);
            g.drawImage(tmp, xCoord, y - (pos >> 16), 20);
            pos += ratio;
        }
        if (this.iScreenWidth == 240 && this.iScreenHeight == 320) {
            return _src;
        }
        return resizedImage;
    }

    private Sprite fixBackgroundSpriteToScreen(Image _src, int _NoOfFrames) {
        int srcWidth = _src.getWidth();
        int srcHeight = _src.getHeight();
        Image tmp = Image.createImage((int)this.iScreenWidth, (int)srcHeight);
        Graphics g = tmp.getGraphics();
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, this.iScreenWidth, this.iScreenHeight * 2);
        int ratio = (srcWidth << 16) / this.iScreenWidth;
        int pos = ratio / 2;
        this.iScaleRatio = (double)_src.getHeight() / (double)this.iScreenHeight;
        double tan = (double)srcHeight / (double)srcWidth;
        int newHeight = (int)((double)_src.getHeight() / this.iScaleRatio);
        int newWidth = (int)((double)newHeight / tan);
        ratio = (srcWidth << 16) / newWidth;
        g.fillRect(0, 0, this.iScreenWidth, this.iScreenHeight * 2);
        for (int x = 0; x < this.iScreenWidth; ++x) {
            g.setClip(x, 0, 1, srcHeight);
            g.drawImage(_src, x - (pos >> 16), 0, 20);
            pos += ratio;
        }
        Image resizedImage = Image.createImage((int)this.iScreenWidth, (int)this.iScreenHeight);
        g = resizedImage.getGraphics();
        g.fillRect(0, 0, this.iScreenWidth, this.iScreenHeight * 2);
        ratio = (srcHeight << 16) / this.iScreenHeight;
        pos = ratio / 2;
        int xCoord = (this.iScreenWidth - newWidth) / 2;
        for (int y = 0; y < this.iScreenHeight; ++y) {
            g.setClip(0, y, this.iScreenWidth, 1);
            g.drawImage(tmp, xCoord, y - (pos >> 16), 20);
            pos += ratio;
        }
        if (this.iScreenWidth == 240 && this.iScreenHeight == 320) {
            return new Sprite(_src);
        }
        return new Sprite(resizedImage);
    }

    public Image scaleInRatioToScreen(Image _src, int _ratio) {
        int scanline = _src.getWidth();
        int srcWidth = _src.getWidth();
        int srcHeight = _src.getHeight();
        int[] buf = new int[srcWidth * srcHeight];
        _src.getRGB(buf, 0, scanline, 0, 0, srcWidth, srcHeight);
        double tan = (double)srcWidth / (double)srcHeight;
        int newWidth = this.iBackgroundWidth / _ratio;
        int newHeight = (int)((double)newWidth / tan);
        int[] buf2 = new int[newWidth * newHeight];
        for (int y = 0; y < newHeight; ++y) {
            int c1 = y * newWidth;
            int c2 = y * srcHeight / newHeight * scanline;
            for (int x = 0; x < newWidth; ++x) {
                buf2[c1 + x] = buf[c2 + x * srcWidth / newWidth];
            }
        }
        if (this.iScreenWidth == 240 && this.iScreenHeight == 320) {
            return _src;
        }
        return Image.createRGBImage((int[])buf2, (int)newWidth, (int)newHeight, (boolean)true);
    }

    private Image scaleInAutoRatioToScreen(Image _src) {
        int scanline = _src.getWidth();
        int srcWidth = _src.getWidth();
        int srcHeight = _src.getHeight();
        int[] buf = new int[srcWidth * srcHeight];
        _src.getRGB(buf, 0, scanline, 0, 0, srcWidth, srcHeight);
        double tan = (double)srcHeight / (double)srcWidth;
        int newHeight = (int)((double)_src.getHeight() / this.iScaleRatio);
        int newWidth = (int)((double)newHeight / tan);
        int[] buf2 = new int[newWidth * newHeight];
        for (int y = 0; y < newHeight; ++y) {
            int c1 = y * newWidth;
            int c2 = y * srcHeight / newHeight * scanline;
            for (int x = 0; x < newWidth; ++x) {
                buf2[c1 + x] = buf[c2 + x * srcWidth / newWidth];
            }
        }
        if (this.iScreenWidth == 240 && this.iScreenHeight == 320) {
            return _src;
        }
        return Image.createRGBImage((int[])buf2, (int)newWidth, (int)newHeight, (boolean)true);
    }

    private Sprite scaleAnimatedSpriteInRatioToScreen(Image _src, int _NOFrames, double _ratio) {
        int scanline = _src.getWidth();
        int srcWidth = _src.getWidth();
        int srcHeight = _src.getHeight();
        int[] buf = new int[srcWidth * srcHeight];
        _src.getRGB(buf, 0, scanline, 0, 0, srcWidth, srcHeight);
        double tan = (double)srcWidth / (double)srcHeight;
        int newWidth = (int)((double)this.iBackgroundWidth / _ratio);
        while (newWidth % _NOFrames != 0) {
            --newWidth;
        }
        int newHeight = (int)((double)newWidth / tan);
        int[] buf2 = new int[newWidth * newHeight];
        for (int y = 0; y < newHeight; ++y) {
            int c1 = y * newWidth;
            int c2 = y * srcHeight / newHeight * scanline;
            for (int x = 0; x < newWidth; ++x) {
                buf2[c1 + x] = buf[c2 + x * srcWidth / newWidth];
            }
        }
        if (this.iScreenWidth == 240 && this.iScreenHeight == 320) {
            return new Sprite(Image.createImage((Image)_src), srcWidth / _NOFrames, srcHeight);
        }
        return new Sprite(Image.createRGBImage((int[])buf2, (int)newWidth, (int)newHeight, (boolean)true), newWidth / _NOFrames, newHeight);
    }

    public Sprite scaleAnimatedSpriteInAutoRatioToScreen(Image _src, int _NOFrames) {
        int scanline = _src.getWidth();
        int srcWidth = _src.getWidth();
        int srcHeight = _src.getHeight();
        int[] buf = new int[srcWidth * srcHeight];
        _src.getRGB(buf, 0, scanline, 0, 0, srcWidth, srcHeight);
        double tan = (double)srcHeight / (double)srcWidth;
        int newHeight = (int)((double)_src.getHeight() / this.iScaleRatio);
        int newWidth = (int)((double)newHeight / tan);
        while (newWidth % _NOFrames != 0) {
            --newWidth;
        }
        int[] buf2 = new int[newWidth * newHeight];
        for (int y = 0; y < newHeight; ++y) {
            int c1 = y * newWidth;
            int c2 = y * srcHeight / newHeight * scanline;
            for (int x = 0; x < newWidth; ++x) {
                buf2[c1 + x] = buf[c2 + x * srcWidth / newWidth];
            }
        }
        if (this.iScreenWidth == 240 && this.iScreenHeight == 320) {
            return new Sprite(Image.createImage((Image)_src), srcWidth / _NOFrames, srcHeight);
        }
        return new Sprite(Image.createRGBImage((int[])buf2, (int)newWidth, (int)newHeight, (boolean)true), newWidth / _NOFrames, newHeight);
    }

    public int getBackgroundWidth() {
        return this.iBackgroundWidth;
    }
}

