/*
 * Decompiled with CFR 0.152.
 */
package GameEngine;

import GameEngine.ImageResizer;
import GameEngine.LevelLoader;
import java.io.IOException;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;

public class SpriteLoader {
    public int iWidth;
    public int iHeight;
    public ImageResizer resize;
    public int iBearOldPosLeft;
    public int iBearOldPosRight;
    public Sprite iMenuBackground;
    public Sprite iSelectorL;
    public Sprite iSelectorR;
    public boolean iIsServerShotActive;
    public boolean iIsClientShotActive;
    public boolean iShowRabbitOnClient;
    public int iSelectRandomPlayer;
    public int iGameBackgroundWidth;
    private LayerManager iMenuLayer;
    private LayerManager iGameLayer;
    private LayerManager iLevelLayer;
    private LayerManager iWaitLayer;
    private LayerManager iInfoLayer;
    public int deltaX = 0;
    public int deltaY = 0;
    public double scaleWidth = 0.0;
    public double scaleHeight = 0.0;
    public Sprite iServer;
    public Sprite iClient;
    public Sprite iBall;
    public Sprite iWinnerServer;
    public Sprite iWinnerClient;
    public Sprite iLooser;
    public Sprite iServerShot;
    public Sprite iClientShot;
    public Sprite iAbout;
    public Sprite iWait;
    public Sprite iLogo;
    public Sprite iSmashRabbit;
    public Sprite iSmashSinglePlayer;
    public int iHalfBallWidth;
    public int iHalfBallHeigth;
    public int iLeftGameBorder;
    public int iRightGameBorder;
    public int iFirstFifth;
    public int iSecondFifth;
    public int iThiredFifth;
    public int iForthFifth;
    public int iLastFifth;
    public int iMoveBrickInRatio;
    public boolean iClientBallOut;
    public boolean iServerBallOut;
    public double iPlayerSpeed;
    public int xdir = 0;
    public int ydir = 0;
    public int oldxdir = 0;
    public int oldydir = 0;
    public int xDefaultDir = 0;
    public int yDefaultDir = 0;
    public int iPlayerX;
    public int iSenfSpeed;
    public int iZyklus;

    public SpriteLoader(int _height, int _width) {
        this.iHeight = _height;
        this.iWidth = _width;
        this.loadGraphics();
    }

    public void loadGraphics() {
        try {
            this.resize = new ImageResizer(this.iWidth, this.iHeight);
            this.iGameBackgroundWidth = this.resize.getBackgroundWidth();
            this.iMenuLayer = new LayerManager();
            this.iGameLayer = new LayerManager();
            this.iLevelLayer = new LayerManager();
            this.iWaitLayer = new LayerManager();
            this.iInfoLayer = new LayerManager();
            LevelLoader levelLoader = new LevelLoader(this.iWidth, this.iHeight);
            Sprite gameBackground = levelLoader.getGameBackground();
            this.iLevelLayer = levelLoader.getLevel();
            this.iMenuBackground = this.resize.scaleAnimatedSpriteInAutoRatioToScreen(Image.createImage((String)"/resGFX/menuSprite.png"), 2);
            this.iMenuBackground.defineReferencePixel(this.iMenuBackground.getWidth() / 2, this.iMenuBackground.getHeight() / 2);
            this.iMenuBackground.setRefPixelPosition(this.iWidth / 2, this.iHeight / 2);
            this.iSelectorL = new Sprite(this.resize.scaleInRatioToScreen(Image.createImage((String)"/resGFX/flowers_l.png"), 8));
            this.iSelectorL.defineReferencePixel(this.iSelectorL.getWidth() / 2, this.iSelectorL.getHeight() / 2);
            this.iSelectorL.setRefPixelPosition((this.iWidth - this.iGameBackgroundWidth) / 2 + (int)((double)this.iGameBackgroundWidth / 7.3), (int)((double)this.iHeight / 2.9));
            this.iSelectorR = new Sprite(this.resize.scaleInRatioToScreen(Image.createImage((String)"/resGFX/flowers_r.png"), 8));
            this.iSelectorR.defineReferencePixel(this.iSelectorR.getWidth() / 2, this.iSelectorR.getHeight() / 2);
            this.iSelectorR.setRefPixelPosition((this.iWidth - this.iGameBackgroundWidth) / 2 + (int)((double)this.iGameBackgroundWidth / 1.9), (int)((double)this.iHeight / 3.2));
            this.iLogo = new Sprite(this.resize.scaleInRatioToScreen(Image.createImage((String)"/resGFX/logo.png"), 1));
            this.iLogo.defineReferencePixel(this.iLogo.getWidth() / 2, this.iLogo.getHeight() / 2);
            this.iLogo.setRefPixelPosition(this.iWidth / 2, this.iHeight / 6);
            this.iMenuLayer.append((Layer)this.iLogo);
            this.iMenuLayer.append((Layer)this.iSelectorL);
            this.iMenuLayer.append((Layer)this.iSelectorR);
            this.iMenuLayer.append((Layer)this.iMenuBackground);
            int[] frameSequencePlayers = new int[]{4, 3, 2, 1, 0, 0, 1, 2, 3, 4, 5};
            this.iServer = this.resize.scaleAnimatedSpriteInAutoRatioToScreen(Image.createImage((String)"/resGFX/elchSprite.png"), 6);
            this.iServer.defineReferencePixel(this.iServer.getWidth() / 2, this.iServer.getHeight() / 2);
            this.iServer.setFrameSequence(frameSequencePlayers);
            this.iClient = this.resize.scaleAnimatedSpriteInAutoRatioToScreen(Image.createImage((String)"/resGFX/schafSpriteInverse.png"), 6);
            this.iClient.defineReferencePixel(this.iClient.getWidth() / 2, this.iClient.getHeight() / 2);
            this.iClient.setFrameSequence(frameSequencePlayers);
            this.iClient.setRefPixelPosition(this.iWidth / 2, this.iClient.getHeight() / 2);
            this.iServer.setRefPixelPosition(this.iWidth / 2, this.iHeight - this.iClient.getHeight() / 2);
            this.iBall = new Sprite(this.resize.scaleInRatioToScreen(Image.createImage((String)"/resGFX/ball.png"), 20));
            this.iBall.defineReferencePixel(this.iBall.getWidth() / 2, this.iBall.getHeight() / 2);
            this.iBall.setRefPixelPosition(this.iWidth / 2, this.iHeight / 3);
            this.iServerShot = new Sprite(this.resize.scaleInRatioToScreen(Image.createImage((String)"/resGFX/spucke.png"), 24));
            this.iServerShot.defineReferencePixel(this.iServerShot.getWidth() / 2, this.iServerShot.getHeight() / 2);
            this.iServerShot.setRefPixelPosition(-200, -200);
            this.iClientShot = new Sprite(this.resize.scaleInRatioToScreen(Image.createImage((String)"/resGFX/spucke.png"), 24));
            this.iClientShot.defineReferencePixel(this.iClientShot.getWidth() / 2, this.iClientShot.getHeight() / 2);
            this.iClientShot.setRefPixelPosition(-200, -200);
            this.iSmashRabbit = this.resize.scaleAnimatedSpriteInAutoRatioToScreen(Image.createImage((String)"/resGFX/smash_rabbit.png"), 1);
            this.iSmashRabbit.defineReferencePixel(this.iSmashRabbit.getWidth() / 2, this.iSmashRabbit.getHeight() / 2);
            this.iSmashRabbit.setRefPixelPosition(this.iWidth / 2, this.iHeight / 2);
            this.iSmashRabbit.setVisible(false);
            this.iSmashSinglePlayer = new Sprite(this.resize.scaleInRatioToScreen(Image.createImage((String)"/resGFX/stars.png"), 5));
            this.iSmashSinglePlayer.defineReferencePixel(this.iSmashSinglePlayer.getWidth() / 2, this.iSmashSinglePlayer.getHeight() / 2);
            this.iSmashSinglePlayer.setRefPixelPosition(this.iWidth / 2, this.iHeight / 2);
            this.iSmashSinglePlayer.setVisible(false);
            this.deltaX = this.iWidth / 2;
            this.deltaY = this.iHeight / 3;
            this.iGameLayer.append((Layer)this.iSmashSinglePlayer);
            this.iGameLayer.append((Layer)this.iBall);
            this.iGameLayer.append((Layer)this.iServer);
            this.iGameLayer.append((Layer)this.iClient);
            this.iGameLayer.append((Layer)this.iServerShot);
            this.iGameLayer.append((Layer)this.iClientShot);
            this.iGameLayer.append((Layer)gameBackground);
            this.iWait = new Sprite(this.resize.scaleAnimatedSpriteInAutoRatioToScreen(Image.createImage((String)"/resGFX/suchSprite.png"), 2));
            this.iWait.defineReferencePixel(this.iWait.getWidth() / 2, this.iWait.getHeight() / 2);
            this.iWait.setRefPixelPosition(this.iWidth / 2, this.iHeight / 2);
            this.iWaitLayer.append((Layer)this.iWait);
            this.iAbout = new Sprite(this.resize.scaleAnimatedSpriteInAutoRatioToScreen(Image.createImage((String)"/resGFX/about.png"), 2));
            this.iAbout.defineReferencePixel(this.iAbout.getWidth() / 2, this.iAbout.getHeight() / 2);
            this.iAbout.setRefPixelPosition(this.iWidth / 2, this.iHeight / 2);
            this.iInfoLayer.append((Layer)this.iAbout);
            this.iFirstFifth = this.iServer.getWidth() / 5;
            this.iSecondFifth = 2 * (this.iServer.getWidth() / 5);
            this.iThiredFifth = 3 * (this.iServer.getWidth() / 5);
            this.iForthFifth = 4 * (this.iServer.getWidth() / 5);
            this.iLastFifth = this.iServer.getX() + this.iServer.getWidth();
            this.iWinnerServer = new Sprite(this.resize.scaleAnimatedSpriteInAutoRatioToScreen(Image.createImage((String)"/resGFX/elch_win.png"), 4));
            this.iWinnerClient = new Sprite(this.resize.scaleAnimatedSpriteInAutoRatioToScreen(Image.createImage((String)"/resGFX/schaf_win.png"), 4));
            this.iLooser = new Sprite(this.resize.scaleAnimatedSpriteInAutoRatioToScreen(Image.createImage((String)"/resGFX/bear_lost.png"), 2));
            this.iWinnerServer.defineReferencePixel(this.iWinnerServer.getWidth() / 2, this.iWinnerServer.getHeight() / 2);
            this.iWinnerClient.defineReferencePixel(this.iWinnerClient.getWidth() / 2, this.iWinnerClient.getHeight() / 2);
            this.iWinnerServer.setRefPixelPosition(this.iWidth / 2, this.iHeight / 2);
            this.iWinnerClient.setRefPixelPosition(this.iWidth / 2, this.iHeight / 2);
            this.iLooser.defineReferencePixel(this.iLooser.getWidth() / 2, this.iLooser.getHeight() / 2);
            this.iLooser.setRefPixelPosition(this.iWidth / 2, this.iHeight / 2);
            this.iHalfBallWidth = this.iBall.getWidth() / 2;
            this.iHalfBallHeigth = this.iBall.getHeight() / 2;
            this.iLeftGameBorder = (this.iWidth - this.iGameBackgroundWidth) / 2;
            this.iRightGameBorder = (this.iWidth - this.iGameBackgroundWidth) / 2 + this.iGameBackgroundWidth;
            this.iMoveBrickInRatio = this.iHeight / 20;
            this.iPlayerSpeed = (double)this.iGameBackgroundWidth / 30.0;
            this.iBearOldPosLeft = ((Sprite)this.iLevelLayer.getLayerAt(0)).getY();
            this.iBearOldPosRight = ((Sprite)this.iLevelLayer.getLayerAt(1)).getY();
            this.iSelectRandomPlayer = 0;
            this.iZyklus = 0;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.calcScales();
    }

    private void calcScales() {
        this.scaleWidth = 1.0 / (double)this.iGameBackgroundWidth;
        this.scaleHeight = 1.0 / (double)this.iHeight;
        this.xdir = (int)(1200.0 * this.scaleWidth);
        this.ydir = (int)(1200.0 * this.scaleHeight);
        this.iPlayerX = this.iWidth / 2;
        this.iSenfSpeed = this.ydir * 5;
        this.xDefaultDir = this.xdir;
        this.yDefaultDir = this.ydir;
    }

    public void resetGame() {
        if (this.iSelectRandomPlayer == 6) {
            this.iSelectRandomPlayer = 0;
        }
        this.deltaX = this.iWidth / 2;
        this.deltaY = this.iHeight / 3;
        this.xdir = (int)(1200.0 * this.scaleWidth);
        this.ydir = (int)(1200.0 * this.scaleHeight);
        this.iPlayerX = this.iWidth / 2;
        try {
            if (this.iSelectRandomPlayer == 5) {
                this.iServer = this.resize.scaleAnimatedSpriteInAutoRatioToScreen(Image.createImage((String)"/resGFX/elchSprite.png"), 6);
                this.iClient = this.resize.scaleAnimatedSpriteInAutoRatioToScreen(Image.createImage((String)"/resGFX/schafSpriteInverse.png"), 6);
                this.iWinnerServer = this.resize.scaleAnimatedSpriteInAutoRatioToScreen(Image.createImage((String)"/resGFX/elch_win.png"), 4);
                this.iWinnerClient = this.resize.scaleAnimatedSpriteInAutoRatioToScreen(Image.createImage((String)"/resGFX/schaf_win.png"), 4);
            } else if (this.iSelectRandomPlayer == 0) {
                this.iServer = this.resize.scaleAnimatedSpriteInAutoRatioToScreen(Image.createImage((String)"/resGFX/eichkatzeSprite.png"), 6);
                this.iClient = this.resize.scaleAnimatedSpriteInAutoRatioToScreen(Image.createImage((String)"/resGFX/luchsSpriteInverse.png"), 6);
                this.iWinnerServer = this.resize.scaleAnimatedSpriteInAutoRatioToScreen(Image.createImage((String)"/resGFX/eich_win.png"), 4);
                this.iWinnerClient = this.resize.scaleAnimatedSpriteInAutoRatioToScreen(Image.createImage((String)"/resGFX/katz_win.png"), 4);
            } else if (this.iSelectRandomPlayer == 3) {
                this.iServer = this.resize.scaleAnimatedSpriteInAutoRatioToScreen(Image.createImage((String)"/resGFX/schafSprite.png"), 6);
                this.iClient = this.resize.scaleAnimatedSpriteInAutoRatioToScreen(Image.createImage((String)"/resGFX/eichkatzeSpriteInverse.png"), 6);
                this.iWinnerServer = this.resize.scaleAnimatedSpriteInAutoRatioToScreen(Image.createImage((String)"/resGFX/schaf_win.png"), 4);
                this.iWinnerClient = this.resize.scaleAnimatedSpriteInAutoRatioToScreen(Image.createImage((String)"/resGFX/eich_win.png"), 4);
            } else if (this.iSelectRandomPlayer == 2) {
                this.iServer = this.resize.scaleAnimatedSpriteInAutoRatioToScreen(Image.createImage((String)"/resGFX/luchsSprite.png"), 6);
                this.iClient = this.resize.scaleAnimatedSpriteInAutoRatioToScreen(Image.createImage((String)"/resGFX/elchSpriteInverse.png"), 6);
                this.iWinnerServer = this.resize.scaleAnimatedSpriteInAutoRatioToScreen(Image.createImage((String)"/resGFX/katz_win.png"), 4);
                this.iWinnerClient = this.resize.scaleAnimatedSpriteInAutoRatioToScreen(Image.createImage((String)"/resGFX/elch_win.png"), 4);
            } else if (this.iSelectRandomPlayer == 1) {
                this.iServer = this.resize.scaleAnimatedSpriteInAutoRatioToScreen(Image.createImage((String)"/resGFX/elchSprite.png"), 6);
                this.iClient = this.resize.scaleAnimatedSpriteInAutoRatioToScreen(Image.createImage((String)"/resGFX/eichkatzeSpriteInverse.png"), 6);
                this.iWinnerServer = this.resize.scaleAnimatedSpriteInAutoRatioToScreen(Image.createImage((String)"/resGFX/elch_win.png"), 4);
                this.iWinnerClient = this.resize.scaleAnimatedSpriteInAutoRatioToScreen(Image.createImage((String)"/resGFX/eich_win.png"), 4);
            } else if (this.iSelectRandomPlayer == 4) {
                this.iServer = this.resize.scaleAnimatedSpriteInAutoRatioToScreen(Image.createImage((String)"/resGFX/schafSprite.png"), 6);
                this.iClient = this.resize.scaleAnimatedSpriteInAutoRatioToScreen(Image.createImage((String)"/resGFX/luchsSpriteInverse.png"), 6);
                this.iWinnerServer = this.resize.scaleAnimatedSpriteInAutoRatioToScreen(Image.createImage((String)"/resGFX/schaf_win.png"), 4);
                this.iWinnerClient = this.resize.scaleAnimatedSpriteInAutoRatioToScreen(Image.createImage((String)"/resGFX/katz_win.png"), 4);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        ++this.iSelectRandomPlayer;
        int[] frameSequencePlayers = new int[]{4, 3, 2, 1, 0, 0, 1, 2, 3, 4, 5};
        this.iServer.setFrameSequence(frameSequencePlayers);
        this.iClient.setFrameSequence(frameSequencePlayers);
        this.iServer.defineReferencePixel(this.iServer.getWidth() / 2, this.iServer.getHeight() / 2);
        this.iClient.defineReferencePixel(this.iClient.getWidth() / 2, this.iClient.getHeight() / 2);
        this.iClient.setRefPixelPosition(this.iWidth / 2, this.iClient.getHeight() / 2);
        this.iServer.setRefPixelPosition(this.iWidth / 2, this.iHeight - this.iClient.getHeight() / 2);
        this.iLooser.setFrame(0);
        this.iWinnerServer.defineReferencePixel(this.iWinnerServer.getWidth() / 2, this.iWinnerServer.getHeight() / 2);
        this.iWinnerClient.defineReferencePixel(this.iWinnerClient.getWidth() / 2, this.iWinnerClient.getHeight() / 2);
        this.iWinnerServer.setRefPixelPosition(this.iWidth / 2, this.iHeight / 2);
        this.iWinnerClient.setRefPixelPosition(this.iWidth / 2, this.iHeight / 2);
        this.iGameLayer = new LayerManager();
        this.iGameLayer.append((Layer)this.iSmashSinglePlayer);
        this.iGameLayer.append((Layer)this.iBall);
        this.iGameLayer.append((Layer)this.iServer);
        this.iGameLayer.append((Layer)this.iClient);
        this.iGameLayer.append((Layer)this.iServerShot);
        this.iGameLayer.append((Layer)this.iClientShot);
        LevelLoader levelLoader = new LevelLoader(this.iWidth, this.iHeight);
        this.iGameLayer.append((Layer)levelLoader.getGameBackground());
        this.iLevelLayer = levelLoader.getLevel();
        this.iServerBallOut = false;
        this.iClientBallOut = false;
        this.iServerShot.setPosition(-200, -200);
        this.iClientShot.setPosition(-200, -200);
        this.iIsServerShotActive = false;
        this.iIsClientShotActive = false;
    }

    public LayerManager getMenuLayer() {
        return this.iMenuLayer;
    }

    public LayerManager getGameLayer() {
        return this.iGameLayer;
    }

    public LayerManager getLevelLayer() {
        return this.iLevelLayer;
    }

    public LayerManager getWaitLayer() {
        return this.iWaitLayer;
    }

    public LayerManager getInfoLayer() {
        return this.iInfoLayer;
    }
}

