/*
 * Decompiled with CFR 0.152.
 */
package GameEngine;

import Audio.SoundEffects;
import GameEngine.SpriteLoader;
import java.util.Random;
import javax.microedition.lcdui.game.Sprite;

public class SpriteProcessor
extends SpriteLoader {
    private int iBearColFlag;
    private boolean iSideColFlag;
    public SoundEffects iSFX;
    private Random iRndMissBall = new Random();
    private boolean iStopClient;

    public SpriteProcessor(int _height, int _width) {
        super(_height, _width);
        this.iHeight = _height;
        this.iWidth = _width;
        this.iSFX = new SoundEffects();
    }

    public void moveSelector(int menuState) {
        int newPositionY_L = 0;
        int newPositionX_L = 0;
        int newPositionY_R = 0;
        int newPositionX_R = 0;
        this.iSFX.playTackSound();
        switch (menuState) {
            case 0: {
                newPositionY_L = (int)((double)this.iHeight / 2.9);
                newPositionX_L = (this.iWidth - this.iGameBackgroundWidth) / 2 + (int)((double)this.iGameBackgroundWidth / 7.3);
                newPositionY_R = (int)((double)this.iHeight / 3.2);
                newPositionX_R = (this.iWidth - this.iGameBackgroundWidth) / 2 + (int)((double)this.iGameBackgroundWidth / 1.9);
                break;
            }
            case 1: {
                newPositionY_L = (int)((double)this.iHeight / 2.05);
                newPositionX_L = (this.iWidth - this.iGameBackgroundWidth) / 2 + (int)((double)this.iGameBackgroundWidth / 6.1);
                newPositionY_R = (int)((double)this.iHeight / 2.17);
                newPositionX_R = (this.iWidth - this.iGameBackgroundWidth) / 2 + (int)((double)this.iGameBackgroundWidth / 1.8);
                break;
            }
            case 2: {
                newPositionY_L = (int)((double)this.iHeight / 1.54);
                newPositionX_L = (this.iWidth - this.iGameBackgroundWidth) / 2 + (int)((double)this.iGameBackgroundWidth / 7.5);
                newPositionY_R = (int)((double)this.iHeight / 1.63);
                newPositionX_R = (this.iWidth - this.iGameBackgroundWidth) / 2 + (int)((double)this.iGameBackgroundWidth / 1.93);
                break;
            }
            case 3: {
                newPositionY_L = (int)((double)this.iHeight / 1.27);
                newPositionX_L = (this.iWidth - this.iGameBackgroundWidth) / 2 + (int)((double)this.iGameBackgroundWidth / 3.6);
                newPositionY_R = (int)((double)this.iHeight / 1.33);
                newPositionX_R = (this.iWidth - this.iGameBackgroundWidth) / 2 + this.iGameBackgroundWidth / 2;
                break;
            }
            case 4: {
                newPositionY_L = (int)((double)this.iHeight / 1.09);
                newPositionX_L = (this.iWidth - this.iGameBackgroundWidth) / 2 + (int)((double)this.iGameBackgroundWidth / 5.07);
                newPositionX_R = -200;
                newPositionY_R = -200;
                break;
            }
        }
        this.iSelectorL.setRefPixelPosition(newPositionX_L, newPositionY_L);
        this.iSelectorR.setRefPixelPosition(newPositionX_R, newPositionY_R);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    public void processServerMovement() {
        this.oldxdir = this.deltaX;
        this.oldydir = this.deltaY;
        this.deltaX += this.xdir;
        this.deltaY += this.ydir;
        this.iServer.setPosition(this.iPlayerX, this.iServer.getY());
        this.iBall.setRefPixelPosition(this.deltaX, this.deltaY);
    }

    public void processClientMovement() {
        this.oldydir = this.iBall.getRefPixelY();
        this.iClient.setPosition(this.iPlayerX, this.iClient.getY());
    }

    public void moveServerLeft() {
        if (this.iServer.getX() > this.iWidth - this.iGameBackgroundWidth >> 1 && !this.iSmashRabbit.isVisible()) {
            this.iPlayerX = (int)((double)this.iPlayerX - this.iPlayerSpeed);
        }
    }

    public void moveServerRight() {
        if (this.iServer.getX() + this.iServer.getWidth() < (this.iWidth - this.iGameBackgroundWidth >> 1) + this.iGameBackgroundWidth && !this.iSmashRabbit.isVisible()) {
            this.iPlayerX = (int)((double)this.iPlayerX + this.iPlayerSpeed);
        }
    }

    public void moveClientLeft() {
        if (this.iClient.getX() > this.iWidth - this.iGameBackgroundWidth >> 1 && !this.iSmashRabbit.isVisible()) {
            this.iPlayerX = (int)((double)this.iPlayerX - this.iPlayerSpeed);
        }
    }

    public void moveClientRight() {
        if (this.iClient.getX() + this.iServer.getWidth() < (this.iWidth - this.iGameBackgroundWidth >> 1) + this.iGameBackgroundWidth && !this.iSmashRabbit.isVisible()) {
            this.iPlayerX = (int)((double)this.iPlayerX + this.iPlayerSpeed);
        }
    }

    public void moveCPULeft() {
        if (this.iClient.getX() > this.iWidth - this.iGameBackgroundWidth >> 1) {
            this.iClient.move((int)(-this.iPlayerSpeed), 0);
        }
    }

    public void moveCPURight() {
        if (this.iClient.getX() + this.iServer.getWidth() < (this.iWidth - this.iGameBackgroundWidth >> 1) + this.iGameBackgroundWidth) {
            this.iClient.move((int)this.iPlayerSpeed, 0);
        }
    }

    public void moveEnemySinglePlayerMode() {
        if (this.iStopClient) {
            return;
        }
        if (this.iServer.getRefPixelX() - this.iClient.getRefPixelX() < 5 && this.iServer.getRefPixelX() - this.iClient.getRefPixelX() > -5 && !this.iIsClientShotActive) {
            this.releaseShotClient(true);
        }
        if (this.ydir < 0 && (double)this.iBall.getRefPixelY() < (double)this.iHeight * 0.35) {
            if (this.iBall.getRefPixelX() < this.iClient.getX() + this.iSecondFifth) {
                this.moveCPULeft();
            }
            if (this.iBall.getRefPixelX() > this.iClient.getX() + this.iThiredFifth) {
                this.moveCPURight();
            }
        }
    }

    public void moveMouth() {
        if (this.oldydir < this.iBall.getRefPixelY() && this.iBall.getRefPixelY() > this.iHeight - this.iHeight / 4) {
            this.iServer.nextFrame();
        }
        if (this.oldydir > this.iBall.getRefPixelY() && this.iBall.getRefPixelY() < this.iHeight / 4) {
            this.iClient.nextFrame();
        }
    }

    private void puddleBallCollSide(Sprite aSprite) {
        if (this.iSideColFlag) {
            this.iSideColFlag = true;
            if (this.iBall.getRefPixelY() > aSprite.getY() - aSprite.getHeight() && this.iBall.getRefPixelY() < aSprite.getY() + aSprite.getHeight() && this.ydir < 0) {
                this.xdir = -this.xdir;
                this.ydir = -this.ydir;
            } else if (this.iBall.getRefPixelY() > aSprite.getY() && this.iBall.getRefPixelY() < aSprite.getY() + aSprite.getHeight() && this.ydir > 0) {
                this.xdir = -this.xdir;
                this.ydir = -this.ydir;
            }
        }
    }

    private void puddleBallCollFront(Sprite aSprite) {
        if (this.iBall.getRefPixelX() > aSprite.getX() && this.iBall.getRefPixelX() < aSprite.getX() + this.iFirstFifth) {
            if (this.xdir <= 0) {
                this.ydir = -this.ydir;
                this.xdir -= 2;
            } else {
                this.ydir = -this.ydir;
                this.xdir = -this.xdir;
            }
        } else if (this.iBall.getRefPixelX() >= aSprite.getX() + this.iFirstFifth && this.iBall.getRefPixelX() < aSprite.getX() + this.iSecondFifth) {
            if (this.xdir <= 0) {
                this.ydir = -this.ydir;
                --this.xdir;
            } else {
                this.ydir = -this.ydir;
                this.xdir = -this.xdir + 1;
            }
        } else if (this.iBall.getRefPixelX() >= aSprite.getX() + this.iSecondFifth && this.iBall.getRefPixelX() < aSprite.getX() + this.iThiredFifth) {
            if (this.xdir <= 0) {
                this.ydir = -this.ydir;
                this.xdir = -this.xDefaultDir;
            } else {
                this.ydir = -this.ydir;
                this.xdir = this.xDefaultDir;
            }
        } else if (this.iBall.getRefPixelX() >= aSprite.getX() + this.iThiredFifth && this.iBall.getRefPixelX() < aSprite.getX() + this.iForthFifth) {
            if (this.xdir >= 0) {
                this.ydir = -this.ydir;
                ++this.xdir;
            } else {
                this.ydir = -this.ydir;
                this.xdir = -this.xdir + 1;
            }
        } else if (this.iBall.getRefPixelX() >= aSprite.getX() + this.iForthFifth && this.iBall.getRefPixelX() < aSprite.getX() + this.iLastFifth) {
            if (this.xdir >= 0) {
                this.ydir = -this.ydir;
                this.xdir += 2;
            } else {
                this.ydir = -this.ydir;
                this.xdir = -this.xdir;
            }
        } else {
            this.ydir = -this.ydir;
        }
    }

    public void releaseShotServer(boolean aActivate) {
        if (!aActivate) {
            this.iIsServerShotActive = false;
            this.iServerShot.setPosition(-200, -200);
        } else {
            this.iIsServerShotActive = true;
            this.iServerShot.setRefPixelPosition(this.iServer.getRefPixelX(), this.iServer.getRefPixelY());
        }
    }

    public void releaseShotClient(boolean aActivate) {
        if (!aActivate) {
            this.iIsClientShotActive = false;
            this.iClientShot.setPosition(-200, -200);
        } else {
            this.iIsClientShotActive = true;
            this.iClientShot.setRefPixelPosition(this.iClient.getRefPixelX(), this.iClient.getRefPixelY());
        }
    }

    private void moveShotServer() {
        if (this.iIsServerShotActive) {
            this.iServerShot.move(0, -this.iSenfSpeed);
            if (this.iServerShot.getRefPixelY() < 0) {
                this.releaseShotServer(false);
            } else if (this.iServerShot.collidesWith(this.iClient, true)) {
                this.iShowRabbitOnClient = true;
                this.releaseShotServer(false);
                this.iSFX.playSmackSound();
            }
        }
    }

    private void moveShotClient() {
        if (this.iIsClientShotActive) {
            this.iClientShot.move(0, this.iSenfSpeed);
            if (this.iClientShot.getRefPixelY() > this.iHeight) {
                this.releaseShotClient(false);
                this.iIsClientShotActive = false;
            } else if (this.iClientShot.collidesWith(this.iServer, true)) {
                this.iSmashRabbit.setVisible(true);
                this.releaseShotClient(false);
                this.iIsClientShotActive = false;
                this.iSFX.playSmackSound();
            }
        }
    }

    private void moveShotSinglePlayer() {
        if (this.iIsServerShotActive) {
            this.iServerShot.move(0, -this.iSenfSpeed);
            if (this.iServerShot.getRefPixelY() < 0) {
                this.releaseShotServer(false);
            } else if (this.iServerShot.collidesWith(this.iClient, true) && this.iZyklus == 0) {
                this.releaseShotServer(false);
                this.iSFX.playSmackSound();
                ++this.iZyklus;
            }
        }
        if (this.iZyklus > 0 && this.iZyklus <= 50) {
            ++this.iZyklus;
            this.iStopClient = true;
            this.iSmashSinglePlayer.setRefPixelPosition(this.iClient.getRefPixelX(), this.iClient.getY() + this.iClient.getHeight());
            this.iSmashSinglePlayer.setVisible(true);
        }
        if (this.iZyklus > 50) {
            this.iStopClient = false;
            this.iZyklus = 0;
            this.iSmashSinglePlayer.setVisible(false);
        }
    }

    private void checkServerRabbit() {
        if (!this.iSmashRabbit.isVisible()) {
            return;
        }
        this.iSmashRabbit.move(0, this.iHeight / 100);
        if (this.iSmashRabbit.getY() > this.iHeight) {
            this.iSmashRabbit.setVisible(false);
            this.iSmashRabbit.setRefPixelPosition(this.iWidth / 2, this.iHeight / 2);
        }
    }

    private void checkClientRabbit() {
        if (!this.iShowRabbitOnClient && !this.iSmashRabbit.isVisible()) {
            return;
        }
        this.iSmashRabbit.move(0, this.iHeight / 100);
        if (this.iSmashRabbit.getY() > this.iHeight) {
            this.iSmashRabbit.setVisible(false);
            this.iShowRabbitOnClient = false;
            this.iSmashRabbit.setRefPixelPosition(this.iWidth / 2, this.iHeight / 2);
        }
    }

    private void ballBearCollision() {
        int count = 0;
        for (int i = 0; i < this.getLevelLayer().getSize(); ++i) {
            if (this.iBall.collidesWith((Sprite)this.getLevelLayer().getLayerAt(i), true)) {
                if (this.iBearColFlag != 0) continue;
                Sprite temp = (Sprite)this.getLevelLayer().getLayerAt(i);
                if (this.iBall.getRefPixelX() > temp.getX() && this.iBall.getRefPixelX() < temp.getX() + temp.getWidth()) {
                    this.ydir = -this.ydir;
                    this.moveBear(temp, i);
                    this.iBearColFlag = 1;
                } else {
                    this.iBearColFlag = 1;
                    this.xdir = -this.xdir;
                }
                return;
            }
            ++count;
        }
        if (count == this.getLevelLayer().getSize()) {
            this.iBearColFlag = 0;
        }
    }

    private void moveBear(Sprite aBear, int aIndex) {
        if (this.ydir < 0) {
            aBear.setPosition(aBear.getX(), aBear.getY() + this.iMoveBrickInRatio);
            aBear.setFrame(1);
        } else {
            aBear.setPosition(aBear.getX(), aBear.getY() - this.iMoveBrickInRatio);
            aBear.setFrame(0);
        }
    }

    private void ballBorderCollision() {
        if (this.deltaX + this.iHalfBallWidth >= this.iRightGameBorder && this.xdir > 0) {
            this.xdir = -this.xdir;
        }
        if (this.deltaX - this.iHalfBallWidth <= this.iLeftGameBorder && this.xdir < 0) {
            this.xdir = -this.xdir;
        }
        if (this.deltaY + this.iHalfBallHeigth >= this.iHeight) {
            this.ydir = -this.ydir;
            this.missBall(false);
            this.iSFX.playTackSound();
        }
        if (this.deltaY - this.iHalfBallHeigth <= 0) {
            this.ydir = -this.ydir;
            this.missBall(true);
            this.iSFX.playTackSound();
        }
    }

    private void missBall(boolean aServerMiss) {
        int i = this.iRndMissBall.nextInt(this.getLevelLayer().getSize());
        Sprite aBrick = (Sprite)this.getLevelLayer().getLayerAt(i);
        if (aServerMiss) {
            aBrick.setPosition(aBrick.getX(), aBrick.getY() - this.iMoveBrickInRatio);
            aBrick.setFrame(0);
        } else {
            aBrick.setPosition(aBrick.getX(), aBrick.getY() + this.iMoveBrickInRatio);
            aBrick.setFrame(1);
        }
        this.resetXdir();
    }

    private void hasBearMoved() {
        for (int i = 0; i < this.getLevelLayer().getSize(); ++i) {
            if (((Sprite)this.getLevelLayer().getLayerAt(i)).getY() < this.iBearOldPosLeft) {
                ((Sprite)this.getLevelLayer().getLayerAt(i)).setFrame(0);
            }
            if (((Sprite)this.getLevelLayer().getLayerAt(i)).getY() <= this.iBearOldPosLeft) continue;
            ((Sprite)this.getLevelLayer().getLayerAt(i)).setFrame(1);
        }
        this.iBearOldPosLeft = ((Sprite)this.getLevelLayer().getLayerAt(0)).getY();
        this.iBearOldPosRight = ((Sprite)this.getLevelLayer().getLayerAt(1)).getY();
    }

    public void singlePlayerGameLogic() {
        this.ballBorderCollision();
        this.moveShotSinglePlayer();
        this.moveShotClient();
        this.checkClientRabbit();
        this.moveMouth();
        if (this.iBall.collidesWith(this.iServer, true) && this.ydir > 0) {
            this.puddleBallCollSide(this.iServer);
            this.puddleBallCollFront(this.iServer);
            this.iSFX.playDunkSound();
        } else if (this.iBall.collidesWith(this.iClient, true) && this.ydir < 0) {
            this.puddleBallCollSide(this.iClient);
            this.puddleBallCollFront(this.iClient);
            this.iSFX.playDunkSound();
        } else {
            this.iSideColFlag = false;
        }
        this.ballBearCollision();
    }

    public void serverGameLogic() {
        this.ballBorderCollision();
        this.moveShotServer();
        this.moveShotClient();
        this.moveMouth();
        if (this.iBall.collidesWith(this.iServer, true) && this.ydir > 0) {
            this.puddleBallCollSide(this.iServer);
            this.puddleBallCollFront(this.iServer);
        } else if (this.iBall.collidesWith(this.iClient, true) && this.ydir < 0) {
            this.puddleBallCollSide(this.iClient);
            this.puddleBallCollFront(this.iClient);
        } else {
            this.iSideColFlag = false;
        }
        this.ballBearCollision();
        this.checkServerRabbit();
    }

    public void clientGameLogic() {
        this.moveMouth();
        if (this.iShowRabbitOnClient) {
            this.iSmashRabbit.setVisible(true);
        }
        this.checkClientRabbit();
        this.hasBearMoved();
    }

    public void resetXdir() {
        int negativ = 1;
        if (this.xdir < 0) {
            negativ = -1;
        }
        Random r = new Random();
        this.xdir = r.nextInt(4);
        this.xdir *= negativ;
    }
}

