/*
 * Decompiled with CFR 0.152.
 */
package tinbrain;

import com.xendex.BEEzzz.BEEzzz2D;
import game.Game;
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;
import tinbrain.Menu;
import tinbrain.RM;
import tinbrain.midp20.MIDP20Proxy;
import tinbrain.nokia.ACanvas;
import tinbrain.util.GL;

public class GCanvas
implements Runnable {
    protected static volatile boolean isRunning;
    private static int globalFrameCount;
    private static long uptimeMillis;
    protected static int width;
    protected static int height;
    private static boolean forcedSize;
    private static int keyStatesUp;
    private static int keyStatesDown;
    private static int keyStates;
    private static Canvas canvas;
    private static Graphics deviceGraphics;
    private static Graphics targetGraphics;
    public static boolean backBufferEnabled;
    public static final Font FONT_LARGE;
    public static final Font FONT_MEDIUM;
    public static final Font FONT_SMALL;
    public static final int FONT_LARGE_HEIGHT;
    public static final int FONT_MEDIUM_HEIGHT;
    public static final int FONT_SMALL_HEIGHT;
    private static int softkeyPressed;
    protected static byte[][] softkeys;
    private static int leftSoftButton;
    private static int rightSoftButton;
    public static Font softButtonFont;
    public static boolean hideSoftKeys;
    public static boolean swapSoftKeys;
    private static final int[][] clipStack;
    private static int clipStackPtr;
    private static final int[] tmpClip;
    private static final int[] tmpRect;
    public static long frameTime;
    private static long lastFrameTime;
    private static long lastDrawTime;
    private static int frameTimeCount;
    private static String fpsMessage;
    private static String tmpMessage;
    private static int tmpMessageTime;
    private static int cheatFlags;
    private static final int[] cheatBase;
    private static int cheatPosition;
    private static long current;
    private static long last;
    private static long delay;
    private static byte[] sqrtLookup;
    private static boolean inputDone;
    public static final Random random;
    public static final int[] xPoints;
    public static final int[] yPoints;

    protected static final void setForcedSize(int n, int n2) {
        if (n != width || n2 != height) {
            GCanvas.setSize(n, n2);
            forcedSize = true;
        }
    }

    public static final void setSize(int n, int n2) {
        if (!forcedSize) {
            width = n;
            height = n2;
        }
    }

    public static final void init(MIDlet mIDlet) {
        canvas = new ACanvas();
        Display.getDisplay((MIDlet)mIDlet).setCurrent((Displayable)canvas);
    }

    public static final void initResources() {
        GCanvas.initSprites();
        sqrtLookup = RM.getBytes(0);
    }

    private static final void updateInput() {
        keyStates = keyStatesDown;
        keyStatesDown &= ~keyStatesUp;
        keyStatesUp = 0;
    }

    public static final void resetKeys() {
        softkeyPressed = 0;
        keyStatesUp = 0;
        keyStatesDown = 0;
        keyStates = 0;
    }

    public static final int getSoftkeys() {
        int n = softkeyPressed;
        softkeyPressed = 0;
        return n;
    }

    public static final int getSoftKeyAreaTop() {
        return height - (2 + RM.getFontHeight(softButtonFont));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void drawScene(Graphics graphics) {
        deviceGraphics = graphics;
        targetGraphics = graphics;
        Graphics graphics2 = graphics;
        synchronized (graphics2) {
            GCanvas.doDrawScene(graphics);
        }
    }

    private static void doDrawScene(Graphics graphics) {
        targetGraphics.setClip(0, 0, width, height);
        try {
            Menu.onDraw(targetGraphics);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!hideSoftKeys) {
            GCanvas.drawSoftButtons();
        }
        long l = System.currentTimeMillis();
        if (GCanvas.cheatEnabled(5)) {
            if (--frameTimeCount == 0) {
                frameTimeCount = 16;
                int n = (int)(l - lastFrameTime);
                lastFrameTime = l;
                if ((n >>= 4) > 0) {
                    int n2 = 1024000 / n + 512 >> 10;
                    fpsMessage = Integer.toString(n2);
                }
            }
            if (fpsMessage != null) {
                targetGraphics.setColor(-1);
                targetGraphics.setFont(FONT_SMALL);
                targetGraphics.drawString(fpsMessage, 2, 20, 20);
            }
        }
        GCanvas.updateUptime(l);
        if (tmpMessageTime > 0) {
            targetGraphics.setColor(-16777216);
            targetGraphics.fillRect(0, (height >> 1) - 2, width, FONT_SMALL_HEIGHT + 4);
            targetGraphics.setColor(-1);
            targetGraphics.setFont(FONT_SMALL);
            targetGraphics.drawString(tmpMessage, width >> 1, height >> 1, 17);
            --tmpMessageTime;
        }
        ++globalFrameCount;
        inputDone = false;
    }

    private static final void updateUptime(long l) {
        if (canvas.isShown()) {
            long l2 = Math.abs(l - lastDrawTime);
            if (l2 < 800L) {
                uptimeMillis += l2;
            }
            lastDrawTime = l;
        }
    }

    private static void drawSoftButtons() {
        int n;
        byte by;
        targetGraphics.setFont(softButtonFont);
        if (leftSoftButton != -1) {
            by = softkeys[leftSoftButton][2];
            if (by < 0) {
                n = RM.getShortFromBytes(softkeys[leftSoftButton], 0);
                Game.drawSoftkeyLabels(targetGraphics, 3, height - 1 + 2 + 0, RM.t(n), true);
            } else {
                GCanvas.drawImage(by, 3, height - 1 - 5, true, 36);
            }
        }
        if (rightSoftButton != -1) {
            by = softkeys[rightSoftButton][2];
            if (by < 0) {
                n = RM.getShortFromBytes(softkeys[rightSoftButton], 0);
                Game.drawSoftkeyLabels(targetGraphics, width - 3, height - 1 + 2 + 0, RM.t(n), false);
            } else {
                GCanvas.drawImage(by, width - 3, height - 1 - 5, true, 40);
            }
        }
    }

    public static final boolean cheatEnabled(int n) {
        return (cheatFlags & 1 << n) != 0;
    }

    public static final void dbgLog(String string) {
    }

    public static final void showTemporaryMessage(String string) {
        tmpMessage = string;
        tmpMessageTime = 30;
        GCanvas.redraw();
        Thread.yield();
    }

    public static final long getUptimeMillis() {
        return uptimeMillis;
    }

    public static final void tick() {
        if (!inputDone) {
            try {
                GCanvas.updateInput();
                Menu.onInput();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            inputDone = true;
        }
        if (inputDone) {
            GCanvas.redraw();
        }
        current = System.currentTimeMillis();
        frameTime = Math.abs(current - last);
        delay = GCanvas.clamp(50L - frameTime, 2L, 50L);
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        last = System.currentTimeMillis();
    }

    public static final void redraw() {
        if (canvas != null) {
            canvas.repaint();
            canvas.serviceRepaints();
        }
    }

    public static final void idleTick() {
        GCanvas.updateUptime(System.currentTimeMillis());
    }

    public static final void keyPressed(int n) {
        if (100 == n) {
            return;
        }
        if (107 == n) {
            return;
        }
        int n2 = GCanvas.getVKey(n);
        GL.dbgPrint(n + ":" + n2);
        if (Menu.getMode() != 0) {
            if (cheatPosition == cheatBase.length) {
                for (int i = 0; i < 9; ++i) {
                    if (n2 != RM.getValue(31, i, 0)) continue;
                    GCanvas.toggleCheat(i);
                    break;
                }
                cheatPosition = 0;
            }
            cheatPosition = cheatBase[cheatPosition] == n2 ? ++cheatPosition : 0;
        }
        if (n2 != 0) {
            keyStatesDown |= n2;
        } else {
            if (n == -6) {
                softkeyPressed |= swapSoftKeys ? 262144 : 131072;
            }
            if (n == -7) {
                softkeyPressed |= swapSoftKeys ? 131072 : 262144;
            }
        }
    }

    public static final void toggleCheat(int n) {
        int n2;
        int n3 = -1;
        int n4 = 1 << n;
        if ((cheatFlags & n4) != 0) {
            cheatFlags &= ~n4;
            n3 = 59;
        } else {
            n2 = RM.getValue(31, n, 2);
            if (n2 != 0) {
                Menu.performMenuAction(n2);
            } else {
                cheatFlags |= n4;
                n3 = 58;
            }
        }
        n2 = RM.getValue(31, n, 1);
        if (n2 != -1 && n3 != -1) {
            GCanvas.showTemporaryMessage(RM.t(n2) + " " + RM.t(n3));
            Menu.refreshMenu();
        }
    }

    public static final void keyReleased(int n) {
        if (100 == n) {
            return;
        }
        keyStatesUp |= GCanvas.getVKey(n);
    }

    public static final boolean anyKey() {
        return keyStatesDown != 0;
    }

    public static final boolean consumeAnyKey() {
        if (GCanvas.anyKey()) {
            GCanvas.resetKeys();
            return true;
        }
        return GCanvas.getSoftkeys() != 0;
    }

    public static final boolean isKeyPressed(int n) {
        return (keyStates & n) != 0;
    }

    public static final boolean isUP() {
        return (0x81 & keyStates) != 0;
    }

    public static final boolean isRIGHT() {
        return (0x802 & keyStates) != 0;
    }

    public static final boolean isDOWN() {
        return (0x2004 & keyStates) != 0;
    }

    public static final boolean isLEFT() {
        return (0x208 & keyStates) != 0;
    }

    public static final boolean isUPLEFT() {
        return (0x40 & keyStates) != 0;
    }

    public static final boolean isUPRIGHT() {
        return (0x100 & keyStates) != 0;
    }

    public static final boolean isDOWNLEFT() {
        return (0x1000 & keyStates) != 0;
    }

    public static final boolean isDOWNRIGHT() {
        return (0x4000 & keyStates) != 0;
    }

    public static final boolean isFIRE() {
        return (0x410 & keyStates) != 0;
    }

    public static final boolean consumeKey(int n) {
        if (GCanvas.isKeyPressed(n)) {
            keyStatesDown &= ~n;
            return true;
        }
        return false;
    }

    public static final boolean consumeUP() {
        if (GCanvas.isUP()) {
            keyStatesDown &= 0xFFFFFF7E;
            return true;
        }
        return false;
    }

    public static final boolean consumeDOWN() {
        if (GCanvas.isDOWN()) {
            keyStatesDown &= 0xFFFFDFFB;
            return true;
        }
        return false;
    }

    public static final boolean consumeLEFT() {
        if (GCanvas.isLEFT()) {
            keyStatesDown &= 0xFFFFFDF7;
            return true;
        }
        return false;
    }

    public static final boolean consumeRIGHT() {
        if (GCanvas.isRIGHT()) {
            keyStatesDown &= 0xFFFFF7FD;
            return true;
        }
        return false;
    }

    public static final boolean consumeFIRE() {
        if (GCanvas.isFIRE()) {
            keyStatesDown &= 0xFFFFFBEF;
            return true;
        }
        return false;
    }

    private static final int mapVKey(int n) {
        switch (n) {
            case 48: {
                return 32;
            }
            case 49: {
                return 64;
            }
            case 50: {
                return 128;
            }
            case 51: {
                return 256;
            }
            case 52: {
                return 512;
            }
            case 53: {
                return 1024;
            }
            case 54: {
                return 2048;
            }
            case 55: {
                return 4096;
            }
            case 56: {
                return 8192;
            }
            case 57: {
                return 16384;
            }
            case 42: {
                return 32768;
            }
            case 35: {
                return 65536;
            }
        }
        return 0;
    }

    private static final int getVKey(int n) {
        int n2 = GCanvas.mapVKey(n);
        if (n2 != 0) {
            return n2;
        }
        int n3 = n;
        if (n3 == -6 || n3 == -7) {
            return 0;
        }
        if (n3 == -5) {
            return 16;
        }
        int n4 = 0;
        try {
            n4 = canvas.getGameAction(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch (n4) {
            case 1: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 6: {
                return 4;
            }
            case 2: {
                return 8;
            }
            case 8: {
                return 16;
            }
        }
        return 0;
    }

    public static final void hideNotify() {
        try {
            Menu.doPause();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final void showNotify() {
    }

    public void run() {
        isRunning = true;
        lastDrawTime = last = System.currentTimeMillis();
        uptimeMillis = last;
        while (isRunning) {
            GCanvas.tick();
        }
        BEEzzz2D.instance.notifyDestroyed();
    }

    public static final void setSoftButton(int n, int n2) {
        boolean bl = swapSoftKeys;
        leftSoftButton = bl ? n2 : n;
        rightSoftButton = bl ? n : n2;
    }

    public static final void drawImage(int n, int n2, int n3, int n4) {
        GCanvas.drawImage(targetGraphics, n, n2, n3, true, n4);
    }

    public static final void drawImage(int n, int n2, int n3, boolean bl, int n4) {
        GCanvas.drawImage(targetGraphics, n, n2, n3, bl, n4);
    }

    public static final void drawImage(Graphics graphics, int n, int n2, int n3, boolean bl, int n4) {
        int n5 = RM.getType(n);
        if (n5 == 1) {
            graphics.drawImage(RM.getImage(n), n2, n3, n4);
            return;
        }
        if (n5 == 4) {
            int n6 = RM.getWidth(n);
            MIDP20Proxy.drawImage(graphics, RM.getInts(n), n2, n3, n6, RM.getHeight(n), n6, bl, n4);
            return;
        }
        if (n5 == 5) {
            return;
        }
    }

    public static final void drawSprite(int n, int n2, int n3, int n4) {
        GCanvas.drawSprite(targetGraphics, n, n2, n3, n4);
    }

    public static final void initSprites() {
        byte[] byArray = RM.getBytes(50);
        for (int i = 0; i < 30; ++i) {
            int n = i * 5;
            byte by = byArray[n + 0];
            if (by < 0) continue;
            int n2 = byArray[n + 2];
            int n3 = byArray[n + 3];
            byte by2 = byArray[n + 1];
            int n4 = RM.getWidth(by);
            int n5 = RM.getHeight(by);
            int n6 = n5 / by2;
            int n7 = 0;
            int n8 = 0;
            n7 = n2 == -2 ? n4 >> 1 : (n2 == -3 ? n4 : n2);
            n8 = n3 == -2 ? n6 >> 1 : (n3 == -5 ? n6 : n3);
            byArray[n + 4] = (byte)n6;
            byArray[n + 2] = (byte)n7;
            byArray[n + 3] = (byte)n8;
        }
    }

    public static final void drawSprite(Graphics graphics, int n, int n2, int n3, int n4) {
        boolean bl = false;
        boolean bl2 = false;
        byte[] byArray = RM.getBytes(50);
        int n5 = n * 5;
        byte by = byArray[n5 + 0];
        byte by2 = byArray[n5 + 2];
        byte by3 = byArray[n5 + 3];
        byte by4 = byArray[n5 + 4];
        int n6 = RM.getWidth(by);
        n2 -= by2;
        n3 -= by3;
        if (graphics != targetGraphics) {
            GCanvas.pushClip(graphics);
            graphics.clipRect(n2, n3, n6, (int)by4);
            GCanvas.drawImage(graphics, by, n2, n3 - n4 * by4, true, 20);
            GCanvas.popClip(graphics);
        } else {
            GCanvas.pushClip();
            if (GCanvas.clipRect(n2, n3, n6, by4)) {
                GCanvas.drawImage(by, n2, n3 - n4 * by4, 20);
            }
            GCanvas.popClip();
        }
    }

    public static final int getSpriteWidth(int n) {
        return RM.getWidth(RM.getValue(50, n, 0));
    }

    public static final int getSpriteHeight(int n) {
        return RM.getValue(50, n, 4);
    }

    public static final int getSpriteFrames(int n) {
        return RM.getValue(50, n, 1);
    }

    public static final int log2(int n) {
        n |= n >> 1;
        n |= n >> 2;
        n |= n >> 4;
        n |= n >> 8;
        n |= n >> 16;
        return GCanvas.ones(n) - 1;
    }

    public static final int mul(int n, int n2) {
        return (int)((long)n * (long)n2 >> 10);
    }

    private static final int sqrt_lookup(int n) {
        int n2 = -1;
        if (sqrtLookup == null) {
            sqrtLookup = RM.getBytes(0);
        }
        if (n >= 65536) {
            if (n >= 0x1000000) {
                int n3 = n >= 0x10000000 ? (n >= 0x40000000 ? (sqrtLookup[n >> 24] & 0xFF) << 8 : (sqrtLookup[n >> 22] & 0xFF) << 7) : (n >= 0x4000000 ? (sqrtLookup[n >> 20] & 0xFF) << 6 : (sqrtLookup[n >> 18] & 0xFF) << 5);
                n3 = n3 + 1 + n / n3 >> 1;
                n3 = n3 + 1 + n / n3 >> 1;
                n2 = n3 * n3 > n ? --n3 : n3;
            } else {
                int n4 = n >= 0x100000 ? (n >= 0x400000 ? (sqrtLookup[n >> 16] & 0xFF) << 4 : (sqrtLookup[n >> 14] & 0xFF) << 3) : (n >= 262144 ? (sqrtLookup[n >> 12] & 0xFF) << 2 : (sqrtLookup[n >> 10] & 0xFF) << 1);
                n4 = n4 + 1 + n / n4 >> 1;
                n2 = n4 * n4 > n ? --n4 : n4;
            }
        } else if (n >= 256) {
            int n5 = n >= 4096 ? (n >= 16384 ? (sqrtLookup[n >> 8] & 0xFF) + 1 : ((sqrtLookup[n >> 6] & 0xFF) >> 1) + 1) : (n >= 1024 ? ((sqrtLookup[n >> 4] & 0xFF) >> 2) + 1 : ((sqrtLookup[n >> 2] & 0xFF) >> 3) + 1);
            n2 = n5 * n5 > n ? --n5 : n5;
        } else if (n >= 0) {
            n2 = (sqrtLookup[n] & 0xFF) >> 4;
        }
        return n2 << 5;
    }

    public static final int sqrt(int n) {
        return GCanvas.sqrt_lookup(n);
    }

    public static final int sin(int n) {
        n &= 0x3FF;
        if ((n &= 0x3FF) <= 256) {
            return RM.getValue(49, n);
        }
        if (n <= 512) {
            return RM.getValue(49, 512 - n);
        }
        if (n <= 768) {
            return -RM.getValue(49, n - 512);
        }
        return -RM.getValue(49, 1024 - n);
    }

    public static final int cos(int n) {
        return GCanvas.sin(n + 256);
    }

    public static final int getRandom(int n, int n2) {
        if (n2 == n) {
            return n;
        }
        int n3 = random.nextInt();
        n3 = n3 < 0 ? -n3 : n3;
        int n4 = n2 - n;
        return n + n3 % n4;
    }

    public static final int ones(int n) {
        n -= n >>> 1 & 0x55555555;
        n = (n >>> 2 & 0x33333333) + (n & 0x33333333);
        n = (n >>> 4) + n & 0xF0F0F0F;
        n += n >>> 8;
        n += n >>> 16;
        return n & 0x3F;
    }

    public static final int clamp(int n, int n2, int n3) {
        return n < n2 ? n2 : (n > n3 ? n3 : n);
    }

    public static final long clamp(long l, long l2, long l3) {
        return l < l2 ? l2 : (l > l3 ? l3 : l);
    }

    public static final int getSecond(int n) {
        return n % 60000 / 1000;
    }

    public static final Graphics getTargetGraphics() {
        return targetGraphics;
    }

    public static final int getGlobalFrameCount() {
        return globalFrameCount;
    }

    public static final int getWidth() {
        return width;
    }

    public static final int getHeight() {
        return height;
    }

    public static final void pushClip() {
        GCanvas.pushClip(targetGraphics);
    }

    public static final void pushClip(Graphics graphics) {
        int[] nArray = clipStack[++clipStackPtr];
        RM.setRect(nArray, graphics.getClipX(), graphics.getClipY(), graphics.getClipWidth(), graphics.getClipHeight());
    }

    public static final boolean clipRect(int n, int n2, int n3, int n4) {
        return GCanvas.clipRect(targetGraphics, n, n2, n3, n4);
    }

    public static final boolean clipRect(Graphics graphics, int n, int n2, int n3, int n4) {
        int[] nArray = clipStack[clipStackPtr];
        RM.setRect(tmpClip, nArray);
        GCanvas.clipRect(tmpClip, n, n2, n3, n4);
        GCanvas.setClip(graphics, tmpClip);
        return !RM.isRectEmpty(tmpClip);
    }

    public static final boolean clipRect(Graphics graphics, int[] nArray) {
        int[] nArray2 = clipStack[clipStackPtr];
        RM.setRect(tmpClip, nArray2);
        RM.intersectRect(tmpClip, nArray);
        GCanvas.setClip(graphics, tmpClip);
        return !RM.isRectEmpty(tmpClip);
    }

    public static final void popClip() {
        GCanvas.popClip(targetGraphics);
    }

    public static final void popClip(Graphics graphics) {
        GCanvas.setClip(graphics, clipStack[clipStackPtr--]);
    }

    public static final void clipRect(int[] nArray, int n, int n2, int n3, int n4) {
        RM.setRect(tmpRect, n, n2, n3, n4);
        RM.intersectRect(nArray, tmpRect);
    }

    public static final void setClip(Graphics graphics, int[] nArray) {
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        int n4 = nArray[3];
        GCanvas.setClip(graphics, n, n2, n3 - n, n4 - n2);
    }

    public static final void setClip(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setClip(n, n2, n3, n4);
    }

    public static final int getCharWidth(char c) {
        return RM.getCharWidth(c, targetGraphics.getFont());
    }

    public static final int getStringWidth(String string) {
        return RM.getStringWidth(string, targetGraphics.getFont());
    }

    public static final int getFontHeight() {
        return targetGraphics.getFont().getHeight();
    }

    public static final void drawString(String string, int n, int n2, int n3) {
        targetGraphics.drawString(string, n, n2, n3);
    }

    static {
        backBufferEnabled = true;
        FONT_LARGE = Font.getFont((int)64, (int)1, (int)16);
        FONT_MEDIUM = Font.getFont((int)64, (int)1, (int)0);
        FONT_SMALL = Font.getFont((int)64, (int)1, (int)0);
        FONT_LARGE_HEIGHT = RM.getFontHeight(FONT_LARGE);
        FONT_MEDIUM_HEIGHT = RM.getFontHeight(FONT_MEDIUM);
        FONT_SMALL_HEIGHT = RM.getFontHeight(FONT_SMALL);
        leftSoftButton = -1;
        rightSoftButton = -1;
        softButtonFont = FONT_SMALL;
        clipStack = new int[8][4];
        clipStackPtr = -1;
        tmpClip = new int[4];
        tmpRect = new int[4];
        frameTimeCount = 16;
        cheatBase = new int[]{65536, 128, 32, 32};
        random = new Random();
        xPoints = new int[64];
        yPoints = new int[64];
    }
}

