/*
 * Decompiled with CFR 0.152.
 */
package com.tinyline.tiny2d;

import com.tinyline.tiny2d.TinyPoint;
import com.tinyline.tiny2d.TinyRect;

public final class TinyPath {
    public static final byte TYPE_MOVETO = 1;
    public static final byte TYPE_LINETO = 2;
    public static final byte TYPE_CURVETO = 3;
    public static final byte TYPE_CURVETO_CUBIC = 4;
    public static final byte TYPE_CLOSE = 5;
    int[] a;
    int[] b;
    byte[] c;
    int d;

    public TinyPath(int n) {
        this.a = new int[n];
        this.b = new int[n];
        this.c = new byte[n];
        this.d = 0;
    }

    public TinyPath(TinyPath tinyPath) {
        this.d = tinyPath.d;
        this.a = new int[this.d];
        this.b = new int[this.d];
        this.c = new byte[this.d];
        System.arraycopy(tinyPath.a, 0, this.a, 0, this.d);
        System.arraycopy(tinyPath.b, 0, this.b, 0, this.d);
        System.arraycopy(tinyPath.c, 0, this.c, 0, this.d);
    }

    public final void compact() {
        if (this.c.length - this.d > 16 && this.d != 0) {
            int n = this.d;
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            byte[] byArray = new byte[n];
            System.arraycopy(this.a, 0, nArray, 0, this.d);
            System.arraycopy(this.b, 0, nArray2, 0, this.d);
            System.arraycopy(this.c, 0, byArray, 0, this.d);
            this.a = nArray;
            this.b = nArray2;
            this.c = byArray;
        }
    }

    public final void lineTo(int n, int n2) {
        this.addPoint(n, n2, (byte)2);
    }

    public final void moveTo(int n, int n2) {
        this.addPoint(n, n2, (byte)1);
    }

    public final int numPoints() {
        return this.d;
    }

    public final void reset() {
        this.d = 0;
    }

    public final void closePath() {
        if (this.d > 0 && this.c[this.d - 1] == 5) {
            return;
        }
        this.addPoint(0, 0, (byte)5);
    }

    public final void curveTo(int n, int n2, int n3, int n4) {
        this.addPoint(n, n2, (byte)3);
        this.addPoint(n3, n4, (byte)3);
    }

    public final void curveToCubic(int n, int n2, int n3, int n4, int n5, int n6) {
        this.addPoint(n, n2, (byte)4);
        this.addPoint(n3, n4, (byte)4);
        this.addPoint(n5, n6, (byte)4);
    }

    public final TinyRect getBBox() {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        block3: for (int i = 0; i < this.d; ++i) {
            switch (this.c[i]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    if (this.a[i] < n) {
                        n = this.a[i];
                    }
                    if (this.a[i] > n2) {
                        n2 = this.a[i];
                    }
                    if (this.b[i] < n3) {
                        n3 = this.b[i];
                    }
                    if (this.b[i] <= n4) continue block3;
                    n4 = this.b[i];
                }
            }
        }
        return new TinyRect(n, n3, n2, n4);
    }

    public final void addPoint(int n, int n2, byte by) {
        if (this.d >= this.c.length - 1) {
            int n3 = this.c.length + 16;
            int[] nArray = new int[n3];
            int[] nArray2 = new int[n3];
            byte[] byArray = new byte[n3];
            System.arraycopy(this.a, 0, nArray, 0, this.d);
            System.arraycopy(this.b, 0, nArray2, 0, this.d);
            System.arraycopy(this.c, 0, byArray, 0, this.d);
            this.a = nArray;
            this.b = nArray2;
            this.c = byArray;
        }
        this.a[this.d] = n;
        this.b[this.d] = n2;
        this.c[this.d] = by;
        ++this.d;
    }

    public final TinyPoint getCurrentPoint() {
        TinyPoint tinyPoint = new TinyPoint();
        for (int i = this.d - 1; i >= 0; --i) {
            byte by = this.c[i];
            if (by != 1) continue;
            tinyPoint.x = this.a[i];
            tinyPoint.y = this.b[i];
            break;
        }
        return tinyPoint;
    }

    public final int getX(int n) {
        return this.a[n];
    }

    public final int getY(int n) {
        return this.b[n];
    }

    public final byte getType(int n) {
        return this.c[n];
    }
}

