/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Angle;
import game.ImageBank;
import game.SoccerCanvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class Entity {
    public static final int NO_DIRS = 4;
    protected SoccerCanvas canvas;
    protected double x;
    protected double y;
    protected Angle angle = new Angle(0.0);
    protected double addAngle;
    protected int width;
    protected int height;

    public Entity(SoccerCanvas canvas) {
        this.canvas = canvas;
    }

    public abstract void think();

    public abstract void paint(Graphics var1);

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Angle getAngle() {
        return this.angle;
    }

    protected void drawRotatedImage(Graphics gr, String path, int anim, int frame, int x, int y, double angle) {
        int a2 = (int)(angle * 180.0 / Math.PI);
        String p = "/" + path + "/" + anim + "." + frame + ".png";
        Image img = ImageBank.getRotatedImage(p, a2);
        gr.drawRegion(img, 0, 0, img.getWidth(), img.getHeight(), ImageBank.getRotationForRotatedImage(a2), x, y, 3);
    }
}

