/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Pannel {
    public Vector arrowList = new Vector();
    public byte levelIndex;
    public byte levelNum;
    public int height;
    public static final byte ARROW_UP = 1;
    public static final byte ARROW_DOWN = 2;
    public static final byte ARROW_LEFT = 3;
    public static final byte ARROW_RIGHT = 4;
    public static final byte ARROW_SPACE = 0;
    public int ARROW_UP_X;
    public int ARROW_DOWN_X;
    public int ARROW_LEFT_X;
    public int ARROW_RIGHT_X;
    public Levels levels = new Levels();
    private Exceptions exceptions;
    private Image imageArrowUp;
    private Image imageArrowDown;
    private Image imageArrowLeft;
    private Image imageArrowRight;
    private int screenWidth;
    private int screenHeight;
    private int centerX;
    private int centerY;
    private int clipTop;
    private int clipBottom;
    public int arrowIndexCount;
    public int spacing;
    public int speed;

    public Pannel(int screenHeight, int screenWidth) {
        this.screenHeight = screenHeight;
        this.screenWidth = screenWidth;
        this.centerX = screenWidth / 2;
        this.centerY = screenHeight / 2;
        this.clipTop = this.centerY - 80;
        this.clipBottom = this.centerY + 44;
        this.ARROW_UP_X = screenWidth / 2 + 41;
        this.ARROW_DOWN_X = screenWidth / 2 + 41;
        this.ARROW_LEFT_X = screenWidth / 2 + 25;
        this.ARROW_RIGHT_X = screenWidth / 2 + 56;
        this.levelIndex = 0;
        this.levelNum = 0;
        this.height = screenHeight - 100;
        this.arrowIndexCount = 0;
        this.spacing = 35;
        this.speed = 2;
    }

    public void initializePannel() {
        try {
            this.imageArrowUp = Image.createImage((String)"/images/arrow_up_pannel.png");
            this.imageArrowDown = Image.createImage((String)"/images/arrow_down_pannel.png");
            this.imageArrowLeft = Image.createImage((String)"/images/arrow_left_pannel.png");
            this.imageArrowRight = Image.createImage((String)"/images/arrow_right_pannel.png");
        }
        catch (Exception ex) {
            this.exceptions.ThrowExeption(ex);
        }
        for (int j = 0; j < 100; ++j) {
            this.AddArrowToList();
        }
    }

    public void AddArrowToList() {
        int x = 0;
        byte orientation = this.levels.levels[this.levelNum][this.levelIndex];
        if (orientation == 1) {
            x = this.ARROW_UP_X;
        } else if (orientation == 2) {
            x = this.ARROW_DOWN_X;
        } else if (orientation == 3) {
            x = this.ARROW_LEFT_X;
        } else if (orientation == 4) {
            x = this.ARROW_RIGHT_X;
        }
        this.arrowList.addElement(new ArrowPannel(orientation, x, this.height));
        this.levelIndex = (byte)(this.levelIndex + 1);
        this.height += this.spacing;
    }

    public void UpdateArrows() {
        int size = this.arrowList.size();
        for (int j = 0; j < size; ++j) {
            ArrowPannel temp = (ArrowPannel)this.arrowList.elementAt(j);
            temp.y -= this.speed;
            if (temp.y > this.clipTop || temp.offScreenTop) continue;
            temp.offScreenTop = true;
            ++this.arrowIndexCount;
        }
    }

    public void RenderArrows(Graphics g) {
        int size = this.arrowList.size();
        for (int j = 0; j < size; ++j) {
            ArrowPannel temp = (ArrowPannel)this.arrowList.elementAt(j);
            if (temp.scored) continue;
            Image tempImage = null;
            if (temp.orientation == 1) {
                tempImage = this.imageArrowUp;
            } else if (temp.orientation == 2) {
                tempImage = this.imageArrowDown;
            } else if (temp.orientation == 3) {
                tempImage = this.imageArrowLeft;
            } else if (temp.orientation == 4) {
                tempImage = this.imageArrowRight;
            }
            if (tempImage == null || temp.y <= this.clipTop || temp.y >= this.clipBottom) continue;
            g.drawImage(tempImage, temp.x, temp.y, 3);
        }
    }

    public void Reload() {
        this.arrowIndexCount = 0;
        this.levelIndex = 0;
        this.height = this.screenHeight - 100;
        if (this.levelNum == 8) {
            this.spacing -= 2;
        }
        if (!this.arrowList.isEmpty()) {
            this.arrowList.removeAllElements();
        }
        if (this.arrowList.isEmpty()) {
            for (int j = 0; j < 100; ++j) {
                this.AddArrowToList();
            }
        }
    }
}

