/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

public class GameMain
extends GameCanvas
implements Runnable,
CommandListener {
    private GameAlpha midlet;
    private Thread gameThread = null;
    private Image imageStage;
    private Image imageScoreUp;
    private Image imageScoreDown;
    private Image imageScoreLeft;
    private Image imageScoreRight;
    private Image imageStageUp;
    private Image imageStageRight;
    private Image imageStageDown;
    private Image imageStageLeft;
    private Image imageStageArrow;
    public Pannel pannel;
    public long firstTime = System.currentTimeMillis();
    public Player player;
    private boolean levelStart;
    private byte levelCount;
    private boolean gameRunning;
    private boolean levelGetReady;
    private long getReadyTimer;
    public static final byte ARROW_UP = 1;
    public static final byte ARROW_DOWN = 2;
    public static final byte ARROW_LEFT = 3;
    public static final byte ARROW_RIGHT = 4;
    public static final byte ARROW_SPACE = 0;
    public int ARROW_UP_COLLITION;
    public int ARROW_DOWN_COLLITION;
    public int ARROW_LEFT_COLLITION;
    public int ARROW_RIGHT_COLLITION;
    private int centerX;
    private int centerY;
    private int score;
    private int screenWidth;
    private int screenHeight;
    private boolean updateScore;
    private int arrowIndexScore;
    private boolean showImageScore;
    private Image imageScore;
    private int imageScoreX;
    private int imageScoreY;
    private Image imageNoteBlack;
    private Image imageNoteBlue;
    private Image imageNoteOrange;
    private Random generator;
    private int notesTimer;
    private int x_black;
    private int y_black;
    private int x_blue;
    private int y_blue;
    private int x_orange;
    private int y_orange;
    private boolean showImageStageArrow;
    private Image imageSpeakers;
    private boolean showSpeakers;
    private boolean showStats;
    private long showStatsTimer;
    private boolean showCountingScore;
    private int countingScore;
    private int collitionFault;
    private int prevScore;
    public MinimunScore minimunScore;

    public GameMain(GameAlpha midlet) throws Exception {
        super(true);
        this.midlet = midlet;
        this.setCommandListener(this);
        this.setFullScreenMode(true);
        this.levelStart = false;
        this.gameRunning = false;
        this.levelGetReady = false;
        this.getReadyTimer = 0L;
        this.levelCount = 0;
        this.score = 0;
        this.updateScore = false;
        this.arrowIndexScore = 0;
        this.imageScore = null;
        this.imageScoreX = 0;
        this.imageScoreY = 0;
        this.notesTimer = 10;
        this.x_black = 0;
        this.y_black = 0;
        this.x_blue = 0;
        this.y_blue = 0;
        this.x_orange = 0;
        this.y_orange = 0;
        this.showImageStageArrow = false;
        this.showSpeakers = false;
        this.showStatsTimer = 0L;
        this.showStats = false;
        this.player = null;
        this.prevScore = 0;
        this.minimunScore = new MinimunScore(midlet);
        this.pannel = null;
    }

    public void start() {
        System.gc();
        this.gameThread = new Thread(this);
        this.gameThread.start();
        this.pannel = new Pannel(this.getHeight(), this.getWidth());
        try {
            this.imageStage = Image.createImage((String)"/images/stage_temp2.png");
            this.imageScoreUp = Image.createImage((String)"/images/score_up.png");
            this.imageScoreDown = Image.createImage((String)"/images/score_down.png");
            this.imageScoreLeft = Image.createImage((String)"/images/score_left.png");
            this.imageScoreRight = Image.createImage((String)"/images/score_right.png");
            this.imageNoteBlue = Image.createImage((String)"/images/note_blue.png");
            this.imageNoteBlack = Image.createImage((String)"/images/note_black.png");
            this.imageNoteOrange = Image.createImage((String)"/images/note_orange.png");
            this.imageStageUp = Image.createImage((String)"/images/stage_up.png");
            this.imageStageRight = Image.createImage((String)"/images/stage_right.png");
            this.imageStageDown = Image.createImage((String)"/images/stage_down.png");
            this.imageStageLeft = Image.createImage((String)"/images/stage_left.png");
            this.imageSpeakers = Image.createImage((String)"/images/speakers2.png");
        }
        catch (Exception ex) {
            this.midlet.exceptions.ThrowExeption(ex);
        }
        this.levelCount = 0;
        this.levelStart = true;
        this.centerX = this.getWidth() / 2;
        this.centerY = this.getHeight() / 2;
        this.screenWidth = this.getWidth();
        this.screenHeight = this.getHeight();
        this.ARROW_UP_COLLITION = this.centerY - 67;
        this.ARROW_DOWN_COLLITION = this.centerY - 35;
        this.ARROW_LEFT_COLLITION = this.centerY - 50;
        this.ARROW_RIGHT_COLLITION = this.centerY - 51;
        this.generator = new Random();
        this.pannel.initializePannel();
        this.collitionFault = 5;
    }

    public void stop() {
        this.gameThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Graphics g = this.getGraphics();
        Thread currentThread = Thread.currentThread();
        try {
            while (currentThread == this.gameThread) {
                long startTime = System.currentTimeMillis();
                this.UpdateInput();
                this.UpdateLogic();
                this.Render(g);
                long timeTake = System.currentTimeMillis() - startTime;
                if (timeTake < 33L) {
                    GameMain gameMain = this;
                    synchronized (gameMain) {
                        this.wait(33L - timeTake);
                        continue;
                    }
                }
                currentThread.yield();
            }
            return;
        }
        catch (Exception ex) {
            this.midlet.exceptions.ThrowExeption(ex);
        }
    }

    public void commandAction(Command c, Displayable d) {
    }

    private void UpdateInput() {
        int keyStates = this.getKeyStates();
        if ((keyStates & 2) != 0) {
            this.TestCollition((byte)1);
            this.imageStageArrow = this.imageStageUp;
            this.showImageStageArrow = true;
        }
        if ((keyStates & 0x40) != 0) {
            this.TestCollition((byte)2);
            this.imageStageArrow = this.imageStageDown;
            this.showImageStageArrow = true;
        }
        if ((keyStates & 4) != 0) {
            this.TestCollition((byte)3);
            this.imageStageArrow = this.imageStageLeft;
            this.showImageStageArrow = true;
        }
        if ((keyStates & 0x20) != 0) {
            this.TestCollition((byte)4);
            this.imageStageArrow = this.imageStageRight;
            this.showImageStageArrow = true;
        }
    }

    public void UpdateLogic() {
        if (this.levelStart) {
            this.levelStart = false;
            this.levelGetReady = true;
            this.getReadyTimer = System.currentTimeMillis();
        } else if (this.levelGetReady) {
            long tempTimer = System.currentTimeMillis() - this.getReadyTimer;
            if (tempTimer >= 1500L) {
                this.PlayLevelMusic();
                this.gameRunning = true;
                this.levelGetReady = false;
            }
        } else if (this.gameRunning) {
            this.pannel.UpdateArrows();
            if (this.pannel.arrowIndexCount >= 100) {
                try {
                    this.player.stop();
                }
                catch (Exception ex) {
                    this.midlet.exceptions.ThrowExeption(ex);
                }
                this.gameRunning = false;
                this.showCountingScore = true;
            }
        } else if (this.showStats) {
            long timeTake = System.currentTimeMillis() - this.showStatsTimer;
            if (timeTake >= 2500L) {
                int minScore = this.minimunScore.GetMinimunScore();
                if (this.score < minScore) {
                    this.gameThread = null;
                    this.minimunScore.Initialize();
                    this.midlet.display.setCurrent((Displayable)this.minimunScore);
                    System.gc();
                } else if (this.score >= minScore) {
                    if (this.pannel.levelNum == 8) {
                        this.midlet.ShowGameOver();
                    } else {
                        this.prevScore = this.score;
                        if (this.pannel.spacing > 25) {
                            this.pannel.spacing -= 4;
                        }
                        if (this.pannel.speed <= 2) {
                            ++this.pannel.speed;
                        }
                        this.pannel.levelNum = (byte)(this.pannel.levelNum + 1);
                        this.pannel.Reload();
                        this.levelStart = true;
                        this.showStats = false;
                        System.gc();
                    }
                }
            }
        } else if (this.showCountingScore) {
            if (this.countingScore < this.score) {
                this.countingScore += 4;
            } else if (this.countingScore >= this.score) {
                this.showCountingScore = false;
                this.showStats = true;
                this.showStatsTimer = System.currentTimeMillis();
            }
        }
    }

    public void Render(Graphics g) {
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(0);
        g.drawImage(this.imageStage, this.centerX, this.centerY, 3);
        if (this.levelGetReady) {
            int level = this.pannel.levelNum;
            String buff = "Level: " + ++level;
            g.setColor(-1);
            g.fillRect(this.centerX - 30, this.centerY - 20, 80, 40);
            g.setColor(0);
            g.drawString(buff, this.centerX - 20, this.centerY - 20, 20);
            buff = "GET READY!";
            g.drawString(buff, this.centerX - 20, this.centerY, 20);
        } else if (this.gameRunning) {
            g.setClip(this.centerX + 20, this.centerY - 72, 42, 104);
            this.pannel.RenderArrows(g);
            if (this.showImageScore) {
                g.drawImage(this.imageScore, this.imageScoreX, this.imageScoreY, 3);
                this.showImageScore = false;
            }
            g.setClip(this.centerX - 31, this.centerY - 72, 43, 80);
            this.DrawNotes(g);
            g.setClip(0, 0, this.screenWidth, this.screenHeight);
            if (this.showImageStageArrow) {
                g.drawImage(this.imageStageArrow, this.centerX - 9, this.centerY + 45, 3);
                this.showImageStageArrow = false;
            }
            if (this.showSpeakers) {
                g.drawImage(this.imageSpeakers, this.centerX - 10, this.centerY + 18, 3);
                this.showSpeakers = false;
            }
        } else if (this.showStats) {
            String buff = "score: " + this.score;
            g.setColor(-1);
            g.fillRect(this.centerX - 30, this.centerY - 20, 80, 20);
            g.setColor(0);
            g.drawString(buff, this.centerX - 20, this.centerY - 20, 20);
        } else if (this.showCountingScore) {
            String buff = "score: " + this.countingScore;
            g.setColor(-1);
            g.fillRect(this.centerX - 30, this.centerY - 20, 80, 20);
            g.setColor(0xFF0000);
            g.drawString(buff, this.centerX - 20, this.centerY - 20, 20);
        }
        this.flushGraphics();
    }

    public void PlayLevelMusic() {
        try {
            if (this.player != null) {
                this.player.deallocate();
                this.player.close();
                this.player = null;
            }
            if (this.pannel.levelNum == 0) {
                InputStream is = this.getClass().getResourceAsStream("/midis/level1.mid");
                this.player = Manager.createPlayer((InputStream)is, (String)"audio/midi");
            } else if (this.pannel.levelNum == 1) {
                InputStream is = this.getClass().getResourceAsStream("/midis/level2.mid");
                this.player = Manager.createPlayer((InputStream)is, (String)"audio/midi");
            } else if (this.pannel.levelNum == 2) {
                InputStream is = this.getClass().getResourceAsStream("/midis/level3.mid");
                this.player = Manager.createPlayer((InputStream)is, (String)"audio/midi");
            } else if (this.pannel.levelNum == 3) {
                InputStream is = this.getClass().getResourceAsStream("/midis/level4.mid");
                this.player = Manager.createPlayer((InputStream)is, (String)"audio/midi");
            } else if (this.pannel.levelNum == 4) {
                InputStream is = this.getClass().getResourceAsStream("/midis/level5.mid");
                this.player = Manager.createPlayer((InputStream)is, (String)"audio/midi");
            } else if (this.pannel.levelNum == 5) {
                InputStream is = this.getClass().getResourceAsStream("/midis/level6.mid");
                this.player = Manager.createPlayer((InputStream)is, (String)"audio/midi");
            } else if (this.pannel.levelNum == 6) {
                InputStream is = this.getClass().getResourceAsStream("/midis/level7.mid");
                this.player = Manager.createPlayer((InputStream)is, (String)"audio/midi");
            } else if (this.pannel.levelNum == 7) {
                InputStream is = this.getClass().getResourceAsStream("/midis/level8.mid");
                this.player = Manager.createPlayer((InputStream)is, (String)"audio/midi");
            } else if (this.pannel.levelNum == 8) {
                InputStream is = this.getClass().getResourceAsStream("/midis/level9.mid");
                this.player = Manager.createPlayer((InputStream)is, (String)"audio/midi");
            }
            this.player.stop();
            this.player.setLoopCount(3);
            this.player.start();
        }
        catch (Exception ex) {
            this.midlet.exceptions.ThrowExeption(ex);
        }
    }

    public void TestCollition(byte orientation) {
        int b = this.pannel.arrowIndexCount + 2;
        int size = this.pannel.arrowList.size();
        if (b > size) {
            b = size;
        }
        for (int j = this.pannel.arrowIndexCount; j < b; ++j) {
            int dif;
            ArrowPannel temp = (ArrowPannel)this.pannel.arrowList.elementAt(j);
            if (temp.orientation != orientation) continue;
            if (orientation == 1) {
                dif = temp.y - this.ARROW_UP_COLLITION;
                if (dif > this.collitionFault || dif < -this.collitionFault || temp.scored) continue;
                this.arrowIndexScore = j;
                this.ProcessAccertion();
                this.updateScore = true;
                this.imageScore = this.imageScoreUp;
                this.imageScoreX = this.centerX + 41;
                this.imageScoreY = this.ARROW_UP_COLLITION;
                break;
            }
            if (orientation == 2) {
                dif = temp.y - this.ARROW_DOWN_COLLITION;
                if (dif > this.collitionFault || dif < -this.collitionFault || temp.scored) continue;
                this.arrowIndexScore = j;
                this.ProcessAccertion();
                this.updateScore = true;
                this.imageScore = this.imageScoreDown;
                this.imageScoreX = this.centerX + 41;
                this.imageScoreY = this.ARROW_DOWN_COLLITION;
                break;
            }
            if (orientation == 3) {
                dif = temp.y - this.ARROW_LEFT_COLLITION;
                if (dif > this.collitionFault || dif < -this.collitionFault || temp.scored) continue;
                this.arrowIndexScore = j;
                this.ProcessAccertion();
                this.updateScore = true;
                this.imageScore = this.imageScoreLeft;
                this.imageScoreX = this.centerX + 25;
                this.imageScoreY = this.ARROW_LEFT_COLLITION;
                break;
            }
            if (orientation != 4 || (dif = temp.y - this.ARROW_RIGHT_COLLITION) > this.collitionFault || dif < -this.collitionFault || temp.scored) continue;
            this.arrowIndexScore = j;
            this.ProcessAccertion();
            this.updateScore = true;
            this.imageScore = this.imageScoreRight;
            this.imageScoreX = this.centerX + 56;
            this.imageScoreY = this.ARROW_RIGHT_COLLITION;
            break;
        }
    }

    public void ProcessAccertion() {
        ArrowPannel temp = (ArrowPannel)this.pannel.arrowList.elementAt(this.arrowIndexScore);
        temp.scored = true;
        this.score += 10;
        this.showImageScore = true;
    }

    public void Delay(long time) {
        long startTime = System.currentTimeMillis();
        long timeTake = 0L;
        while (timeTake < time) {
            timeTake = System.currentTimeMillis() - startTime;
        }
    }

    public void DrawNotes(Graphics g) {
        for (int j = 0; j < 10; ++j) {
            if (this.notesTimer >= 3) {
                this.x_black = this.centerX - 11 + this.generator.nextInt() % 40;
                this.y_black = this.centerY - 32 + this.generator.nextInt() % 80;
                this.x_blue = this.centerX - 11 + this.generator.nextInt() % 40;
                this.y_blue = this.centerY - 32 + this.generator.nextInt() % 80;
                this.x_orange = this.centerX - 11 + this.generator.nextInt() % 40;
                this.y_orange = this.centerY - 32 + this.generator.nextInt() % 80;
                this.notesTimer = 0;
                this.showSpeakers = true;
                System.gc();
            }
            g.drawImage(this.imageNoteBlack, this.x_black, this.y_black, 3);
            g.drawImage(this.imageNoteBlue, this.x_blue, this.y_blue, 3);
            g.drawImage(this.imageNoteOrange, this.x_orange, this.y_orange, 3);
        }
        ++this.notesTimer;
    }

    protected void keyPressed(int keyCode) {
        if (keyCode == 50) {
            this.TestCollition((byte)1);
            this.imageStageArrow = this.imageStageUp;
            this.showImageStageArrow = true;
        } else if (keyCode == 56) {
            this.TestCollition((byte)2);
            this.imageStageArrow = this.imageStageDown;
            this.showImageStageArrow = true;
        } else if (keyCode == 52) {
            this.TestCollition((byte)3);
            this.imageStageArrow = this.imageStageLeft;
            this.showImageStageArrow = true;
        } else if (keyCode == 54) {
            this.TestCollition((byte)4);
            this.imageStageArrow = this.imageStageRight;
            this.showImageStageArrow = true;
        }
        if (keyCode == 48) {
            this.midlet.ShowGameMenu();
        }
    }

    public int GetScore() {
        return this.score;
    }

    public void ResetLevel() {
        this.score = this.prevScore;
        this.gameRunning = false;
        this.levelGetReady = false;
        this.showStats = false;
        this.showCountingScore = false;
        this.pannel.arrowIndexCount = 0;
        this.levelStart = true;
        this.pannel.Reload();
        this.gameThread = new Thread(this);
        this.gameThread.start();
        this.setFullScreenMode(true);
    }

    public void CleanUp() {
        this.gameThread = null;
        this.imageStage = null;
        this.imageScoreUp = null;
        this.imageScoreDown = null;
        this.imageScoreLeft = null;
        this.imageScoreRight = null;
        this.imageNoteBlue = null;
        this.imageNoteBlack = null;
        this.imageNoteOrange = null;
        this.imageStageUp = null;
        this.imageStageRight = null;
        this.imageStageDown = null;
        this.imageStageLeft = null;
        this.imageSpeakers = null;
        if (this.player != null) {
            try {
                this.player.deallocate();
                this.player.close();
                this.player = null;
            }
            catch (Exception ex) {
                this.midlet.exceptions.ThrowExeption(ex);
            }
        }
        if (this.pannel != null) {
            this.pannel.arrowList.removeAllElements();
            this.pannel = null;
        }
        this.levelStart = false;
        this.gameRunning = false;
        this.levelGetReady = false;
        this.getReadyTimer = 0L;
        this.levelCount = 0;
        this.score = 0;
        this.updateScore = false;
        this.arrowIndexScore = 0;
        this.imageScore = null;
        this.imageScoreX = 0;
        this.imageScoreY = 0;
        this.notesTimer = 10;
        this.x_black = 0;
        this.y_black = 0;
        this.x_blue = 0;
        this.y_blue = 0;
        this.x_orange = 0;
        this.y_orange = 0;
        this.showImageStageArrow = false;
        this.showSpeakers = false;
        this.showStatsTimer = 0L;
        this.showStats = false;
        this.player = null;
        this.prevScore = 0;
        System.gc();
    }

    public void Suspend() {
        this.gameThread = null;
        try {
            if (this.player != null) {
                this.player.stop();
            }
        }
        catch (Exception ex) {
            this.midlet.exceptions.ThrowExeption(ex);
        }
    }

    public void Resume() {
        try {
            if (this.player != null) {
                this.player.setLoopCount(3);
            }
            this.player.start();
        }
        catch (Exception ex) {
            this.midlet.exceptions.ThrowExeption(ex);
        }
        this.gameThread = new Thread(this);
        this.gameThread.start();
        this.setFullScreenMode(true);
    }
}

