/*
 * Decompiled with CFR 0.152.
 */
package joybits.syslik_winter;

public class Crypto {
    private int crc = 0;
    private static int[] crc_table = Crypto.make_crc_table();

    private static int[] make_crc_table() {
        int[] crc_table = new int[256];
        for (int n = 0; n < 256; ++n) {
            int c = n;
            int k = 8;
            while (--k >= 0) {
                if ((c & 1) != 0) {
                    c = 0xEDB88320 ^ c >>> 1;
                    continue;
                }
                c >>>= 1;
            }
            crc_table[n] = c;
        }
        return crc_table;
    }

    public long getValue() {
        return (long)this.crc & 0xFFFFFFFFL;
    }

    public void reset() {
        this.crc = 0;
    }

    public void update(int bval) {
        int c = ~this.crc;
        c = crc_table[(c ^ bval) & 0xFF] ^ c >>> 8;
        this.crc = ~c;
    }

    public void update(byte[] buf, int off, int len) {
        int c = ~this.crc;
        while (--len >= 0) {
            c = crc_table[(c ^ buf[off++]) & 0xFF] ^ c >>> 8;
        }
        this.crc = ~c;
    }

    public void update(byte[] buf) {
        this.update(buf, 0, buf.length);
    }
}

