/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;

public class Model
implements Runnable {
    private static final int KOEF_SECONDS_TO_MILISECONDS = 1000;
    private AppD appd;
    private Display display;
    private View v;
    private Displayable prevDisplayable;
    private int tRun;
    private long tStart;
    public static final int NUM_SCREENS = 3;
    public static final int STATE_SCREEN_BACK = 2;
    public static final int STATE_SCREEN_EXIT = 8;
    public static final int STATE_MESSAGE_SENT = 16;
    public static final int STATE_ERROR = 32;
    public static final int STATE_BACKGROUND = 64;
    private int state;
    private int tStopsCount;
    private int tCurrentStop;
    private boolean message_sent;
    private boolean error_sent;
    private String leftSoft;
    private String rightSoft;
    private String screenText;
    private int controlEvent;
    private boolean running;
    private String PText;
    private String Code;
    private String SNum;
    private final String L_SOFT;
    private final String R_SOFT;
    private final String NL;
    private String DSL_BORDER;
    private String DSL_BBACK;
    private String DSL_BEXIT;
    private String DSL_TBUY0;
    private String DSL_TNUM;
    private String DSL_TSEND;
    private String DSL_TER;

    public Model(AppD appD) {
        this.L_SOFT = " '1'";
        this.R_SOFT = "'3' ";
        this.NL = "\n";
        this.appd = appD;
        this.display = Display.getDisplay((MIDlet)appD);
    }

    private void readAppProp() {
        this.PText = AppD._m.getAppProperty("Payment-Text");
        this.Code = AppD._m.getAppProperty("Code");
        this.SNum = AppD._m.getAppProperty("Short-Number");
    }

    private void readIni() {
        DataInputStream dataInputStream = new DataInputStream("".getClass().getResourceAsStream("/dge.ini"));
        try {
            this.tRun = dataInputStream.readInt();
            System.out.println("tRun: " + this.tRun);
            this.tStopsCount = dataInputStream.readInt();
            System.out.println("tStop: " + this.tStopsCount);
            this.DSL_BORDER = dataInputStream.readUTF();
            this.DSL_BBACK = dataInputStream.readUTF();
            this.DSL_BEXIT = dataInputStream.readUTF();
            this.DSL_TBUY0 = dataInputStream.readUTF();
            this.DSL_TNUM = dataInputStream.readUTF();
            this.DSL_TSEND = dataInputStream.readUTF();
            this.DSL_TER = dataInputStream.readUTF();
            dataInputStream.close();
        }
        catch (Exception exception) {
            System.out.println("Error readIni: " + exception);
        }
    }

    private void check() {
        if (this.PText == null) {
            this.PText = "PAYMENT TEXT";
        }
        if (this.Code == null) {
            this.Code = "XXX";
        }
        if (this.SNum == null) {
            this.SNum = "YYY";
        }
        if (this.DSL_BORDER == null) {
            this.DSL_BORDER = "BUY";
        }
        if (this.DSL_BBACK == null) {
            this.DSL_BBACK = "BACK";
        }
        if (this.DSL_BEXIT == null) {
            this.DSL_BEXIT = "EXIT";
        }
        if (this.DSL_TBUY0 == null) {
            this.DSL_TBUY0 = "IF YOU WANT BUT THIS GAME, YOU HAVE TO SEND SMS WITH CODE";
        }
        if (this.DSL_TNUM == null) {
            this.DSL_TNUM = "TO THE NUMBER";
        }
        if (this.DSL_TSEND == null) {
            this.DSL_TSEND = "YOUR ORDER HAS SENT. SOME TIME LATER YOU'LL RECEIVE SMS WITH URL";
        }
        if (this.DSL_TER == null) {
            this.DSL_TER = "ERROR! SMS DIDN'T SEND";
        }
    }

    private void init() {
        this.message_sent = false;
        this.error_sent = false;
        this.state = 64;
        this.tCurrentStop = 0;
        this.controlEvent = -1;
        this.leftSoft = "LEFT";
        this.rightSoft = "RIGHT";
        this.screenText = "";
        this.check();
    }

    public void registerView(View view) {
        this.v = view;
    }

    public String getText() {
        return this.screenText;
    }

    public String getSoftName(boolean bl) {
        return bl ? this.leftSoft : this.rightSoft;
    }

    public boolean chT() {
        return System.currentTimeMillis() - this.tStart > (long)(this.tRun * 1000);
    }

    public void resetT() {
        this.tStart = System.currentTimeMillis();
    }

    public void start() {
        new Thread(this).start();
    }

    public void updateControlRequest(int n2) {
        this.controlEvent = n2;
    }

    public int getState() {
        return this.state;
    }

    private void showScreen() {
        try {
            this.controlEvent = -1;
            this.state = this.tCurrentStop < this.tStopsCount ? 2 : 8;
            if (this.message_sent) {
                this.state |= 0x10;
                this.leftSoft = this.tCurrentStop < this.tStopsCount ? this.DSL_BBACK + " '1'" : null;
                this.rightSoft = "'3' " + this.DSL_BEXIT;
                this.screenText = "\n" + this.DSL_TSEND + "\n" + "\n";
            } else {
                if (this.tCurrentStop < this.tStopsCount) {
                    this.leftSoft = this.DSL_BORDER + " '1'";
                    this.rightSoft = "'3' " + this.DSL_BBACK;
                } else {
                    this.leftSoft = this.DSL_BORDER + " '1'";
                    this.rightSoft = "'3' " + this.DSL_BEXIT;
                }
                this.screenText = this.DSL_TBUY0 + "\n" + this.Code + "\n" + this.DSL_TNUM + "\n" + this.SNum + "\n" + this.PText.toUpperCase();
                if (this.error_sent) {
                    this.state |= 0x20;
                    this.screenText = this.DSL_TER + "\n" + this.screenText;
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Error showScreen MODEL: " + exception);
        }
        if (this.v != null) {
            this.v.eugine_update_view();
        }
    }

    private void showPrevScreen() {
        this.resetT();
        this.state = 64;
        this.display.setCurrent(this.prevDisplayable);
    }

    private void processControlEvent() {
        if (this.controlEvent == -1) {
            return;
        }
        if (this.controlEvent == 1) {
            this.showPrevScreen();
        } else if (this.controlEvent == 2) {
            this.stop();
        } else if (this.controlEvent == 0 && !this.message_sent) {
            this.message_sent = DSender.send((String)this.SNum, (String)this.Code);
            if (!this.message_sent) {
                this.error_sent = true;
            }
            this.showScreen();
            System.out.println("message sent = " + this.message_sent);
        }
        this.controlEvent = -1;
    }

    private void update() {
        if ((this.state & 0x40) == 64) {
            if (this.chT()) {
                ++this.tCurrentStop;
                this.prevDisplayable = this.display.getCurrent();
                this.showScreen();
                this.display.setCurrent((Displayable)this.v);
            }
        } else {
            if (this.display.getCurrent() != this.v) {
                this.display.setCurrent((Displayable)this.v);
            }
            this.processControlEvent();
            if (this.v != null) {
                this.v.eugine_update_view();
            }
        }
    }

    private void stop() {
        this.running = false;
        AppD._m.notifyDestroyed();
    }

    public void run() {
        this.readAppProp();
        this.readIni();
        this.init();
        this.running = true;
        Thread.currentThread().setPriority(1);
        this.resetT();
        while (this.running) {
            this.update();
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {}
        }
    }
}

