/*
 * Decompiled with CFR 0.152.
 */
package Expressions;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class CValue {
    public static final byte TYPE_INT = 0;
    public static final byte TYPE_DOUBLE = 1;
    public static final byte TYPE_STRING = 2;
    public byte type;
    public int intValue;
    public double doubleValue;
    public String stringValue;

    public CValue() {
        this.type = 0;
        this.intValue = 0;
    }

    public CValue(CValue cValue) {
        switch (cValue.type) {
            case 0: {
                this.intValue = cValue.intValue;
                break;
            }
            case 1: {
                this.doubleValue = cValue.doubleValue;
                break;
            }
            case 2: {
                this.stringValue = new String(cValue.stringValue);
            }
        }
        this.type = cValue.type;
    }

    public CValue(int n) {
        this.type = 0;
        this.intValue = n;
    }

    public CValue(double d) {
        this.type = 1;
        this.doubleValue = d;
    }

    public CValue(String string) {
        this.type = (byte)2;
        this.stringValue = string;
    }

    public byte getType() {
        return this.type;
    }

    public int getInt() {
        switch (this.type) {
            case 0: {
                return this.intValue;
            }
            case 1: {
                return (int)this.doubleValue;
            }
        }
        return 0;
    }

    public double getDouble() {
        switch (this.type) {
            case 0: {
                return this.intValue;
            }
            case 1: {
                return this.doubleValue;
            }
        }
        return 0.0;
    }

    public String getString() {
        if (this.type == 2) {
            return this.stringValue;
        }
        return "";
    }

    public void forceInt(int n) {
        this.type = 0;
        this.intValue = n;
    }

    public void forceDouble(double d) {
        this.type = 1;
        this.doubleValue = d;
    }

    public void forceString(String string) {
        this.type = (byte)2;
        this.stringValue = new String(string);
    }

    public void forceValue(CValue cValue) {
        this.type = cValue.type;
        switch (this.type) {
            case 0: {
                this.intValue = cValue.intValue;
                break;
            }
            case 1: {
                this.doubleValue = cValue.doubleValue;
                break;
            }
            case 2: {
                this.stringValue = new String(cValue.stringValue);
            }
        }
    }

    public void setValue(CValue cValue) {
        switch (this.type) {
            case 0: {
                this.intValue = cValue.getInt();
                break;
            }
            case 1: {
                this.doubleValue = cValue.getDouble();
                break;
            }
            case 2: {
                this.stringValue = new String(cValue.stringValue);
            }
        }
    }

    public void getCompatibleTypes(CValue cValue) {
        if (this.type == 0 && cValue.type == 1) {
            this.convertToDouble();
        } else if (this.type == 1 && cValue.type == 0) {
            cValue.convertToDouble();
        }
    }

    public void convertToDouble() {
        if (this.type == 0) {
            this.doubleValue = this.intValue;
            this.type = 1;
        }
    }

    public void convertToInt() {
        if (this.type == 1) {
            this.intValue = (int)this.doubleValue;
            this.type = 0;
        }
    }

    public void add(CValue cValue) {
        if (this.type != cValue.type) {
            this.getCompatibleTypes(cValue);
        }
        switch (this.type) {
            case 0: {
                this.intValue += cValue.intValue;
                break;
            }
            case 1: {
                this.doubleValue += cValue.doubleValue;
                break;
            }
            case 2: {
                this.stringValue = new String(this.stringValue + cValue.stringValue);
            }
        }
    }

    public void sub(CValue cValue) {
        if (this.type != cValue.type) {
            this.getCompatibleTypes(cValue);
        }
        switch (this.type) {
            case 0: {
                this.intValue -= cValue.intValue;
                break;
            }
            case 1: {
                this.doubleValue -= cValue.doubleValue;
            }
        }
    }

    public void negate() {
        switch (this.type) {
            case 0: {
                this.intValue = -this.intValue;
                break;
            }
            case 1: {
                this.doubleValue = -this.doubleValue;
            }
        }
    }

    public void mul(CValue cValue) {
        if (this.type != cValue.type) {
            this.getCompatibleTypes(cValue);
        }
        switch (this.type) {
            case 0: {
                this.intValue *= cValue.intValue;
                break;
            }
            case 1: {
                this.doubleValue *= cValue.doubleValue;
            }
        }
    }

    public void div(CValue cValue) {
        if (this.type != cValue.type) {
            this.getCompatibleTypes(cValue);
        }
        switch (this.type) {
            case 0: {
                if (cValue.intValue != 0) {
                    this.intValue /= cValue.intValue;
                    break;
                }
                this.intValue = 0;
                break;
            }
            case 1: {
                if (cValue.doubleValue != 0.0) {
                    this.doubleValue /= cValue.doubleValue;
                    break;
                }
                this.doubleValue = 0.0;
            }
        }
    }

    public void pow(CValue cValue) {
        if (this.type != cValue.type) {
            this.getCompatibleTypes(cValue);
        }
        switch (this.type) {
            case 0: {
                this.doubleValue = this.getDouble() * cValue.getDouble();
                this.type = 1;
                break;
            }
            case 1: {
                this.doubleValue *= cValue.doubleValue;
            }
        }
    }

    public void mod(CValue cValue) {
        if (this.type != cValue.type) {
            this.getCompatibleTypes(cValue);
        }
        switch (this.type) {
            case 0: {
                if (cValue.intValue == 0) {
                    this.intValue = 0;
                    break;
                }
                this.intValue %= cValue.intValue;
                break;
            }
            case 1: {
                if (cValue.doubleValue == 0.0) {
                    this.doubleValue = 0.0;
                    break;
                }
                this.doubleValue %= cValue.doubleValue;
            }
        }
    }

    public void andLog(CValue cValue) {
        if (this.type != cValue.type) {
            this.getCompatibleTypes(cValue);
        }
        switch (this.type) {
            case 0: {
                this.intValue &= cValue.intValue;
                break;
            }
            case 1: {
                this.forceInt(this.getInt() & cValue.getInt());
            }
        }
    }

    public void orLog(CValue cValue) {
        if (this.type != cValue.type) {
            this.getCompatibleTypes(cValue);
        }
        switch (this.type) {
            case 0: {
                this.intValue |= cValue.intValue;
                break;
            }
            case 1: {
                this.forceInt(this.getInt() | cValue.getInt());
            }
        }
    }

    public void xorLog(CValue cValue) {
        if (this.type != cValue.type) {
            this.getCompatibleTypes(cValue);
        }
        switch (this.type) {
            case 0: {
                this.intValue ^= cValue.intValue;
                break;
            }
            case 1: {
                this.forceInt(this.getInt() ^ cValue.getInt());
            }
        }
    }

    public boolean equal(CValue cValue) {
        if (this.type != cValue.type) {
            this.getCompatibleTypes(cValue);
        }
        switch (this.type) {
            case 0: {
                return this.intValue == cValue.intValue;
            }
            case 1: {
                return this.doubleValue == cValue.doubleValue;
            }
            case 2: {
                return this.stringValue.compareTo(cValue.stringValue) == 0;
            }
        }
        return false;
    }

    public boolean greater(CValue cValue) {
        if (this.type != cValue.type) {
            this.getCompatibleTypes(cValue);
        }
        switch (this.type) {
            case 0: {
                return this.intValue >= cValue.intValue;
            }
            case 1: {
                return this.doubleValue >= cValue.doubleValue;
            }
            case 2: {
                return this.stringValue.compareTo(cValue.stringValue) >= 0;
            }
        }
        return false;
    }

    public boolean lower(CValue cValue) {
        if (this.type != cValue.type) {
            this.getCompatibleTypes(cValue);
        }
        switch (this.type) {
            case 0: {
                return this.intValue <= cValue.intValue;
            }
            case 1: {
                return this.doubleValue <= cValue.doubleValue;
            }
            case 2: {
                return this.stringValue.compareTo(cValue.stringValue) <= 0;
            }
        }
        return false;
    }

    public boolean greaterThan(CValue cValue) {
        if (this.type != cValue.type) {
            this.getCompatibleTypes(cValue);
        }
        switch (this.type) {
            case 0: {
                return this.intValue > cValue.intValue;
            }
            case 1: {
                return this.doubleValue > cValue.doubleValue;
            }
            case 2: {
                return this.stringValue.compareTo(cValue.stringValue) > 0;
            }
        }
        return false;
    }

    public boolean lowerThan(CValue cValue) {
        if (this.type != cValue.type) {
            this.getCompatibleTypes(cValue);
        }
        switch (this.type) {
            case 0: {
                return this.intValue < cValue.intValue;
            }
            case 1: {
                return this.doubleValue < cValue.doubleValue;
            }
            case 2: {
                return this.stringValue.compareTo(cValue.stringValue) < 0;
            }
        }
        return false;
    }

    public boolean notEqual(CValue cValue) {
        if (this.type != cValue.type) {
            this.getCompatibleTypes(cValue);
        }
        switch (this.type) {
            case 0: {
                return this.intValue != cValue.intValue;
            }
            case 1: {
                return this.doubleValue != cValue.doubleValue;
            }
            case 2: {
                return this.stringValue.compareTo(cValue.stringValue) != 0;
            }
        }
        return false;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.type);
        switch (this.type) {
            case 0: {
                dataOutputStream.writeInt(this.intValue);
                break;
            }
            case 1: {
                dataOutputStream.writeDouble(this.doubleValue);
                break;
            }
            case 2: {
                dataOutputStream.writeUTF(this.stringValue);
            }
        }
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.type = dataInputStream.readByte();
        switch (this.type) {
            case 0: {
                this.intValue = dataInputStream.readInt();
                break;
            }
            case 1: {
                this.doubleValue = dataInputStream.readDouble();
                break;
            }
            case 2: {
                this.stringValue = dataInputStream.readUTF();
            }
        }
    }
}

