/*
 * Decompiled with CFR 0.152.
 */
package Movements;

import Movements.CMove;
import Movements.CMoveDef;
import Movements.CMoveDefExtension;
import Movements.CRunMvtExtension;
import Objects.CObject;
import Services.CBinaryFile;
import java.io.DataInputStream;
import java.io.DataOutputStream;

public class CMoveExtension
extends CMove {
    CRunMvtExtension movement;
    public double callParam = 0.0;
    public DataInputStream inputStream = null;
    public DataOutputStream outputStream = null;

    public CMoveExtension(CRunMvtExtension cRunMvtExtension) {
        this.movement = cRunMvtExtension;
    }

    public void init(CObject cObject, CMoveDef cMoveDef) {
        this.hoPtr = cObject;
        CMoveDefExtension cMoveDefExtension = (CMoveDefExtension)cMoveDef;
        CBinaryFile cBinaryFile = new CBinaryFile(cMoveDefExtension.data);
        this.movement.initialize(cBinaryFile);
        this.hoPtr.roc.rcCheckCollides = true;
        this.hoPtr.roc.rcChanged = true;
    }

    public void kill() {
        this.movement.kill();
    }

    public void move() {
        this.hoPtr.roc.rcChanged = this.movement.move();
    }

    public void stop() {
        this.movement.stop(this.rmCollisionCount == this.hoPtr.hoAdRunHeader.rh3CollisionCount);
    }

    public void start() {
        this.movement.start();
    }

    public void bounce() {
        this.movement.bounce(this.rmCollisionCount == this.hoPtr.hoAdRunHeader.rh3CollisionCount);
    }

    public void setSpeed(int n) {
        this.movement.setSpeed(n);
    }

    public void setMaxSpeed(int n) {
        this.movement.setMaxSpeed(n);
    }

    public void reverse() {
        this.movement.reverse();
    }

    public void setXPosition(int n) {
        this.movement.setXPosition(n);
        this.hoPtr.roc.rcChanged = true;
        this.hoPtr.roc.rcCheckCollides = true;
    }

    public void setYPosition(int n) {
        this.movement.setYPosition(n);
        this.hoPtr.roc.rcChanged = true;
        this.hoPtr.roc.rcCheckCollides = true;
    }

    public void setDir(int n) {
        this.movement.setDir(n);
        this.hoPtr.roc.rcChanged = true;
        this.hoPtr.roc.rcCheckCollides = true;
    }

    public double callMovement(int n, double d) {
        this.callParam = d;
        return this.movement.actionEntry(n);
    }

    public int callSavePosition(DataOutputStream dataOutputStream) {
        this.outputStream = dataOutputStream;
        return (int)this.movement.actionEntry(4112);
    }

    public int callLoadPosition(DataInputStream dataInputStream) {
        this.inputStream = dataInputStream;
        return (int)this.movement.actionEntry(4113);
    }
}

