/*
 * Decompiled with CFR 0.152.
 */
package Objects;

import Banks.CFont;
import Banks.CImage;
import Banks.CImageBank;
import Expressions.CValue;
import OI.CDefCounter;
import OI.CDefCounters;
import OI.CObjectCommon;
import Objects.CObject;
import RunLoop.CCreateObjectInfo;
import Services.CFontInfo;
import Services.CRect;
import Services.CServices;
import Sprites.CMask;
import Sprites.CSprite;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CCounter
extends CObject {
    public short rsFlags;
    public int rsMini;
    public int rsMaxi;
    public CValue rsValue;
    public int rsBoxCx;
    public int rsBoxCy;
    public double rsMiniDouble;
    public double rsMaxiDouble;
    public short rsOldFrame;
    public byte rsHidden;
    public short rsFont;
    public int rsColor1;
    public int rsColor2;
    public int displayFlags;
    Image backSave = null;
    CRect backRect;

    public void init(CObjectCommon cObjectCommon, CCreateObjectInfo cCreateObjectInfo) {
        Object object;
        this.rsFlags = 0;
        this.rsFont = (short)-1;
        this.rsColor1 = 0;
        this.rsColor2 = 0;
        this.hoImgHeight = 1;
        this.hoImgWidth = 1;
        if (this.hoCommon.ocCounters == null) {
            this.rsBoxCx = 1;
            this.hoImgWidth = 1;
            this.rsBoxCy = 1;
            this.hoImgHeight = 1;
        } else {
            object = this.hoCommon.ocCounters;
            this.hoImgWidth = this.rsBoxCx = ((CDefCounters)object).odCx;
            this.hoImgHeight = this.rsBoxCy = ((CDefCounters)object).odCy;
            this.displayFlags = ((CDefCounters)object).odDisplayFlags;
            switch (((CDefCounters)object).odDisplayType) {
                case 5: {
                    this.rsColor1 = ((CDefCounters)object).ocColor1;
                    break;
                }
                case 2: 
                case 3: {
                    this.rsColor1 = ((CDefCounters)object).ocColor1;
                    this.rsColor2 = ((CDefCounters)object).ocColor2;
                }
            }
        }
        object = (CDefCounter)this.hoCommon.ocObject;
        this.rsMini = ((CDefCounter)object).ctMini;
        this.rsMaxi = ((CDefCounter)object).ctMaxi;
        this.rsMiniDouble = this.rsMini;
        this.rsMaxiDouble = this.rsMaxi;
        this.rsValue = new CValue(((CDefCounter)object).ctInit);
        this.rsOldFrame = (short)-1;
    }

    public void handle() {
        this.ros.handle();
        if (this.roc.rcChanged) {
            this.roc.rcChanged = false;
            this.modif();
        }
    }

    public void modif() {
        this.ros.modifRoutine();
    }

    public void display() {
        this.ros.displayRoutine();
    }

    public void kill(boolean bl) {
    }

    public void killBack() {
        this.backSave = null;
        this.backRect = null;
    }

    public void getZoneInfos() {
        this.hoImgHeight = 1;
        this.hoImgWidth = 1;
        if (this.hoCommon.ocCounters == null) {
            return;
        }
        CDefCounters cDefCounters = this.hoCommon.ocCounters;
        int n = 0;
        double d = 0.0;
        if (this.rsValue.getType() == 0) {
            n = this.rsValue.getInt();
        } else {
            d = this.rsValue.getDouble();
            n = (int)d;
        }
        String string = "";
        switch (cDefCounters.odDisplayType) {
            case 4: {
                int n2 = cDefCounters.nFrames;
                this.rsOldFrame = this.rsMaxi <= this.rsMini ? (short)0 : (short)((n - this.rsMini) * --n2 / (this.rsMaxi - this.rsMini));
                short s = cDefCounters.frames[this.rsOldFrame];
                CImage cImage = this.hoAdRunHeader.rhApp.imageBank.getImageFromHandle(s);
                short s2 = cImage.width;
                this.hoImgWidth = s2;
                this.rsBoxCx = s2;
                short s3 = cImage.height;
                this.hoImgHeight = s3;
                this.rsBoxCy = s3;
                this.hoImgXSpot = cImage.xSpot;
                this.hoImgYSpot = cImage.ySpot;
                break;
            }
            case 2: 
            case 3: {
                int n3 = this.rsBoxCx;
                if (cDefCounters.odDisplayType == 2) {
                    n3 = this.rsBoxCy;
                }
                this.rsOldFrame = this.rsMaxi <= this.rsMini ? (short)0 : (short)((n - this.rsMini) * n3 / (this.rsMaxi - this.rsMini));
                if (cDefCounters.odDisplayType == 3) {
                    this.hoImgYSpot = 0;
                    this.hoImgHeight = this.rsBoxCy;
                    this.hoImgWidth = this.rsOldFrame;
                    if ((cDefCounters.odDisplayFlags & 0x100) != 0) {
                        this.hoImgXSpot = this.rsOldFrame - this.rsBoxCx;
                        break;
                    }
                    this.hoImgXSpot = 0;
                    break;
                }
                this.hoImgXSpot = 0;
                this.hoImgWidth = this.rsBoxCx;
                this.hoImgHeight = this.rsOldFrame;
                if ((cDefCounters.odDisplayFlags & 0x100) != 0) {
                    this.hoImgYSpot = this.rsOldFrame - this.rsBoxCy;
                    break;
                }
                this.hoImgYSpot = 0;
                break;
            }
            case 1: {
                string = this.rsValue.getType() == 0 ? CServices.intToString(n, this.displayFlags) : CServices.doubleToString(d);
                int n4 = 0;
                int n5 = 0;
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    short s = 0;
                    if (c == '-') {
                        s = cDefCounters.frames[10];
                    } else if (c == '.') {
                        s = cDefCounters.frames[12];
                    } else if (c == '+') {
                        s = cDefCounters.frames[11];
                    } else if (c == 'e' || c == 'E') {
                        s = cDefCounters.frames[13];
                    } else if (c >= '0' && c <= '9') {
                        s = cDefCounters.frames[c - 48];
                    }
                    CImage cImage = this.hoAdRunHeader.rhApp.imageBank.getImageFromHandle(s);
                    n4 += cImage.width;
                    n5 = Math.max(n5, cImage.height);
                }
                this.hoImgWidth = n4;
                this.hoImgHeight = n5;
                this.hoImgXSpot = n4;
                this.hoImgYSpot = n5;
                break;
            }
            case 5: {
                string = this.rsValue.getType() == 0 ? CServices.intToString(n, this.displayFlags) : CServices.doubleToString(d);
                CRect cRect = new CRect();
                cRect.left = this.hoX - this.hoAdRunHeader.rhWindowX;
                cRect.top = this.hoY - this.hoAdRunHeader.rhWindowY;
                cRect.right = cRect.left + this.rsBoxCx;
                cRect.bottom = cRect.top + this.rsBoxCy;
                this.hoImgWidth = (short)(cRect.right - cRect.left);
                this.hoImgHeight = (short)(cRect.bottom - cRect.top);
                this.hoImgYSpot = 0;
                this.hoImgXSpot = 0;
                short s = this.rsFont;
                if (s == -1) {
                    s = cDefCounters.odFont;
                }
                CFont cFont = this.hoAdRunHeader.rhApp.fontBank.getFontFromHandle(s);
                int n6 = 0;
                short s4 = (short)(CServices.DT_RIGHT | CServices.DT_VCENTER | CServices.DT_SINGLELINE);
                int n7 = cRect.right;
                n6 = CServices.drawText(this.hoAdRunHeader.rhApp.g2EditWin, string, (short)(s4 | CServices.DT_CALCRECT), cRect, 0, cFont, 0, 0);
                cRect.right = n7;
                if (n6 == 0) break;
                short s5 = (short)(cRect.right - cRect.left);
                this.hoImgWidth = s5;
                this.hoImgXSpot = s5;
                if (this.hoImgHeight < cRect.bottom - cRect.top) {
                    this.hoImgHeight = (short)(cRect.bottom - cRect.top);
                }
                this.hoImgYSpot = this.hoImgHeight;
                break;
            }
            default: {
                this.hoImgHeight = 1;
                this.hoImgWidth = 1;
            }
        }
    }

    public void saveBack(Image image) {
        if (this.hoRect.left < this.hoRect.right && this.hoRect.top < this.hoRect.bottom) {
            int n = this.hoRect.right - this.hoRect.left + 1;
            int n2 = this.hoRect.bottom - this.hoRect.top + 1;
            if (this.backRect == null || n != this.backRect.right - this.backRect.left || n2 != this.backRect.bottom - this.backRect.top) {
                this.backSave = Image.createImage((int)n, (int)n2);
                this.backRect = new CRect();
            }
            this.backRect.left = this.hoRect.left;
            this.backRect.top = this.hoRect.top;
            this.backRect.right = this.hoRect.left + n;
            this.backRect.bottom = this.hoRect.top + n2;
            Graphics graphics = this.backSave.getGraphics();
            CServices.drawRegion(graphics, image, this.hoRect.left, this.hoRect.top, n, n2, 0, 0);
        }
    }

    public void restoreBack(Graphics graphics) {
        if (this.backRect != null) {
            graphics.drawImage(this.backSave, this.backRect.left, this.backRect.top, 20);
            this.hoAdRunHeader.rhApp.winMan.winAddCoord(this.backRect.left, this.backRect.top, this.backRect.right, this.backRect.bottom);
        }
    }

    public void draw(Graphics graphics) {
        if (this.hoCommon.ocCounters == null) {
            return;
        }
        CDefCounters cDefCounters = this.hoCommon.ocCounters;
        int n = this.ros.rsEffect;
        int n2 = this.ros.rsEffectParam;
        int n3 = 0;
        double d = 0.0;
        if (this.rsValue.getType() == 0) {
            n3 = this.rsValue.getInt();
        } else {
            d = this.rsValue.getDouble();
            n3 = (int)d;
        }
        String string = "";
        int n4 = this.rsColor1;
        int n5 = 0;
        switch (cDefCounters.odDisplayType) {
            case 4: {
                this.hoAdRunHeader.spriteGen.pasteSpriteEffect(graphics, cDefCounters.frames[this.rsOldFrame], this.hoRect.left, this.hoRect.top, 0, n, n2);
                break;
            }
            case 2: 
            case 3: {
                int n6 = this.rsBoxCx;
                if (cDefCounters.odDisplayType == 2) {
                    n6 = this.rsBoxCy;
                }
                if (cDefCounters.ocFillType == 2) {
                    n4 = this.rsColor1;
                    n5 = this.rsColor2;
                    int n7 = CServices.getRValueJava(n5) - CServices.getRValueJava(n4);
                    int n8 = n7 * this.rsOldFrame / n6 + CServices.getRValueJava(n4) & 0xFF;
                    n7 = CServices.getGValueJava(n5) - CServices.getGValueJava(n4);
                    int n9 = n7 * this.rsOldFrame / n6 + CServices.getGValueJava(n4) & 0xFF;
                    n7 = CServices.getBValueJava(n5) - CServices.getBValueJava(n4);
                    int n10 = n7 * this.rsOldFrame / n6 + CServices.getBValueJava(n4) & 0xFF;
                    n5 = CServices.RGBJava(n8, n9, n10);
                    if ((cDefCounters.odDisplayFlags & 0x100) != 0) {
                        n7 = n4;
                        n4 = n5;
                        n5 = n7;
                    }
                }
                int n11 = this.hoRect.right - this.hoRect.left;
                int n12 = this.hoRect.bottom - this.hoRect.top;
                int n13 = this.hoRect.left;
                int n14 = this.hoRect.top;
                switch (cDefCounters.ocFillType) {
                    case 1: {
                        graphics.setColor(n4);
                        graphics.fillRect(n13, n14, n11, n12);
                        break;
                    }
                    case 2: {
                        if (cDefCounters.odDisplayType == 2) {
                            CServices.drawGradient(graphics, n13, n14, n11, n12, n4, n5, true);
                            break;
                        }
                        CServices.drawGradient(graphics, n13, n14, n11, n12, n4, n5, false);
                        break;
                    }
                }
                this.hoAdRunHeader.rhApp.winMan.winAddCoord(this.hoRect.left, this.hoRect.top, this.hoRect.left + this.hoImgWidth, this.hoRect.top + this.hoImgHeight);
                break;
            }
            case 1: {
                string = this.rsValue.getType() == 0 ? CServices.intToString(n3, this.displayFlags) : CServices.doubleToString(d);
                int n15 = this.hoRect.left;
                int n16 = this.hoRect.top;
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    short s = 0;
                    if (c == '-') {
                        s = cDefCounters.frames[10];
                    } else if (c == '.') {
                        s = cDefCounters.frames[12];
                    } else if (c == '+') {
                        s = cDefCounters.frames[11];
                    } else if (c == 'e' || c == 'E') {
                        s = cDefCounters.frames[13];
                    } else if (c >= '0' && c <= '9') {
                        s = cDefCounters.frames[c - 48];
                    }
                    this.hoAdRunHeader.spriteGen.pasteSpriteEffect(graphics, s, n15, n16, 0, n, n2);
                    CImage cImage = this.hoAdRunHeader.rhApp.imageBank.getImageFromHandle(s);
                    n15 += cImage.width;
                }
                break;
            }
            case 5: {
                string = this.rsValue.getType() == 0 ? CServices.intToString(n3, this.displayFlags) : CServices.doubleToString(d);
                short s = this.rsFont;
                if (s == -1) {
                    s = cDefCounters.odFont;
                }
                CFont cFont = this.hoAdRunHeader.rhApp.fontBank.getFontFromHandle(s);
                short s2 = (short)(CServices.DT_RIGHT | CServices.DT_VCENTER | CServices.DT_SINGLELINE);
                if (this.hoRect.bottom - this.hoRect.top != 0) {
                    CServices.drawText(graphics, string, s2, this.hoRect, this.rsColor1, cFont, n, n2);
                }
                this.hoAdRunHeader.rhApp.winMan.winAddCoord(this.hoRect.left, this.hoRect.top, this.hoRect.left + this.hoImgWidth, this.hoRect.top + this.hoImgHeight);
            }
        }
    }

    public CMask getCollisionMask(int n) {
        return null;
    }

    public void cpt_ToFloat(CValue cValue) {
        if (this.rsValue.getType() == 0) {
            if (cValue.getType() == 0) {
                return;
            }
            this.rsValue.forceDouble(this.rsValue.getInt());
            this.display();
            this.roc.rcChanged = true;
        } else {
            cValue.convertToDouble();
        }
    }

    public void cpt_Change(CValue cValue) {
        if (this.rsValue.getType() == 0) {
            int n = cValue.getInt();
            if (n < this.rsMini) {
                n = this.rsMini;
            }
            if (n > this.rsMaxi) {
                n = this.rsMaxi;
            }
            if (n != this.rsValue.getInt()) {
                this.rsValue.forceInt(n);
                this.modif();
            }
        } else {
            double d = cValue.getDouble();
            if (d < this.rsMiniDouble) {
                d = this.rsMiniDouble;
            }
            if (d > this.rsMaxiDouble) {
                d = this.rsMaxiDouble;
            }
            if (d != this.rsValue.getDouble()) {
                this.rsValue.forceDouble(d);
                this.modif();
            }
        }
    }

    public void cpt_Add(CValue cValue) {
        this.cpt_ToFloat(cValue);
        CValue cValue2 = new CValue(this.rsValue);
        cValue2.add(cValue);
        this.cpt_Change(cValue2);
    }

    public void cpt_Sub(CValue cValue) {
        this.cpt_ToFloat(cValue);
        CValue cValue2 = new CValue(this.rsValue);
        cValue2.sub(cValue);
        this.cpt_Change(cValue2);
    }

    public void cpt_SetMin(CValue cValue) {
        this.rsMini = cValue.getInt();
        this.rsMiniDouble = cValue.getDouble();
        CValue cValue2 = new CValue(this.rsValue);
        this.cpt_Change(cValue2);
    }

    public void cpt_SetMax(CValue cValue) {
        this.rsMaxi = cValue.getInt();
        this.rsMaxiDouble = cValue.getDouble();
        CValue cValue2 = new CValue(this.rsValue);
        this.cpt_Change(cValue2);
    }

    public void cpt_SetColor1(int n) {
        this.rsColor1 = n;
        this.display();
        this.roc.rcChanged = true;
    }

    public void cpt_SetColor2(int n) {
        this.rsColor2 = n;
        this.display();
        this.roc.rcChanged = true;
    }

    public CValue cpt_GetValue() {
        return this.rsValue;
    }

    public CValue cpt_GetMin() {
        CValue cValue = new CValue();
        if (this.rsValue.type == 0) {
            cValue.forceInt(this.rsMini);
        } else {
            cValue.forceDouble(this.rsMiniDouble);
        }
        return cValue;
    }

    public CValue cpt_GetMax() {
        CValue cValue = new CValue();
        if (this.rsValue.type == 0) {
            cValue.forceInt(this.rsMaxi);
        } else {
            cValue.forceDouble(this.rsMaxiDouble);
        }
        return cValue;
    }

    public int cpt_GetColor1() {
        return this.rsColor1;
    }

    public int cpt_GetColor2() {
        return this.rsColor2;
    }

    public CFontInfo getFont() {
        CDefCounters cDefCounters = this.hoCommon.ocCounters;
        if (cDefCounters.odDisplayType == 5) {
            short s = this.rsFont;
            if (s == -1) {
                s = cDefCounters.odFont;
            }
            return this.hoAdRunHeader.rhApp.fontBank.getFontInfoFromHandle(s);
        }
        return null;
    }

    public void setFont(CFontInfo cFontInfo, CRect cRect) {
        CDefCounters cDefCounters = this.hoCommon.ocCounters;
        if (cDefCounters.odDisplayType == 5) {
            this.rsFont = this.hoAdRunHeader.rhApp.fontBank.addFont(cFontInfo);
            if (cRect != null) {
                this.hoImgWidth = this.rsBoxCx = cRect.right - cRect.left;
                this.hoImgHeight = this.rsBoxCy = cRect.bottom - cRect.top;
            }
            this.modif();
            this.roc.rcChanged = true;
        }
    }

    public int getFontColor() {
        return this.rsColor1;
    }

    public void setFontColor(int n) {
        this.rsColor1 = n;
        this.modif();
        this.roc.rcChanged = true;
    }

    public void spriteDraw(Graphics graphics, CSprite cSprite, CImageBank cImageBank, int n, int n2) {
        this.draw(graphics);
    }

    public void spriteSave(Graphics graphics, Image image, CSprite cSprite, int n, int n2) {
    }

    public void spriteKill(CSprite cSprite) {
    }

    public void spriteRestore(Graphics graphics, Image image, CSprite cSprite, int n, int n2) {
    }

    public CMask spriteGetMask() {
        return null;
    }
}

