/*
 * Decompiled with CFR 0.152.
 */
package Sprites;

import Application.CRunApp;
import Application.CRunFrame;
import Banks.CImage;
import Banks.CImageBank;
import Objects.CObject;
import Services.CArrayList;
import Services.CRect;
import Services.CServices;
import Sprites.CMask;
import Sprites.CPSCM;
import Sprites.CSprite;
import Sprites.IDrawable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CSpriteGen {
    public static final int AS_DEACTIVATE = 0;
    public static final int AS_REDRAW = 1;
    public static final int AS_ACTIVATE = 2;
    public static final int AS_ENABLE = 4;
    public static final int AS_DISABLE = 8;
    public static final int AS_REDRAW_RECT = 32;
    public static final int GS_BACKGROUND = 1;
    public static final int GS_SAMELAYER = 2;
    public static final short CM_BOX = 0;
    public static final short CM_BITMAP = 1;
    public static final short PSCF_CURRENTSURFACE = 1;
    public static final short PSCF_TEMPSURFACE = 2;
    public static final short LAYER_ALL = -1;
    public static final int EFFECT_NONE = 0;
    public static final int EFFECT_SEMITRANSP = 1;
    public static final int EFFECTFLAG_TRANSPARENT = 0x10000000;
    public static final int EFFECTFLAG_ANTIALIAS = 0x20000000;
    public static final int EFFECT_MASK = 65535;
    public CSprite firstSprite;
    public CSprite lastSprite;
    CRunFrame frame;
    CRunApp app;
    CImageBank bank;
    public short colMode;
    public Image spritesBack;
    Graphics g2SpritesBack;
    public static final int PSF_HOTSPOT = 1;
    public static final int PSF_NOTRANSP = 2;
    public static final int SCF_OBSTACLE = 1;
    public static final int SCF_PLATFORM = 2;
    public static final int SCF_EVENNOCOL = 4;
    public static final int SCF_BACKGROUND = 8;

    public CSpriteGen() {
    }

    public CSpriteGen(CImageBank cImageBank, CRunApp cRunApp, CRunFrame cRunFrame, Image image) {
        this.firstSprite = null;
        this.lastSprite = null;
        this.bank = cImageBank;
        this.frame = cRunFrame;
        this.app = cRunApp;
        this.spritesBack = image;
        this.g2SpritesBack = this.spritesBack.getGraphics();
    }

    public CSprite addSprite(int n, int n2, short s, short s2, int n3, int n4, int n5, CObject cObject) {
        CSprite cSprite = null;
        cSprite = this.winAllocSprite();
        cSprite.bank = this.bank;
        cSprite.sprFlags = n5 | 0x40;
        cSprite.sprFlags &= 0xFFFF8FDD;
        cSprite.sprLayer = (short)(s2 * 2);
        if ((n5 & 0x80000) == 0) {
            cSprite.sprLayer = (short)(cSprite.sprLayer + 1);
        }
        cSprite.sprZOrder = n3;
        cSprite.sprX = cSprite.sprXnew = n;
        cSprite.sprY = cSprite.sprYnew = n2;
        cSprite.sprImg = cSprite.sprImgNew = s;
        cSprite.sprExtraInfo = cObject;
        cSprite.sprEffect = 0x10000000;
        cSprite.sprEffectParam = 0;
        cSprite.sprTempScaleY = 1.0f;
        cSprite.sprScaleY = 1.0f;
        cSprite.sprTempScaleX = 1.0f;
        cSprite.sprScaleX = 1.0f;
        cSprite.sprTempAngle = 0;
        cSprite.sprAngle = 0;
        cSprite.sprTempImg = 0;
        cSprite.sprY1z = -1;
        cSprite.sprX1z = -1;
        cSprite.sprBackColor = 0;
        if ((n5 & 0x400) != 0) {
            cSprite.sprBackColor = n4;
        }
        cSprite.updateBoundingBox();
        cSprite.sprX1 = cSprite.sprX1new;
        cSprite.sprY1 = cSprite.sprY1new;
        cSprite.sprX2 = cSprite.sprX2new;
        cSprite.sprY2 = cSprite.sprY2new;
        this.sortLastSprite(cSprite);
        this.updateCollisList(cSprite);
        if ((cSprite.sprFlags & 0x80) == 0 && (cSprite.sprFlags & 8) != 0) {
            this.reafSpr(cSprite);
        }
        return cSprite;
    }

    public CSprite addOwnerDrawSprite(int n, int n2, int n3, int n4, short s, int n5, int n6, int n7, CObject cObject, IDrawable iDrawable) {
        CSprite cSprite = this.winAllocSprite();
        cSprite.sprX = cSprite.sprXnew = n;
        cSprite.sprY = cSprite.sprYnew = n2;
        cSprite.sprX1new = cSprite.sprX1 = n;
        cSprite.sprY1new = cSprite.sprY1 = n2;
        cSprite.sprX2new = cSprite.sprX2 = n3;
        cSprite.sprY2new = cSprite.sprY2 = n4;
        cSprite.sprY1z = -1;
        cSprite.sprX1z = -1;
        cSprite.sprLayer = (short)(s * 2);
        if ((n7 & 0x80000) == 0) {
            cSprite.sprLayer = (short)(cSprite.sprLayer + 1);
        }
        cSprite.sprZOrder = n5;
        cSprite.sprExtraInfo = cObject;
        cSprite.sprRout = iDrawable;
        cSprite.sprFlags = n7 | 0x40 | 0x2000;
        cSprite.sprFlags &= 0xFFFFEFDD;
        cSprite.sprEffect = 0x10000000;
        cSprite.sprEffectParam = 0;
        cSprite.sprTempScaleY = 1.0f;
        cSprite.sprScaleY = 1.0f;
        cSprite.sprTempScaleX = 1.0f;
        cSprite.sprScaleX = 1.0f;
        cSprite.sprTempAngle = 0;
        cSprite.sprAngle = 0;
        cSprite.sprTempImg = 0;
        cSprite.sprBackColor = 0;
        if ((n7 & 0x400) != 0) {
            cSprite.sprBackColor = n6;
        }
        this.sortLastSprite(cSprite);
        this.updateCollisList(cSprite);
        if ((cSprite.sprFlags & 0x80) == 0 && (cSprite.sprFlags & 8) != 0) {
            this.reafSpr(cSprite);
        }
        return cSprite;
    }

    public CSprite modifSprite(CSprite cSprite, int n, int n2, short s) {
        if (cSprite != null && (cSprite.sprXnew != n || cSprite.sprYnew != n2 || cSprite.sprImgNew != s)) {
            if (cSprite.sprImgNew != s && (cSprite.sprAngle != 0 || cSprite.sprScaleX != 1.0f || cSprite.sprScaleY != 1.0f)) {
                cSprite.sprFlags |= 2;
                cSprite.sprSf = null;
                cSprite.sprColMask = null;
            }
            cSprite.sprXnew = n;
            cSprite.sprYnew = n2;
            cSprite.sprImgNew = s;
            cSprite.updateBoundingBox();
            cSprite.sprFlags |= 0x40;
            this.updateCollisList(cSprite);
            if ((cSprite.sprFlags & 0x80) == 0 && (cSprite.sprFlags & 0x848) != 0) {
                cSprite.sprFlags |= 0x40;
                this.reafSpr(cSprite);
            }
        }
        return cSprite;
    }

    public CSprite modifSpriteEx(CSprite cSprite, int n, int n2, short s, float f, float f2, boolean bl, int n3, boolean bl2) {
        if (cSprite != null) {
            boolean bl3;
            if (f < 0.0f) {
                f = 0.0f;
            }
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            boolean bl4 = (cSprite.sprFlags & 0x100000) != 0;
            boolean bl5 = bl3 = (cSprite.sprFlags & 0x200000) != 0;
            if ((n3 %= 360) < 0) {
                n3 += 360;
            }
            boolean bl6 = false;
            if (cSprite.sprScaleX != f || cSprite.sprScaleY != f2 || bl != bl4 || cSprite.sprAngle != n3 || bl3 != bl2) {
                bl6 = true;
            }
            if (bl6 || cSprite.sprXnew != n || cSprite.sprYnew != n2 || cSprite.sprImgNew != s) {
                if (bl6 || cSprite.sprImgNew != s && (cSprite.sprAngle != 0 || cSprite.sprScaleX != 1.0f || cSprite.sprScaleY != 1.0f)) {
                    cSprite.sprFlags |= 2;
                    cSprite.sprSf = null;
                    cSprite.sprColMask = null;
                }
                cSprite.sprXnew = n;
                cSprite.sprYnew = n2;
                cSprite.sprImgNew = s;
                cSprite.sprScaleX = f;
                cSprite.sprScaleY = f2;
                cSprite.sprAngle = (short)n3;
                cSprite.sprFlags &= 0xFFCFFFFF;
                if (bl) {
                    cSprite.sprFlags |= 0x100000;
                }
                if (bl2) {
                    cSprite.sprFlags |= 0x200000;
                }
                cSprite.updateBoundingBox();
                cSprite.sprFlags |= 0x40;
                this.updateCollisList(cSprite);
                if ((cSprite.sprFlags & 0x80) == 0 && (cSprite.sprFlags & 0x848) != 0) {
                    cSprite.sprFlags |= 0x40;
                    this.reafSpr(cSprite);
                }
            }
        }
        return cSprite;
    }

    public CSprite modifSpriteEffect(CSprite cSprite, int n, int n2) {
        if (cSprite != null) {
            cSprite.sprEffect = n;
            cSprite.sprEffectParam = n2;
            cSprite.sprFlags |= 0x40;
            if ((cSprite.sprFlags & 0x880) == 0) {
                this.reafSpr(cSprite);
            }
        }
        return cSprite;
    }

    public CSprite modifOwnerDrawSprite(CSprite cSprite, int n, int n2, int n3, int n4) {
        if (cSprite != null) {
            cSprite.sprX1new = n;
            cSprite.sprY1new = n2;
            cSprite.sprX2new = n3;
            cSprite.sprY2new = n4;
            cSprite.sprFlags |= 0x40;
            this.updateCollisList(cSprite);
            if ((cSprite.sprFlags & 0x880) == 0) {
                this.reafSpr(cSprite);
            }
        }
        return cSprite;
    }

    public void setSpriteLayer(CSprite cSprite, int n) {
        if (cSprite == null) {
            return;
        }
        int n2 = n * 2;
        if ((cSprite.sprFlags & 0x80000) == 0) {
            ++n2;
        }
        if (cSprite.sprLayer != (short)n2) {
            CSprite cSprite2;
            short s = cSprite.sprLayer;
            cSprite.sprLayer = (short)n2;
            if (s < n2) {
                if (this.lastSprite != null) {
                    while (cSprite != this.lastSprite && (cSprite2 = cSprite.objNext) != null && cSprite2.sprLayer <= (short)n2) {
                        int n3 = cSprite.sprZOrder;
                        int n4 = cSprite2.sprZOrder;
                        this.swapSprites(cSprite, cSprite2);
                        cSprite.sprZOrder = n3;
                        cSprite2.sprZOrder = n4;
                    }
                }
            } else if (this.firstSprite != null) {
                while (cSprite != this.firstSprite && (cSprite2 = cSprite.objPrev) != null && cSprite2.sprLayer > (short)n2) {
                    int n5 = cSprite.sprZOrder;
                    int n6 = cSprite2.sprZOrder;
                    this.swapSprites(cSprite2, cSprite);
                    cSprite.sprZOrder = n5;
                    cSprite2.sprZOrder = n6;
                }
            }
            cSprite.sprZOrder = (cSprite2 = cSprite.objPrev) == null || cSprite2.sprLayer != cSprite.sprLayer ? 1 : cSprite2.sprZOrder + 1;
        }
        if ((cSprite.sprFlags & 0x80) == 0) {
            this.activeSprite(cSprite, 1, null);
        }
    }

    public void setSpriteScale(CSprite cSprite, float f, float f2, boolean bl) {
        if (cSprite != null) {
            boolean bl2;
            if (f < 0.0f) {
                f = 0.0f;
            }
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            boolean bl3 = bl2 = (cSprite.sprFlags & 0x100000) != 0;
            if (cSprite.sprScaleX != f || cSprite.sprScaleY != f2 || bl != bl2) {
                cSprite.sprScaleX = f;
                cSprite.sprScaleY = f2;
                cSprite.sprFlags |= 0x42;
                cSprite.sprFlags &= 0xFFEFFFFF;
                if (bl) {
                    cSprite.sprFlags |= 0x100000;
                }
                cSprite.sprSf = null;
                cSprite.sprColMask = null;
                cSprite.updateBoundingBox();
                this.updateCollisList(cSprite);
                if ((cSprite.sprFlags & 0x80) == 0) {
                    this.reafSpr(cSprite);
                }
            }
        }
    }

    public void setSpriteAngle(CSprite cSprite, int n, boolean bl) {
        if (cSprite != null) {
            boolean bl2;
            boolean bl3 = bl2 = (cSprite.sprFlags & 0x200000) != 0;
            if ((n %= 360) < 0) {
                n += 360;
            }
            if (cSprite.sprAngle != n || bl2 != bl) {
                cSprite.sprAngle = (short)n;
                cSprite.sprFlags &= 0xFFDFFFFF;
                if (bl) {
                    cSprite.sprFlags |= 0x200000;
                }
                cSprite.sprFlags |= 0x42;
                cSprite.sprSf = null;
                cSprite.sprColMask = null;
                cSprite.updateBoundingBox();
                this.updateCollisList(cSprite);
                if ((cSprite.sprFlags & 0x80) == 0) {
                    this.reafSpr(cSprite);
                }
            }
        }
    }

    public void sortLastSprite(CSprite cSprite) {
        CSprite cSprite2;
        CSprite cSprite3;
        CSprite cSprite4 = cSprite;
        short s = cSprite4.sprLayer;
        CSprite cSprite5 = cSprite4.objPrev;
        while (cSprite5 != null && s < cSprite5.sprLayer) {
            cSprite3 = cSprite5.objPrev;
            if (cSprite3 == null) {
                this.firstSprite = cSprite4;
            } else {
                cSprite3.objNext = cSprite4;
            }
            cSprite2 = cSprite4.objNext;
            if (cSprite2 == null) {
                this.lastSprite = cSprite5;
            } else {
                cSprite2.objPrev = cSprite5;
            }
            cSprite4.objPrev = cSprite5.objPrev;
            cSprite5.objPrev = cSprite4;
            cSprite5.objNext = cSprite4.objNext;
            cSprite4.objNext = cSprite5;
            cSprite5 = cSprite4;
            cSprite5 = cSprite5.objPrev;
        }
        if (cSprite5 != null && s == cSprite5.sprLayer) {
            int n = cSprite4.sprZOrder;
            while (cSprite5 != null && s == cSprite5.sprLayer && n < cSprite5.sprZOrder) {
                cSprite3 = cSprite5.objPrev;
                if (cSprite3 == null) {
                    this.firstSprite = cSprite4;
                } else {
                    cSprite3.objNext = cSprite4;
                }
                cSprite2 = cSprite4.objNext;
                if (cSprite2 == null) {
                    this.lastSprite = cSprite5;
                } else {
                    cSprite2.objPrev = cSprite5;
                }
                cSprite4.objPrev = cSprite5.objPrev;
                cSprite5.objPrev = cSprite4;
                cSprite5.objNext = cSprite4.objNext;
                cSprite4.objNext = cSprite5;
                cSprite5 = cSprite4;
                cSprite5 = cSprite5.objPrev;
            }
        }
    }

    void clearCollisList(CSprite cSprite) {
        int n = cSprite.sprCollisList.size();
        for (int i = 0; i < n; ++i) {
            CSprite cSprite2 = (CSprite)cSprite.sprCollisList.get(i);
            int n2 = cSprite2.sprCollisList.indexOf(cSprite);
            if (n2 == -1) continue;
            cSprite2.sprCollisList.remove(n2);
        }
        cSprite.sprCollisList.clear();
    }

    public void updateCollisList(CSprite cSprite) {
        CSprite cSprite2;
        int n;
        int n2;
        int n3 = Math.min(cSprite.sprX1, cSprite.sprX1new);
        int n4 = Math.min(cSprite.sprY1, cSprite.sprY1new);
        int n5 = Math.max(cSprite.sprX2, cSprite.sprX2new);
        int n6 = Math.max(cSprite.sprY2, cSprite.sprY2new);
        int n7 = n2 = cSprite.sprCollisList.size();
        for (n = 0; n < n7; ++n) {
            cSprite2 = (CSprite)cSprite.sprCollisList.get(n);
            cSprite2.sprFlags |= 0x10000000;
        }
        cSprite2 = this.firstSprite;
        while (cSprite2 != null) {
            if (cSprite2 != cSprite && (n3 < cSprite2.sprX2 && n5 > cSprite2.sprX1 && n4 < cSprite2.sprY2 && n6 > cSprite2.sprY1 || n3 < cSprite2.sprX2new && n5 > cSprite2.sprX1new && n4 < cSprite2.sprY2new && n6 > cSprite2.sprY1new)) {
                if ((cSprite2.sprFlags & 0x10000000) == 0) {
                    cSprite.sprCollisList.add(cSprite2);
                    cSprite2.sprCollisList.add(cSprite);
                } else {
                    cSprite2.sprFlags &= 0xEFFFFFFF;
                    --n2;
                }
            }
            cSprite2 = cSprite2.objNext;
        }
        if (n2 != 0) {
            n7 = cSprite.sprCollisList.size();
            for (n = 0; n < n7; ++n) {
                cSprite2 = (CSprite)cSprite.sprCollisList.get(n);
                if ((cSprite2.sprFlags & 0x10000000) == 0) continue;
                cSprite2.sprFlags &= 0xEFFFFFFF;
                cSprite.sprCollisList.remove(n);
                --n;
                --n7;
                int n8 = cSprite2.sprCollisList.indexOf(cSprite);
                if (n8 == -1) continue;
                cSprite2.sprCollisList.remove(n8);
            }
        }
    }

    public void reafSpr(CSprite cSprite) {
        int n = cSprite.sprCollisList.size();
        for (int i = 0; i < n; ++i) {
            CSprite cSprite2 = (CSprite)cSprite.sprCollisList.get(i);
            if ((cSprite2.sprFlags & 8) == 0 || (cSprite2.sprFlags & 0x18C0) != 0) continue;
            cSprite2.sprFlags |= 0x1000;
            this.reafSpr(cSprite2);
        }
    }

    public void reafRect(CRect cRect) {
        int n = Math.min(cRect.left, cRect.right);
        int n2 = Math.min(cRect.top, cRect.bottom);
        int n3 = Math.max(cRect.left, cRect.right);
        int n4 = Math.max(cRect.top, cRect.bottom);
        CSprite cSprite = this.firstSprite;
        while (cSprite != null) {
            if ((cSprite.sprFlags & 8) != 0 && (cSprite.sprFlags & 0x18C0) == 0 && (n < cSprite.sprX2 && n3 > cSprite.sprX1 && n2 < cSprite.sprY2 && n4 > cSprite.sprY1 || n < cSprite.sprX2new && n3 > cSprite.sprX1new && n2 < cSprite.sprY2new && n4 > cSprite.sprY1new)) {
                cSprite.sprFlags |= 0x1000;
                this.reafSpr(cSprite);
            }
            cSprite = cSprite.objNext;
        }
    }

    public void swapSprites(CSprite cSprite, CSprite cSprite2) {
        if (cSprite == cSprite2) {
            return;
        }
        CSprite cSprite3 = cSprite.objPrev;
        CSprite cSprite4 = cSprite.objNext;
        CSprite cSprite5 = cSprite2.objPrev;
        CSprite cSprite6 = cSprite2.objNext;
        int n = cSprite.sprZOrder;
        cSprite.sprZOrder = cSprite2.sprZOrder;
        cSprite2.sprZOrder = n;
        if (cSprite4 == cSprite2) {
            if (cSprite3 != null) {
                cSprite3.objNext = cSprite2;
            }
            cSprite2.objPrev = cSprite3;
            cSprite2.objNext = cSprite;
            cSprite.objPrev = cSprite2;
            cSprite.objNext = cSprite6;
            if (cSprite6 != null) {
                cSprite6.objPrev = cSprite;
            }
            if (cSprite3 == null) {
                this.firstSprite = cSprite2;
            }
            if (cSprite6 == null) {
                this.lastSprite = cSprite;
            }
        } else if (cSprite6 == cSprite) {
            if (cSprite5 != null) {
                cSprite5.objNext = cSprite;
            }
            cSprite.objPrev = cSprite5;
            cSprite.objNext = cSprite2;
            cSprite2.objPrev = cSprite;
            cSprite2.objNext = cSprite4;
            if (cSprite4 != null) {
                cSprite4.objPrev = cSprite2;
            }
            if (cSprite5 == null) {
                this.firstSprite = cSprite;
            }
            if (cSprite4 == null) {
                this.lastSprite = cSprite2;
            }
        } else {
            if (cSprite3 != null) {
                cSprite3.objNext = cSprite2;
            }
            if (cSprite4 != null) {
                cSprite4.objPrev = cSprite2;
            }
            cSprite.objPrev = cSprite5;
            cSprite.objNext = cSprite6;
            if (cSprite5 != null) {
                cSprite5.objNext = cSprite;
            }
            if (cSprite6 != null) {
                cSprite6.objPrev = cSprite;
            }
            cSprite2.objPrev = cSprite3;
            cSprite2.objNext = cSprite4;
            if (cSprite3 == null) {
                this.firstSprite = cSprite2;
            }
            if (cSprite5 == null) {
                this.firstSprite = cSprite;
            }
            if (cSprite4 == null) {
                this.lastSprite = cSprite2;
            }
            if (cSprite6 == null) {
                this.lastSprite = cSprite;
            }
        }
    }

    public void moveSpriteToFront(CSprite cSprite) {
        if (this.lastSprite != null) {
            CSprite cSprite2;
            short s = cSprite.sprLayer;
            while (cSprite != this.lastSprite && (cSprite2 = cSprite.objNext) != null && cSprite2.sprLayer <= s) {
                this.swapSprites(cSprite, cSprite2);
            }
            if ((cSprite.sprFlags & 0x80) == 0) {
                this.activeSprite(cSprite, 1, null);
            }
        }
    }

    public void moveSpriteToBack(CSprite cSprite) {
        if (this.lastSprite != null) {
            CSprite cSprite2;
            short s = cSprite.sprLayer;
            while (cSprite != this.firstSprite && (cSprite2 = cSprite.objPrev) != null && cSprite2.sprLayer >= s) {
                this.swapSprites(cSprite2, cSprite);
            }
            if ((cSprite.sprFlags & 0x80) == 0) {
                this.activeSprite(cSprite, 1, null);
            }
        }
    }

    public void moveSpriteBefore(CSprite cSprite, CSprite cSprite2) {
        if (cSprite.sprLayer == cSprite2.sprLayer) {
            CSprite cSprite3 = cSprite.objPrev;
            while (cSprite3 != null && cSprite3 != cSprite2) {
                cSprite3 = cSprite3.objPrev;
            }
            if (cSprite3 != null) {
                CSprite cSprite4 = cSprite;
                while ((cSprite4 = cSprite.objPrev) != null) {
                    this.swapSprites(cSprite, cSprite4);
                    if (cSprite4 != cSprite2) continue;
                }
                if ((cSprite.sprFlags & 0x80) == 0) {
                    this.activeSprite(cSprite, 1, null);
                }
            }
        }
    }

    public void moveSpriteAfter(CSprite cSprite, CSprite cSprite2) {
        if (cSprite.sprLayer == cSprite2.sprLayer) {
            CSprite cSprite3 = cSprite.objNext;
            while (cSprite3 != null && cSprite3 != cSprite2) {
                cSprite3 = cSprite3.objNext;
            }
            if (cSprite3 != null) {
                CSprite cSprite4;
                while ((cSprite4 = cSprite.objNext) != null) {
                    this.swapSprites(cSprite, cSprite4);
                    if (cSprite4 != cSprite2) continue;
                }
                if ((cSprite.sprFlags & 0x80) == 0) {
                    this.activeSprite(cSprite, 1, null);
                }
            }
        }
    }

    public boolean isSpriteBefore(CSprite cSprite, CSprite cSprite2) {
        if (cSprite.sprLayer < cSprite2.sprLayer) {
            return true;
        }
        if (cSprite.sprLayer > cSprite2.sprLayer) {
            return false;
        }
        return cSprite.sprZOrder < cSprite2.sprZOrder;
    }

    public boolean isSpriteAfter(CSprite cSprite, CSprite cSprite2) {
        if (cSprite.sprLayer > cSprite2.sprLayer) {
            return true;
        }
        if (cSprite.sprLayer < cSprite2.sprLayer) {
            return false;
        }
        return cSprite.sprZOrder > cSprite2.sprZOrder;
    }

    public CSprite getFirstSprite(int n, int n2) {
        CSprite cSprite = null;
        cSprite = this.firstSprite;
        int n3 = n;
        if (n != -1) {
            n3 *= 2;
            if ((n2 & 1) == 0) {
                ++n3;
            }
        }
        while (cSprite != null && n3 != -1 && cSprite.sprLayer != n3) {
            if (cSprite.sprLayer > n3) {
                cSprite = null;
                break;
            }
            cSprite = cSprite.objNext;
        }
        return cSprite;
    }

    public CSprite getNextSprite(CSprite cSprite, int n) {
        block6: {
            if (cSprite == null) break block6;
            short s = cSprite.sprLayer;
            if ((n & 1) != 0) {
                while ((cSprite = cSprite.objNext) != null) {
                    if ((cSprite.sprFlags & 0x80000) == 0) {
                        if ((n & 2) == 0) continue;
                        cSprite = null;
                        break;
                    }
                    if ((n & 2) == 0 || cSprite.sprLayer == s) break;
                    cSprite = null;
                    break;
                }
            } else {
                while ((cSprite = cSprite.objNext) != null) {
                    if ((cSprite.sprFlags & 0x80000) != 0) {
                        if ((n & 2) == 0) continue;
                        cSprite = null;
                        break;
                    }
                    if ((n & 2) == 0 || cSprite.sprLayer == s) break;
                    cSprite = null;
                    break;
                }
            }
        }
        return cSprite;
    }

    public CSprite getPrevSprite(CSprite cSprite, int n) {
        block6: {
            if (cSprite == null) break block6;
            short s = cSprite.sprLayer;
            if ((n & 1) != 0) {
                while ((cSprite = cSprite.objPrev) != null) {
                    if ((cSprite.sprFlags & 0x80000) == 0) {
                        if ((n & 2) == 0) continue;
                        cSprite = null;
                        break;
                    }
                    if ((n & 2) == 0 || cSprite.sprLayer == s) break;
                    cSprite = null;
                    break;
                }
            } else {
                while ((cSprite = cSprite.objPrev) != null) {
                    if ((cSprite.sprFlags & 0x80000) != 0) {
                        if ((n & 2) == 0) continue;
                        cSprite = null;
                        break;
                    }
                    if ((n & 2) == 0 || cSprite.sprLayer == s) break;
                    cSprite = null;
                    break;
                }
            }
        }
        return cSprite;
    }

    public void showSprite(CSprite cSprite, boolean bl) {
        if (cSprite != null) {
            if (bl) {
                cSprite.sprFlags &= 0xFFFFFF6F;
                if ((cSprite.sprFlags & 8) != 0) {
                    cSprite.sprFlags |= 0x40;
                    this.reafSpr(cSprite);
                }
            } else if ((cSprite.sprFlags & 0x80) == 0) {
                if (cSprite.sprX1z == -1 && cSprite.sprY1z == -1) {
                    cSprite.sprFlags |= 0x80;
                } else {
                    cSprite.sprFlags |= 0x10;
                    if ((cSprite.sprFlags & 8) != 0) {
                        cSprite.sprFlags |= 0x40;
                        this.reafSpr(cSprite);
                    }
                }
            }
        }
    }

    public void activeSprite(CSprite cSprite, int n, CRect cRect) {
        if (cSprite != null) {
            switch (n) {
                case 0: {
                    cSprite.sprFlags |= 8;
                }
                case 1: {
                    cSprite.sprFlags |= 0x40;
                    this.reafSpr(cSprite);
                    break;
                }
                case 2: {
                    cSprite.sprFlags &= 0xFFFFFFF7;
                    break;
                }
                case 4: {
                    cSprite.sprFlags &= 0xFFFFF7FF;
                    break;
                }
                case 8: {
                    cSprite.sprFlags |= 0x800;
                }
            }
        } else {
            if (n == 32) {
                this.reafRect(cRect);
                return;
            }
            cSprite = this.firstSprite;
            while (cSprite != null) {
                switch (n) {
                    case 0: {
                        cSprite.sprFlags |= 8;
                    }
                    case 1: {
                        if ((cSprite.sprFlags & 0x80) != 0) break;
                        cSprite.sprFlags |= 0x40;
                        break;
                    }
                    case 17: {
                        if ((cSprite.sprFlags & 0x80080) != 0) break;
                        cSprite.sprFlags |= 0x40;
                        break;
                    }
                    case 2: {
                        cSprite.sprFlags &= 0xFFFFFFF7;
                        break;
                    }
                    case 4: {
                        cSprite.sprFlags &= 0xFFFFF7FF;
                        break;
                    }
                    case 8: {
                        cSprite.sprFlags |= 0x800;
                        break;
                    }
                    default: {
                        cSprite.sprFlags &= 0xFFFFFFF7;
                    }
                }
                cSprite = cSprite.objNext;
            }
        }
    }

    public void sprite_Intersect(int n, int n2) {
        CSprite cSprite = this.firstSprite;
        while (cSprite != null) {
            if ((cSprite.sprFlags & 8) != 0 && (cSprite.sprFlags & 0x18C0) == 0) {
                int n3 = Math.min(cSprite.sprX1, cSprite.sprX1new);
                int n4 = Math.min(cSprite.sprY1, cSprite.sprY1new);
                int n5 = Math.max(cSprite.sprX2, cSprite.sprX2new);
                int n6 = Math.max(cSprite.sprY2, cSprite.sprY2new);
                if (n5 > 0 && n6 > 0 && n3 < n && n4 < n2) {
                    int n7 = cSprite.sprCollisList.size();
                    for (int i = 0; i < n7; ++i) {
                        CSprite cSprite2 = (CSprite)cSprite.sprCollisList.get(i);
                        if ((cSprite2.sprFlags & 0x88) != 0 || (n3 >= cSprite2.sprX2 || n5 <= cSprite2.sprX1 || n4 >= cSprite2.sprY2 || n6 <= cSprite2.sprY1) && (n3 >= cSprite2.sprX2new || n5 <= cSprite2.sprX1new || n4 >= cSprite2.sprY2new || n6 <= cSprite2.sprY1new)) continue;
                        cSprite.sprFlags |= 0x1000;
                        this.reafSpr(cSprite);
                        break;
                    }
                }
            }
            cSprite = cSprite.objNext;
        }
    }

    public void killSprite(CSprite cSprite) {
        CSprite cSprite2 = cSprite;
        cSprite2.killSpriteZone();
        if ((cSprite2.sprFlags & 0x2000) != 0) {
            cSprite2.sprRout.spriteKill(cSprite2);
        }
        this.clearCollisList(cSprite2);
        cSprite2.sprCollisList = null;
        cSprite2.sprSf = null;
        cSprite2.sprTempSf = null;
        cSprite2.sprColMask = null;
        cSprite2.sprTempColMask = null;
        this.winFreeSprite(cSprite2);
    }

    public void delSprite(CSprite cSprite) {
        if (cSprite != null) {
            CSprite cSprite2 = cSprite;
            cSprite2.sprFlags &= 0xFFFFFFFE;
            cSprite2.sprFlags |= 0x60;
            if ((cSprite2.sprFlags & 0x80) == 0 && (cSprite2.sprFlags & 8) != 0) {
                cSprite2.sprFlags &= 0xFFFFFFF7;
                this.reafSpr(cSprite2);
            }
        }
    }

    public void delSpriteFast(CSprite cSprite) {
        this.killSprite(cSprite);
    }

    public void recalcSpriteSurface(CSprite cSprite) {
        cSprite.sprColMask = null;
        if (cSprite.sprAngle == 0 && cSprite.sprScaleX == 1.0f && cSprite.sprScaleY == 1.0f) {
            cSprite.sprSf = null;
        } else {
            Image image;
            if (cSprite.sprTempSf != null && cSprite.sprImgNew == cSprite.sprTempImg && cSprite.sprAngle == cSprite.sprTempAngle && cSprite.sprScaleX == cSprite.sprTempScaleX && cSprite.sprScaleY == cSprite.sprTempScaleY) {
                cSprite.sprSf = cSprite.sprTempSf;
                cSprite.sprTempSf = null;
                cSprite.sprColMask = cSprite.sprTempColMask;
                cSprite.sprTempColMask = null;
                return;
            }
            CImage cImage = this.bank.getImageFromHandle(cSprite.sprImgNew);
            if (cImage == null) {
                cSprite.sprSf = null;
                return;
            }
            int n = cSprite.sprX2new - cSprite.sprX1new;
            int n2 = cSprite.sprY2new - cSprite.sprY1new;
            if (n <= 0) {
                n = 1;
            }
            if (n2 <= 0) {
                n2 = 1;
            }
            cSprite.sprSf = image = Image.createImage((Image)cImage.img, (int)0, (int)0, (int)cImage.img.getWidth(), (int)cImage.img.getHeight(), (int)0);
        }
    }

    public void recalcTempSpriteSurface(CSprite cSprite, int n, int n2) {
        if (cSprite.sprTempAngle != 0 || cSprite.sprTempScaleX != 1.0f || cSprite.sprTempScaleY != 1.0f) {
            Image image;
            CImage cImage = this.bank.getImageFromHandle(cSprite.sprTempImg);
            if (cImage == null) {
                cSprite.sprTempSf = null;
                return;
            }
            int n3 = n;
            int n4 = n2;
            if (n3 <= 0) {
                n3 = 1;
            }
            if (n4 <= 0) {
                n4 = 1;
            }
            cSprite.sprTempSf = image = Image.createImage((Image)cImage.img, (int)0, (int)0, (int)cImage.img.getWidth(), (int)cImage.img.getHeight(), (int)0);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CMask getSpriteMask(CSprite cSprite, short s, int n) {
        if (cSprite == null) return null;
        if ((cSprite.sprFlags & 0x2000) != 0) return cSprite.sprRout.spriteGetMask();
        short s2 = s;
        if (s2 == -1) {
            s2 = cSprite.sprImg;
        }
        if (s2 == -1) return null;
        if (cSprite.sprAngle != 0 || cSprite.sprScaleX != 1.0f || cSprite.sprScaleY != 1.0f) {
            if ((cSprite.sprFlags & 2) != 0) {
                cSprite.sprFlags &= 0xFFFFFFFD;
                this.recalcSpriteSurface(cSprite);
            }
            if (cSprite.sprSf == null) return null;
            if (cSprite.sprColMask != null) return cSprite.sprColMask;
            cSprite.sprColMask = new CMask();
            cSprite.sprColMask.createMask(cSprite.sprSf, n);
            return cSprite.sprColMask;
        }
        CImage cImage = this.bank.getImageFromHandle(s2);
        return cImage.getMask(n);
    }

    public void spriteUpdate() {
        CSprite cSprite = this.firstSprite;
        while (cSprite != null) {
            if ((cSprite.sprFlags & 0x40) != 0) {
                cSprite.sprX = cSprite.sprXnew;
                cSprite.sprY = cSprite.sprYnew;
                cSprite.sprX1 = cSprite.sprX1new;
                cSprite.sprY1 = cSprite.sprY1new;
                cSprite.sprX2 = cSprite.sprX2new;
                cSprite.sprY2 = cSprite.sprY2new;
                if ((cSprite.sprFlags & 0x2000) == 0) {
                    cSprite.sprImg = cSprite.sprImgNew;
                }
            }
            if ((cSprite.sprFlags & 2) != 0) {
                cSprite.sprFlags &= 0xFFFFFFFD;
                this.recalcSpriteSurface(cSprite);
            }
            cSprite = cSprite.objNext;
        }
    }

    public void spriteClear(Graphics graphics) {
        CSprite cSprite = this.firstSprite;
        this.sprite_Intersect(this.frame.leEditWinWidth, this.frame.leEditWinHeight);
        while (cSprite != null) {
            if ((cSprite.sprFlags & 0x1048) != 8 && (cSprite.sprFlags & 0x800) == 0 && cSprite.sprX1z != -1 && cSprite.sprY1z != -1) {
                if ((cSprite.sprFlags & 0x400) != 0) {
                    graphics.setColor(cSprite.sprBackColor);
                    graphics.fillRect(cSprite.sprX1, cSprite.sprY1, cSprite.sprX2 - cSprite.sprX1, cSprite.sprY2 - cSprite.sprY1);
                    this.app.winMan.winAddCoord(cSprite.sprX1, cSprite.sprY1, cSprite.sprX2, cSprite.sprY2);
                } else if ((cSprite.sprFlags & 0x4000) != 0) {
                    if (cSprite.sprRout != null) {
                        cSprite.sprRout.spriteRestore(graphics, this.spritesBack, cSprite, cSprite.sprX1, cSprite.sprY1);
                    }
                } else {
                    int n = cSprite.sprX2z - cSprite.sprX1z;
                    int n2 = cSprite.sprY2z - cSprite.sprY1z;
                    if (n > 0 && n2 > 0) {
                        CServices.drawRegion(graphics, this.spritesBack, cSprite.sprX1z, cSprite.sprY1z, n, n2, cSprite.sprX1z, cSprite.sprY1z);
                    }
                    if ((cSprite.sprFlags & 0x48) != 8) {
                        this.app.winMan.winAddCoord(cSprite.sprX1, cSprite.sprY1, cSprite.sprX2, cSprite.sprY2);
                    }
                }
            }
            if ((cSprite.sprFlags & 0x10) != 0) {
                cSprite.killSpriteZone();
                cSprite.sprFlags &= 0xFFFFFFEF;
                cSprite.sprFlags |= 0x80;
                cSprite.sprY1z = -1;
                cSprite.sprX1z = -1;
            }
            if ((cSprite.sprFlags & 0x20) != 0) {
                CSprite cSprite2 = cSprite.objNext;
                this.killSprite(cSprite);
                cSprite = cSprite2;
                continue;
            }
            cSprite = cSprite.objNext;
        }
    }

    public void winBackSave(Image image) {
        CSprite cSprite = this.firstSprite;
        if (cSprite == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = this.frame.leEditWinWidth;
        int n4 = this.frame.leEditWinHeight;
        int n5 = n + n3;
        int n6 = n2 + n4;
        CSprite cSprite2 = this.firstSprite;
        while (cSprite2 != null) {
            if ((cSprite2.sprFlags & 0x880) == 0 && (cSprite2.sprFlags & 0x1048) != 8 && ((cSprite2.sprFlags & 0x400) != 0 || (cSprite2.sprFlags & 0x200) == 0)) {
                if (cSprite2.sprX1 >= n5 || cSprite2.sprX2 <= n || cSprite2.sprY1 >= n6 || cSprite2.sprY2 <= n2) {
                    cSprite2.sprY1z = -1;
                    cSprite2.sprX1z = -1;
                } else {
                    if ((cSprite2.sprEffect & 0x20000000) != 0) {
                        cSprite2.sprX1z = Math.max(cSprite2.sprX1 - 1, n);
                        cSprite2.sprY1z = Math.max(cSprite2.sprY1 - 1, n2);
                        cSprite2.sprX2z = Math.min(cSprite2.sprX2 + 1, n5);
                        cSprite2.sprY2z = Math.min(cSprite2.sprY2 + 1, n6);
                    } else {
                        cSprite2.sprX1z = Math.max(cSprite2.sprX1, n);
                        cSprite2.sprY1z = Math.max(cSprite2.sprY1, n2);
                        cSprite2.sprX2z = Math.min(cSprite2.sprX2, n5);
                        cSprite2.sprY2z = Math.min(cSprite2.sprY2, n6);
                    }
                    if ((cSprite2.sprFlags & 0x400) == 0) {
                        if ((cSprite2.sprFlags & 0x4000) != 0 && cSprite2.sprRout != null) {
                            cSprite2.sprRout.spriteSave(this.g2SpritesBack, image, cSprite2, cSprite2.sprX1z, cSprite2.sprY1z);
                        }
                        int n7 = cSprite2.sprX2z - cSprite2.sprX1z;
                        int n8 = cSprite2.sprY2z - cSprite2.sprY1z;
                        if (n7 > 0 && n8 > 0) {
                            CServices.drawRegion(this.g2SpritesBack, image, cSprite2.sprX1z, cSprite2.sprY1z, n7, n8, cSprite2.sprX1z, cSprite2.sprY1z);
                        }
                    }
                }
            }
            cSprite2 = cSprite2.objNext;
        }
    }

    public void pasteSpriteEffect(Graphics graphics, short s, int n, int n2, int n3, int n4, int n5) {
        CImage cImage = this.bank.getImageFromHandle(s);
        if (cImage != null) {
            int n6 = n;
            if ((n3 & 1) != 0) {
                n6 -= cImage.xSpot;
            }
            int n7 = n2;
            if ((n3 & 1) != 0) {
                n7 -= cImage.ySpot;
            }
            graphics.drawImage(cImage.img, n6, n7, 20);
            this.app.winMan.winAddCoord(n6, n7, n6 + cImage.width, n7 + cImage.height);
        }
    }

    public CPSCM prepareSpriteColMask(CSprite cSprite, short s, int n, int n2, short s2, float f, float f2, CRect cRect) {
        cRect.left = cRect.right = n;
        cRect.top = cRect.bottom = n2;
        CPSCM cPSCM = new CPSCM();
        short s3 = cSprite.sprImgNew;
        if ((cSprite.sprFlags & 2) == 0) {
            s3 = cSprite.sprImg;
        }
        if (cSprite.sprSf != null && s == s3 && s2 == cSprite.sprAngle && f == cSprite.sprScaleX && f2 == cSprite.sprScaleY) {
            if ((cSprite.sprFlags & 2) != 0) {
                cSprite.sprColMask = null;
            }
            cPSCM.mask = cSprite.sprColMask;
            if ((cSprite.sprFlags & 2) != 0) {
                cRect.left -= cSprite.sprXnew - cSprite.sprX1new;
                cRect.top -= cSprite.sprYnew - cSprite.sprY1new;
                cRect.right = cRect.left + (cSprite.sprX2new - cSprite.sprX1new);
                cRect.bottom = cRect.top + (cSprite.sprY2new - cSprite.sprY1new);
            } else {
                cRect.left -= cSprite.sprX - cSprite.sprX1;
                cRect.top -= cSprite.sprY - cSprite.sprY1;
                cRect.right = cRect.left + (cSprite.sprX2 - cSprite.sprX1);
                cRect.bottom = cRect.top + (cSprite.sprY2 - cSprite.sprY1);
            }
            cPSCM.flags |= 1;
        } else {
            if (s == cSprite.sprTempImg && s2 == cSprite.sprTempAngle && f == cSprite.sprTempScaleX && f2 == cSprite.sprTempScaleY) {
                cPSCM.mask = cSprite.sprTempColMask;
            } else {
                cSprite.sprTempImg = s;
                cSprite.sprTempAngle = s2;
                cSprite.sprTempScaleX = f;
                cSprite.sprTempScaleY = f2;
                cSprite.sprTempSf = null;
                cSprite.sprTempColMask = null;
            }
            cSprite.calcBoundingBox(s, n, n2, s2, f, f2, cRect);
            cPSCM.flags |= 2;
        }
        return cPSCM;
    }

    public CMask completeSpriteColMask(CSprite cSprite, int n, int n2, int n3) {
        CMask cMask = null;
        if ((n & 1) != 0) {
            if ((cSprite.sprFlags & 2) != 0) {
                cSprite.sprFlags &= 0xFFFFFFFD;
                this.recalcSpriteSurface(cSprite);
            }
            cMask = new CMask();
            cMask.createMask(cSprite.sprSf, 0);
            cSprite.sprColMask = cMask;
        } else if ((n & 2) != 0) {
            if (cSprite.sprTempSf == null) {
                this.recalcTempSpriteSurface(cSprite, n2, n3);
            }
            if (cSprite.sprTempSf != null) {
                cMask = new CMask();
                cMask.createMask(cSprite.sprTempSf, 0);
                cSprite.sprTempColMask = cMask;
            }
        }
        return cMask;
    }

    public void winDrawSprites(Graphics graphics) {
        CSprite cSprite = this.firstSprite;
        if (cSprite == null) {
            return;
        }
        CSprite cSprite2 = cSprite;
        while (cSprite2 != null) {
            if ((cSprite2.sprFlags & 0x880) == 0 && (cSprite2.sprFlags & 0x1048) != 8 && ((cSprite2.sprFlags & 0x200) != 0 || cSprite2.sprX1z != -1 || cSprite2.sprY1z != -1)) {
                if ((cSprite2.sprFlags & 0x2000) != 0) {
                    if (cSprite2.sprRout != null) {
                        cSprite2.sprRout.spriteDraw(graphics, cSprite2, this.bank, cSprite2.sprX1, cSprite2.sprY1);
                    }
                } else {
                    cSprite2.draw(graphics);
                    if ((cSprite2.sprFlags & 0x48) != 8) {
                        this.app.winMan.winAddCoord(cSprite2.sprX1, cSprite2.sprY1, cSprite2.sprX2 + 1, cSprite2.sprY2 + 1);
                    }
                }
                cSprite2.sprFlags &= 0xFFFFEFBF;
            }
            cSprite2 = cSprite2.objNext;
        }
    }

    public void spriteDraw(Graphics graphics, Image image) {
        this.winBackSave(image);
        this.winDrawSprites(graphics);
    }

    public CSprite getLastSprite(int n, int n2) {
        CSprite cSprite = this.lastSprite;
        int n3 = n;
        if (n != -1) {
            n3 *= 2;
            if ((n2 & 1) == 0) {
                ++n3;
            }
        }
        while (cSprite != null && n3 != -1 && cSprite.sprLayer != n3) {
            if (cSprite.sprLayer < n3) {
                cSprite = null;
                break;
            }
            cSprite = cSprite.objPrev;
        }
        return cSprite;
    }

    public CSprite winAllocSprite() {
        CSprite cSprite = new CSprite(this.bank);
        if (this.firstSprite == null) {
            this.firstSprite = cSprite;
            this.lastSprite = cSprite;
            cSprite.objPrev = null;
            cSprite.objNext = null;
            return cSprite;
        }
        CSprite cSprite2 = this.lastSprite;
        cSprite2.objNext = cSprite;
        cSprite.objPrev = cSprite2;
        cSprite.objNext = null;
        this.lastSprite = cSprite;
        return cSprite;
    }

    public void winFreeSprite(CSprite cSprite) {
        if (cSprite.objPrev == null) {
            this.firstSprite = cSprite.objNext;
        } else {
            cSprite.objPrev.objNext = cSprite.objNext;
        }
        if (cSprite.objNext != null) {
            cSprite.objNext.objPrev = cSprite.objPrev;
        } else {
            this.lastSprite = cSprite.objPrev;
        }
    }

    public void winSetColMode(short s) {
        this.colMode = s;
    }

    public CSprite spriteCol_TestPoint(CSprite cSprite, short s, int n, int n2, int n3) {
        int n4;
        boolean bl;
        CSprite cSprite2 = cSprite;
        cSprite2 = cSprite2 == null ? this.firstSprite : cSprite2.objNext;
        boolean bl2 = s == -1;
        boolean bl3 = bl = (n3 & 4) != 0;
        if ((n3 & 8) != 0) {
            n4 = 0;
            if (s != -1) {
                s = (short)(s * 2);
            }
        } else {
            n4 = 1;
            if (s != -1) {
                s = (short)(s * 2 + 1);
            }
        }
        while (cSprite2 != null) {
            block14: {
                int n5;
                int n6;
                block16: {
                    block15: {
                        block13: {
                            if (bl2) break block13;
                            if (cSprite2.sprLayer < s) break block14;
                            if (cSprite2.sprLayer > s) {
                                break;
                            }
                            break block15;
                        }
                        if ((cSprite2.sprLayer & 1) != n4) break block14;
                    }
                    if (!bl && (cSprite2.sprFlags & 1) == 0 || n < cSprite2.sprX1 || n >= cSprite2.sprX2 || n2 < cSprite2.sprY1 || n2 >= cSprite2.sprY2 || (cSprite2.sprFlags & 0x20) != 0) break block14;
                    n6 = CMask.GCMF_OBSTACLE;
                    if ((n3 & 8) == 0 || (cSprite2.sprFlags & 0x20000) == 0) break block16;
                    if ((n3 & 1) != 0) break block14;
                    n6 = CMask.GCMF_PLATFORM;
                }
                if (this.colMode == 0 || (cSprite2.sprFlags & 0x100) != 0) {
                    return cSprite2;
                }
                CMask cMask = this.getSpriteMask(cSprite2, (short)-1, n6);
                if (cMask != null && (n5 = n2 - cSprite2.sprY1) < cMask.height) {
                    short s2;
                    int n7 = n5 * cMask.lineWidth;
                    int n8 = n - cSprite2.sprX1;
                    if (n8 < cMask.width && (cMask.mask[n7 += n8 / 16] & (s2 = (short)(32768 >> (n8 & 0xF)))) != 0) {
                        return cSprite2;
                    }
                }
            }
            cSprite2 = cSprite2.objNext;
        }
        return null;
    }

    public CArrayList spriteCol_TestSprite_All(CSprite cSprite, short s, int n, int n2, int n3, float f, float f2, int n4) {
        Object object;
        Object object2;
        short s2 = this.colMode;
        CArrayList cArrayList = null;
        if (cSprite == null) {
            return null;
        }
        if ((cSprite.sprFlags & 0x100) != 0) {
            s2 = 0;
        }
        int n5 = cSprite.sprLayer;
        if ((n4 & 8) != 0) {
            n5 &= 0xFFFFFFFE;
        } else {
            if ((cSprite.sprFlags & 1) == 0) {
                return null;
            }
            n5 |= 1;
        }
        int n6 = n;
        int n7 = n2;
        int n8 = n6;
        int n9 = n7;
        int n10 = 0;
        CMask cMask = null;
        if ((cSprite.sprFlags & 0x2000) != 0 || n3 == 0 && f == 1.0f && f2 == 1.0f) {
            cMask = this.getSpriteMask(cSprite, s, CMask.GCMF_OBSTACLE);
            if (cMask == null) {
                s2 = 0;
                n8 += cSprite.sprX2 - cSprite.sprX1;
                n9 += cSprite.sprY2 - cSprite.sprY1;
            } else {
                if ((cSprite.sprFlags & 0x400000) == 0) {
                    n6 -= cMask.xSpot;
                    n7 -= cMask.ySpot;
                }
                n8 = n6 + cMask.width;
                n9 = n7 + cMask.height;
            }
        } else {
            object2 = new CRect();
            object = this.prepareSpriteColMask(cSprite, s, n, n2, (short)n3, f, f2, (CRect)object2);
            n10 = ((CPSCM)object).flags;
            cMask = ((CPSCM)object).mask;
            n6 = ((CRect)object2).left;
            n7 = ((CRect)object2).top;
            n8 = ((CRect)object2).right;
            n9 = ((CRect)object2).bottom;
        }
        object2 = this.firstSprite;
        while (object2 != null) {
            block22: {
                int n11;
                block23: {
                    if (((CSprite)object2).sprLayer < n5) break block22;
                    if (((CSprite)object2).sprLayer > n5) break;
                    if ((((CSprite)object2).sprFlags & 1) == 0 || n6 >= ((CSprite)object2).sprX2 || n8 <= ((CSprite)object2).sprX1 || n7 >= ((CSprite)object2).sprY2 || n9 <= ((CSprite)object2).sprY1 || object2 == cSprite || (((CSprite)object2).sprFlags & 0x20) != 0) break block22;
                    n11 = CMask.GCMF_OBSTACLE;
                    if ((n4 & 8) == 0 || (((CSprite)object2).sprFlags & 0x20000) == 0) break block23;
                    if ((n4 & 1) != 0) break block22;
                    n11 = CMask.GCMF_PLATFORM;
                }
                if (s2 == 0 || (((CSprite)object2).sprFlags & 0x100) != 0) {
                    if (cArrayList == null) {
                        cArrayList = new CArrayList();
                    }
                    cArrayList.add(((CSprite)object2).sprExtraInfo);
                } else if (cMask == null && (cMask = this.completeSpriteColMask(cSprite, n10, n8 - n6, n9 - n7)) == null) {
                    if (cArrayList == null) {
                        cArrayList = new CArrayList();
                    }
                    cArrayList.add(((CSprite)object2).sprExtraInfo);
                } else {
                    object = this.getSpriteMask((CSprite)object2, (short)-1, n11);
                    if (object != null && cMask.testMask(0, n6, n7, (CMask)object, 0, ((CSprite)object2).sprX1, ((CSprite)object2).sprY1)) {
                        if (cArrayList == null) {
                            cArrayList = new CArrayList();
                        }
                        cArrayList.add(((CSprite)object2).sprExtraInfo);
                    }
                }
            }
            object2 = ((CSprite)object2).objNext;
        }
        return cArrayList;
    }

    public CSprite spriteCol_TestSprite(CSprite cSprite, short s, int n, int n2, int n3, float f, float f2, int n4, int n5) {
        if (cSprite == null) {
            return null;
        }
        if ((cSprite.sprFlags & 0x100) != 0) {
            this.colMode = 0;
        }
        int n6 = cSprite.sprLayer;
        if ((n5 & 8) != 0) {
            n6 &= 0xFFFFFFFE;
        } else {
            if ((cSprite.sprFlags & 1) == 0) {
                return null;
            }
            n6 |= 1;
        }
        int n7 = n;
        int n8 = n2;
        int n9 = n7;
        int n10 = n8;
        int n11 = 0;
        CMask cMask = null;
        if ((cSprite.sprFlags & 0x2000) != 0 || n3 == 0 && f == 1.0f && f2 == 1.0f) {
            cMask = this.getSpriteMask(cSprite, s, CMask.GCMF_OBSTACLE);
            if (cMask == null) {
                this.colMode = 0;
                n9 += cSprite.sprX2 - cSprite.sprX1;
                n10 += cSprite.sprY2 - cSprite.sprY1;
            } else {
                if ((cSprite.sprFlags & 0x400000) == 0) {
                    n7 -= cMask.xSpot;
                    n8 -= cMask.ySpot;
                }
                n9 = n7 + cMask.width;
                n10 = n8 + cMask.height;
            }
        } else {
            CRect cRect = new CRect();
            CPSCM cPSCM = this.prepareSpriteColMask(cSprite, s, n, n2, (short)n3, f, f2, cRect);
            n11 = cPSCM.flags;
            cMask = cPSCM.mask;
            n7 = cRect.left;
            n8 = cRect.top;
            n9 = cRect.right;
            n10 = cRect.bottom;
        }
        int n12 = n9 - n7;
        int n13 = n10 - n8;
        if (n4 != 0) {
            int n14 = n10 - n8;
            if (n4 > n14) {
                n4 = n14;
            }
            n8 += n14 - n4;
        }
        CSprite cSprite2 = this.firstSprite;
        while (cSprite2 != null) {
            block21: {
                CMask cMask2;
                int n15;
                block22: {
                    if (cSprite2.sprLayer < n6) break block21;
                    if (cSprite2.sprLayer > n6) break;
                    if ((cSprite2.sprFlags & 1) == 0 || n7 >= cSprite2.sprX2 || n9 <= cSprite2.sprX1 || n8 >= cSprite2.sprY2 || n10 <= cSprite2.sprY1 || cSprite2 == cSprite || (cSprite2.sprFlags & 0x20) != 0) break block21;
                    n15 = CMask.GCMF_OBSTACLE;
                    if ((n5 & 8) == 0 || (cSprite2.sprFlags & 0x20000) == 0) break block22;
                    if ((n5 & 1) != 0) break block21;
                    n15 = CMask.GCMF_PLATFORM;
                }
                if (this.colMode == 0 || (cSprite2.sprFlags & 0x100) != 0) {
                    return cSprite2;
                }
                if (cMask == null && (cMask = this.completeSpriteColMask(cSprite, n11, n12, n13)) == null) {
                    return cSprite2;
                }
                int n16 = 0;
                int n17 = cMask.height;
                if (n4 != 0) {
                    if (n4 > n17) {
                        n4 = n17;
                    }
                    n16 = n17 - n4;
                    n17 = n4;
                }
                if ((cMask2 = this.getSpriteMask(cSprite2, (short)0, n15)) != null && cMask.testMask(n16, n7, n8, cMask2, 0, cSprite2.sprX1, cSprite2.sprY1)) {
                    return cSprite2;
                }
            }
            cSprite2 = cSprite2.objNext;
        }
        return null;
    }

    public CSprite spriteCol_TestRect(CSprite cSprite, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        boolean bl;
        CSprite cSprite2 = cSprite;
        cSprite2 = cSprite2 == null ? this.firstSprite : cSprite2.objNext;
        boolean bl2 = n == -1;
        boolean bl3 = bl = (n6 & 4) != 0;
        if ((n6 & 8) != 0) {
            n7 = 0;
            if (n != -1) {
                n *= 2;
            }
        } else {
            n7 = 1;
            if (n != -1) {
                n = n * 2 + 1;
            }
        }
        while (cSprite2 != null) {
            block13: {
                int n8;
                block15: {
                    block14: {
                        block12: {
                            if (bl2) break block12;
                            if (cSprite2.sprLayer < n) break block13;
                            if (cSprite2.sprLayer > n) {
                                break;
                            }
                            break block14;
                        }
                        if ((cSprite2.sprLayer & 1) != n7) break block13;
                    }
                    if (!bl && (cSprite2.sprFlags & 1) == 0 || n2 > cSprite2.sprX2 || n2 + n4 <= cSprite2.sprX1 || n3 > cSprite2.sprY2 || n3 + n5 <= cSprite2.sprY1 || (cSprite2.sprFlags & 0x20) != 0) break block13;
                    n8 = CMask.GCMF_OBSTACLE;
                    if ((n6 & 8) == 0 || (cSprite2.sprFlags & 0x20000) == 0) break block15;
                    if ((n6 & 1) != 0) break block13;
                    n8 = CMask.GCMF_PLATFORM;
                }
                if (this.colMode == 0 || (cSprite2.sprFlags & 0x100) != 0) {
                    return cSprite2;
                }
                CMask cMask = this.getSpriteMask(cSprite2, (short)0, n8);
                if (cMask != null && cMask.testRect(0, n2 - cSprite2.sprX1, n3 - cSprite2.sprY1, n4, n5)) {
                    return cSprite2;
                }
            }
            cSprite2 = cSprite2.objNext;
        }
        return null;
    }
}

