/*
 * Decompiled with CFR 0.152.
 */
public class GameLogicTanks
extends GameLogic {
    private static final byte TANK_SIZE = 6;
    private static final int LIFE_MAX = 3;
    private static final byte SCORE_INC = 50;
    private static final int SCORE_UP = 1000;
    private static final int[][] TANK_FIGURE = new int[][]{{1, 10, 11, 12, 20, 22}, {0, 1, 11, 12, 20, 21}, {0, 2, 10, 11, 12, 21}, {1, 2, 10, 11, 21, 22}};
    private static final int[] COLLISION_FIGURE = new int[]{0, 3, 11, 12, 21, 22, 30, 33};
    private static final byte[] BULLET_STARTING_POS = new byte[]{1, 12, 21, 10};
    private static final int[] TANK_OP_STARTING_POS = new int[]{0, 170, 7, 177};
    private int[] iBulletPos;
    private byte[] bBulletDirection;
    private int[] iTankOpPos;
    private byte[] bTankOpDirection;
    private byte bTankOpUpdate;
    private byte bTankOpCount = (byte)4;
    private boolean[] previous_rotate;
    private byte shoot_probability;
    private int[] iBulletOpPos;
    private byte[] bBulletOpDirection;
    private int iTankPos = 74;
    private byte bTankDirection = 0;
    private byte bBulletsAvailable = (byte)2;
    private static final byte UP_DIRECTION = 0;
    private static final byte RIGHT_DIRECTION = 1;
    private static final byte DOWN_DIRECTION = 2;
    private static final byte LEFT_DIRECTION = 3;
    private byte bShowCollision = 0;
    private long lBallUpdate;

    public GameLogicTanks() {
        super(6, 3);
        this.iBulletPos = new int[this.bBulletsAvailable];
        this.bBulletDirection = new byte[this.bBulletsAvailable];
        this.iBulletOpPos = new int[this.bTankOpCount];
        this.bBulletOpDirection = new byte[this.bTankOpCount];
        this.iTankOpPos = new int[this.bTankOpCount];
        this.bTankOpDirection = new byte[this.bTankOpCount];
        this.previous_rotate = new boolean[this.bTankOpCount];
    }

    protected void save() throws Exception {
        super.save();
        GUtillIo.writeInt(this.iTankPos);
        GUtillIo.writeByte(this.bTankDirection);
        GUtillIo.writeByte(this.bBulletsAvailable);
        GUtillIo.writeByte(this.bShowCollision);
        GUtillIo.writeByte(this.bTankOpCount);
        GUtillIo.writeByte(this.bTankOpUpdate);
        GUtillIo.writeIntArray(this.iBulletPos);
        GUtillIo.writeByteArray(this.bBulletDirection);
        GUtillIo.writeIntArray(this.iBulletOpPos);
        GUtillIo.writeByteArray(this.bBulletOpDirection);
        GUtillIo.writeIntArray(this.iTankOpPos);
        GUtillIo.writeByteArray(this.bTankOpDirection);
        GUtillIo.writeBooleanArray(this.previous_rotate);
    }

    protected void load() throws Exception {
        super.load();
        this.iTankPos = GUtillIo.readInt();
        this.bTankDirection = GUtillIo.readByte();
        this.bBulletsAvailable = GUtillIo.readByte();
        this.bShowCollision = GUtillIo.readByte();
        this.bTankOpCount = GUtillIo.readByte();
        this.bTankOpUpdate = GUtillIo.readByte();
        this.iBulletPos = GUtillIo.readIntArray();
        this.bBulletDirection = GUtillIo.readByteArray();
        this.iBulletOpPos = GUtillIo.readIntArray();
        this.bBulletOpDirection = GUtillIo.readByteArray();
        this.iTankOpPos = GUtillIo.readIntArray();
        this.bTankOpDirection = GUtillIo.readByteArray();
        this.previous_rotate = GUtillIo.readBooleanArray();
    }

    private final void updateFigure() {
        boolean lifedecr = false;
        for (int i = 0; i < 6; ++i) {
            this.figure_pos[i] = this.iTankPos + TANK_FIGURE[this.bTankDirection][i];
            if (GameField.get(this.figure_pos[i]) != 1) continue;
            lifedecr = true;
        }
    }

    protected void placePlayer() {
        this.active = false;
        this.shoot_probability = (byte)(9 - (EGame.iLevel - 1) / 2);
        GameField.clear();
        GUtillArray.fill(this.iBulletOpPos, -1);
        this.bTankOpCount = (byte)4;
        GUtillArray.fill(this.iTankOpPos, -1);
        this.iTankPos = 74;
        this.bTankDirection = 0;
        GUtillArray.fill(this.figure_elem, (byte)1);
        this.bBulletsAvailable = (byte)2;
        this.bTankOpUpdate = 0;
        GUtillArray.fill(this.previous_rotate, false);
        this.updateFigure();
    }

    public boolean updateEvent() {
        if (E.kStates[7] && !this.active) {
            this.active = true;
            E.kStates[7] = false;
        }
        if (this.active && this.bShowCollision == 0) {
            if (this.CurrentScore == 1000) {
                this.CurrentScore = 0;
                this.gameup = true;
                this.placePlayer();
            }
            if (E.kStates[6]) {
                if (this.can(this.iTankPos, (byte)3, this.iTankPos - 1)) {
                    --this.iTankPos;
                }
                this.bTankDirection = (byte)3;
                this.updateFigure();
            } else if (E.kStates[8]) {
                if (this.can(this.iTankPos, (byte)1, this.iTankPos + 1)) {
                    ++this.iTankPos;
                }
                this.bTankDirection = 1;
                this.updateFigure();
            } else if (E.kStates[4]) {
                if (this.can(this.iTankPos, (byte)0, this.iTankPos - 10)) {
                    this.iTankPos -= 10;
                }
                this.bTankDirection = 0;
                this.updateFigure();
            } else if (E.kStates[10]) {
                if (this.can(this.iTankPos, (byte)2, this.iTankPos + 10)) {
                    this.iTankPos += 10;
                }
                this.bTankDirection = (byte)2;
                this.updateFigure();
            }
            if (E.kStates[7] && this.bBulletsAvailable != 0) {
                E.kStates[7] = false;
                if (this.bBulletsAvailable > 0) {
                    this.bBulletsAvailable = (byte)(this.bBulletsAvailable - 1);
                    this.bBulletDirection[1 - this.bBulletsAvailable] = this.bTankDirection;
                    this.iBulletPos[1 - this.bBulletsAvailable] = this.iTankPos + BULLET_STARTING_POS[this.bTankDirection];
                }
            }
            if (this.lBallUpdate < System.currentTimeMillis()) {
                int i;
                block12: for (i = 0; i < 2 - this.bBulletsAvailable; ++i) {
                    switch (this.bBulletDirection[i]) {
                        case 0: {
                            int j;
                            GameField.set(this.iBulletPos[i], (byte)0);
                            if (this.iBulletPos[i] / 10 == 0) {
                                this.iBulletPos[i] = i == 0 ? this.iBulletPos[1] : -1;
                                this.bBulletDirection[i] = i == 0 ? this.bBulletDirection[1] : -1;
                                this.bBulletsAvailable = (byte)(this.bBulletsAvailable + 1);
                                continue block12;
                            }
                            int n = i;
                            this.iBulletPos[n] = this.iBulletPos[n] - 10;
                            if (GameField.get(this.iBulletPos[i]) == 1) {
                                this.killTank(this.iBulletPos[i]);
                                this.iBulletPos[i] = i == 0 ? this.iBulletPos[1] : -1;
                                this.bBulletDirection[i] = i == 0 ? this.bBulletDirection[1] : -1;
                                this.bBulletsAvailable = (byte)(this.bBulletsAvailable + 1);
                                continue block12;
                            }
                            if (GameField.get(this.iBulletPos[i]) == 2) {
                                for (j = 0; j < this.bTankOpCount; ++j) {
                                    if (this.iBulletOpPos[j] != this.iBulletPos[i]) continue;
                                    this.iBulletOpPos[j] = -1;
                                    this.bBulletOpDirection[j] = -1;
                                    break;
                                }
                            }
                            GameField.set(this.iBulletPos[i], (byte)2);
                            continue block12;
                        }
                        case 1: {
                            int j;
                            GameField.set(this.iBulletPos[i], (byte)0);
                            if (this.iBulletPos[i] % 10 == 9) {
                                this.iBulletPos[i] = i == 0 ? this.iBulletPos[1] : -1;
                                this.bBulletDirection[i] = i == 0 ? this.bBulletDirection[1] : -1;
                                this.bBulletsAvailable = (byte)(this.bBulletsAvailable + 1);
                                continue block12;
                            }
                            int n = i;
                            this.iBulletPos[n] = this.iBulletPos[n] + 1;
                            if (GameField.get(this.iBulletPos[i]) == 1) {
                                this.killTank(this.iBulletPos[i]);
                                this.iBulletPos[i] = i == 0 ? this.iBulletPos[1] : -1;
                                this.bBulletDirection[i] = i == 0 ? this.bBulletDirection[1] : -1;
                                this.bBulletsAvailable = (byte)(this.bBulletsAvailable + 1);
                                continue block12;
                            }
                            if (GameField.get(this.iBulletPos[i]) == 2) {
                                for (j = 0; j < this.bTankOpCount; ++j) {
                                    if (this.iBulletOpPos[j] != this.iBulletPos[i]) continue;
                                    this.iBulletOpPos[j] = -1;
                                    this.bBulletOpDirection[j] = -1;
                                    break;
                                }
                            }
                            GameField.set(this.iBulletPos[i], (byte)2);
                            continue block12;
                        }
                        case 2: {
                            int j;
                            GameField.set(this.iBulletPos[i], (byte)0);
                            if (this.iBulletPos[i] / 10 == 19) {
                                this.iBulletPos[i] = i == 0 ? this.iBulletPos[1] : -1;
                                this.bBulletDirection[i] = i == 0 ? this.bBulletDirection[1] : -1;
                                this.bBulletsAvailable = (byte)(this.bBulletsAvailable + 1);
                                continue block12;
                            }
                            int n = i;
                            this.iBulletPos[n] = this.iBulletPos[n] + 10;
                            if (GameField.get(this.iBulletPos[i]) == 1) {
                                this.killTank(this.iBulletPos[i]);
                                this.iBulletPos[i] = i == 0 ? this.iBulletPos[1] : -1;
                                this.bBulletDirection[i] = i == 0 ? this.bBulletDirection[1] : -1;
                                this.bBulletsAvailable = (byte)(this.bBulletsAvailable + 1);
                                continue block12;
                            }
                            if (GameField.get(this.iBulletPos[i]) == 2) {
                                for (j = 0; j < this.bTankOpCount; ++j) {
                                    if (this.iBulletOpPos[j] != this.iBulletPos[i]) continue;
                                    this.iBulletOpPos[j] = -1;
                                    this.bBulletOpDirection[j] = -1;
                                    break;
                                }
                            }
                            GameField.set(this.iBulletPos[i], (byte)2);
                            continue block12;
                        }
                        case 3: {
                            int j;
                            GameField.set(this.iBulletPos[i], (byte)0);
                            if (this.iBulletPos[i] % 10 == 0) {
                                this.iBulletPos[i] = i == 0 ? this.iBulletPos[1] : -1;
                                this.bBulletDirection[i] = i == 0 ? this.bBulletDirection[1] : -1;
                                this.bBulletsAvailable = (byte)(this.bBulletsAvailable + 1);
                                continue block12;
                            }
                            int n = i;
                            this.iBulletPos[n] = this.iBulletPos[n] - 1;
                            if (GameField.get(this.iBulletPos[i]) == 1) {
                                this.killTank(this.iBulletPos[i]);
                                this.iBulletPos[i] = i == 0 ? this.iBulletPos[1] : -1;
                                this.bBulletDirection[i] = i == 0 ? this.bBulletDirection[1] : -1;
                                this.bBulletsAvailable = (byte)(this.bBulletsAvailable + 1);
                                continue block12;
                            }
                            if (GameField.get(this.iBulletPos[i]) == 2) {
                                for (j = 0; j < this.bTankOpCount; ++j) {
                                    if (this.iBulletOpPos[j] != this.iBulletPos[i]) continue;
                                    this.iBulletOpPos[j] = -1;
                                    this.bBulletOpDirection[j] = -1;
                                    break;
                                }
                            }
                            GameField.set(this.iBulletPos[i], (byte)2);
                        }
                    }
                }
                block17: for (i = 0; i < this.bTankOpCount; ++i) {
                    if (this.iBulletOpPos[i] == -1) continue;
                    switch (this.bBulletOpDirection[i]) {
                        case 0: {
                            GameField.set(this.iBulletOpPos[i], GameField.get(this.iBulletOpPos[i]) == 1 ? (byte)1 : 0);
                            if (this.iBulletOpPos[i] / 10 == 0) {
                                this.iBulletOpPos[i] = -1;
                                this.bBulletOpDirection[i] = -1;
                                continue block17;
                            }
                            int n = i;
                            this.iBulletOpPos[n] = this.iBulletOpPos[n] - 10;
                            if (this.killPlayer(this.iBulletOpPos[i]) || GameField.get(this.iBulletOpPos[i]) == 1) {
                                this.iBulletOpPos[i] = -1;
                                this.bBulletOpDirection[i] = -1;
                                continue block17;
                            }
                            GameField.set(this.iBulletOpPos[i], (byte)2);
                            continue block17;
                        }
                        case 1: {
                            GameField.set(this.iBulletOpPos[i], GameField.get(this.iBulletOpPos[i]) == 1 ? (byte)1 : 0);
                            if (this.iBulletOpPos[i] % 10 == 9) {
                                this.iBulletOpPos[i] = -1;
                                this.bBulletOpDirection[i] = -1;
                                continue block17;
                            }
                            int n = i;
                            this.iBulletOpPos[n] = this.iBulletOpPos[n] + 1;
                            if (this.killPlayer(this.iBulletOpPos[i]) || GameField.get(this.iBulletOpPos[i]) == 1) {
                                this.iBulletOpPos[i] = -1;
                                this.bBulletOpDirection[i] = -1;
                                continue block17;
                            }
                            GameField.set(this.iBulletOpPos[i], (byte)2);
                            continue block17;
                        }
                        case 2: {
                            GameField.set(this.iBulletOpPos[i], GameField.get(this.iBulletOpPos[i]) == 1 ? (byte)1 : 0);
                            if (this.iBulletOpPos[i] / 10 == 19) {
                                this.iBulletOpPos[i] = -1;
                                this.bBulletOpDirection[i] = -1;
                                continue block17;
                            }
                            int n = i;
                            this.iBulletOpPos[n] = this.iBulletOpPos[n] + 10;
                            if (this.killPlayer(this.iBulletOpPos[i]) || GameField.get(this.iBulletOpPos[i]) == 1) {
                                this.iBulletOpPos[i] = -1;
                                this.bBulletOpDirection[i] = -1;
                                continue block17;
                            }
                            GameField.set(this.iBulletOpPos[i], (byte)2);
                            continue block17;
                        }
                        case 3: {
                            GameField.set(this.iBulletOpPos[i], GameField.get(this.iBulletOpPos[i]) == 1 ? (byte)1 : 0);
                            if (this.iBulletOpPos[i] % 10 == 0) {
                                this.iBulletOpPos[i] = -1;
                                this.bBulletOpDirection[i] = -1;
                                continue block17;
                            }
                            int n = i;
                            this.iBulletOpPos[n] = this.iBulletOpPos[n] - 1;
                            if (this.killPlayer(this.iBulletOpPos[i]) || GameField.get(this.iBulletOpPos[i]) == 1) {
                                this.iBulletOpPos[i] = -1;
                                this.bBulletOpDirection[i] = -1;
                                continue block17;
                            }
                            GameField.set(this.iBulletOpPos[i], (byte)2);
                        }
                    }
                }
            }
        }
        return false;
    }

    private void killTank(int pos) {
        block0: for (int i = 0; i < this.bTankOpCount; ++i) {
            for (int j = 0; j < 6; ++j) {
                if (this.iTankOpPos[i] + TANK_FIGURE[this.bTankOpDirection[i]][j] != pos) continue;
                this.score += 50;
                this.CurrentScore += 50;
                for (int q = 0; q < 6; ++q) {
                    GameField.set(this.iTankOpPos[i] + TANK_FIGURE[this.bTankOpDirection[i]][q], (byte)0);
                }
                this.iTankOpPos[i] = -1;
                continue block0;
            }
        }
    }

    private boolean killPlayer(int bulletpos) {
        for (int i = 0; i < 6; ++i) {
            if (this.iTankPos + TANK_FIGURE[this.bTankDirection][i] != bulletpos) continue;
            this.showCollision();
            return true;
        }
        return false;
    }

    public void updateLevel(int level) {
        this.clear();
        this.placePlayer();
        this.bShowCollision = 0;
        this.bBulletsAvailable = (byte)2;
    }

    public void updateState() {
        if (this.active && this.canUpdate()) {
            if (this.bShowCollision != 0) {
                if (this.bShowCollision == 4) {
                    this.bShowCollision = 0;
                    this.lifeDecr();
                } else {
                    this.bShowCollision = (byte)(this.bShowCollision + 1);
                }
            } else {
                for (int i = this.bTankOpUpdate; i < this.bTankOpCount - (2 - this.bTankOpUpdate); ++i) {
                    boolean shoot;
                    int j;
                    int new_pos = -1;
                    boolean k = false;
                    byte dir = -1;
                    if (this.iTankOpPos[i] != -1) {
                        for (j = 0; j < 6; ++j) {
                            GameField.set(this.iTankOpPos[i] + TANK_FIGURE[this.bTankOpDirection[i]][j], (byte)0);
                        }
                    }
                    if (this.iTankOpPos[i] == -1) {
                        this.bTankOpDirection[i] = (byte)GUtillMath.rnd(4);
                        for (j = 0; j < 4; ++j) {
                            if (!this.can(this.iTankOpPos[i], this.bTankOpDirection[i], TANK_OP_STARTING_POS[j])) continue;
                            new_pos = TANK_OP_STARTING_POS[j];
                            break;
                        }
                        this.previous_rotate[i] = false;
                    } else {
                        do {
                            if ((dir = (byte)((byte)GUtillMath.rnd(4))) != this.bTankOpDirection[i] && !this.previous_rotate[i]) {
                                this.bTankOpDirection[i] = dir;
                                new_pos = this.iTankOpPos[i];
                                this.previous_rotate[i] = true;
                                break;
                            }
                            this.bTankOpDirection[i] = dir;
                            switch (this.bTankOpDirection[i]) {
                                case 0: {
                                    new_pos = this.iTankOpPos[i] - 10;
                                    break;
                                }
                                case 1: {
                                    new_pos = this.iTankOpPos[i] + 1;
                                    break;
                                }
                                case 2: {
                                    new_pos = this.iTankOpPos[i] + 10;
                                    break;
                                }
                                case 3: {
                                    new_pos = this.iTankOpPos[i] - 1;
                                }
                            }
                            this.previous_rotate[i] = false;
                        } while (!this.can(this.iTankOpPos[i], this.bTankOpDirection[i], new_pos));
                    }
                    this.iTankOpPos[i] = new_pos;
                    if (this.iTankOpPos[i] != -1) {
                        for (j = 0; j < 6; ++j) {
                            GameField.set(this.iTankOpPos[i] + TANK_FIGURE[this.bTankOpDirection[i]][j], (byte)1);
                        }
                    }
                    boolean bl = shoot = GUtillMath.rnd(this.shoot_probability) == 0;
                    if (this.iTankOpPos[i] == -1 || !shoot || this.iBulletOpPos[i] != -1) continue;
                    System.out.println("SHOOOT!!!!!!!!!");
                    this.bBulletOpDirection[i] = this.bTankOpDirection[i];
                    this.iBulletOpPos[i] = this.iTankOpPos[i] + BULLET_STARTING_POS[this.bTankOpDirection[i]];
                }
                this.bTankOpUpdate = (byte)(this.bTankOpUpdate == 0 ? 2 : 0);
            }
        }
    }

    private final void showCollision() {
        int i = 0;
        for (i = 0; i < 6; ++i) {
            GameField.set(this.iTankPos + TANK_FIGURE[this.bTankDirection][i], (byte)0);
        }
        GUtillArray.fill(this.figure_elem, (byte)0);
        if (this.iTankPos % 10 == 7) {
            --this.iTankPos;
        }
        if (this.iTankPos / 10 == 17) {
            this.iTankPos -= 10;
        }
        for (i = 0; i < COLLISION_FIGURE.length; ++i) {
            GameField.set(this.iTankPos + COLLISION_FIGURE[i], (byte)2);
        }
        GameField.set(this.iTankPos + COLLISION_FIGURE[0] + 1, (byte)0);
        GameField.set(this.iTankPos + COLLISION_FIGURE[0] + 2, (byte)0);
        GameField.set(this.iTankPos + COLLISION_FIGURE[0] + 10, (byte)0);
        GameField.set(this.iTankPos + COLLISION_FIGURE[0] + 20, (byte)0);
        GameField.set(this.iTankPos + COLLISION_FIGURE[0] + 13, (byte)0);
        GameField.set(this.iTankPos + COLLISION_FIGURE[0] + 23, (byte)0);
        GameField.set(this.iTankPos + COLLISION_FIGURE[0] + 31, (byte)0);
        GameField.set(this.iTankPos + COLLISION_FIGURE[0] + 32, (byte)0);
        this.bShowCollision = (byte)(this.bShowCollision + 1);
    }

    private final boolean checkCollision() {
        int posNext = TANK_FIGURE[this.bTankDirection][0] - 10;
        return GameField.get(posNext) == 1;
    }

    private final boolean can(int pos, byte dir, int new_pos) {
        if (pos != -1) {
            if (pos % 10 == 0 && dir == 3) {
                return false;
            }
            if (pos % 10 == 7 && dir == 1) {
                return false;
            }
            if (pos / 10 == 0 && dir == 0) {
                return false;
            }
            if (pos / 10 == 17 && dir == 2) {
                return false;
            }
        }
        if (pos == -1) {
            for (int i = 0; i < 6; ++i) {
                if (GameField.get(new_pos + TANK_FIGURE[dir][i]) != 2) continue;
                return false;
            }
        }
        int new_pos_x = new_pos % 10;
        int new_pos_y = new_pos / 10;
        for (int i = 0; i < this.bTankOpCount; ++i) {
            int tank_pos_x = this.iTankOpPos[i] % 10;
            int tank_pos_y = this.iTankOpPos[i] / 10;
            if (this.iTankOpPos[i] == -1 || pos == this.iTankOpPos[i] || GUtillMath.abs(tank_pos_x - new_pos_x) >= 3 || GUtillMath.abs(tank_pos_y - new_pos_y) >= 3) continue;
            return false;
        }
        if (pos != this.iTankPos) {
            int tank_pos_x = this.iTankPos % 10;
            int tank_pos_y = this.iTankPos / 10;
            if (GUtillMath.abs(tank_pos_x - new_pos_x) < 3 && GUtillMath.abs(tank_pos_y - new_pos_y) < 3) {
                return false;
            }
        }
        return true;
    }
}

