/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Image;

public class Gr2DText {
    public static final byte ANCHOR_TXT_TOPLEFT = 0;
    public static final byte ANCHOR_TXT_TOP = 1;
    public static final byte ANCHOR_TXT_TOPRIGHT = 2;
    public static final byte ANCHOR_TXT_LEFT = 4;
    public static final byte ANCHOR_TXT_CENTER = 5;
    public static final byte ANCHOR_TXT_RIGHT = 6;
    public static final byte ANCHOR_TXT_BOTTOMLEFT = 8;
    public static final byte ANCHOR_TXT_BOTTOM = 9;
    public static final byte ANCHOR_TXT_BOTTOMRIGHT = 10;
    public static final byte CHAR_SPACE = -1;
    public static final byte CHAR_CR = -2;
    public static final byte CHAR_LAST = -8;
    private static final byte[] TEXTS_ANCHOR_SHIFT = new byte[]{31, 1, 0};
    private static final int RETURN_WORD_WIDTH = 0;
    private static final int RETURN_END = 1;
    private static int[] iArrFontX;
    private static int[] iArrFontY;
    private static byte[] bArrFontW;
    private static byte bFontH;
    private static byte bFontSpace;
    private static byte bFontInterchar;
    private static String sFontMap;
    private static byte[] bArrText;
    private static short[] sArrTextIndex;
    private static Image IArrImage;
    private static int iLangCur;
    private static int iLangCount;
    private static short[] sArrLangNameIndexes;
    private static byte[] bArrLangNameTexts;
    private static String sDataFile;

    public static final void init(String textFilePath, String fontDataFilePath) {
        try {
            sDataFile = textFilePath;
            GUtillIo.initRead(sDataFile);
            GUtillIo.readInt();
            short len = GUtillIo.readByte();
            iLangCount = len - 1;
            sArrLangNameIndexes = GUtillIo.readShortArray(len);
            len = GUtillIo.readShort();
            bArrLangNameTexts = GUtillIo.readByteArray(len);
            iLangCur = 0;
            GUtillIo.closeRead();
            Gr2DText.loadDef();
            Gr2DText.loadImg();
            Gr2DText.loadMap();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final void loadImg() throws Exception {
        IArrImage = Gr2D.createImage("/f1");
    }

    private static final void loadMap() throws Exception {
        GUtillIo.initRead("/f1.map");
        GUtillIo.skip(2L);
        StringBuffer map = new StringBuffer();
        for (int i = 0; i < iArrFontX.length; ++i) {
            map.append(GUtillIo.readLine());
        }
        sFontMap = map.toString();
        GUtillIo.closeRead();
    }

    private static final void loadDef() throws Exception {
        GUtillIo.initRead("/f1.def");
        int num = GUtillIo.readUnsignedByte();
        iArrFontX = GUtillIo.readUnsignedByteArray(num);
        iArrFontY = GUtillIo.readUnsignedByteArray(num);
        bArrFontW = GUtillIo.readByteArray(num);
        bFontH = GUtillIo.readByte();
        bFontSpace = GUtillIo.readByte();
        bFontInterchar = GUtillIo.readByte();
        bFontInterchar = 0;
        GUtillIo.closeRead();
    }

    public static final void setLangCur(int langId) {
        try {
            GUtillIo.initRead(sDataFile);
            int skip = GUtillIo.readInt();
            GUtillIo.skip(skip);
            for (int cur = 0; cur < langId; ++cur) {
                skip = GUtillIo.readInt();
                GUtillIo.skip(skip);
            }
            GUtillIo.readInt();
            sArrTextIndex = GUtillIo.readShortArray(GUtillIo.readShort());
            bArrText = GUtillIo.readByteArray(GUtillIo.readShort());
            GUtillIo.closeRead();
            iLangCur = langId;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final int getLangCount() {
        return iLangCount;
    }

    public static final int getLangCur() {
        return iLangCur;
    }

    public static final byte[] getLangName(int index) {
        short begin = sArrLangNameIndexes[index];
        int len = sArrLangNameIndexes[index + 1] - begin;
        return GUtillArray.get(bArrLangNameTexts, (int)begin, len);
    }

    public static int getTextWidth(int textId) {
        int result = 0;
        for (int i = sArrTextIndex[textId]; i < sArrTextIndex[textId + 1]; ++i) {
            int charIndex = Gr2DText.getCharIndex(bArrText[i]);
            result += (charIndex < 0 ? bFontSpace : bArrFontW[charIndex]) + bFontInterchar;
        }
        return result - bFontInterchar;
    }

    public static int getTextWidth(byte[] text) {
        int result = 0;
        int length = text.length;
        for (int i = 0; i < length; ++i) {
            int charIndex = Gr2DText.getCharIndex(text[i]);
            result += (charIndex < 0 ? bFontSpace : bArrFontW[charIndex]) + bFontInterchar;
        }
        return result - bFontInterchar;
    }

    public static byte getFontHeight() {
        return bFontH;
    }

    public static byte getFontInterChar() {
        return bFontInterchar;
    }

    public static final int getTextLineCount(int textId, int textW) {
        int lineCount = 1;
        byte[] text = Gr2DText.getTextUpdate(textId, textW);
        int length = text.length;
        for (int i = 0; i < length; ++i) {
            if (text[i] != -2) continue;
            ++lineCount;
        }
        return lineCount;
    }

    public static byte[] getTextUpdate(int textId, int textW) {
        byte[] lines = new byte[]{};
        int lineWidthCurrent = 0;
        block0: for (int i = sArrTextIndex[textId]; i < sArrTextIndex[textId + 1]; ++i) {
            if (bArrText[i] == -2) {
                lineWidthCurrent = 0;
                lines = GUtillArray.add(lines, (byte)-2);
                continue;
            }
            short to = sArrTextIndex[textId + 1];
            int[] temp = Gr2DText.getWordWidth(i, to);
            if ((lineWidthCurrent += temp[0]) > textW && lineWidthCurrent != temp[0]) {
                --i;
                lineWidthCurrent = 0;
                lines = GUtillArray.add(lines, (byte)-2);
                continue;
            }
            if (lineWidthCurrent > textW + bFontSpace + bFontInterchar && lineWidthCurrent == temp[0]) {
                int width = 0;
                for (int j = i; j < to; ++j) {
                    int charId = bArrText[j];
                    if (charId <= -8) {
                        charId = 128 - (charId - -8);
                    }
                    if (charId < 0 || (width += bArrFontW[charId] + bFontInterchar) <= textW) continue;
                    for (int k = i; k < j; ++k) {
                        lines = GUtillArray.add(lines, bArrText[k]);
                    }
                    lines = GUtillArray.add(lines, (byte)-2);
                    lineWidthCurrent = 0;
                    i = j - 1;
                    continue block0;
                }
                continue;
            }
            for (int j = i; j < temp[1]; ++j) {
                lines = GUtillArray.add(lines, bArrText[j]);
            }
            lineWidthCurrent += bFontSpace + bFontInterchar;
            i = temp[1];
            lines = GUtillArray.add(lines, bArrText[i]);
            if (bArrText[i] != -2) continue;
            lineWidthCurrent = 0;
        }
        return lines;
    }

    public static void renderSymbol(int symbolId, int x, int y, int anchor) {
        if ((anchor & 3) != 0) {
            x += Gr2DText.anchorOffset(anchor & 3, bArrFontW[symbolId]);
        }
        if (anchor > 3) {
            y += Gr2DText.anchorOffset(anchor >>> 2, bFontH);
        }
        Gr2D.saveClip();
        x += Gr2DText.renderChar(symbolId, x, y);
        Gr2D.restoreClip();
    }

    public static final byte getSymbolWidth(int symbolId) {
        return bArrFontW[symbolId];
    }

    public static final void renderTextLine(int textId, int x, int y, int anchor) {
        if ((anchor & 3) != 0) {
            x += Gr2DText.anchorOffset(anchor & 3, Gr2DText.getTextWidth(textId));
        }
        if (anchor > 3) {
            y += Gr2DText.anchorOffset(anchor >>> 2, bFontH);
        }
        Gr2D.saveClip();
        for (int i = sArrTextIndex[textId]; i < sArrTextIndex[textId + 1]; ++i) {
            x += Gr2DText.renderChar(bArrText[i], x, y);
        }
        Gr2D.restoreClip();
    }

    public static final byte[] convertInt(int number) {
        int length = 0;
        int temp = number;
        while (temp > 0) {
            temp /= 10;
            ++length;
        }
        temp = number;
        byte[] result = new byte[number == 0 ? 1 : length];
        int i = length;
        while (--i >= 0) {
            result[i] = (byte)(temp % 10);
            temp /= 10;
        }
        return result;
    }

    public static final void renderString(String value, int x, int y, int anchor) {
        byte[] text = Gr2DText.convertString(value);
        int textLength = text.length;
        if ((anchor & 3) != 0) {
            x += Gr2DText.anchorOffset(anchor & 3, Gr2DText.textWidthTotal(text));
        }
        if (anchor > 3) {
            y += Gr2DText.anchorOffset(anchor >>> 2, bFontH);
        }
        Gr2D.saveClip();
        for (int i = 0; i < textLength; ++i) {
            x += Gr2DText.renderChar(text[i], x, y);
        }
        Gr2D.restoreClip();
    }

    public static final void renderTextMultiline(int textId, int lineFirst, int lineCount, int textW, int x, int y, int anchor) {
        int i;
        int lineEnd = lineFirst + lineCount;
        int lineCurrent = 1;
        byte[] text = Gr2DText.getTextUpdate(textId, textW);
        int count = text.length;
        int[] xFirst = Gr2DText.getTextLinesWidth(text, textId, textW);
        int length = xFirst.length;
        if ((anchor & 3) != 0) {
            for (i = 0; i < length; ++i) {
                xFirst[i] = x + Gr2DText.anchorOffset(anchor & 3, xFirst[i]);
            }
        } else {
            for (i = 0; i < length; ++i) {
                xFirst[i] = x;
            }
        }
        int _x = xFirst[0];
        int _y = y;
        Gr2D.saveClip();
        for (i = 0; i < count; ++i) {
            if (lineCurrent >= lineFirst && lineCurrent < lineEnd) {
                int _temp = Gr2DText.renderChar(text[i], _x, _y);
                if (_temp != -8) {
                    _x += _temp;
                    continue;
                }
                _y += bFontH;
                _x = xFirst[++lineCurrent - 1];
                continue;
            }
            if (lineCurrent < lineFirst && text[i] == -2) {
                _x = xFirst[++lineCurrent - 1];
                continue;
            }
            if (lineCurrent >= lineEnd) break;
        }
        Gr2D.restoreClip();
    }

    public static final void renderTextMultiline(int textId, byte[] text, int symbolCount, int lineFirst, int lineCount, int textW, int x, int y, int careteId, int anchor) {
        int i;
        int lineEnd = lineFirst + lineCount;
        int lineCurrent = 1;
        int textLen = text.length;
        int[] xFirst = Gr2DText.getTextLinesWidth(text, textId, textW);
        int length = xFirst.length;
        if ((anchor & 3) != 0) {
            for (i = 0; i < length; ++i) {
                xFirst[i] = x + Gr2DText.anchorOffset(anchor & 3, xFirst[i]);
            }
        } else {
            for (i = 0; i < length; ++i) {
                xFirst[i] = x;
            }
        }
        int _x = xFirst[0];
        int _y = y;
        int count = 0;
        Gr2D.saveClip();
        for (i = 0; i < textLen; ++i) {
            if (lineCurrent >= lineFirst && lineCurrent < lineEnd) {
                if (count < symbolCount) {
                    int _temp = Gr2DText.renderChar(text[i], _x, _y);
                    if (_temp != -8) {
                        _x += _temp;
                    } else {
                        _y += bFontH;
                        _x = xFirst[++lineCurrent - 1];
                    }
                    ++count;
                    continue;
                }
                if (careteId == -1) break;
                Gr2DText.renderChar(careteId, _x, _y);
                break;
            }
            if (lineCurrent < lineFirst && text[i] == -2) {
                _x = xFirst[++lineCurrent - 1];
                continue;
            }
            if (lineCurrent >= lineEnd) break;
        }
        Gr2D.restoreClip();
    }

    public static void renderTextMultiline(int textId, int textW, int x, int y, int anchor) {
        int i;
        int lineCurrent = 0;
        byte[] text = Gr2DText.getTextUpdate(textId, textW);
        int count = text.length;
        int[] xFirst = Gr2DText.getTextLinesWidth(text, textId, textW);
        int length = xFirst.length;
        if ((anchor & 3) != 0) {
            for (i = 0; i < length; ++i) {
                xFirst[i] = x + Gr2DText.anchorOffset(anchor & 3, xFirst[i]);
            }
        } else {
            for (i = 0; i < length; ++i) {
                xFirst[i] = x;
            }
        }
        int _y = y;
        if (anchor > 3) {
            for (i = 0; i < length; ++i) {
                _y += Gr2DText.anchorOffset(anchor >>> 2, bFontH);
            }
        }
        int _x = xFirst[lineCurrent];
        Gr2D.saveClip();
        for (i = 0; i < count; ++i) {
            int _temp = Gr2DText.renderChar(text[i], _x, _y);
            if (_temp != -8) {
                _x += _temp;
                continue;
            }
            _y += bFontH;
            _x = xFirst[++lineCurrent];
        }
        Gr2D.restoreClip();
    }

    private static final int[] getTextLinesWidth(byte[] texts, int textId, int textW) {
        int i;
        int count = texts.length;
        int lineCount = Gr2DText.getTextLineCount(textId, textW);
        int lineCurrent = 0;
        int[] lineWidth = new int[lineCount];
        for (i = 0; i < lineCount; ++i) {
            lineWidth[i] = 0;
        }
        for (i = 0; i < count; ++i) {
            if (texts[i] != -2) {
                int n = lineCurrent;
                lineWidth[n] = lineWidth[n] + ((texts[i] < 0 ? bFontSpace : bArrFontW[texts[i]]) + bFontInterchar);
                continue;
            }
            ++lineCurrent;
        }
        return lineWidth;
    }

    private static int[] getWordWidth(int fromPos, int toPos) {
        int wordWidth = 0;
        int spaceId = toPos - 1;
        int[] result = new int[2];
        try {
            for (int i = fromPos; i < toPos; ++i) {
                int charId = bArrText[i];
                if (charId <= -8) {
                    charId = 128 - (charId - -8);
                }
                if (charId >= 0) {
                    wordWidth += bArrFontW[charId] + bFontInterchar;
                    continue;
                }
                wordWidth += bFontSpace + bFontInterchar;
                spaceId = i;
                break;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        result[0] = wordWidth;
        result[1] = spaceId;
        return result;
    }

    public static final int getSymbolCount(byte[] text, int lineFirst, int lineLast, int textW) {
        int result = 0;
        int lineCur = 1;
        int length = text.length;
        for (int i = 0; i < length; ++i) {
            if (lineCur >= lineFirst && lineCur <= lineLast) {
                ++result;
                if (text[i] != -2) continue;
                ++lineCur;
                continue;
            }
            if (lineCur < lineFirst && text[i] == -2) {
                ++lineCur;
                continue;
            }
            if (lineCur > lineLast) break;
        }
        return result;
    }

    private static final int textWidthTotal(byte[] text) {
        int result = 0;
        int length = text.length;
        for (int i = 0; i < length; ++i) {
            result += (text[i] < 0 ? bFontSpace : bArrFontW[text[i]]) + bFontInterchar;
        }
        return result - bFontInterchar;
    }

    private static final int getCharIndex(int charId) {
        int result = charId;
        if (charId <= -8) {
            result = 128 - (charId - -8);
        }
        return result;
    }

    private static final int renderChar(int charId, int x, int y) {
        int charIndex = Gr2DText.getCharIndex(charId);
        if (charIndex >= 0) {
            Gr2D.setClip(x, y, bArrFontW[charIndex], bFontH);
            Gr2D.renderImage(IArrImage, x - iArrFontX[charIndex], y - iArrFontY[charIndex], 0);
        }
        if (charIndex >= 0) {
            return bArrFontW[charIndex] + bFontInterchar;
        }
        if (charIndex > -2) {
            return bFontSpace;
        }
        if (charIndex == -2) {
            return -8;
        }
        if (charIndex == -1) {
            return bFontSpace;
        }
        return 0;
    }

    public static final byte[] getText(int textId) {
        if (textId < -1) {
            return Gr2DText.getLangName(-textId - 2);
        }
        int length = sArrTextIndex[textId + 1] - sArrTextIndex[textId];
        byte[] result = GUtillArray.get(bArrText, (int)sArrTextIndex[textId], length);
        return result;
    }

    public static final void renderTextLine(byte[] text, int x, int y, int anchor) {
        Gr2DText.renderTextLine(text, x, y, bFontInterchar, anchor);
    }

    public static final void renderTextLine(byte[] text, int x, int y, int interchar, int anchor) {
        int length = text.length;
        int width = Gr2DText.getTextWidth(text) + interchar * length;
        if ((anchor & 3) != 0) {
            x += Gr2DText.anchorOffset(anchor & 3, width);
        }
        if (anchor > 3) {
            y += Gr2DText.anchorOffset(anchor >>> 2, bFontH);
        }
        Gr2D.saveClip();
        for (int i = 0; i < length; ++i) {
            x += Gr2DText.renderChar(text[i], x, y) - bFontInterchar + interchar;
        }
        Gr2D.restoreClip();
    }

    private static int anchorOffset(int anchor, int size) {
        return -(size >>> TEXTS_ANCHOR_SHIFT[anchor]);
    }

    public static final byte[] convertString(String value) {
        int valLen = value.length();
        byte[] res = new byte[valLen];
        int offset = 0;
        int k = 0;
        for (int i = 0; i < valLen; ++i) {
            if (value.charAt(i) == ' ') {
                res[i] = -1;
                continue;
            }
            if (value.charAt(i) == '\n') {
                res[i] = -2;
                continue;
            }
            k = 0;
            int pos = sFontMap.indexOf(value.charAt(i));
            if (pos == -1) continue;
            for (int j = pos; j > 0; --j) {
                if (sFontMap.charAt(j) != '\n') continue;
                k = (short)(k + 1);
            }
            res[i] = (byte)(k < 128 ? k : -(8 + (k - 128)));
        }
        byte[] temp = new byte[valLen -= offset];
        System.arraycopy(res, 0, temp, 0, valLen);
        return temp;
    }

    public static void updateText(int textId, short replaceId, String newText) {
        try {
            byte[] temp;
            int i;
            byte[] replaceText = Gr2DText.convertString(newText);
            int replaceTextLength = replaceText.length;
            int textLength = sArrTextIndex[textId + 1] - sArrTextIndex[textId];
            byte[] text = new byte[textLength];
            System.arraycopy(bArrText, sArrTextIndex[textId], text, 0, textLength);
            for (i = 0; i < textLength; ++i) {
                if (text[i] != replaceId) continue;
                temp = new byte[textLength + replaceTextLength - 1];
                System.arraycopy(text, 0, temp, 0, i);
                System.arraycopy(replaceText, 0, temp, i, replaceTextLength);
                System.arraycopy(text, i + 1, temp, i + replaceTextLength, textLength - i - 1);
                text = temp;
                break;
            }
            if (i != textLength) {
                temp = new byte[bArrText.length - 1 + replaceTextLength];
                int firstFrom = 0;
                int firstInto = 0;
                int length = sArrTextIndex[textId];
                System.arraycopy(bArrText, firstFrom, temp, firstInto, length);
                firstFrom = 0;
                firstInto = sArrTextIndex[textId];
                length = text.length;
                System.arraycopy(text, firstFrom, temp, firstInto, length);
                firstFrom = sArrTextIndex[textId + 1];
                firstInto = sArrTextIndex[textId] + text.length;
                length = bArrText.length - sArrTextIndex[textId + 1];
                System.arraycopy(bArrText, firstFrom, temp, firstInto, length);
                bArrText = temp;
                int count = sArrTextIndex.length;
                i = textId + 1;
                while (i < count) {
                    int n = i++;
                    sArrTextIndex[n] = (short)(sArrTextIndex[n] + (short)(replaceTextLength - 1));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        IArrImage = null;
        iLangCur = 0;
        iLangCount = 0;
    }
}

