/*
 * Decompiled with CFR 0.152.
 */
package ng.games.pacman.levels;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class Level {
    public static final byte EMPTY_SPACE = 0;
    public static final byte FOOD = 1;
    public static final byte WATCH = 2;
    public static final byte PHONE = 3;
    public static final byte CAKE = 4;
    public static final byte WINE = 5;
    public static final byte MONSTER = 6;
    public static final byte PLAYER = 7;
    public static final byte WALL = 8;
    private byte[][] levelMap;
    private static Level[] loadedLevels;
    private int playerX;
    private int playerY;
    private int[] monstersX;
    private int[] monstersY;
    private int[] startMonstersX;
    private int[] startMonstersY;
    private int foodCount;
    private int startPlayerX;
    private int startPlayerY;
    private short levelWidth;
    private short levelHeight;

    private Level(byte[][] byArray) {
        int n;
        this.levelMap = byArray;
        this.levelWidth = (short)byArray.length;
        this.levelHeight = (short)byArray[0].length;
        Vector<int[]> vector = new Vector<int[]>();
        for (n = 0; n < this.levelWidth; ++n) {
            block6: for (int i = 0; i < this.levelHeight; ++i) {
                switch (this.getObjectAt(n, i)) {
                    case 1: {
                        ++this.foodCount;
                        continue block6;
                    }
                    case 6: {
                        vector.addElement(new int[]{n, i});
                        this.setObjectAt(n, i, (byte)0);
                        continue block6;
                    }
                    case 7: {
                        this.playerX = n;
                        this.playerY = i;
                        this.startPlayerX = n;
                        this.startPlayerY = i;
                        this.setObjectAt(n, i, (byte)0);
                    }
                }
            }
        }
        this.monstersX = new int[vector.size()];
        this.monstersY = new int[vector.size()];
        this.startMonstersX = new int[vector.size()];
        this.startMonstersY = new int[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            int[] nArray = (int[])vector.elementAt(n);
            this.monstersX[n] = nArray[0];
            this.monstersY[n] = nArray[1];
            this.startMonstersX[n] = nArray[0];
            this.startMonstersY[n] = nArray[1];
        }
    }

    private Level() {
    }

    public int getFoodCount() {
        return this.foodCount;
    }

    public void setFoodCount(int n) {
        this.foodCount = n;
    }

    private static Level loadFromStream(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readShort();
        short s = dataInputStream.readShort();
        byte[][] byArray = new byte[n][s];
        for (int i = 0; i < n; ++i) {
            dataInputStream.read(byArray[i]);
        }
        Level level = new Level(byArray);
        return level;
    }

    public static void loadLevelPack(String string) throws IOException {
        Vector<Level> vector = new Vector<Level>();
        InputStream inputStream = new Object().getClass().getResourceAsStream("/" + string);
        System.out.println("is = " + inputStream);
        System.out.println("resourceName = " + string);
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        do {
            Level level = Level.loadFromStream(dataInputStream);
            vector.addElement(level);
        } while (dataInputStream.readByte() != 0);
        loadedLevels = new Level[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            Level.loadedLevels[i] = (Level)vector.elementAt(i);
        }
        dataInputStream.close();
    }

    public static int getLevelsCount() {
        return loadedLevels.length;
    }

    public int getWidth() {
        return this.levelWidth;
    }

    public int getHeight() {
        return this.levelHeight;
    }

    public static Level getLevel(int n) {
        return loadedLevels[n].copyLevel();
    }

    private Level copyLevel() {
        int n;
        Level level = new Level();
        level.levelMap = new byte[this.levelWidth][this.levelHeight];
        for (n = 0; n < this.levelWidth; ++n) {
            for (int i = 0; i < this.levelHeight; ++i) {
                level.levelMap[n][i] = this.levelMap[n][i];
            }
        }
        level.monstersX = new int[this.getMonstersCount()];
        level.monstersY = new int[this.getMonstersCount()];
        level.startMonstersX = new int[this.getMonstersCount()];
        level.startMonstersY = new int[this.getMonstersCount()];
        for (n = 0; n < this.getMonstersCount(); ++n) {
            level.monstersX[n] = this.monstersX[n];
            level.monstersY[n] = this.monstersY[n];
            level.startMonstersX[n] = this.startMonstersX[n];
            level.startMonstersY[n] = this.startMonstersY[n];
        }
        level.playerX = this.playerX;
        level.playerY = this.playerY;
        level.levelWidth = this.levelWidth;
        level.levelHeight = this.levelHeight;
        level.foodCount = this.foodCount;
        level.startPlayerX = this.startPlayerX;
        level.startPlayerY = this.startPlayerY;
        return level;
    }

    public byte getObjectAt(int n, int n2) {
        return this.levelMap[n][n2];
    }

    public void setObjectAt(int n, int n2, byte by) {
        this.levelMap[n][n2] = by;
    }

    public int getMonstersCount() {
        return this.monstersX.length;
    }

    public int getMonsterX(int n) {
        return this.monstersX[n];
    }

    public int getMonsterY(int n) {
        return this.monstersY[n];
    }

    public void setMonsterPosition(int n, int n2, int n3) {
        this.monstersX[n] = n2;
        this.monstersY[n] = n3;
    }

    public int getPlayerX() {
        return this.playerX;
    }

    public int getPlayerY() {
        return this.playerY;
    }

    public void setPlayerPosition(int n, int n2) {
        this.playerX = n;
        this.playerY = n2;
    }

    public void log() {
        for (int i = 0; i < this.levelHeight; ++i) {
            for (int j = 0; j < this.levelWidth; ++j) {
                System.out.print(this.getObjectAt(j, i));
            }
            System.out.println();
        }
    }

    public boolean isIntersectingWall(int n, int n2, int n3, int n4) {
        int n5 = n / 16;
        int n6 = n2 / 16;
        int n7 = (n + n3 - 1) / 16;
        int n8 = (n2 + n4 - 1) / 16;
        return this.getObjectAt(n5, n6) >= 8 || this.getObjectAt(n7, n6) >= 8 || this.getObjectAt(n5, n8) >= 8 || this.getObjectAt(n7, n8) >= 8;
    }

    public void resetObjects() {
        this.playerX = this.startPlayerX;
        this.playerY = this.startPlayerY;
        for (int i = 0; i < this.monstersX.length; ++i) {
            this.monstersX[i] = this.startMonstersX[i];
            this.monstersY[i] = this.startMonstersY[i];
        }
    }

    public static void freeLevels() {
        loadedLevels = null;
    }
}

