/*
 * Decompiled with CFR 0.152.
 */
package ng.games.pacman.sprites;

import ng.games.pacman.GameManager;
import ng.games.pacman.sprites.MovableObject;
import ng.games.pacman.util.image.ImageFramer;

public class AIPlayer
extends MovableObject {
    private int index;
    private boolean turnProhibited = false;
    private int oldXCell;
    private int oldYCell;
    private MovableObject victim;
    private int prefferedTurnDirection;
    private int prefferedMoveDirection;

    public AIPlayer(ImageFramer imageFramer, int n, int n2, int n3) {
        super(imageFramer, n, n2, n3);
        this.calcPrefferedDirections();
    }

    public int getCurrentFrameIndex() {
        if (GameManager.getInstance().isInGodMode()) {
            return this.getFramesCount() * 4 + this.getDirection() * this.getFramesCount() + super.getCurrentFrameIndex();
        }
        return this.getDirection() * this.getFramesCount() + super.getCurrentFrameIndex();
    }

    protected void cellReached(int n, int n2) {
        this.makeTurn(this.victim.getNextPointDirection(n, n2, this.prefferedMoveDirection, this.prefferedTurnDirection));
        if (GameManager.randomInt(100) == 0) {
            this.calcPrefferedDirections();
        }
    }

    private void calcPrefferedDirections() {
        this.prefferedMoveDirection = GameManager.randomInt(2);
        this.prefferedTurnDirection = GameManager.randomInt(2);
    }

    public void updateLogic(long l) {
        if (this.isPlayerCatched()) {
            GameManager.getInstance().playerCatched();
        }
        super.updateLogic(l);
    }

    private boolean isPlayerCatched() {
        boolean bl;
        if (this.getXPos() < this.victim.getXPos()) {
            bl = this.victim.getXPos() < this.getXPos() + 16 - 2;
        } else {
            boolean bl2 = bl = this.getXPos() < this.victim.getXPos() + 16 - 2;
        }
        boolean bl3 = this.getYPos() < this.victim.getYPos() ? this.victim.getYPos() < this.getYPos() + 16 - 2 : this.getYPos() < this.victim.getYPos() + 16 - 2;
        boolean bl4 = bl && bl3;
        return bl4;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public void setVictim(MovableObject movableObject) {
        this.victim = movableObject;
    }
}

