/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class EGameView {
    public static int iFieldWidth;
    private static final int iTopSpace = 0;
    private static final int iLeftSpace = 0;
    private static final int iRightSpace = 0;
    private static final int NUMBER_FIELD_LEN = 5;
    public static int iBrickW;
    public static int iBrickH;
    private static int iFieldTop;
    private static int iFieldLeft;
    private static int iFieldRight;
    private static int iFieldBottom;
    private static int iInfoTop;
    private static int iInfoLeft;
    private static int iNumberLeft;
    private static int iFillIndex;
    private static int iFillStep;
    private static final int STEP_PER_ONE = 3;
    public static boolean bIsOnFill;
    private static long lBlinkTime;
    private static long lBlink2Time;
    public static boolean bBackgroundIsInvalid;
    public static final int HIGHSCORE = 0;
    public static final int SCORE = 1;
    public static final int SPEED = 2;
    public static final int LEVEL = 3;
    public static final int STATE = 4;
    private static final int[] iArrNumberY;
    private static final int[] iArrTextY;
    private static final int[] iArrTextX;
    private static final short[] sArrTextId;
    private static final byte[] bArrTextState;
    private static final int[] iArrBtnPos;
    public static Image IBack;
    private static Graphics GBack;
    private static int renderedHiScore;
    private static int renderedScore;
    private static int renderedSpeed;
    private static int renderedLevel;

    public static final void init() {
        iBrickW = Gr2DFrame.getSubImageW(1);
        iBrickH = Gr2DFrame.getSubImageH(1);
        iFieldLeft = Gr2DFrame.getSubImageW(6);
        iFieldTop = Gr2DFrame.getSubImageH(6);
        iFieldRight = GUtillScreen.w - iBrickW - 2;
        iFieldBottom = iFieldTop + 20 * iBrickH;
        lBlinkTime = System.currentTimeMillis();
        EGameView.createPos();
        EGameView.createBack();
    }

    public static final void fill(boolean full) {
        if (full) {
            iFillIndex = 0;
            iFillStep = 1;
        } else {
            iFillIndex = 200;
            iFillStep = -1;
        }
        bIsOnFill = true;
    }

    public static final void disableFill() {
        if (E.MATRIX_SKIN_RENDERING_ON) {
            GameField.stopMatrixFilling();
        }
        bIsOnFill = false;
    }

    public static final void render(GameLogic model) {
        if (System.currentTimeMillis() > lBlinkTime + 100L) {
            GameFieldItem.blink1IsVisible = !GameFieldItem.blink1IsVisible;
            lBlinkTime = System.currentTimeMillis();
        }
        if (System.currentTimeMillis() > lBlink2Time + 300L) {
            GameFieldItem.blink2isVisible = !GameFieldItem.blink2isVisible;
            lBlink2Time = System.currentTimeMillis();
        }
        if (bBackgroundIsInvalid) {
            Gr2D.saveClip();
            Gr2D.setClip(0, 0, GUtillScreen.w, GUtillScreen.h);
            Gr2D.renderImage(IBack, 0, 0, 20);
            Gr2D.restoreClip();
            renderedHiScore = -1;
            renderedScore = -1;
            renderedSpeed = -1;
            renderedLevel = -1;
            GameField.fieldIsInvalid = true;
            EGameView.renderButtons();
            bBackgroundIsInvalid = false;
        }
        for (int i = 0; i < 5; ++i) {
            if (bArrTextState[i] != 1) continue;
            Gr2DFrame.renderSubImage(sArrTextId[i], iArrTextX[i], iArrTextY[i], 20);
        }
        if (renderedHiScore != 0) {
            EGameView.renderNumberField(0, EGame.iHighscore);
        }
        if (renderedScore != 1) {
            EGameView.renderNumberField(1, model.score);
        }
        if (renderedSpeed != 2) {
            EGameView.renderNumberField(2, EGame.iSpeed);
        }
        if (renderedLevel != 3) {
            EGameView.renderNumberField(3, EGame.iLevel);
        }
        EGameView.renderInfoField(model.info);
        if (!(GameField.USE_MATRIX_FILLING && E.MATRIX_SKIN_RENDERING_ON || !bIsOnFill)) {
            if ((iFillIndex += 3 * iFillStep) > 199) {
                iFillIndex = 199;
            } else if (iFillIndex < 0) {
                iFillIndex = 0;
            }
        }
        if (GameField.USE_MATRIX_FILLING && E.MATRIX_SKIN_RENDERING_ON && bIsOnFill) {
            bIsOnFill = GameField.FillMatrixStyle(iFillStep == 1);
        }
        GameField.render(0 + iFieldTop, 0 + iFieldLeft, model, bIsOnFill ? iFillIndex : -1);
        if (bIsOnFill && (!GameField.USE_MATRIX_FILLING || !E.MATRIX_SKIN_RENDERING_ON) && (iFillIndex == 199 && iFillStep == 1 || iFillIndex == 0 && iFillStep == -1)) {
            bIsOnFill = false;
        }
        if (!(model.active || bIsOnFill || EGame.logic.gameup || EGame.iStateCur != 0 && EGame.iStateCur != 1)) {
            Gr2DText.renderTextLine(34, 0 + iFieldLeft + 5 * iBrickW, GUtillScreen.h2, 5);
            bBackgroundIsInvalid = true;
        }
    }

    public static final void setTextState(int id, byte state) {
        EGameView.bArrTextState[id] = state;
    }

    private static final void createPos() {
        short numberH = Gr2DFrame.getSubImageH(24);
        EGameView.iArrTextX[0] = iFieldRight - 0 - Gr2DFrame.getSubImageW(13) + 5;
        EGameView.iArrTextY[0] = 0 + iFieldTop;
        EGameView.iArrNumberY[0] = 0 + iFieldTop + Gr2DFrame.getSubImageH(13) + 2;
        EGameView.iArrTextY[1] = iArrNumberY[0] + numberH + 2;
        EGameView.iArrTextX[1] = iFieldRight - 0 - Gr2DFrame.getSubImageW(10);
        EGameView.iArrNumberY[1] = iArrTextY[1] + Gr2DFrame.getSubImageH(10) + 2;
        EGameView.iArrNumberY[2] = 0 + iFieldBottom - numberH;
        EGameView.iArrTextY[2] = iArrNumberY[2] - 2 - Gr2DFrame.getSubImageH(9);
        EGameView.iArrTextX[2] = iFieldRight - 0 - Gr2DFrame.getSubImageW(9);
        EGameView.iArrNumberY[3] = iArrTextY[2] - 2 - numberH;
        EGameView.iArrTextY[3] = iArrNumberY[3] - 2 - Gr2DFrame.getSubImageH(11);
        EGameView.iArrTextX[3] = iFieldRight - 0 - Gr2DFrame.getSubImageW(11);
        EGameView.iArrTextY[4] = iArrNumberY[1] + numberH + 2;
        EGameView.iArrTextX[4] = iFieldRight - 0 - Gr2DFrame.getSubImageW(12);
        iInfoTop = iArrTextY[4] + Gr2DFrame.getSubImageH(12) + 4;
        iInfoLeft = iFieldRight - 0 - iBrickW * 4;
        EGameView.iArrBtnPos[0] = 0 + iFieldBottom + Gr2DFrame.getSubImageH(4) + 1;
        EGameView.iArrBtnPos[1] = 4;
        EGameView.iArrBtnPos[2] = GUtillScreen.w - 4 - Gr2DFrame.getSubImageW(27);
        short subw = Gr2DFrame.getSubImageW(24);
        iNumberLeft = iFieldRight - 0 - 5 * subw;
    }

    private static final void createBack() {
        IBack = Gr2D.createImage(GUtillScreen.w, GUtillScreen.h);
        GBack = IBack.getGraphics();
        if (E.bCurrentSkin == 4) {
            Image bg = Gr2D.createImage("/bg");
            Gr2D.renderImage(GBack, bg, 0, 0, 20);
            bg = null;
            System.gc();
        } else {
            Gr2D.renderRectGradient(GBack, 0, 0, GUtillScreen.w, GUtillScreen.h, Constants.GRADIENT_TOP[E.bCurrentSkin], Constants.GRADIENT_BOTTOM[E.bCurrentSkin]);
        }
        int subx = 0;
        int suby = 0;
        Gr2DFrame.renderSubImage(GBack, 6, subx, suby, 20);
        iFieldWidth = 0 + iFieldLeft + 10 * iBrickW + 6;
        subx = 0 + iFieldLeft + 10 * iBrickW;
        suby = 0;
        Gr2DFrame.renderSubImage(GBack, 7, subx, suby, 20);
        subx = 0;
        suby = 0 + iFieldTop + 20 * iBrickH;
        Gr2DFrame.renderSubImage(GBack, 2, subx, suby, 20);
        suby = 0 + iFieldTop + 20 * iBrickH;
        subx = 0 + iFieldLeft + 10 * iBrickW;
        Gr2DFrame.renderSubImage(GBack, 5, subx, suby, 20);
        subx = 0 + iFieldLeft;
        suby = 0;
        Gr2DFrame.renderSubImgOnCount(GBack, 3, subx, suby, 10, 1, 20);
        subx = 0 + iFieldLeft;
        suby = 0 + iFieldTop + 20 * iBrickH;
        Gr2DFrame.renderSubImgOnCount(GBack, 4, subx, suby, 10, 1, 20);
        subx = 0;
        suby = 0 + iFieldTop;
        Gr2DFrame.renderSubImgOnCount(GBack, 8, subx, suby, 1, 20, 20);
        subx = 0 + iFieldLeft + 10 * iBrickW;
        suby = 0 + iFieldTop;
        Gr2DFrame.renderSubImgOnCount(GBack, 8, subx, suby, 1, 20, 20);
        subx = 0 + iFieldLeft;
        suby = 0 + iFieldTop;
        Gr2DFrame.renderSubImgOnArea(GBack, 0, subx, suby, iBrickW * 10, iBrickH * 20, 20);
        for (int i = 0; i < 4; ++i) {
            Gr2DFrame.renderSubImgOnCount(GBack, 24, iNumberLeft - 5, iArrNumberY[i], 5, 1, 0);
        }
    }

    private static final void renderNumberField(int id, int value) {
        int subw = Gr2DFrame.getSubImageW(24) + 1;
        byte[] number = Gr2DText.convertInt(value);
        int count = number.length < 5 ? number.length : 5;
        for (int i = 0; i < count; ++i) {
            Gr2DFrame.renderSubImage(24, iFieldRight - 0 - i * subw, iArrNumberY[id], 20);
            Gr2DFrame.renderSubImage(14 + number[count - 1 - i], iFieldRight - 0 - i * subw, iArrNumberY[id], 20);
        }
    }

    private static final void renderInfoField(boolean[] info) {
        if (info != null && info.length > 0) {
            int[] pos = new int[2];
            for (int i = 0; i < 16; ++i) {
                EGameView.getFieldPos(iInfoTop, iInfoLeft, 4, i, pos);
                if (info[i]) {
                    Gr2DFrame.renderSubImage(1, pos[0], pos[1], 20);
                    continue;
                }
                Gr2DFrame.renderSubImage(0, pos[0], pos[1], 20);
            }
        }
    }

    private static final void renderButtons() {
        Gr2DFrame.renderSubImage(26, iArrBtnPos[1], iArrBtnPos[0], 20);
        int img = 28;
        if (EGame.iStateCur == 1) {
            img = 27;
        }
        Gr2DFrame.renderSubImage(img, iArrBtnPos[2], iArrBtnPos[0], 20);
    }

    public static final int[] getFieldPos(int top, int left, int w, int index, int[] pos) {
        pos[1] = top + index / w * iBrickH;
        pos[0] = left + index % w * iBrickW;
        return pos;
    }

    public static final int getBrickIndex(int[] pos) {
        int index = (pos[1] - 0 + iFieldTop) / iBrickH * 10;
        return index += (pos[0] - iFieldLeft - 0) / iBrickW;
    }

    public static final int[] getBrickPos(int index) {
        int[] pos = new int[2];
        pos[1] = 0 + iFieldTop + index / 10 * iBrickH;
        pos[0] = 0 + iFieldLeft + index % 10 * iBrickW;
        return pos;
    }

    public static boolean infoPressed(int[] pos) {
        return pos[0] >= iInfoLeft && pos[0] <= iInfoLeft + iBrickW * 4 && pos[1] >= iInfoTop && pos[1] <= iInfoTop + iBrickH * 4;
    }

    static {
        iFillIndex = -1;
        iFillStep = 0;
        bIsOnFill = false;
        lBlinkTime = 0L;
        lBlink2Time = 0L;
        bBackgroundIsInvalid = true;
        iArrNumberY = new int[4];
        iArrTextY = new int[5];
        iArrTextX = new int[5];
        sArrTextId = new short[]{13, 10, 9, 11, 12};
        bArrTextState = new byte[]{1, 1, 1, 1, 0};
        iArrBtnPos = new int[3];
        IBack = null;
        GBack = null;
        renderedHiScore = -1;
        renderedScore = -1;
        renderedSpeed = -1;
        renderedLevel = -1;
    }
}

