/*
 * Decompiled with CFR 0.152.
 */
public abstract class GameLogic {
    protected int score = 0;
    protected int CurrentScore = 0;
    public boolean active = false;
    protected boolean gameover = false;
    public boolean gameup = false;
    public static final int INFO_H = 4;
    public static final int INFO_LEN = 16;
    protected static final int[] COLLISION_FIGURE = new int[]{0, 3, 11, 12, 21, 22, 30, 33};
    protected static final int[] COLLISION_CLEAN_FIGURE = new int[]{1, 2, 10, 13, 20, 23, 31, 32};
    protected final boolean[] info = new boolean[16];
    protected int[] figure_pos;
    protected int[] figure_elem;
    private int life_max;
    protected int life = 0;
    public int firstKeydownDelay = 90;
    public int repeatKeydownDelay = 20;
    private long lLastKeyPressedTime = 0L;
    public boolean fillOnSpeedUp = false;
    protected byte bShowCollision = 0;

    public GameLogic(int figureSize) {
        this.figure_pos = new int[figureSize];
        this.figure_elem = new int[figureSize];
        this.life_max = 0;
        this.clear();
    }

    public GameLogic(int figureSize, int lifeMax) {
        GameFieldItem.TAIN_HIGHLIGHT_1_TARIN = true;
        this.figure_pos = new int[figureSize];
        this.figure_elem = new int[figureSize];
        this.life_max = lifeMax;
        this.clear();
    }

    protected final void clear() {
        if (!this.gameup) {
            GUtillArray.fill(this.info, false);
            GUtillArray.fill(this.figure_pos, -1);
            GUtillArray.fill(this.figure_elem, 0);
            this.updateLifeInfo();
            this.gameover = false;
            this.gameup = false;
            this.active = false;
            this.score = 0;
            this.CurrentScore = 0;
            this.life = this.life_max;
            this.updateLifeInfo();
            EGameView.bBackgroundIsInvalid = true;
        }
    }

    protected void save() throws Exception {
        GUtillIo.writeInt(this.life);
        GUtillIo.writeInt(this.score);
        GUtillIo.writeInt(this.CurrentScore);
        GUtillIo.writeBooleanArray(this.info);
        GUtillIo.writeInt(this.figure_pos.length);
        GUtillIo.writeArray(this.figure_pos);
        GUtillIo.writeArray(this.figure_elem);
    }

    protected void load() throws Exception {
        this.gameover = false;
        this.gameup = false;
        this.active = false;
        this.life = GUtillIo.readInt();
        this.score = GUtillIo.readInt();
        this.CurrentScore = GUtillIo.readInt();
        GUtillIo.readBooleanArray(this.info);
        int len = GUtillIo.readInt();
        this.figure_pos = GUtillIo.readIntArray(len);
        this.figure_elem = GUtillIo.readIntArray(len);
    }

    protected final boolean canUpdate() {
        return !this.gameover && !this.gameup;
    }

    protected final void lifeDecr() {
        if (this.life >= 1) {
            --this.life;
            this.updateLifeInfo();
        }
        if (this.life == 0) {
            this.gameover = true;
        } else {
            this.placePlayer();
        }
        EGameView.bBackgroundIsInvalid = true;
    }

    protected void placePlayer() {
    }

    public void updateLevel(int level) {
    }

    public void updateState() {
    }

    public void updateKeys() {
        boolean keyWasUsed = false;
        for (int currentKey = 0; currentKey < 45; ++currentKey) {
            if (!E.keyIsPressed(currentKey)) continue;
            boolean delayPassed = false;
            if (E.kPressedCount[currentKey] < 2 && !E.kIgnoreFirstKeyDownDelay[currentKey]) {
                delayPassed = this.lLastKeyPressedTime + (long)this.firstKeydownDelay < System.currentTimeMillis();
            } else {
                boolean bl = delayPassed = this.lLastKeyPressedTime + (long)this.repeatKeydownDelay < System.currentTimeMillis();
            }
            if (!delayPassed) continue;
            this.keyClicked(currentKey);
            if (E.kPressedCount[currentKey] < 254) {
                int n = currentKey;
                E.kPressedCount[n] = (short)(E.kPressedCount[n] + 1);
            }
            keyWasUsed = true;
        }
        if (keyWasUsed) {
            this.lLastKeyPressedTime = System.currentTimeMillis();
        }
    }

    protected void collisionAtPos(int pos) {
        int x = pos % 10;
        int y = pos / 10;
        if (x > 6) {
            x = 6;
        }
        if (y > 16) {
            y = 16;
        }
        pos = x + 10 * y;
        int i = 0;
        for (i = 0; i < COLLISION_FIGURE.length; ++i) {
            GameField.getItem(COLLISION_FIGURE[i] + pos).setBrickType(1);
            GameField.getItem(COLLISION_FIGURE[i] + pos).setIsBlinking(true);
            GameField.getItem(COLLISION_FIGURE[i] + pos).setIsHotBrick(true);
        }
        for (i = 0; i < COLLISION_CLEAN_FIGURE.length; ++i) {
            GameField.getItem(COLLISION_CLEAN_FIGURE[i] + pos).setBrickType(0);
        }
        this.bShowCollision = (byte)(this.bShowCollision + 1);
    }

    public void keyClicked(int key) {
    }

    public boolean updateEvent() {
        return false;
    }

    private final void updateLifeInfo() {
        if (this.life_max > 0) {
            for (int i = 1; i <= 4; ++i) {
                this.info[16 - i * 4] = i <= this.life;
            }
        }
    }
}

