/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public final class SameGame2
extends MIDlet
implements CommandListener {
    public static final int COLUMNS = 14;
    public static final int ROWS = 11;
    public static final int SIZEX = 9;
    public static final int SIZEY = 9;
    public static final int STATE_PLAYING = 1;
    public static final int STATE_MENU = 2;
    public static final int MENU_MAIN = 1;
    public static final int MENU_INGAME = 2;
    public static final int MENU_GAMEOVER = 3;
    public ClickField theField = new ClickField(14, 11, 9, 9);
    private Display display = Display.getDisplay((MIDlet)this);
    private SameGame2Canvas theCanvas;
    private RecordStore rs;
    private Command menuCommand;
    public int xp = 0;
    public int yp = 0;
    public int score = 0;
    public int hiScore = 0;
    public int lowScore = 0;
    public int nrGames = 0;
    public int totScore = 0;
    public int totLeft = 0;
    public int mostRemoved = 0;
    public int leastLeft = -1;
    public int mostLeft = 0;
    public int gameState = 2;
    public int activeMenu = 1;
    public int menuPos = 0;
    public static String[] infoBoxStr = new String[8];
    public static int infoBoxRows = 0;
    public static int infoBoxCol = 0x8080E8;

    public SameGame2() {
        this.updateMenu();
    }

    public void up() {
        --this.yp;
        if (this.yp < 0) {
            this.yp = 0;
        } else {
            this.theCanvas.paintField(this.xp, this.yp, 1, 2);
        }
    }

    public void down() {
        ++this.yp;
        if (this.yp > 10) {
            this.yp = 10;
        } else {
            this.theCanvas.paintField(this.xp, this.yp - 1, 1, 2);
        }
    }

    public void left() {
        --this.xp;
        if (this.xp < 0) {
            this.xp = 0;
        } else {
            this.theCanvas.paintField(this.xp, this.yp, 2, 1);
        }
    }

    public void right() {
        ++this.xp;
        if (this.xp > 13) {
            this.xp = 13;
        } else {
            this.theCanvas.paintField(this.xp - 1, this.yp, 2, 1);
        }
    }

    public void remove() {
        int n = this.theField.checkClick(this.xp, this.yp);
        if (n > 1) {
            if (n > this.mostRemoved) {
                this.mostRemoved = n;
            }
            while (n > 0) {
                this.score += n;
                --n;
            }
            this.theCanvas.repaintMode = 0;
            this.theCanvas.repaint();
            if (this.theField.countRemovable() == 0) {
                int n2 = this.theField.countBlocks();
                this.totLeft += n2;
                if (this.leastLeft == -1 || n2 < this.leastLeft) {
                    this.leastLeft = n2;
                }
                if (n2 > this.mostLeft) {
                    this.mostLeft = n2;
                }
                this.score = n2 == 0 ? (this.score += 250) : (this.score += 125 / n2);
                ++this.nrGames;
                this.totScore += this.score;
                if (this.score > this.hiScore) {
                    this.hiScore = this.score;
                }
                if (this.score < this.lowScore || this.lowScore == 0) {
                    this.lowScore = this.score;
                }
                this.SaveStats();
                this.gameState = 2;
                this.activeMenu = 3;
                this.menuPos = 0;
                this.updateMenu();
                this.theCanvas.repaintMode = 0;
                this.theCanvas.repaint();
            }
        }
    }

    public void menuUp() {
        --this.menuPos;
        this.updateMenu();
        this.theCanvas.RepaintInfoBox();
    }

    public void menuDown() {
        ++this.menuPos;
        this.updateMenu();
        this.theCanvas.RepaintInfoBox();
    }

    public void menuSelect() {
        switch (this.activeMenu) {
            case 1: {
                switch (this.menuPos) {
                    case 0: {
                        this.gameState = 1;
                        this.theCanvas.repaintMode = 0;
                        this.theCanvas.repaint();
                        break;
                    }
                    case 1: {
                        this.ShowStats();
                        break;
                    }
                    case 2: {
                        this.ShowHelp();
                        break;
                    }
                    case 3: {
                        this.destroyApp(false);
                        this.notifyDestroyed();
                    }
                }
                break;
            }
            case 2: {
                switch (this.menuPos) {
                    case 0: {
                        this.gameState = 1;
                        this.theCanvas.repaintMode = 0;
                        this.theCanvas.repaint();
                        break;
                    }
                    case 1: {
                        this.ShowStats();
                        break;
                    }
                    case 2: {
                        this.ShowHelp();
                        break;
                    }
                    case 3: {
                        this.gameState = 2;
                        this.activeMenu = 1;
                        this.menuPos = 0;
                        this.updateMenu();
                        this.InitGame();
                        this.theCanvas.repaintMode = 0;
                        this.theCanvas.repaint();
                    }
                }
                break;
            }
            case 3: {
                this.gameState = 2;
                this.activeMenu = 1;
                this.menuPos = 0;
                this.updateMenu();
                this.InitGame();
                this.theCanvas.repaintMode = 0;
                this.theCanvas.repaint();
            }
        }
    }

    public void updateMenu() {
        switch (this.activeMenu) {
            case 1: {
                if (this.menuPos < 0) {
                    this.menuPos = 0;
                }
                if (this.menuPos > 3) {
                    this.menuPos = 3;
                }
                SameGame2.infoBoxStr[0] = this.menuPos == 0 ? "   =Play=   " : "    Play    ";
                SameGame2.infoBoxStr[1] = this.menuPos == 1 ? "=Statistics=" : " Statistics ";
                SameGame2.infoBoxStr[2] = this.menuPos == 2 ? "=About/Help=" : " About/Help ";
                SameGame2.infoBoxStr[3] = this.menuPos == 3 ? "   =Exit=   " : "    Exit    ";
                infoBoxRows = 4;
                break;
            }
            case 2: {
                if (this.menuPos < 0) {
                    this.menuPos = 0;
                }
                if (this.menuPos > 3) {
                    this.menuPos = 3;
                }
                SameGame2.infoBoxStr[0] = this.menuPos == 0 ? "  =Resume=  " : "   Resume   ";
                SameGame2.infoBoxStr[1] = this.menuPos == 1 ? "=Statistics=" : " Statistics ";
                SameGame2.infoBoxStr[2] = this.menuPos == 2 ? "=About/Help=" : " About/Help ";
                SameGame2.infoBoxStr[3] = this.menuPos == 3 ? "=Main Menu= " : " Main Menu  ";
                infoBoxRows = 4;
                break;
            }
            case 3: {
                if (this.menuPos < 4) {
                    this.menuPos = 4;
                }
                if (this.menuPos > 4) {
                    this.menuPos = 4;
                }
                SameGame2.infoBoxStr[0] = "  Game Over!  ";
                String string = "" + this.score;
                while (string.length() < 5) {
                    string = " " + string;
                }
                SameGame2.infoBoxStr[1] = "Score:   " + string;
                string = "" + this.hiScore;
                while (string.length() < 5) {
                    string = " " + string;
                }
                SameGame2.infoBoxStr[2] = "Hiscore: " + string;
                SameGame2.infoBoxStr[3] = "              ";
                SameGame2.infoBoxStr[4] = "     =OK=     ";
                infoBoxRows = 5;
            }
        }
    }

    public void init() throws MIDletStateChangeException {
    }

    public void InitGame() {
        this.theField.randomizeField();
        this.xp = 0;
        this.yp = 0;
        this.score = 0;
    }

    public void startApp() {
        boolean bl = true;
        SdwUtil.Seed((int)System.currentTimeMillis());
        this.InitGame();
        this.theCanvas = new SameGame2Canvas(this);
        this.menuCommand = new Command("Menu", 5, 1);
        this.theCanvas.addCommand(this.menuCommand);
        this.theCanvas.setCommandListener(this);
        try {
            this.rs = RecordStore.openRecordStore((String)"SameGame2", (boolean)true);
        }
        catch (RecordStoreException recordStoreException) {
            bl = false;
        }
        if (bl) {
            this.LoadStats();
        }
        this.display.setCurrent((Displayable)this.theCanvas);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
    }

    public void ShowMainMenu() {
        if (this.gameState == 1) {
            this.gameState = 2;
            this.activeMenu = 2;
            this.menuPos = 0;
            this.updateMenu();
            this.theCanvas.repaintMode = 0;
            this.theCanvas.repaint();
        }
    }

    public void ShowHelp() {
        String string = "SameGame v2.0\n(C) 2005 Andreas Gustafsson\nhttp://sdw.webhop.net\nandreas.gustafsson@gmail.com\n\nInstructions:\nPress # for ingame menu.\nControl the cursor with 2,4,6,8.\nRemove groups of two or more connected pieces with the same color by pressing 5. Larger groups give more points.\nThere is also an extra bonus awarded at the end of the game (less pieces left - more bonus points).";
        Alert alert = new Alert("About/Help", string, null, null);
        alert.setTimeout(-2);
        this.display.setCurrent((Displayable)alert);
    }

    public void ShowStats() {
        String string = "Games played:" + this.nrGames + "\n";
        string = string + "Highscore:" + this.hiScore + "\n";
        string = this.lowScore != 0 ? string + "Lowscore:" + this.lowScore + "\n" : string + "Lowscore:-\n";
        string = this.nrGames != 0 ? string + "Avg.score:" + this.totScore / this.nrGames + "\n" : string + "Avg.score:-\n";
        string = this.leastLeft != -1 ? string + "Least blocks left:" + this.leastLeft + "\n" : string + "Least blocks left:-\n";
        string = this.mostLeft != 0 ? string + "Most blocks left:" + this.mostLeft + "\n" : string + "Most blocks left:-\n";
        string = this.nrGames != 0 ? string + "Avg.blocks left:" + this.totLeft / this.nrGames + "\n" : string + "Avg.blocks left:-\n";
        string = string + "Most removed in one move:" + this.mostRemoved;
        Alert alert = new Alert("Statistics", string, null, null);
        alert.setTimeout(-2);
        this.display.setCurrent((Displayable)alert);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.menuCommand) {
            this.ShowMainMenu();
        }
    }

    private void putInt(byte[] byArray, int n, int n2) {
        byArray[n + 0] = (byte)(n2 >> 24 & 0xFF);
        byArray[n + 1] = (byte)(n2 >> 16 & 0xFF);
        byArray[n + 2] = (byte)(n2 >> 8 & 0xFF);
        byArray[n + 3] = (byte)(n2 >> 0 & 0xFF);
    }

    private int getInt(byte[] byArray, int n) {
        return (byArray[n + 0] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    private void LoadStats() {
        try {
            RecordEnumeration recordEnumeration = this.rs.enumerateRecords(null, null, false);
            byte[] byArray = new byte[32];
            while (recordEnumeration.hasNextElement()) {
                int n = recordEnumeration.nextRecordId();
                if (32 != this.rs.getRecordSize(n)) continue;
                this.rs.getRecord(n, byArray, 0);
                this.nrGames = this.getInt(byArray, 0);
                this.hiScore = this.getInt(byArray, 4);
                this.lowScore = this.getInt(byArray, 8);
                this.totScore = this.getInt(byArray, 12);
                this.leastLeft = this.getInt(byArray, 16);
                this.mostLeft = this.getInt(byArray, 20);
                this.totLeft = this.getInt(byArray, 24);
                this.mostRemoved = this.getInt(byArray, 28);
            }
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    private void SaveStats() {
        int n = 1;
        byte[] byArray = new byte[32];
        this.putInt(byArray, 0, this.nrGames);
        this.putInt(byArray, 4, this.hiScore);
        this.putInt(byArray, 8, this.lowScore);
        this.putInt(byArray, 12, this.totScore);
        this.putInt(byArray, 16, this.leastLeft);
        this.putInt(byArray, 20, this.mostLeft);
        this.putInt(byArray, 24, this.totLeft);
        this.putInt(byArray, 28, this.mostRemoved);
        try {
            this.rs.setRecord(n, byArray, 0, byArray.length);
        }
        catch (InvalidRecordIDException invalidRecordIDException) {
            try {
                n = this.rs.addRecord(byArray, 0, byArray.length);
            }
            catch (RecordStoreException recordStoreException) {}
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }
}

