/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Game
extends PlatformGameEngine {
    public static final int GAME_SPEED = 100;
    public static final int FRAME_TIME_IN_LOCK = 100;
    public static boolean lockFps;
    public static final int ROCKS_DAY_COLOR = 10868479;
    public static final int ROCKS_DUSK_COLOR = 15454892;
    public static final int MAX_DESCENT_SPEED = 10;
    public static boolean isDoublePixel;
    private static final int PLAYER_PUSHING_SPEED = 3;
    protected static final int PLAYER_MAX_SPEED = 10;
    protected static final int PLAYER_ACCELERATE = 15;
    protected static final int PLAYER_BREAKING = 25;
    protected static final int PLAYER_JUMPING_SPEED = 10;
    protected static final int PLAYER_MAX_JUMP_TIME = 270;
    protected static final int PLAYER_JUMP_TIME_BONUS = 90;
    protected static final int PLAYER_NORMAL_FRAME_DELAY = 100;
    protected static final int PLAYER_IDLE_FRAME_DELAY = 1000;
    protected static final int HIT_SOMEONE_SPEED = 24;
    protected static final int HIT_BY_SOMEONE_SPEED = 12;
    protected static final int KILLED_SPEED = 10;
    protected static final int IMMORTAL_TIME = 1500;
    protected static final int IMMORTAL_BLINK_TIME = 100;
    public static final int DESCENT_TIME_TO_HIT = 80;
    public static final int PLAYER_GRAVITY = 72;
    public static final int GRAVITY = 48;
    private static final int CAMERA_SPEED = 10;
    private static final int LEVEL_TIME = 300;
    private static final int TIME_TIME = 750;
    private static final int LEVEL_HURRY_UP_TIME = 50;
    protected static final int PLAYER_ANIM_IDLE = 0;
    protected static final int PLAYER_ANIM_WALK = 1;
    protected static final int PLAYER_ANIM_RUN = 2;
    protected static final int PLAYER_ANIM_BREAKING = 3;
    protected static final int PLAYER_ANIM_JUMP = 4;
    protected static final int PLAYER_ANIM_DESCENT = 5;
    public static GameAnimation playerAnim;
    public static int fPlayerPrevPosX;
    public static int fPlayerPrevPosY;
    public static int fPlayerPosX;
    public static int fPlayerPosY;
    public static int fPlayerVX;
    public static int fPlayerVY;
    public static int isPlayerTurnRight;
    public static boolean isPlayerOnFloor;
    public static boolean isPlayerJumping;
    public static boolean isPlayerJumpAllowed;
    public static int playerMaxJumpTime;
    public static int playerJumpTime;
    public static int playerDescentTime;
    public static int playerAnimTime;
    public static int playerWidth;
    public static int playerHeight;
    public static int playerWidthInPixels;
    public static int playerHeightInPixels;
    public static int playerActiveAnim;
    public static int immortalTime;
    public static boolean isDieing;
    public static boolean playerOutOfScreenAllowed;
    public static int lastJumpfPosX;
    protected static int idleTime;
    private static GameAnimation[] enemiesAnim;
    private static Enemy[] enemies;
    private static GameAnimation[] specialsAnim;
    private static Special[] specials;
    private static Particle[] particles;
    public static GameAnimation tntAnim;
    public static GameAnimation flaxyAnim;
    public static Image maxStoneImage;
    public static Image[] boxExplodeImage;
    public static Image[] explosionImage;
    public static final int BUBBLE_OPEN = 0;
    public static final int BUBBLE_WHAT = 1;
    public static final int BUBBLE_SHERIFF = 2;
    public static final int BUBBLE_KEY = 3;
    public static final int BUBBLE_BILLY = 4;
    public static final int BUBBLE_FLAXY = 5;
    public static final int BUBBLE_TIME = 2000;
    public static final int BUBBLE_TIME1 = 500;
    public static final int BUBBLE_TIME2 = 1500;
    public static GameAnimation bubble;
    public static int bubbleHeightInPixels;
    protected static int playerBubbleType;
    protected static int playerBubbleTime;
    private int fCameraPosX;
    private int fCameraPosY;
    private Image waterImage1;
    private Image waterImage2;
    private boolean isWater;
    private int levelNum;
    private static int shakingTime;
    private static int littleShakingTime;
    private int exitPosX;
    private int exitPosY;
    private boolean isBigExit;
    private boolean isExitLock;
    private boolean isBoss;
    private int triggersNum;
    private int enemiesNum;
    private int specialNum;
    public static final int RAIN_DESCENT_SPEED = 24;
    public static final int RAIN_HEIGHT = 2048;
    public static final int RAIN_SIZE = 32;
    private int[] rainX;
    private int[] rainY;
    private int[] rainHeight;
    private boolean isRain;
    private static Special[] specGroup;
    public static final int LABEL_SIZE = 8;
    public static final int LABEL_SPEED = 4;
    private static int[] labelX;
    private static int[] labelY;
    private static int[] labelTimeToLive;
    private static String[] label;
    protected boolean endTable;
    protected boolean finalTable;
    private String[] endText = new String[4];
    private String[] endText2 = new String[4];
    private static int levelCoins;
    protected int endTableTime;
    private String levelName;
    private static int vibraTime;
    boolean isNewRecordTable;
    boolean isNewRecord;
    boolean isNewRealRecord;
    public static final int ALPHABET_IN_GAME = 0;
    public static int lineSpacing;
    public static int letterSpacing;
    public static final int GUI_PLAYER = 0;
    public static final int GUI_COIN = 1;
    public static final int GUI_TIME = 2;
    public static final int GUI_LIVE0 = 3;
    public static final int GUI_LIVE1 = 4;
    public static final int GUI_NUM = 5;
    private static Image[] guiImages;
    private static StringBuffer sb;
    private static int lives;
    private static int coins;
    protected static int score;
    private static boolean hasKey;
    private static int energy;
    public static final int TEXT_GREAT = 0;
    public static final int TEXT_HURRY_UP = 1;
    public static final int TEXT_BONUS = 2;
    public static final int TEXT_SCORE = 3;
    public static final int TEXT_GAME_OVER = 4;
    public static final int TEXT_LEVEL_DONE = 5;
    public static final int TEXT_LEVEL = 6;
    public static final int TEXT_NEW_RECORD = 7;
    public static final int TEXT_ENTER_NICK = 8;
    public static final int TEXT_GET_READY = 9;
    protected int fLoading;
    private boolean ready;
    private int loadingFrame = 2;
    private int gameTime;
    protected boolean actLeft;
    protected boolean actRight;
    protected boolean actUp;
    protected boolean actWalk;
    static boolean isInit;
    private static final short[] cosTab;

    private GameAnimation _loadAnimation(int n) {
        switch (n) {
            case 2: {
                return new GameAnimation(MainCanvas.midlet, "dude.ani", "dude", null, 176, 208);
            }
            case 4: {
                return new GameAnimation(MainCanvas.midlet, "froggy.ani", "froggy", null, 176, 208);
            }
            case 5: {
                return new GameAnimation(MainCanvas.midlet, "snake.ani", "snake", null, 176, 208);
            }
            case 6: {
                if (maxStoneImage == null) {
                    maxStoneImage = MainCanvas.createImage("/max_stone.png", isDoublePixel);
                }
                return new GameAnimation(MainCanvas.midlet, "max2.ani", "max2", null, 176, 208);
            }
            case 7: {
                if (tntAnim == null) {
                    tntAnim = new GameAnimation(MainCanvas.midlet, "dynamite.ani", "dynamite", null, 176, 208);
                }
                return new GameAnimation(MainCanvas.midlet, "max.ani", "max", null, 176, 208);
            }
            case 8: {
                return new GameAnimation(MainCanvas.midlet, "ted.ani", "ted", null, 176, 208);
            }
            case 9: {
                return new GameAnimation(MainCanvas.midlet, "fish.ani", "fish", null, 176, 208);
            }
            case 10: {
                return new GameAnimation(MainCanvas.midlet, "fish.ani", "fish", null, 176, 208);
            }
            case 11: {
                return new GameAnimation(MainCanvas.midlet, "boss.ani", "boss", null, 176, 208);
            }
            case 12: {
                return new GameAnimation(MainCanvas.midlet, "spring.ani", "spring", null, 176, 208);
            }
            case 16: {
                return new GameAnimation(MainCanvas.midlet, "sax.ani", "sax", null, 176, 208);
            }
            case 17: {
                return new GameAnimation(MainCanvas.midlet, "block.ani", "block", null, 176, 208);
            }
            case 18: {
                return new GameAnimation(MainCanvas.midlet, "bomb.ani", "bomb", null, 176, 208);
            }
            case 21: {
                return new GameAnimation(MainCanvas.midlet, "detonator.ani", "detonator", null, 176, 208);
            }
            case 22: {
                return new GameAnimation(MainCanvas.midlet, "stone.ani", "stone", null, 176, 208);
            }
            case 19: {
                return new GameAnimation(MainCanvas.midlet, "bridge.ani", "bridge", null, 176, 208);
            }
            case 20: {
                return new GameAnimation(MainCanvas.midlet, "key.ani", "key", null, 176, 208);
            }
            case 23: {
                return new GameAnimation(MainCanvas.midlet, "mark.ani", "mark", null, 176, 208);
            }
            case 24: {
                return new GameAnimation(MainCanvas.midlet, "billy.ani", "billy", null, 176, 208);
            }
            case 25: {
                if (flaxyAnim == null) {
                    flaxyAnim = new GameAnimation(MainCanvas.midlet, "flaxy.ani", "flaxy", null, 176, 208);
                }
                return new GameAnimation(MainCanvas.midlet, "cage.ani", "cage", null, 176, 208);
            }
            case 26: {
                return new GameAnimation(MainCanvas.midlet, "bird.ani", "bird", null, 176, 208);
            }
        }
        return null;
    }

    private GameAnimation loadAnimation(int n) {
        if (n == 2 || n == 3) {
            GameAnimation anim;
            n = 2;
            Game.enemiesAnim[0] = anim = this._loadAnimation(n);
            Game.enemiesAnim[1] = anim;
            return anim;
        }
        if (n == 12 || n == 13 || n == 14 || n == 15 || n == 29) {
            GameAnimation anim;
            n = 12;
            Game.specialsAnim[0] = anim = this._loadAnimation(n);
            Game.specialsAnim[1] = anim;
            Game.specialsAnim[2] = anim;
            Game.specialsAnim[3] = anim;
            Game.specialsAnim[15] = anim;
            return anim;
        }
        return this._loadAnimation(n);
    }

    private void initTriggers() {
        this.triggersNum = 0;
        this.enemiesNum = 0;
        this.specialNum = 0;
        for (int j = 0; j < this.triggerType.length; ++j) {
            for (int i = 0; i < this.triggerType[j].length; ++i) {
                ++this.triggersNum;
                if (this.triggerType[j][i] >= 2 && this.triggerType[j][i] <= 11) {
                    ++this.enemiesNum;
                }
                if (this.triggerType[j][i] >= 12 && this.triggerType[j][i] <= 26 || this.triggerType[j][i] == 29) {
                    ++this.specialNum;
                }
                if (this.triggerType[j][i] - 2 != 9) continue;
                ++this.specialNum;
            }
        }
        enemiesAnim = new GameAnimation[10];
        specialsAnim = new GameAnimation[16];
        enemies = new Enemy[this.enemiesNum];
        specials = new Special[this.specialNum];
        int e = 0;
        int s = 0;
        this.isExitLock = false;
        for (int j = 0; j < this.triggerType.length; ++j) {
            for (int i = 0; i < this.triggerType[j].length; ++i) {
                byte type = this.triggerType[j][i];
                if (type >= 2 && type <= 11) {
                    if (enemiesAnim[type - 2] == null) {
                        Game.enemiesAnim[type - 2] = this.loadAnimation(type);
                    }
                    ++e;
                    if (type - 2 != 9) continue;
                    if (specialsAnim[8] == null) {
                        Game.specialsAnim[8] = this.loadAnimation(20);
                    }
                    ++s;
                    continue;
                }
                if ((type < 12 || type > 26) && type != 29) continue;
                int _type = type - 12;
                if (type == 29) {
                    _type = 15;
                }
                if (specialsAnim[_type] == null) {
                    Game.specialsAnim[_type] = this.loadAnimation(type);
                }
                ++s;
            }
        }
    }

    private void initTriggersSoft() {
        int e = 0;
        int s = 0;
        this.isExitLock = false;
        this.isBoss = false;
        for (int j = 0; j < this.triggerType.length; ++j) {
            for (int i = 0; i < this.triggerType[j].length; ++i) {
                byte type = this.triggerType[j][i];
                int posX = this.triggerSectorX[j][i] + PlatformGameEngine.boardPositionX[j] * PlatformGameEngine.BOARD_WIDTH;
                int posY = this.triggerSectorY[j][i] + PlatformGameEngine.boardPositionY[j] * PlatformGameEngine.BOARD_HEIGHT;
                if (type == 1) {
                    fPlayerPosX = posX << 10;
                    fPlayerPosY = posY << 10;
                    fPlayerPrevPosX = fPlayerPosX;
                    fPlayerPrevPosY = fPlayerPosY;
                    continue;
                }
                if (type >= 2 && type <= 11) {
                    Game.enemies[e] = new Enemy(type - 2, posX << 10, posY << 10, enemiesAnim[type - 2]);
                    ++e;
                    if (type - 2 != 9) continue;
                    this.isBoss = true;
                    Game.specials[s] = new Special(8, -1, -1, -1024, -1024, specialsAnim[8]);
                    ++s;
                    this.isExitLock = true;
                    continue;
                }
                if (type >= 12 && type <= 26 || type == 29) {
                    int _type = type - 12;
                    if (type == 29) {
                        _type = 15;
                    }
                    Game.specials[s] = new Special(_type, posX, posY, posX << 10, posY << 10, specialsAnim[_type]);
                    ++s;
                    if (type - 12 != 8) continue;
                    this.isExitLock = true;
                    continue;
                }
                if (type < 27 || type > 28) continue;
                this.exitPosX = posX;
                this.exitPosY = posY;
                this.isBigExit = type == 28;
            }
        }
    }

    protected void tickProgressBar(int loading) {
        this.fLoading = loading;
        for (int i = 0; i < 3; ++i) {
            MainCanvas.canvas.repaint();
            MainCanvas.canvas.serviceRepaints();
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Game() {
        if (!isInit) {
            int ahs = BPFontReader.getFontHeightByAlphabetId(0);
            lineSpacing = (ahs + 4) / 8;
            letterSpacing = (ahs + 4) / 8;
            boxExplodeImage = MainCanvas.canvas.loadImages("/blockexpl", isDoublePixel);
            explosionImage = MainCanvas.canvas.loadImages("/explosion", isDoublePixel);
            guiImages = MainCanvas.canvas.loadImages("/gui", isDoublePixel);
            bubble = new GameAnimation(MainCanvas.midlet, "bubble.ani", "bubble", null, 176, 208);
            bubbleHeightInPixels = bubble.getHeight();
            playerAnim = new GameAnimation(MainCanvas.midlet, "pet.ani", "pet", null, 176, 208);
            playerWidthInPixels = playerAnim.getWidth();
            playerHeightInPixels = playerAnim.getHeight();
            isInit = true;
        }
        energy = 4;
        lives = 5;
        coins = 0;
        score = 0;
        MainCanvas.canvas.NickClass = new TextBox(88, 104 + BPFontReader.getFontHeightByAlphabetId(0) / 2 + lineSpacing, 140, 0, 0, letterSpacing, 17, false);
    }

    public void initLevel(int _levelNum) {
        this.levelNum = _levelNum;
        this.tickProgressBar(0);
        this.initLevelData(MainCanvas.midlet, "/level" + this.levelNum + ".wmp");
        this.tickProgressBar(200);
        this.initLevelAnimations(MainCanvas.midlet);
        this.tickProgressBar(450);
        this.levelName = BPFontReader.getStringFromOffsets(6) + " " + this.levelNum;
        int gradientNumber = this.levelNum >= 1 && this.levelNum <= 5 || this.levelNum >= 9 && this.levelNum <= 11 ? 1 : (this.levelNum == 6 || this.levelNum == 7 ? 2 : 3);
        int landscapeNumber = 0;
        if (this.levelNum == 1 || this.levelNum == 2 || this.levelNum == 4) {
            landscapeNumber = 1;
        } else if (this.levelNum == 3 || this.levelNum == 6 || this.levelNum == 7 || this.levelNum == 9) {
            landscapeNumber = 2;
        } else if (this.levelNum == 8 || this.levelNum == 12) {
            landscapeNumber = 3;
        }
        this.isWater = this.levelNum == 9;
        boolean bl = this.isRain = this.levelNum == 8 || this.levelNum == 12;
        if (this.isWater) {
            this.waterImage1 = MainCanvas.createImage("/water1.png", isDoublePixel);
            this.waterImage2 = MainCanvas.createImage("/water2.png", isDoublePixel);
        }
        this.gradient = MainCanvas.createImage("/gradient" + gradientNumber + ".png", isDoublePixel);
        if (this.gradient == null) {
            this.gradient = MainCanvas.createImage("/gradient1.png", isDoublePixel);
        }
        if (landscapeNumber > 0) {
            this.landscape = MainCanvas.createImage("/landscape" + landscapeNumber + ".png", isDoublePixel);
            if (landscapeNumber == 1) {
                if (this.landscape != null) {
                    this.landscape = MainCanvas.replaceColor(this.landscape, 0, 10868479);
                }
            } else if (this.landscape == null) {
                this.landscape = MainCanvas.createImage("/landscape1.png", isDoublePixel);
                if (this.landscape != null) {
                    this.landscape = MainCanvas.replaceColor(this.landscape, 0, 10868479);
                }
            }
        }
        this.tickProgressBar(600);
        if (this.isRain) {
            this.rainX = new int[32];
            this.rainY = new int[32];
            this.rainHeight = new int[32];
            for (int i = 0; i < this.rainX.length; ++i) {
                this.randomRain(i, true);
            }
        }
        this.tickProgressBar(650);
        this.initTriggers();
        this.tickProgressBar(900);
        playerWidth = (playerWidthInPixels << 10) / PlatformGameEngine.sectorWidth;
        playerHeight = (playerHeightInPixels << 10) / PlatformGameEngine.sectorHeight;
        this.endTable = false;
        this.ready = false;
        this.initLevelSoft();
        this.tickProgressBar(1024);
        this.fLoading = 1025;
    }

    public void resetLanguage() {
        this.levelName = BPFontReader.getStringFromOffsets(6) + " " + this.levelNum;
    }

    protected void initPlayer() {
        fPlayerVX = 0;
        fPlayerVY = 0;
        isPlayerTurnRight = 1;
        playerMaxJumpTime = 0;
        isPlayerJumping = false;
        playerJumpTime = 0;
        playerDescentTime = 0;
        playerAnimTime = 0;
        hasKey = false;
        immortalTime = 0;
        playerBubbleTime = 2000;
        playerBubbleType = 2;
        isDieing = false;
        isPlayerOnFloor = true;
        playerActiveAnim = 0;
    }

    public void initLevelSoft() {
        this.initTriggersSoft();
        this.initPlayer();
        shakingTime = 0;
        littleShakingTime = 0;
        this.gameTime = 0;
        levelCoins = 0;
        this.updateCamera(0, true);
    }

    public void closeLevelSoft() {
        int i;
        for (i = 0; i < specials.length; ++i) {
            if (!specials[i].isAlive()) continue;
            specials[i].close();
        }
        for (i = 0; i < particles.length; ++i) {
            if (particles[i] != null && particles[i].getTimeToLive() > 0) {
                particles[i].kill();
            }
            Game.particles[i] = null;
        }
        for (i = 0; i < label.length; ++i) {
            Game.label[i] = null;
        }
    }

    public void closeLevel() {
        this.closeLevelSoft();
        this.rainX = null;
        this.rainY = null;
        this.rainHeight = null;
        tntAnim = null;
        maxStoneImage = null;
        flaxyAnim = null;
        enemiesAnim = null;
        specialsAnim = null;
        enemies = null;
        specials = null;
        this.isNewRecord = false;
        this.closeLevelData();
        MainCanvas.stopSound();
        System.gc();
    }

    void nextLevel() {
        MainCanvas.nextLevel();
    }

    public void actionKeyPressed(int keyCode) {
        if ((keyCode == 2048 || keyCode == 8192) && !this.endTable && this.ready) {
            MainCanvas.gameStage = 0;
            MainCanvas.showMenu(MainCanvas.inGameMenu, null, 0);
            return;
        }
        if (keyCode == 1024 && this.isNewRecordTable && MainCanvas.canvas.NickClass.getVisibleText().length() > 0) {
            this.addNewRecord();
            return;
        }
        if (this.endTable && !this.isNewRecordTable) {
            if (lives > 0) {
                this.nextLevel();
            } else {
                MainCanvas.gameOver(this.isNewRecord);
            }
            return;
        }
    }

    public void actionKeyReleased(int keyCode) {
        if (this.fLoading >= 1024 && !this.ready) {
            this.ready = true;
            this.resumeSound();
        }
    }

    public boolean isReady() {
        return this.ready;
    }

    public void resumeSound() {
        MainCanvas.playSound(0, true);
    }

    public static void vibrate(int time) {
        if (time > vibraTime) {
            MainCanvas.vibrate(time);
            vibraTime = time;
        }
    }

    public int getScore() {
        return score;
    }

    public void setScore(int s) {
        score = s;
    }

    private void checkNewRecord() {
        this.isNewRecord = MainCanvas.recordValues[MainCanvas.recordValues.length - 1] < score;
        this.isNewRealRecord = MainCanvas.recordValues[0] < score;
        this.isNewRecordTable = this.isNewRecord;
    }

    private void addNewRecord(String name, int score) {
        int i;
        for (i = 0; i < MainCanvas.recordNames.length && score <= MainCanvas.recordValues[i]; ++i) {
        }
        for (int j = MainCanvas.recordNames.length - 1; j > i; --j) {
            MainCanvas.recordNames[j] = MainCanvas.recordNames[j - 1];
            MainCanvas.recordValues[j] = MainCanvas.recordValues[j - 1];
            MainCanvas.recordValuesString[j] = MainCanvas.recordValuesString[j - 1];
        }
        MainCanvas.recordNames[i] = name;
        MainCanvas.recordValues[i] = score;
        MainCanvas.recordHuman[i] = true;
        sb.delete(0, sb.length());
        sb.append(score);
        MainCanvas.recordValuesString[i] = sb.toString();
        if (lives > 0) {
            ++MainCanvas.levelNumber;
        }
        this.save();
        if (lives > 0) {
            --MainCanvas.levelNumber;
        }
    }

    protected void addNewRecord() {
        this.addNewRecord(MainCanvas.canvas.NickClass.getVisibleText(), score);
        MainCanvas.enterNick = false;
        this.isNewRecordTable = false;
    }

    private void save() {
        MainCanvas.rmsLives = lives;
        MainCanvas.rmsEnergy = energy;
        MainCanvas.rmsCoins = coins;
        MainCanvas.rmsScore = score;
        MainCanvas.rmsKey = hasKey ? 1 : 0;
        MainCanvas.save();
    }

    public void load(int _lives, int _energy, int _coins, int _score, int _key) {
        lives = _lives;
        energy = _energy;
        coins = _coins;
        score = _score;
        hasKey = _key == 1;
    }

    protected void createEndTable() {
        this.checkNewRecord();
        this.endTable = true;
        this.endTableTime = 5000;
        sb.delete(0, sb.length());
        sb.append(score);
        this.endText[0] = this.isNewRealRecord ? BPFontReader.getStringFromOffsets(7) : BPFontReader.getStringFromOffsets(4);
        this.endText[1] = "";
        this.endText[2] = BPFontReader.getStringFromOffsets(3);
        this.endText[3] = sb.toString();
        if (this.isNewRecordTable) {
            this.endText2[0] = "";
            this.endText2[1] = BPFontReader.getStringFromOffsets(8);
            this.endText2[2] = "";
            this.endText2[3] = "";
            MainCanvas.enterNick = true;
        }
    }

    protected void updatePlayer(int delta) {
        fPlayerPrevPosX = fPlayerPosX;
        fPlayerPrevPosY = fPlayerPosY;
        if ((playerBubbleTime -= delta) < 0) {
            playerBubbleTime = 0;
        }
        if (!isDieing && this.gameTime > 225000) {
            Game.kill();
        }
        int playerNewAnim = playerActiveAnim;
        playerAnimTime += delta;
        if (isDieing) {
            if (-(fPlayerVY -= 72 * delta) > 10240) {
                fPlayerVY = -10240;
            }
            fPlayerPosX += fPlayerVX * delta / 1024;
            fPlayerPosY += fPlayerVY * delta / 1024;
        }
        if (fPlayerPosY < -playerHeight) {
            if (!isDieing) {
                Game.vibrate(300);
            }
            if (--lives > 0) {
                energy = 4;
                MainCanvas.restartLevel();
                this.save();
            } else {
                this.createEndTable();
                this.save();
            }
            return;
        }
        if (isDieing) {
            return;
        }
        if (idleTime > 5000) {
            playerBubbleType = 1;
            if (playerBubbleTime == 0) {
                playerBubbleTime = 2000;
            } else if (playerBubbleTime < 1000) {
                playerBubbleTime = 1000;
            }
        }
        if (!this.actUp) {
            isPlayerJumpAllowed = true;
        }
        if (isPlayerJumping) {
            playerJumpTime += delta;
            if (fPlayerVY < 10240) {
                fPlayerVY = 10240;
            }
            if (playerJumpTime >= playerMaxJumpTime || !this.actUp) {
                isPlayerJumping = false;
                isPlayerJumpAllowed = false;
            }
        } else if (this.actUp && isPlayerOnFloor && isPlayerJumpAllowed) {
            isPlayerJumping = true;
            lastJumpfPosX = fPlayerPosX;
            if (fPlayerVY < 10240) {
                fPlayerVY = 10240;
            }
            playerMaxJumpTime = 270 + 90 * Math.abs(fPlayerVX) / 10240;
            playerJumpTime = 0;
        }
        if (!(isPlayerJumping || playerOutOfScreenAllowed && fPlayerPosX <= 0 || -(fPlayerVY -= 72 * delta) <= 10240)) {
            fPlayerVY = -10240;
        }
        int fNewPosY = fPlayerPosY + fPlayerVY * delta / 1024;
        int fPosX = fPlayerPosX + playerWidth / 2;
        if (fNewPosY != fPlayerPosY && fPlayerVY > 0) {
            isPlayerOnFloor = false;
            playerNewAnim = 4;
            int fNewPosY2 = fNewPosY + playerHeight - 1;
            if (PlatformGameEngine.isCollide(fPosX, fPlayerPosY + playerHeight - 1 + 1, fPosX, fNewPosY2, 0)) {
                isPlayerJumping = false;
                isPlayerJumpAllowed = false;
                fPlayerVY = 0;
                this.updateSpecialsFromCollision(0);
                fPlayerPosY = (PlatformGameEngine.collisionY / 1024 << 10) - playerHeight;
            } else {
                fPlayerPosY = fNewPosY;
            }
        }
        int playerMaxSpeed = 10;
        if (this.actWalk) {
            playerMaxSpeed /= 2;
        }
        if (this.actRight && !this.actLeft && fPlayerVX >= 0) {
            if (fPlayerVX < playerMaxSpeed << 10 && (fPlayerVX += 15 * delta) > playerMaxSpeed << 10) {
                fPlayerVX = playerMaxSpeed << 10;
            }
            if (isPlayerOnFloor) {
                playerNewAnim = fPlayerVX <= 5120 ? 1 : 2;
                isPlayerTurnRight = 1;
            }
        } else if (!this.actRight && this.actLeft && fPlayerVX <= 0) {
            if (-fPlayerVX < playerMaxSpeed << 10 && -(fPlayerVX -= 15 * delta) > playerMaxSpeed << 10) {
                fPlayerVX = -playerMaxSpeed << 10;
            }
            if (isPlayerOnFloor) {
                playerNewAnim = fPlayerVX >= -5120 ? 1 : 2;
                isPlayerTurnRight = 0;
            }
        } else if (fPlayerVX > 0) {
            fPlayerVX -= 25 * delta;
            if (isPlayerOnFloor) {
                playerNewAnim = !this.actRight && this.actLeft ? 3 : (fPlayerVX <= 5120 ? 1 : 2);
                isPlayerTurnRight = 1;
            }
            if (fPlayerVX <= 0) {
                if (!this.actRight && this.actLeft) {
                    if (isPlayerOnFloor) {
                        playerNewAnim = 1;
                        isPlayerTurnRight = 0;
                    }
                } else {
                    fPlayerVX = 0;
                    if (isPlayerOnFloor) {
                        playerNewAnim = 0;
                    }
                }
            }
        } else if (fPlayerVX < 0) {
            fPlayerVX += 25 * delta;
            if (isPlayerOnFloor) {
                playerNewAnim = this.actRight && !this.actLeft ? 3 : (fPlayerVX >= -5120 ? 1 : 2);
                isPlayerTurnRight = 0;
            }
            if (fPlayerVX >= 0) {
                if (this.actRight && !this.actLeft) {
                    if (isPlayerOnFloor) {
                        playerNewAnim = 1;
                        isPlayerTurnRight = 1;
                    }
                } else {
                    fPlayerVX = 0;
                    if (isPlayerOnFloor) {
                        playerNewAnim = 0;
                    }
                }
            }
        }
        if (fPlayerVX != 0) {
            int fNewPosX1 = fPlayerPosX + fPlayerVX * delta / 1024;
            if (fNewPosX1 != fPlayerPosX) {
                int fNewPosX2 = fNewPosX1 + playerWidth - 1;
                if (fNewPosX1 < 1024 && !playerOutOfScreenAllowed) {
                    fPlayerPosX = 1024;
                    fPlayerVX = 0;
                    playerNewAnim = 0;
                } else if (fNewPosX1 + playerWidth >= PlatformGameEngine.levelWidth * PlatformGameEngine.BOARD_WIDTH - 1 << 10 && !playerOutOfScreenAllowed) {
                    fPlayerPosX = (PlatformGameEngine.levelWidth * PlatformGameEngine.BOARD_WIDTH - 1 << 10) - playerWidth;
                    fPlayerVX = 0;
                    playerNewAnim = 0;
                } else {
                    boolean leftCollide = PlatformGameEngine.isCollide(fPlayerPosX + playerWidth - 1, fPlayerPosY, fNewPosX2, fPlayerPosY, 2);
                    if (leftCollide && fPlayerVX > 0) {
                        fPlayerVX = 0;
                        playerNewAnim = 0;
                        this.updateSpecialsFromCollision(2);
                        int fPlayerPosX2 = (PlatformGameEngine.collisionX / 1024 << 10) - playerWidth;
                        if ((fPlayerPosX -= 3 * delta) < fPlayerPosX2) {
                            fPlayerPosX = fPlayerPosX2;
                        }
                    } else {
                        boolean rightCollide = PlatformGameEngine.isCollide(fPlayerPosX, fPlayerPosY, fNewPosX1, fPlayerPosY, 1);
                        if (rightCollide && fPlayerVX < 0) {
                            fPlayerVX = 0;
                            playerNewAnim = 0;
                            this.updateSpecialsFromCollision(1);
                            int fPlayerPosX2 = PlatformGameEngine.collisionX / 1024 + 1 << 10;
                            if ((fPlayerPosX += 3 * delta) > fPlayerPosX2) {
                                fPlayerPosX = fPlayerPosX2;
                            }
                        } else {
                            fPlayerPosX = fNewPosX1;
                        }
                    }
                }
            } else {
                playerNewAnim = 0;
            }
        }
        if (fPlayerVX == 0) {
            int fPlayerPosX2;
            int fPlayerPosXP;
            boolean rightCollide;
            boolean leftCollide = PlatformGameEngine.isPointCollide(fPlayerPosX + playerWidth - 1, fPlayerPosY, 2);
            if (leftCollide & !(rightCollide = PlatformGameEngine.isPointCollide(fPlayerPosX, fPlayerPosY, 1))) {
                fPlayerPosXP = fPlayerPosX - 3 * delta;
                fPlayerPosX2 = (fPlayerPosX / 1024 + 1 << 10) - playerWidth;
                if (fPlayerPosXP < fPlayerPosX2) {
                    fPlayerPosXP = fPlayerPosX2;
                }
                fPlayerPosX = PlatformGameEngine.isPointCollide(fPlayerPosXP, fPlayerPosY, 1) ? fPlayerPosXP / 1024 + 1 << 10 : fPlayerPosXP;
            }
            if (!leftCollide & rightCollide) {
                fPlayerPosXP = fPlayerPosX + 3 * delta;
                fPlayerPosX2 = fPlayerPosX / 1024 + 1 << 10;
                if (fPlayerPosXP > fPlayerPosX2) {
                    fPlayerPosXP = fPlayerPosX2;
                }
                fPlayerPosX = PlatformGameEngine.isPointCollide(fPlayerPosXP + playerWidth - 1, fPlayerPosY, 2) ? ((fPlayerPosXP + playerWidth - 1) / 1024 << 10) - playerWidth : fPlayerPosXP;
            }
        }
        fNewPosY = fPlayerPosY + fPlayerVY * delta / 1024;
        fPosX = fPlayerPosX + playerWidth / 2;
        if (fNewPosY != fPlayerPosY && fPlayerVY < 0) {
            boolean collide;
            int fZeroPosY = fPlayerPosY / 1024 << 10;
            if (fZeroPosY < fNewPosY) {
                fZeroPosY = fPlayerPosY;
            }
            if ((collide = PlatformGameEngine.isCollide(fPosX, fZeroPosY - 1, fPosX, fNewPosY, 3)) && fPlayerPosY / 1024 > PlatformGameEngine.collisionY / 1024) {
                isPlayerOnFloor = true;
                fPlayerVY = 0;
                playerDescentTime = 0;
                if (playerActiveAnim == 4 || playerActiveAnim == 5) {
                    playerNewAnim = 0;
                }
                this.updateSpecialsFromCollision(3);
                fPlayerPosY = PlatformGameEngine.collisionY / 1024 + 1 << 10;
            } else {
                fPlayerPosY = fNewPosY;
                playerDescentTime += delta;
                playerNewAnim = 5;
                isPlayerOnFloor = false;
            }
        }
        if (!isPlayerOnFloor) {
            idleTime = 0;
        }
        if (immortalTime > 0 && (immortalTime -= delta) < 0) {
            immortalTime = 0;
        }
        if (playerNewAnim != playerActiveAnim) {
            playerAnimTime = 0;
            playerActiveAnim = playerNewAnim;
        }
    }

    protected void updateCamera(int delta, boolean firstTime) {
        int maxX;
        if (isDieing) {
            return;
        }
        int fCameraNewPosX = isPlayerTurnRight == 1 ? fPlayerPosX + playerWidth / 2 - 71680 / PlatformGameEngine.sectorWidth : fPlayerPosX + playerWidth / 2 - 107520 / PlatformGameEngine.sectorWidth;
        int fCameraNewPosY = fPlayerPosY - 106496 / PlatformGameEngine.sectorHeight;
        if (!firstTime) {
            if (this.fCameraPosX < fCameraNewPosX) {
                this.fCameraPosX += 10 * delta;
                if (this.fCameraPosX > fCameraNewPosX) {
                    this.fCameraPosX = fCameraNewPosX;
                }
            }
            if (this.fCameraPosX > fCameraNewPosX) {
                this.fCameraPosX -= 10 * delta;
                if (this.fCameraPosX < fCameraNewPosX) {
                    this.fCameraPosX = fCameraNewPosX;
                }
            }
            if (this.fCameraPosY < fCameraNewPosY) {
                this.fCameraPosY += 10 * delta;
                if (this.fCameraPosY > fCameraNewPosY) {
                    this.fCameraPosY = fCameraNewPosY;
                }
            }
            if (this.fCameraPosY > fCameraNewPosY) {
                this.fCameraPosY -= 10 * delta;
                if (this.fCameraPosY < fCameraNewPosY) {
                    this.fCameraPosY = fCameraNewPosY;
                }
            }
        } else {
            this.fCameraPosX = fCameraNewPosX;
            this.fCameraPosY = fCameraNewPosY;
        }
        if (fPlayerPosX < this.fCameraPosX) {
            this.fCameraPosX = fPlayerPosX;
        }
        if (fPlayerPosY < this.fCameraPosY) {
            this.fCameraPosY = fPlayerPosY;
        }
        if (fPlayerPosX + playerWidth > this.fCameraPosX + 180224 / PlatformGameEngine.sectorWidth) {
            this.fCameraPosX = fPlayerPosX + playerWidth - 180224 / PlatformGameEngine.sectorWidth;
        }
        if (fPlayerPosY + playerHeight > this.fCameraPosY + 212992 / PlatformGameEngine.sectorHeight) {
            this.fCameraPosY = fPlayerPosY + playerHeight - 212992 / PlatformGameEngine.sectorHeight;
        }
        if (this.fCameraPosX < 1024) {
            this.fCameraPosX = 1024;
        }
        if (this.fCameraPosX > (maxX = (PlatformGameEngine.levelWidth * PlatformGameEngine.BOARD_WIDTH << 10) - 180224 / PlatformGameEngine.sectorWidth) - 1024) {
            this.fCameraPosX = maxX - 1024;
        }
        if (this.fCameraPosY < 1024) {
            this.fCameraPosY = 1024;
        }
        PlatformGameEngine.screenPositionX = this.fCameraPosX * PlatformGameEngine.sectorWidth >> 10;
        PlatformGameEngine.screenPositionY = this.fCameraPosY * PlatformGameEngine.sectorHeight >> 10;
        if (shakingTime > 0) {
            if ((shakingTime -= delta) < 0) {
                shakingTime = 0;
            }
            int shakeX = Game.cos(shakingTime) * PlatformGameEngine.sectorWidth * 2 / 3072;
            int shakeY = Game.sin(shakingTime * 2) * PlatformGameEngine.sectorHeight * 2 / 3072;
            if (shakingTime < 500) {
                shakeX = shakeX * shakingTime / 500;
                shakeY = shakeY * shakingTime / 500;
            }
            PlatformGameEngine.screenPositionX += shakeX;
            PlatformGameEngine.screenPositionY += shakeY;
        }
        if (littleShakingTime > 0) {
            if ((littleShakingTime -= delta) < 0) {
                littleShakingTime = 0;
            }
            PlatformGameEngine.screenPositionY += Game.sin(littleShakingTime) * PlatformGameEngine.sectorHeight / 3072;
        }
    }

    public static Special findSpecial(int cellX, int cellY) {
        for (int i = 0; i < specials.length; ++i) {
            if (!specials[i].isAlive() || cellX != specials[i].getCellX() || cellY != specials[i].getCellY()) continue;
            return specials[i];
        }
        return null;
    }

    public static Special[] findSpecialGroup(int cellX, int cellY) {
        int cellX1 = cellX - 1;
        int cellY1 = cellY - 1;
        int cellX2 = cellX + 1;
        int cellY2 = cellY + 1;
        int found = 0;
        for (int i = 0; i < specials.length; ++i) {
            if (!specials[i].isAlive() || specials[i].getCellX() < cellX1 || specials[i].getCellY() < cellY1 || specials[i].getCellX() > cellX2 || specials[i].getCellY() > cellY2) continue;
            Game.specGroup[found] = specials[i];
            ++found;
        }
        return specGroup;
    }

    private void updateSpecialsFromCollision(int collType) {
        if (specials == null) {
            return;
        }
        int playerX2 = fPlayerPosX + playerWidth;
        int playerY2 = fPlayerPosY + playerHeight;
        for (int i = 0; i < specials.length; ++i) {
            int specialY2;
            int specialX2;
            int specialY1;
            int specialX1;
            if (!specials[i].isAlive() || !specials[i].canBeActivatedFromCollision() || !PlatformGameEngine.isPointInRect(PlatformGameEngine.collisionX, PlatformGameEngine.collisionY, specialX1 = specials[i].getfPosX(), specialY1 = specials[i].getfPosY(), specialX2 = specialX1 + specials[i].getWidth() - 1, specialY2 = specialY1 + specials[i].getHeight() - 1)) continue;
            specials[i].activateFromCollision(collType);
        }
    }

    private void updateContacts() {
        int i;
        if (isDieing) {
            return;
        }
        int playerX2 = fPlayerPosX + playerWidth - 1;
        int playerY2 = fPlayerPosY + playerHeight - 1;
        int screenPosX1 = (PlatformGameEngine.screenPositionX << 10) / PlatformGameEngine.sectorWidth;
        int screenPosY1 = (PlatformGameEngine.screenPositionY << 10) / PlatformGameEngine.sectorHeight;
        int screenPosX2 = screenPosX1 + 180224 / PlatformGameEngine.sectorWidth;
        int screenPosY2 = screenPosY1 + 212992 / PlatformGameEngine.sectorHeight;
        int fPlayerPrevX2 = fPlayerPrevPosX + playerWidth - 1;
        int fPlayerPrevY2 = fPlayerPrevPosY + playerHeight - 1;
        int fPlayerBoxX1 = Math.min(fPlayerPosX, fPlayerPrevPosX);
        int fPlayerBoxY1 = Math.min(fPlayerPosY, fPlayerPrevPosY);
        int fPlayerBoxX2 = Math.max(playerX2, fPlayerPrevX2);
        int fPlayerBoxY2 = Math.max(playerY2, fPlayerPrevY2);
        for (i = 0; i < specials.length; ++i) {
            if (!specials[i].isAlive() || !specials[i].canBeActivatedByPlayer() && !specials[i].canKill()) continue;
            int specialX1 = specials[i].getfPosX();
            int specialY1 = specials[i].getfPosY();
            int specialX2 = specialX1 + specials[i].getWidth() - 1;
            int specialY2 = specialY1 + specials[i].getHeight() - 1;
            if (specialX2 < screenPosX1 || specialX1 >= screenPosX2 || specialY2 < screenPosY1 || specialY1 >= screenPosY2 || !PlatformGameEngine.isPointInRect(fPlayerBoxX1, fPlayerBoxY1, specialX1, specialY1, specialX2, specialY2) && !PlatformGameEngine.isPointInRect(fPlayerBoxX2, fPlayerBoxY1, specialX1, specialY1, specialX2, specialY2) && !PlatformGameEngine.isPointInRect(fPlayerBoxX2, fPlayerBoxY2, specialX1, specialY1, specialX2, specialY2) && !PlatformGameEngine.isPointInRect(fPlayerBoxX1, fPlayerBoxY2, specialX1, specialY1, specialX2, specialY2) && !PlatformGameEngine.isPointInRect(specialX1, specialY1, fPlayerBoxX1, fPlayerBoxY1, fPlayerBoxX2, fPlayerBoxY2) && !PlatformGameEngine.isPointInRect(specialX2, specialY1, fPlayerBoxX1, fPlayerBoxY1, fPlayerBoxX2, fPlayerBoxY2) && !PlatformGameEngine.isPointInRect(specialX2, specialY2, fPlayerBoxX1, fPlayerBoxY1, fPlayerBoxX2, fPlayerBoxY2) && !PlatformGameEngine.isPointInRect(specialX1, specialY2, fPlayerBoxX1, fPlayerBoxY1, fPlayerBoxX2, fPlayerBoxY2) || !specials[i].collideConfirm(fPlayerPosX, fPlayerPosY, playerX2, playerY2)) continue;
            if (specials[i].canKill()) {
                if (!specials[i].isKill(fPlayerPosX, fPlayerPosY, playerX2, playerY2)) continue;
                Game.kill();
                continue;
            }
            specials[i].activate(true);
        }
        for (i = 0; i < enemies.length; ++i) {
            if (!enemies[i].isAlive()) continue;
            int enemyX1 = enemies[i].getfPosX();
            int enemyY1 = enemies[i].getfPosY();
            int enemyX2 = enemyX1 + enemies[i].getWidth() - 1;
            int enemyY2 = enemyY1 + enemies[i].getHeight() - 1;
            if (enemyX2 < screenPosX1 || enemyX1 >= screenPosX2 || enemyY2 < screenPosY1 || enemyY1 >= screenPosY2 || !PlatformGameEngine.isPointInRect(fPlayerBoxX1, fPlayerBoxY1, enemyX1, enemyY1, enemyX2, enemyY2) && !PlatformGameEngine.isPointInRect(fPlayerBoxX2, fPlayerBoxY1, enemyX1, enemyY1, enemyX2, enemyY2) && !PlatformGameEngine.isPointInRect(fPlayerBoxX2, fPlayerBoxY2, enemyX1, enemyY1, enemyX2, enemyY2) && !PlatformGameEngine.isPointInRect(fPlayerBoxX1, fPlayerBoxY2, enemyX1, enemyY1, enemyX2, enemyY2) && !PlatformGameEngine.isPointInRect(enemyX1, enemyY1, fPlayerBoxX1, fPlayerBoxY1, fPlayerBoxX2, fPlayerBoxY2) && !PlatformGameEngine.isPointInRect(enemyX2, enemyY1, fPlayerBoxX1, fPlayerBoxY1, fPlayerBoxX2, fPlayerBoxY2) && !PlatformGameEngine.isPointInRect(enemyX2, enemyY2, fPlayerBoxX1, fPlayerBoxY1, fPlayerBoxX2, fPlayerBoxY2) && !PlatformGameEngine.isPointInRect(enemyX1, enemyY2, fPlayerBoxX1, fPlayerBoxY1, fPlayerBoxX2, fPlayerBoxY2) || !enemies[i].collideConfirm(fPlayerPosX, fPlayerPosY, playerX2, playerY2)) continue;
            if (playerDescentTime > 80) {
                if (!enemies[i].hitConfirm(fPlayerPosX, fPlayerPosY, playerX2, playerY2)) continue;
                enemies[i].die();
                if (fPlayerVY < 24576) {
                    fPlayerVY = 24576;
                }
                playerDescentTime = 0;
                if (enemies[i].getType() != 9 || enemies[i].isAlive()) continue;
                for (int j = 0; j < specials.length; ++j) {
                    if (specials[j].getType() != 8) continue;
                    int x = enemies[i].getfPosX() + (enemies[i].getWidth() - specials[j].getWidth()) / 2;
                    specials[j].setfPos(x, 20480);
                    specials[j].setKeyMovable(true);
                }
                continue;
            }
            if (immortalTime != 0) continue;
            Game.hit();
            fPlayerVX = -fPlayerVX;
        }
        if (immortalTime == 0) {
            for (i = 0; i < particles.length; ++i) {
                if (particles[i] == null || particles[i].getTimeToLive() <= 0 || !particles[i].canHit()) continue;
                int particleX = particles[i].getfPosX() + particles[i].getWidth() / 2;
                int particleY = particles[i].getfPosY() + particles[i].getHeight() / 2;
                int particleX1 = particles[i].getfPosX();
                int particleY1 = particles[i].getfPosY();
                int particleX2 = particleX1 + particles[i].getWidth() - 1;
                int particleY2 = particleY1 + particles[i].getHeight() - 1;
                if (particleX2 < screenPosX1 || particleX1 >= screenPosX2 || particleY2 < screenPosY1 || particleY1 >= screenPosY2 || !PlatformGameEngine.isPointInRect(fPlayerBoxX1, fPlayerBoxY1, particleX1, particleY1, particleX2, particleY2) && !PlatformGameEngine.isPointInRect(fPlayerBoxX2, fPlayerBoxY1, particleX1, particleY1, particleX2, particleY2) && !PlatformGameEngine.isPointInRect(fPlayerBoxX2, fPlayerBoxY2, particleX1, particleY1, particleX2, particleY2) && !PlatformGameEngine.isPointInRect(fPlayerBoxX1, fPlayerBoxY2, particleX1, particleY1, particleX2, particleY2) && !PlatformGameEngine.isPointInRect(particleX1, particleY1, fPlayerBoxX1, fPlayerBoxY1, fPlayerBoxX2, fPlayerBoxY2) && !PlatformGameEngine.isPointInRect(particleX2, particleY1, fPlayerBoxX1, fPlayerBoxY1, fPlayerBoxX2, fPlayerBoxY2) && !PlatformGameEngine.isPointInRect(particleX2, particleY2, fPlayerBoxX1, fPlayerBoxY1, fPlayerBoxX2, fPlayerBoxY2) && !PlatformGameEngine.isPointInRect(particleX1, particleY2, fPlayerBoxX1, fPlayerBoxY1, fPlayerBoxX2, fPlayerBoxY2)) continue;
                Game.hit();
                fPlayerVX = -fPlayerVX;
            }
        }
        int exitX1 = this.exitPosX << 10;
        int exitY1 = this.exitPosY << 10;
        int exitX2 = exitX1 + 2048;
        int exitY2 = exitY1 + 2048;
        if (this.isBigExit) {
            exitY2 += 1024;
        }
        if (PlatformGameEngine.isPointInRect(fPlayerPosX, fPlayerPosY, exitX1, exitY1, exitX2, exitY2) || PlatformGameEngine.isPointInRect(playerX2, fPlayerPosY, exitX1, exitY1, exitX2, exitY2) || PlatformGameEngine.isPointInRect(playerX2, playerY2, exitX1, exitY1, exitX2, exitY2) || PlatformGameEngine.isPointInRect(fPlayerPosX, playerY2, exitX1, exitY1, exitX2, exitY2)) {
            if (!this.isExitLock || hasKey) {
                this.endTable = true;
                this.endTableTime = 5000;
                int bonus = 300 - this.gameTime / 750;
                bonus += levelCoins * 10;
                bonus += lives * 500;
                if (this.isBoss) {
                    bonus += 30000;
                }
                sb.delete(0, sb.length());
                sb.append(bonus);
                this.endText[0] = BPFontReader.getStringFromOffsets(5);
                this.endText[1] = "";
                this.endText[2] = BPFontReader.getStringFromOffsets(2);
                this.endText[3] = sb.toString();
                score += bonus;
                ++MainCanvas.levelNumber;
                this.save();
                --MainCanvas.levelNumber;
            } else {
                playerBubbleType = 3;
                if (playerBubbleTime == 0) {
                    playerBubbleTime = 2000;
                } else if (playerBubbleTime < 1000) {
                    playerBubbleTime = 1000;
                }
            }
        }
    }

    private void randomRain(int n, boolean onScreen) {
        int maxY = this.fCameraPosY + 212992 / PlatformGameEngine.sectorHeight;
        this.rainY[n] = onScreen ? MainCanvas.getRandom(this.fCameraPosY, maxY) : maxY;
        int x1 = this.fCameraPosX - 10240;
        int x2 = x1 + 180224 / PlatformGameEngine.sectorWidth + 20480;
        this.rainX[n] = MainCanvas.getRandom(x1, x2);
        this.rainHeight[n] = 2048;
    }

    private void updateRain(int delta) {
        for (int i = 0; i < this.rainX.length; ++i) {
            int newY = this.rainY[i] - 24 * delta;
            if (newY < this.fCameraPosY - this.rainHeight[i]) {
                this.randomRain(i, false);
                continue;
            }
            int c1 = this.rainY[i] / 1024;
            int c2 = newY / 1024;
            if (c1 != c2 && PlatformGameEngine.isCollide(this.rainX[i], this.rainY[i], this.rainX[i], newY, 3)) {
                if (this.rainHeight[i] == 2048 && MainCanvas.getRandom(0, 2) != 0) {
                    this.rainY[i] = newY;
                    continue;
                }
                this.rainY[i] = PlatformGameEngine.collisionY / 1024 + 1 << 10;
                int n = i;
                this.rainHeight[n] = this.rainHeight[n] - (this.rainY[i] - newY);
                if (this.rainHeight[i] > 0) continue;
                this.randomRain(i, false);
                continue;
            }
            this.rainY[i] = newY;
        }
    }

    void updateLabels(int delta) {
        for (int i = 0; i < label.length; ++i) {
            if (label[i] == null || labelTimeToLive[i] <= 0) continue;
            int n = i;
            labelTimeToLive[n] = labelTimeToLive[n] - delta;
            if (labelTimeToLive[i] < 0) {
                Game.labelTimeToLive[i] = 0;
            }
            int n2 = i;
            labelY[n2] = labelY[n2] + 4 * delta;
        }
    }

    public static void hit() {
        if (energy > 0 && immortalTime <= 0) {
            Game.vibrate(200);
            idleTime = 0;
            playerDescentTime = 0;
            --energy;
            if (fPlayerVY < 12288) {
                fPlayerVY = 12288;
            }
            if (energy <= 0) {
                Game.kill();
            } else {
                immortalTime = 1500;
            }
        }
    }

    public static void kill() {
        Game.vibrate(300);
        idleTime = 0;
        energy = 0;
        playerActiveAnim = 0;
        fPlayerVY = 10240;
        fPlayerVX += MainCanvas.getRandom(-2, 2) << 10;
        isDieing = true;
    }

    public static void giveCoin() {
        if (++coins >= 100) {
            coins = 0;
            ++lives;
        }
    }

    public static void giveScore(int s, int posX, int posY, int width, int height) {
        score += s;
        String l = null;
        if (s == 100) {
            l = "100";
        }
        if (s == 200) {
            l = "200";
        }
        if (s == 2000) {
            l = "2000";
        }
        int x = posX + (width - (BPFontReader.getTextWidth(l, 0, letterSpacing) << 10) / PlatformGameEngine.sectorWidth) / 2;
        int y = posY + (height - (BPFontReader.getFontHeightByAlphabetId(0) << 10) / PlatformGameEngine.sectorHeight) / 2;
        Game.createLabel(l, x, y);
    }

    public static void giveKey(int posX, int posY, int width, int height) {
        hasKey = true;
        String l = BPFontReader.getStringFromOffsets(0);
        int x = posX + (width - (BPFontReader.getTextWidth(l, 0, letterSpacing) << 10) / PlatformGameEngine.sectorWidth) / 2;
        int y = posY + (height - (BPFontReader.getFontHeightByAlphabetId(0) << 10) / PlatformGameEngine.sectorHeight) / 2;
        Game.createLabel(l, x, y);
    }

    public static void shake(int time) {
        if (shakingTime < time) {
            shakingTime = time;
        }
    }

    public static void littleShake(int time) {
        if (littleShakingTime < time) {
            littleShakingTime = time;
        }
    }

    public static void createParticle(int type, int subType, int timeToLive, int x, int y, int vx, int vy) {
        int best = 0;
        int bestTime = 0;
        if (particles[0] != null && (bestTime = particles[0].getTimeToLive()) > 0) {
            for (int i = 1; i < particles.length; ++i) {
                int ttl = 0;
                if (particles[i] != null) {
                    ttl = particles[i].getTimeToLive();
                }
                if (ttl <= 0) {
                    best = i;
                    break;
                }
                if (ttl >= best) continue;
                bestTime = ttl;
                best = i;
            }
        }
        if (particles[best] == null) {
            Game.particles[best] = new Particle();
        }
        particles[best].recreate(type, subType, timeToLive, x, y, vx, vy);
    }

    public static void createLabel(String _label, int x, int y) {
        int best = 0;
        int bestTime = 0;
        if (label[0] != null && (bestTime = labelTimeToLive[0]) > 0) {
            for (int i = 1; i < label.length; ++i) {
                int ttl = 0;
                if (label[i] != null) {
                    ttl = labelTimeToLive[i];
                }
                if (ttl <= 0) {
                    best = i;
                    break;
                }
                if (ttl >= best) continue;
                bestTime = ttl;
                best = i;
            }
        }
        Game.label[best] = _label;
        Game.labelX[best] = x;
        Game.labelY[best] = y;
        Game.labelTimeToLive[best] = 1000;
    }

    public static boolean detonate() {
        int bestX = PlatformGameEngine.levelWidth * PlatformGameEngine.BOARD_WIDTH;
        int bestY = -1;
        Special best = null;
        for (int i = 0; i < specials.length; ++i) {
            if (!specials[i].isAlive() || specials[i].getType() != 6) continue;
            int x = specials[i].getCellX();
            int y = specials[i].getCellY();
            if (x < bestX) {
                bestX = x;
                bestY = y;
                best = specials[i];
                continue;
            }
            if (x != bestX || y <= bestY) continue;
            bestX = x;
            bestY = y;
            best = specials[i];
        }
        if (best != null) {
            best.activate(false);
            return true;
        }
        return false;
    }

    private void physic(int delta) {
        int i;
        if (delta > 100) {
            delta = 100;
        }
        long time = System.currentTimeMillis();
        this.updatePlayer(delta);
        for (i = 0; i < specials.length; ++i) {
            if (specials[i] == null) continue;
            specials[i].update(delta);
        }
        for (i = 0; i < enemies.length; ++i) {
            enemies[i].update(delta);
        }
        for (i = 0; i < particles.length; ++i) {
            if (particles[i] == null) continue;
            particles[i].update(delta);
        }
        this.updateLabels(delta);
        this.updateContacts();
        if (this.isRain) {
            this.updateRain(delta);
        }
        this.updateCamera(delta, false);
    }

    private void checkLock() {
        boolean found = false;
        if (MainCanvas.levelNumber == 10) {
            for (int i = 0; i < specials.length; ++i) {
                if (!specials[i].isAlive() || specials[i].getType() != 10 || !specials[i].isMoving() && !specials[i].wasMoving()) continue;
                found = true;
                break;
            }
        }
        lockFps = found;
    }

    public void myAction(int delta) {
        if (!this.isNewRecordTable) {
            this.actLeft = MainCanvas.isActionKeyPressed(4) || MainCanvas.isActionKeyPressed(16);
            this.actRight = MainCanvas.isActionKeyPressed(8) || MainCanvas.isActionKeyPressed(32);
            boolean bl = this.actUp = MainCanvas.isActionKeyPressed(1) || MainCanvas.isActionKeyPressed(16) || MainCanvas.isActionKeyPressed(32);
            if (MainCanvas.isActionKeyPressed(256)) {
                this.actUp = true;
                if (isPlayerTurnRight == 1) {
                    this.actRight = true;
                } else {
                    this.actLeft = true;
                }
            }
        }
        this.checkLock();
        if (!this.endTable && this.ready) {
            this.gameTime += delta;
            if (playerBubbleTime == 0) {
                idleTime += delta;
            }
            if ((vibraTime -= delta) < 0) {
                vibraTime = 0;
            }
            if (this.actLeft || this.actRight || this.actUp) {
                idleTime = 0;
            }
            this.physic(delta * 100 / 100);
        } else if (this.endTable && !this.isNewRecordTable) {
            this.endTableTime -= delta;
            if (this.endTableTime < 0) {
                this.endTableTime = 0;
                this.endTable = false;
                if (lives > 0) {
                    this.nextLevel();
                } else {
                    MainCanvas.gameOver(this.isNewRecord);
                }
            }
        }
    }

    protected static void paintPlayer(Graphics g) {
        int n = immortalTime / 100;
        if ((n & 1) > 0) {
            return;
        }
        int animType = 0;
        int frameDelay = 100;
        if (playerActiveAnim == 0) {
            animType = 1;
            frameDelay = 1000;
        }
        int anim = playerActiveAnim * 2 + isPlayerTurnRight;
        int x = fPlayerPosX * PlatformGameEngine.sectorWidth / 1024 - PlatformGameEngine.screenPositionX;
        int yr = fPlayerPosY * PlatformGameEngine.sectorHeight / 1024 - PlatformGameEngine.screenPositionY;
        int y = 208 - yr - playerHeightInPixels + 1;
        playerAnim.paintAnimation(anim, playerAnim.correctFrame(anim, playerAnimTime / frameDelay, animType), x, y, false, g);
        if (playerBubbleTime > 0) {
            Game.paintBubble(fPlayerPosX + playerWidth / 2, fPlayerPosY + playerHeight, playerBubbleType, playerBubbleTime, g);
        }
    }

    protected void paintObjects(Graphics g) {
        int i;
        for (i = 0; i < specials.length; ++i) {
            if (specials[i].getType() == 11) continue;
            specials[i].paint(g);
        }
        for (i = 0; i < enemies.length; ++i) {
            enemies[i].paint(g);
        }
        for (i = 0; i < specials.length; ++i) {
            if (specials[i].getType() != 11) continue;
            specials[i].paint(g);
        }
        for (i = 0; i < particles.length; ++i) {
            if (particles[i] == null) continue;
            particles[i].paint(g);
        }
        Game.paintPlayer(g);
        this.paintLabels(g);
    }

    public static void paintBubble(int posX, int posY, int n, int time, Graphics g) {
        int time1 = 500;
        int time2 = 1500;
        if (time < time1) {
            n = 0;
        }
        if (time > time2) {
            n = 0;
            if ((time = time1 - (time - time2)) < 0) {
                time = 0;
            }
        }
        int frameDelay = time1 / 5;
        int x = posX * PlatformGameEngine.sectorWidth / 1024 - PlatformGameEngine.screenPositionX;
        int yr = posY * PlatformGameEngine.sectorHeight / 1024 - PlatformGameEngine.screenPositionY;
        int y = 208 - yr - bubbleHeightInPixels + 1;
        bubble.paintAnimation(n, bubble.correctFrame(n, time / frameDelay, 1), x, y, false, g);
    }

    private void paintWaterCell(int n, int x, int y, Graphics g) {
        if (n == 1) {
            MainCanvas.drawImage(this.waterImage1, x, y, 20, g, isDoublePixel);
        }
        if (n == 2) {
            MainCanvas.drawImage(this.waterImage2, x, y, 20, g, isDoublePixel);
        }
    }

    private void paintWaterBack(Graphics g) {
        int waterWidth = this.waterImage1.getWidth();
        int waterHeight = this.waterImage1.getHeight();
        int x1 = PlatformGameEngine.screenPositionX / waterWidth - 1;
        int x2 = x1 + 1 + 175 / waterWidth + 1;
        int offsetX = this.gameTime * waterWidth / 1000 % waterWidth;
        int offsetY = waterHeight + Game.cos(this.gameTime / 6) * waterHeight / 2048;
        for (int i = x1; i <= x2; ++i) {
            int y = 208 + PlatformGameEngine.screenPositionY - 4 * waterHeight;
            if (offsetY + y >= 208) continue;
            this.paintWaterCell(1, offsetX + i * waterWidth - PlatformGameEngine.screenPositionX, offsetY + y, g);
            if (offsetY + y + waterHeight >= 208) continue;
            this.paintWaterCell(2, offsetX + i * waterWidth - PlatformGameEngine.screenPositionX, offsetY + y + waterHeight, g);
        }
    }

    private void paintWaterFront(Graphics g) {
        int waterWidth = this.waterImage1.getWidth();
        int waterHeight = this.waterImage1.getHeight();
        int x1 = PlatformGameEngine.screenPositionX / waterWidth - 1;
        int x2 = x1 + 1 + 175 / waterWidth + 1;
        int offsetX = this.gameTime * waterWidth / 1000 % waterWidth;
        int offsetY = waterHeight + Game.cos(this.gameTime / 6) * waterHeight / 2048;
        for (int i = x1; i <= x2; ++i) {
            int y = 208 + PlatformGameEngine.screenPositionY - 3 * waterHeight;
            if (offsetY + y >= 208) continue;
            this.paintWaterCell(1, offsetX + waterWidth / 2 + i * waterWidth - PlatformGameEngine.screenPositionX, offsetY + y, g);
            if (offsetY + y + waterHeight >= 208) continue;
            this.paintWaterCell(2, offsetX + waterWidth / 2 + i * waterWidth - PlatformGameEngine.screenPositionX, offsetY + y + waterHeight, g);
            this.paintWaterCell(1, offsetX + i * waterWidth - PlatformGameEngine.screenPositionX, offsetY + y + waterHeight, g);
            if (offsetY + y + 2 * waterHeight >= 208) continue;
            this.paintWaterCell(2, offsetX + i * waterWidth - PlatformGameEngine.screenPositionX, offsetY + y + 2 * waterHeight, g);
        }
    }

    private void paintRain(Graphics g) {
        for (int i = 0; i < this.rainX.length; ++i) {
            int height = this.rainHeight[i] * PlatformGameEngine.sectorHeight / 1024;
            int x = this.rainX[i] * PlatformGameEngine.sectorWidth / 1024 - PlatformGameEngine.screenPositionX;
            int yr = this.rainY[i] * PlatformGameEngine.sectorHeight / 1024 - PlatformGameEngine.screenPositionY;
            int y = 208 - yr - 1;
            g.setColor(0xDDDDDD);
            g.drawLine(x, y - height, x, y);
            g.setColor(0xFFFFFF);
            g.drawLine(x, y, x, y);
            if (this.rainHeight[i] >= 2048) continue;
            for (int j = 0; j < 360; j += 60) {
                int xs = Game.cos(j);
                int ys = Game.sin(j);
                int x1 = xs / 4;
                int y1 = ys / 4;
                int x2 = xs * 3 / 8;
                int y2 = ys * 3 / 8;
                x1 = x1 * PlatformGameEngine.sectorWidth / 1024;
                y1 = y1 * PlatformGameEngine.sectorHeight / 1024;
                x2 = x2 * PlatformGameEngine.sectorWidth / 1024;
                y2 = y2 * PlatformGameEngine.sectorHeight / 1024;
                g.setColor(0xDDDDDD);
                g.drawLine(x + x1, y + y1, x + x2, y + y2);
            }
        }
    }

    private void paintLabels(Graphics g) {
        for (int i = 0; i < label.length; ++i) {
            if (label[i] == null || labelTimeToLive[i] <= 0) continue;
            int height = BPFontReader.getFontHeightByAlphabetId(0);
            int x = labelX[i] * PlatformGameEngine.sectorWidth / 1024 - PlatformGameEngine.screenPositionX;
            int yr = labelY[i] * PlatformGameEngine.sectorHeight / 1024 - PlatformGameEngine.screenPositionY;
            int y = 208 - yr - 1;
            BPFontReader.drawGraphicTextLine(label[i], x, y, 0, letterSpacing, g, 20);
            g.setClip(0, 0, 176, 208);
        }
    }

    private void drawStringNumber(int number, int n, int x, int y, Graphics g) {
        int dx = BPFontReader.getASCIICharWidth('0', 0) - 1 + letterSpacing;
        while (n > 0) {
            char c = (char)(number / n % 10 + 48);
            int o = (dx - BPFontReader.getASCIICharWidth(c, 0)) / 2;
            BPFontReader.drawASCIIChar(c, x + o, y, 0, g);
            n /= 10;
            x += dx;
        }
    }

    private void paintMainLabels(Graphics g) {
        if (this.gameTime < 1000) {
            int letterSpacing = BPFontReader.getLetterSpacing(6);
            BPFontReader.drawGraphicTextLine(this.levelName, 88, (208 - BPFontReader.getFontHeightByAlphabetId(0)) / 2, 0, letterSpacing, g, 17);
        }
        if (!this.endTable && 300 - this.gameTime / 750 <= 50) {
            BPFontReader.drawGraphicTextLine(1, 0, 88, (208 - BPFontReader.getFontHeight(1)) / 2, g, 1);
        }
        g.setClip(0, 0, 176, 208);
    }

    private static final int getGuiImageWidth(int n) {
        return guiImages[n].getWidth();
    }

    private static final int getGuiImageHeight(int n) {
        return guiImages[n].getHeight();
    }

    private static final void paintGuiImage(int n, int x, int y, Graphics g) {
        MainCanvas.drawImage(guiImages[n], x, y, 20, g, isDoublePixel);
    }

    private void paintGui(Graphics g) {
        int time = 300 - this.gameTime / 750;
        if (time < 0) {
            time = 0;
        }
        int w = 0;
        int dx = BPFontReader.getTextWidth("0", 0, letterSpacing);
        w += Game.getGuiImageWidth(0);
        w += dx;
        w += Game.getGuiImageWidth(1);
        w += dx * 2;
        w += dx * 6;
        w += Game.getGuiImageWidth(2);
        int lineHeight = Game.getGuiImageHeight(0);
        int e = 3;
        int space = (176 - (w += dx * 3)) / e;
        int y = (lineHeight - BPFontReader.getFontHeightByAlphabetId(0) + 1) / 2;
        int x = 0;
        Game.paintGuiImage(0, x, 1, g);
        this.drawStringNumber(lives, 1, x += Game.getGuiImageWidth(0), y + 1, g);
        g.setClip(0, 0, 176, 208);
        Game.paintGuiImage(1, x += dx + space, 1, g);
        this.drawStringNumber(coins, 10, x += Game.getGuiImageWidth(1), y + 1, g);
        g.setClip(0, 0, 176, 208);
        this.drawStringNumber(score, 100000, x += dx * 2 + space, y + 1, g);
        g.setClip(0, 0, 176, 208);
        x += dx * 6 + space;
        x = 176 - dx * 3 - letterSpacing * 3;
        Game.paintGuiImage(2, x - Game.getGuiImageWidth(2) - letterSpacing, 1, g);
        this.drawStringNumber(time, 100, x, y + 1, g);
        g.setClip(0, 0, 176, 208);
        int yh = (lineHeight - Game.getGuiImageHeight(3) + 1) / 2;
        for (int i = 0; i < 4; ++i) {
            int heart = i < energy ? 4 : 3;
            int k = 1;
            Game.paintGuiImage(heart, i * (Game.getGuiImageWidth(heart) + 1) + 1, lineHeight * k + yh + 1, g);
        }
        if (!this.endTable) {
            MainCanvas.drawSofts(g, -100, 5);
        }
    }

    protected void paintEndTable(Graphics g) {
        String[] s = this.isNewRecordTable ? this.endText2 : this.endText;
        MainCanvas.paintEndTable(s, 0, letterSpacing, false, g);
    }

    protected void paintLoading(Graphics g) {
        MainCanvas.paintMenuBackground(g, true, true);
        ++this.loadingFrame;
        int x = (176 - playerWidthInPixels) / 2;
        int y = (208 - playerHeightInPixels) / 2;
        int space = BPFontReader.getFontHeight(14) / 2;
        int anim = 5;
        playerAnim.paintAnimation(anim, playerAnim.correctFrame(anim, this.loadingFrame, 0), x, y, false, g);
        BPFontReader.drawGraphicTextLine(14, 0, 88, y + playerHeightInPixels + space, g, 1);
        g.setClip(0, 0, 176, 208);
        MainCanvas.drawProgressBar(g, y + playerHeightInPixels + BPFontReader.getFontHeight(14) + lineSpacing + space, this.fLoading, 1024, 0, 0xFFFFFF, 3434140);
    }

    public void paint(Graphics g) {
        long time = System.currentTimeMillis();
        g.setClip(0, 0, 176, 208);
        if (this.fLoading <= 1024) {
            this.paintLoading(g);
        } else if (!this.ready) {
            MainCanvas.paintMenuBackground(g, true, false);
            BPFontReader.drawGraphicTextLine(9, 0, 88, (208 - BPFontReader.getFontHeight(9)) / 2, g, 1);
        } else {
            this.paintBackground(11327228, g);
            if (MainCanvas.gameStage == 1) {
                if (this.isWater) {
                    this.paintWaterBack(g);
                }
                this.paintLevel(g);
                if (this.isWater) {
                    this.paintWaterFront(g);
                }
                if (this.isRain) {
                    this.paintRain(g);
                }
                this.paintMainLabels(g);
                this.paintGui(g);
                if (this.endTable) {
                    this.paintEndTable(g);
                }
            }
        }
    }

    public static final int cos(int x) {
        if (x < 0) {
            x = -x;
        }
        if (x >= 360) {
            x %= 360;
        }
        if (x > 180) {
            x = 360 - x;
        }
        if (x > 90) {
            return -cosTab[180 - x >> 1];
        }
        if (x < 90) {
            return cosTab[x >> 1];
        }
        return 0;
    }

    public static final int sin(int x) {
        return Game.cos(x - 90);
    }

    public static final int sqrtInt(int n, int l, int r) {
        int v = l + r >> 1;
        int w = v * v;
        if (w > n) {
            if (l < v - 1) {
                return Game.sqrtInt(n, l, v);
            }
            if (Math.abs(l * l - n) < Math.abs(w - n)) {
                return l;
            }
            return v;
        }
        if (w < n) {
            if (v < r - 1) {
                return Game.sqrtInt(n, v, r);
            }
            if (Math.abs(r * r - n) < Math.abs(w - n)) {
                return r;
            }
            return v;
        }
        return v;
    }

    static {
        particles = new Particle[16];
        specGroup = new Special[9];
        labelX = new int[8];
        labelY = new int[8];
        labelTimeToLive = new int[8];
        label = new String[8];
        sb = new StringBuffer();
        cosTab = new short[]{1024, 1023, 1022, 1018, 1014, 1008, 1002, 994, 984, 974, 962, 949, 935, 920, 904, 887, 868, 849, 828, 807, 784, 761, 737, 711, 685, 658, 630, 602, 573, 543, 512, 481, 449, 416, 384, 350, 316, 282, 248, 213, 178, 143, 107, 71, 36, 0};
    }
}

