/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class TextMenu
extends Menu {
    public static final int SCROLLBAR_WIDTH = 8;
    public static final int COLOR_OVERLAP = 0;
    public static final int COLOR_BACKGROUND = 1328764;
    public static final int COLOR_RECT = 12706303;
    private int anchor;
    private int textId;
    private byte[][] splittedText;
    private int space;
    private int lineSpacing;
    private int scrollPos;
    private int allPixels;
    private int scroll;
    private boolean finalMenu;

    public TextMenu(int _textId, Menu parent, int _lineSpacing, int _anchor, boolean _finalMenu) {
        super(_anchor, parent);
        this.textId = _textId;
        this.finalMenu = _finalMenu;
        this.anchor = _anchor;
        this.space = 9;
        this.lineSpacing = _lineSpacing;
        this.update();
    }

    public void update() {
        this.splittedText = BPFontReader.splitGraphicText(this.textId, 176 - 2 * this.space, false);
        this.allPixels = this.splittedText.length * (BPFontReader.getFontHeight(this.textId) + this.lineSpacing) - this.lineSpacing;
    }

    public void paint(Graphics g, int x, int y) {
        int height = 208 - MainCanvas.UP_SPACE - MainCanvas.DOWN_SPACE;
        int pos1 = ((this.scrollPos << 10) + this.allPixels / 2) / this.allPixels;
        int pos2 = ((this.scrollPos + height << 10) + this.allPixels / 2) / this.allPixels;
        int anchor2 = this.anchor;
        if (this.scrollPos + height <= this.allPixels) {
            anchor2 = this.anchor & 0xD;
        }
        int alphabetId = BPFontReader.getAlphabetId(this.textId);
        int letterSpacing = BPFontReader.getLetterSpacing(this.textId);
        BPFontReader.drawGraphicTextInWindow(this.splittedText, this.scrollPos, this.space, MainCanvas.UP_SPACE, 176 - 2 * this.space, height, g, anchor2, this.lineSpacing, alphabetId, letterSpacing);
        if (this.textId == 34) {
            int letterSpacing2 = BPFontReader.getLetterSpacing(33);
            int alphabetId2 = BPFontReader.getAlphabetId(33);
            int pos = BPFontReader.getFontHeight(this.textId) + this.lineSpacing;
            int yv = MainCanvas.UP_SPACE + pos - this.scrollPos;
            if (yv >= MainCanvas.UP_SPACE && yv + BPFontReader.getFontHeight(this.textId) < 208 - MainCanvas.DOWN_SPACE) {
                BPFontReader.drawComposedText(33, 0, MainCanvas.version, 88, yv, alphabetId2, letterSpacing2, g, anchor2);
            }
        }
        g.setClip(0, 0, 176, 208);
        if (pos2 - pos1 < 1024) {
            g.setColor(1328764);
            g.fillRect(176 - this.space, MainCanvas.UP_SPACE, 8, height);
            g.setColor(12706303);
            int y1 = pos1 * (height - 2) >> 10;
            int y2 = pos2 * (height - 2) >> 10;
            g.fillRect(176 - this.space + 1, MainCanvas.UP_SPACE + y1 + 1, 6, y2 - y1);
            g.setColor(0);
            g.drawRect(176 - this.space, MainCanvas.UP_SPACE, 7, height - 1);
        }
        if (MainCanvas.activeMenu == MainCanvas.playdoTxt) {
            MainCanvas.drawSofts(g, 2, 0);
        } else if (this.finalMenu) {
            MainCanvas.drawSofts(g, -100, 0);
        } else {
            MainCanvas.drawSofts(g, 4, 1);
        }
    }

    public void run() {
        int height = 208 - MainCanvas.UP_SPACE - MainCanvas.DOWN_SPACE;
        if (height > this.allPixels) {
            return;
        }
        int fontHeight = BPFontReader.getFontHeight(this.textId) + this.lineSpacing;
        int vel = 5 * fontHeight;
        this.scrollPos += this.scroll * vel * 100 / 1000;
        if (this.scrollPos < 0) {
            this.scrollPos = 0;
        }
        if (height + this.scrollPos > this.allPixels) {
            this.scrollPos = this.allPixels - height;
        }
    }

    public void show() {
    }

    public void keyPressed(int actionCode) {
        if (actionCode == 256 || actionCode == 1024 || actionCode == 2048) {
            this.scroll = 0;
            this.scrollPos = 0;
            MainCanvas.activeMenu = this.parent;
            MainCanvas.activeMenu.show();
        }
        if (actionCode == 1) {
            this.scroll = -1;
        } else if (actionCode == 2) {
            this.scroll = 1;
        }
    }

    public void keyReleased(int actionCode) {
        this.scroll = 0;
    }
}

