/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Background {
    private static final int LEVEL_WIDTH = 20;
    private static final int LEVEL_HEIGHT = 12;
    private static final int DESCENT_TIME = 5000;
    private static final byte[] layer2 = new byte[]{-73, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -78, -77, -73, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -112, -112, -78, -77, -75, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -112, -112, -112, -110, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 94, 94, 94, 94, 94, 95, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 68, 68, 68, 64, 0, 0, 0, 0, 0, 0, 0, 0, 45, 0, 0, 0, 0, 0, 0, 0, 62, 0, 68, 64, 0, 0, 0, 0, 0, 0, 0, 47, 48, 0, 0, 0, 0, 0, 0, 0, -112, -112, -112, -110, 0, 0, 0, 0, 0, 0, 0, 0, 46, 0, 0, 0, 0, 0, 0, 0, -112, -112, -112, -110, 0, 0, 0, 0, 0, 0, 0, 0, 46, 0, 0, 0, 0, 0, 57, 58, -112, -112, -112, -110, 0, 52, 0, 0, 0, 0, 0, 0, 46, 0, 0, 43, 44, 0, 60, 61, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61};
    private static final byte[] layer3 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 36, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 37, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 38, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 37, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 39, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    protected GameAnimation[] animation;
    private Image gradient;
    protected Image landscape;
    private int sectorWidth;
    private int sectorHeight;
    private int screenPositionX;
    private int screenPositionY;
    private int time;

    public Background() {
        boolean[] isAnimation2 = new boolean[256];
        boolean[] isAnimation3 = new boolean[256];
        for (int i = 0; i < layer2.length; ++i) {
            int img = layer2[i];
            if (img < 0) {
                img += 256;
            }
            if (--img >= 0) {
                isAnimation2[img] = true;
            }
            if ((img = layer3[i]) < 0) {
                img += 256;
            }
            if (--img < 0) continue;
            isAnimation3[img] = true;
        }
        this.animation = new GameAnimation[3];
        this.animation[1] = new GameAnimation(MainCanvas.midlet, "layer2.ani", "layer2", isAnimation2, 240, 320);
        this.animation[2] = new GameAnimation(MainCanvas.midlet, "layer3.ani", "layer3", isAnimation3, 240, 320);
        this.sectorWidth = PlatformGameEngine.countCellWidth(this.animation[1]);
        this.sectorHeight = PlatformGameEngine.countCellHeight(this.animation[1]);
        this.gradient = MainCanvas.createImage("/gradient1.png", Game.isDoublePixel);
        this.landscape = MainCanvas.createImage("/landscape1.png", Game.isDoublePixel);
        if (this.landscape != null) {
            this.landscape = MainCanvas.replaceColor(this.landscape, 0, 10868479);
        }
        int center = 7 * this.sectorWidth;
        this.screenPositionX = center - 120;
        if (this.screenPositionX < 0) {
            this.screenPositionX = 0;
        }
        this.screenPositionY = 12 * this.sectorHeight;
    }

    public void full() {
        this.time = 5000;
        this.screenPositionY = 0;
    }

    public void myAction(int delta) {
        this.time += delta;
        int descentTime = 5000;
        if (this.time < descentTime) {
            int t = descentTime - this.time;
            t *= t;
            this.screenPositionY = t * 12 / descentTime * this.sectorHeight / descentTime;
        } else {
            this.screenPositionY = 0;
        }
    }

    private void paintBoardPart2(Graphics _g, int _boardX, int _boardY) {
        if (_boardX < 0 || _boardX >= 20 || _boardY < 0 || _boardY >= 12) {
            return;
        }
        int addr = (12 - _boardY - 1) * 20 + _boardX;
        if (layer2[addr] != 0) {
            int image = layer2[addr];
            if (image < 0) {
                image += 256;
            }
            int x = _boardX * this.sectorWidth - this.screenPositionX;
            int y = 320 - ((_boardY + 1) * this.sectorHeight - this.screenPositionY);
            this.animation[1].paintAnimationQuick(--image, x, y, _g);
        }
    }

    private void paintBoardPart3(Graphics _g, int _boardX, int _boardY) {
        if (_boardX < 0 || _boardX >= 20 || _boardY < 0 || _boardY >= 12) {
            return;
        }
        int addr = (12 - _boardY - 1) * 20 + _boardX;
        if (layer3[addr] != 0) {
            int image = layer3[addr];
            if (image < 0) {
                image += 256;
            }
            int x = _boardX * this.sectorWidth - this.screenPositionX;
            int y = 320 - ((_boardY + 1) * this.sectorHeight - this.screenPositionY);
            this.animation[2].paintAnimationQuick(--image, x, y, _g);
        }
    }

    protected void paint(Graphics _g, boolean paintLevel) {
        PlatformGameEngine._paintBackground(this.gradient, this.landscape, this.screenPositionX, this.screenPositionY, 11327228, _g);
        if (paintLevel) {
            int i;
            int j;
            int _width = 240 / this.sectorWidth;
            int _height = 320 / this.sectorHeight;
            if (_width * this.sectorWidth < 240) {
                ++_width;
            }
            if (_height * this.sectorHeight < 320) {
                ++_height;
            }
            int _sX = this.screenPositionX / this.sectorWidth;
            int _sY = this.screenPositionY / this.sectorHeight;
            int o = 3;
            for (j = -o + 1; j < _height + o; ++j) {
                for (i = -o + 1; i < _width + o; ++i) {
                    this.paintBoardPart2(_g, _sX + i, _sY + j);
                }
            }
            for (j = -o + 1; j < _height + o; ++j) {
                for (i = -o + 1; i < _width + o; ++i) {
                    this.paintBoardPart3(_g, _sX + i, _sY + j);
                }
            }
        }
    }
}

