/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class GameAnimation {
    private static final Random random = new Random();
    public static final int PLAY_ANIMATION_LOOP = 0;
    public static final int PLAY_ANIMATION_ONCE = 1;
    Image[] animationImage;
    public short[][] animationFrameFileNumber;
    public short[][] animationFramePositionX;
    public short[][] animationFramePositionY;
    public short[] animationFrameLeft;
    public short[] animationFrameRight;
    public short[] animationFrameUp;
    public short[] animationFrameDown;
    public short[][] animationFrameNumber;
    public short[][] animationPositionX;
    public short[][] animationPositionY;
    public short screenWidth;
    public short screenHeight;
    private short AnimationFrame;
    private short AnimationPositionX;
    private short AnimationPositionY;
    private int AnimationFrameParts;
    private short AnimationFrameFileNumber;
    private short AnimationFramePositionX;
    private short AnimationFramePositionY;

    GameAnimation(MIDlet midlet, String animationFileNumber, String imagesFileNumber, boolean[] isAnimation, int _screenWidth, int _screenHeight) {
        this.screenWidth = (short)_screenWidth;
        this.screenHeight = (short)_screenHeight;
        boolean[] isImage = new boolean[256];
        this.loadAnimationFile(midlet, animationFileNumber, isAnimation, isImage);
        this.animationImage = GameAnimation.loadImagesBGS(midlet, imagesFileNumber + ".bgs", 0, isImage);
        if (this.animationImage == null) {
            this.animationImage = GameAnimation.loadImages(midlet, imagesFileNumber + ".aio", isImage);
        }
        this.setFramesBoundingBox();
    }

    public int getAnimationNum() {
        return this.animationFrameNumber.length;
    }

    public final int getWidth(int n, int m) {
        return this.animationFrameRight[this.animationFrameNumber[n][m]];
    }

    public final int getHeight(int n, int m) {
        return this.animationFrameUp[this.animationFrameNumber[n][m]];
    }

    public final int getWidth(int n) {
        short width = 0;
        for (int i = 0; i < this.animationFrameNumber[n].length; ++i) {
            short w = this.animationFrameRight[this.animationFrameNumber[n][i]];
            if (w <= width) continue;
            width = w;
        }
        return width;
    }

    public final int getHeight(int n) {
        short height = 0;
        for (int i = 0; i < this.animationFrameNumber[n].length; ++i) {
            short h = this.animationFrameUp[this.animationFrameNumber[n][i]];
            if (h <= height) continue;
            height = h;
        }
        return height;
    }

    public final int getWidth() {
        short width = 0;
        for (int i = 0; i < this.animationFrameRight.length; ++i) {
            if (this.animationFrameRight[i] <= width) continue;
            width = this.animationFrameRight[i];
        }
        return width;
    }

    public final int getHeight() {
        short height = 0;
        for (int i = 0; i < this.animationFrameUp.length; ++i) {
            if (this.animationFrameUp[i] <= height) continue;
            height = this.animationFrameUp[i];
        }
        return height;
    }

    private void setFramesBoundingBox() {
        int _animationFrameNumber = this.animationFrameFileNumber.length;
        this.animationFrameLeft = new short[_animationFrameNumber];
        this.animationFrameRight = new short[_animationFrameNumber];
        this.animationFrameUp = new short[_animationFrameNumber];
        this.animationFrameDown = new short[_animationFrameNumber];
        for (int i = 0; i < _animationFrameNumber; ++i) {
            int _animationFrameParts = this.animationFrameFileNumber[i].length;
            if (_animationFrameParts > 0) {
                this.animationFrameLeft[i] = this.animationFramePositionX[i][0];
                int w = 0;
                if (this.animationImage[this.animationFrameFileNumber[i][0]] != null) {
                    w = this.animationImage[this.animationFrameFileNumber[i][0]].getWidth();
                }
                this.animationFrameRight[i] = (short)(this.animationFramePositionX[i][0] + w);
                int h = 0;
                if (this.animationImage[this.animationFrameFileNumber[i][0]] != null) {
                    h = this.animationImage[this.animationFrameFileNumber[i][0]].getHeight();
                }
                this.animationFrameUp[i] = (short)(this.animationFramePositionY[i][0] + h);
                this.animationFrameDown[i] = this.animationFramePositionY[i][0];
            }
            for (int j = 1; j < _animationFrameParts; ++j) {
                if (this.animationFramePositionX[i][j] < this.animationFrameLeft[i]) {
                    this.animationFrameLeft[i] = this.animationFramePositionX[i][j];
                }
                int w = 0;
                if (this.animationImage[this.animationFrameFileNumber[i][j]] != null) {
                    w = this.animationImage[this.animationFrameFileNumber[i][j]].getWidth();
                }
                if (this.animationFramePositionX[i][j] + w > this.animationFrameRight[i]) {
                    this.animationFrameRight[i] = (short)(this.animationFramePositionX[i][j] + w);
                }
                int h = 0;
                if (this.animationImage[this.animationFrameFileNumber[i][j]] != null) {
                    h = this.animationImage[this.animationFrameFileNumber[i][j]].getHeight();
                }
                if (this.animationFramePositionY[i][j] + h > this.animationFrameUp[i]) {
                    this.animationFrameUp[i] = (short)(this.animationFramePositionY[i][j] + h);
                }
                if (this.animationFramePositionY[i][j] >= this.animationFrameDown[i]) continue;
                this.animationFrameDown[i] = this.animationFramePositionY[i][j];
            }
        }
    }

    private void loadAnimationFile(MIDlet midlet, String name, boolean[] isAnimation, boolean[] isImage) {
        boolean[] isFrame;
        block25: {
            boolean _afpX = false;
            boolean _afpY = false;
            boolean _apX = false;
            boolean _apY = false;
            InputStream is = null;
            FilterInputStream dis = null;
            isFrame = new boolean[256];
            try {
                byte _tempByte2;
                byte _tempByte1;
                byte _tempByte0;
                is = midlet.getClass().getResourceAsStream(name);
                dis = new DataInputStream(is);
                int _animationFrameNumber = ((DataInputStream)dis).readShort();
                int _animationNumber = ((DataInputStream)dis).readShort();
                byte _animationFileType = ((DataInputStream)dis).readByte();
                if (_animationFileType == 3) {
                    byte _tempType3Setup = ((DataInputStream)dis).readByte();
                    _afpX = (_tempType3Setup & 1) == 1;
                    _afpY = (_tempType3Setup >> 1 & 1) == 1;
                    _apX = (_tempType3Setup >> 2 & 1) == 1;
                    _apY = (_tempType3Setup >> 3 & 1) == 1;
                }
                this.animationFrameFileNumber = new short[_animationFrameNumber][];
                this.animationFramePositionX = new short[_animationFrameNumber][];
                this.animationFramePositionY = new short[_animationFrameNumber][];
                this.animationFrameNumber = new short[_animationNumber][];
                this.animationPositionX = new short[_animationNumber][];
                this.animationPositionY = new short[_animationNumber][];
                for (int i = 0; i < _animationFrameNumber; ++i) {
                    int _animationFrameParts = ((DataInputStream)dis).readUnsignedByte();
                    this.animationFrameFileNumber[i] = new short[_animationFrameParts];
                    this.animationFramePositionX[i] = new short[_animationFrameParts];
                    this.animationFramePositionY[i] = new short[_animationFrameParts];
                    for (int j = 0; j < _animationFrameParts; ++j) {
                        this.animationFrameFileNumber[i][j] = (short)((DataInputStream)dis).readUnsignedByte();
                        if (_animationFileType == 1) {
                            this.animationFramePositionX[i][j] = ((DataInputStream)dis).readByte();
                            this.animationFramePositionY[i][j] = ((DataInputStream)dis).readByte();
                        } else if (_animationFileType == 2) {
                            this.animationFramePositionX[i][j] = ((DataInputStream)dis).readShort();
                            this.animationFramePositionY[i][j] = ((DataInputStream)dis).readShort();
                        } else if (_animationFileType == 3) {
                            this.animationFramePositionX[i][j] = _afpX ? ((DataInputStream)dis).readShort() : (short)((DataInputStream)dis).readByte();
                            this.animationFramePositionY[i][j] = _afpY ? ((DataInputStream)dis).readShort() : (short)((DataInputStream)dis).readByte();
                        } else if (_animationFileType == 4) {
                            _tempByte0 = ((DataInputStream)dis).readByte();
                            _tempByte1 = ((DataInputStream)dis).readByte();
                            _tempByte2 = ((DataInputStream)dis).readByte();
                            this.animationFramePositionX[i][j] = (short)((_tempByte0 >> 4 & 0xF) << 8 | _tempByte1);
                            this.animationFramePositionX[i][j] = this.animationFramePositionX[i][j] > 2048 ? (short)(this.animationFramePositionX[i][j] - 4096) : this.animationFramePositionX[i][j];
                            this.animationFramePositionY[i][j] = (short)((_tempByte0 & 0xF) << 8 | _tempByte2);
                            short s = this.animationFramePositionY[i][j] = this.animationFramePositionY[i][j] > 2048 ? (short)(this.animationFramePositionY[i][j] - 4096) : this.animationFramePositionY[i][j];
                        }
                        if (!Game.isDoublePixel) continue;
                        short[] sArray = this.animationFramePositionX[i];
                        int n = j;
                        sArray[n] = (short)(sArray[n] * 2);
                        short[] sArray2 = this.animationFramePositionY[i];
                        int n2 = j;
                        sArray2[n2] = (short)(sArray2[n2] * 2);
                    }
                }
                for (int i = 0; i < _animationNumber; ++i) {
                    int _animationLength = ((DataInputStream)dis).readUnsignedByte();
                    this.animationFrameNumber[i] = new short[_animationLength];
                    this.animationPositionX[i] = new short[_animationLength];
                    this.animationPositionY[i] = new short[_animationLength];
                    for (int j = 0; j < _animationLength; ++j) {
                        this.animationFrameNumber[i][j] = ((DataInputStream)dis).readShort();
                        if (isAnimation == null || isAnimation[i]) {
                            isFrame[this.animationFrameNumber[i][j]] = true;
                        }
                        if (_animationFileType == 1) {
                            this.animationPositionX[i][j] = ((DataInputStream)dis).readByte();
                            this.animationPositionY[i][j] = ((DataInputStream)dis).readByte();
                            continue;
                        }
                        if (_animationFileType == 2) {
                            this.animationPositionX[i][j] = ((DataInputStream)dis).readShort();
                            this.animationPositionY[i][j] = ((DataInputStream)dis).readShort();
                            continue;
                        }
                        if (_animationFileType == 3) {
                            this.animationPositionX[i][j] = _apX ? ((DataInputStream)dis).readShort() : (short)((DataInputStream)dis).readByte();
                            this.animationPositionY[i][j] = _apY ? ((DataInputStream)dis).readShort() : (short)((DataInputStream)dis).readByte();
                            continue;
                        }
                        if (_animationFileType != 4) continue;
                        _tempByte0 = ((DataInputStream)dis).readByte();
                        _tempByte1 = ((DataInputStream)dis).readByte();
                        _tempByte2 = ((DataInputStream)dis).readByte();
                        this.animationPositionX[i][j] = (short)((_tempByte0 >> 4 & 0xF) << 8 | _tempByte1);
                        this.animationPositionX[i][j] = this.animationPositionX[i][j] > 2048 ? (short)(this.animationPositionX[i][j] - 4096) : this.animationPositionX[i][j];
                        this.animationPositionY[i][j] = (short)((_tempByte0 & 0xF) << 8 | _tempByte2);
                        this.animationPositionY[i][j] = this.animationPositionY[i][j] > 2048 ? (short)(this.animationPositionY[i][j] - 4096) : this.animationPositionY[i][j];
                    }
                }
                dis.close();
                dis = null;
                is = null;
            }
            catch (Exception e) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception ed) {
                        // empty catch block
                    }
                    is = null;
                }
                if (dis == null) break block25;
                try {
                    dis.close();
                }
                catch (Exception ed) {
                    // empty catch block
                }
                dis = null;
            }
        }
        for (int i = 0; i < this.animationFrameFileNumber.length; ++i) {
            if (!isFrame[i]) continue;
            for (int j = 0; j < this.animationFrameFileNumber[i].length; ++j) {
                isImage[this.animationFrameFileNumber[i][j]] = true;
            }
        }
    }

    private static Image[] _loadImages(MIDlet midlet, String name, boolean[] isImage) {
        Image[] images;
        block19: {
            InputStream is = null;
            DataInputStream dis = null;
            images = null;
            try {
                is = midlet.getClass().getResourceAsStream(name);
                dis = new DataInputStream(is);
                dis.readByte();
                dis.readByte();
                dis.readByte();
                int count = 0;
                int imagesNumber = 0;
                byte _imageFlag = 0;
                imagesNumber = dis.readUnsignedByte();
                images = new Image[imagesNumber];
                for (int imageCount = 0; imageCount < imagesNumber; ++imageCount) {
                    _imageFlag = dis.readByte();
                    if ((_imageFlag >> 7 & 1) == 1) {
                        count = dis.readShort();
                        if (count > 0) {
                            byte[] temp = new byte[count];
                            for (int k = 0; k < count; ++k) {
                                temp[k] = dis.readByte();
                            }
                            images[imageCount] = Image.createImage((byte[])temp, (int)0, (int)temp.length);
                            continue;
                        }
                        images[imageCount] = null;
                        continue;
                    }
                    int _parentImage = dis.readUnsignedByte();
                    int _transformation = _imageFlag & 7;
                    if (_transformation == 1) {
                        _transformation = 5;
                        images[imageCount] = Image.createImage((Image)images[_parentImage], (int)0, (int)0, (int)images[_parentImage].getWidth(), (int)images[_parentImage].getHeight(), (int)_transformation);
                        continue;
                    }
                    if (_transformation == 2) {
                        _transformation = 3;
                        images[imageCount] = Image.createImage((Image)images[_parentImage], (int)0, (int)0, (int)images[_parentImage].getWidth(), (int)images[_parentImage].getHeight(), (int)_transformation);
                        continue;
                    }
                    if (_transformation == 3) {
                        _transformation = 6;
                        images[imageCount] = Image.createImage((Image)images[_parentImage], (int)0, (int)0, (int)images[_parentImage].getWidth(), (int)images[_parentImage].getHeight(), (int)_transformation);
                        continue;
                    }
                    if (_transformation == 4) {
                        _transformation = 2;
                        images[imageCount] = Image.createImage((Image)images[_parentImage], (int)0, (int)0, (int)images[_parentImage].getWidth(), (int)images[_parentImage].getHeight(), (int)_transformation);
                        continue;
                    }
                    if (_transformation == 5) {
                        _transformation = 5;
                        images[imageCount] = Image.createImage((Image)images[_parentImage], (int)0, (int)0, (int)images[_parentImage].getWidth(), (int)images[_parentImage].getHeight(), (int)_transformation);
                        _transformation = 2;
                        images[imageCount] = Image.createImage((Image)images[imageCount], (int)0, (int)0, (int)images[imageCount].getWidth(), (int)images[imageCount].getHeight(), (int)_transformation);
                        continue;
                    }
                    if (_transformation == 6) {
                        _transformation = 3;
                        images[imageCount] = Image.createImage((Image)images[_parentImage], (int)0, (int)0, (int)images[_parentImage].getWidth(), (int)images[_parentImage].getHeight(), (int)_transformation);
                        _transformation = 2;
                        images[imageCount] = Image.createImage((Image)images[imageCount], (int)0, (int)0, (int)images[imageCount].getWidth(), (int)images[imageCount].getHeight(), (int)_transformation);
                        continue;
                    }
                    if (_transformation != 7) continue;
                    _transformation = 6;
                    images[imageCount] = Image.createImage((Image)images[_parentImage], (int)0, (int)0, (int)images[_parentImage].getWidth(), (int)images[_parentImage].getHeight(), (int)_transformation);
                    _transformation = 2;
                    images[imageCount] = Image.createImage((Image)images[imageCount], (int)0, (int)0, (int)images[imageCount].getWidth(), (int)images[imageCount].getHeight(), (int)_transformation);
                }
                dis.close();
                dis = null;
                is = null;
            }
            catch (Exception e) {
                images = null;
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception ed) {
                        // empty catch block
                    }
                    is = null;
                }
                if (dis == null) break block19;
                try {
                    dis.close();
                }
                catch (Exception ed) {
                    // empty catch block
                }
                dis = null;
            }
        }
        if (isImage != null) {
            for (int imageCount = 0; imageCount < images.length; ++imageCount) {
                if (isImage[imageCount]) continue;
                images[imageCount] = null;
            }
        }
        return images;
    }

    public static Image[] loadImages(MIDlet midlet, String name, boolean[] isImage) {
        Image[] img = GameAnimation._loadImages(midlet, name, isImage);
        return img;
    }

    static Image createFromBGSCreateRGBImageVersion(int width, int height, byte imageFormat, byte transform, byte[] rawData, byte[][] rgbEntries, byte[] alphaEntries) {
        int[] _data = new int[width * height];
        int _srcPtr = 0;
        switch (transform & 3) {
            case 0: {
                for (int y = 0; y < height; ++y) {
                    int _offset = (transform & 4) == 0 ? y * width : (y + 1) * width - 1;
                    for (int x = 0; x < width; ++x) {
                        int n = _data[_offset] = rawData[_srcPtr] < alphaEntries.length ? alphaEntries[rawData[_srcPtr]] << 24 : -16777216;
                        if (rawData[_srcPtr] < rgbEntries.length) {
                            int n2 = _offset;
                            _data[n2] = _data[n2] | rgbEntries[rawData[_srcPtr]][0] << 16 & 0xFF0000;
                            int n3 = _offset;
                            _data[n3] = _data[n3] | rgbEntries[rawData[_srcPtr]][1] << 8 & 0xFF00;
                            int n4 = _offset;
                            _data[n4] = _data[n4] | rgbEntries[rawData[_srcPtr]][2] & 0xFF;
                        } else {
                            _data[_offset] = 0;
                        }
                        ++_srcPtr;
                        if ((transform & 4) == 0) {
                            ++_offset;
                            continue;
                        }
                        --_offset;
                    }
                }
                break;
            }
            case 1: {
                for (int y = 0; y < height; ++y) {
                    int _offset = (transform & 4) == 0 ? height - y - 1 : y;
                    for (int x = 0; x < width; ++x) {
                        int n = _data[_offset] = rawData[_srcPtr] < alphaEntries.length ? alphaEntries[rawData[_srcPtr]] << 24 : -16777216;
                        if (rawData[_srcPtr] < rgbEntries.length) {
                            int n5 = _offset;
                            _data[n5] = _data[n5] | rgbEntries[rawData[_srcPtr]][0] << 16 & 0xFF0000;
                            int n6 = _offset;
                            _data[n6] = _data[n6] | rgbEntries[rawData[_srcPtr]][1] << 8 & 0xFF00;
                            int n7 = _offset;
                            _data[n7] = _data[n7] | rgbEntries[rawData[_srcPtr]][2] & 0xFF;
                        } else {
                            _data[_offset] = 0;
                        }
                        ++_srcPtr;
                        _offset += height;
                    }
                }
                break;
            }
            case 2: {
                for (int y = height; y > 0; --y) {
                    int _offset = (transform & 4) == 0 ? y * width - 1 : (y - 1) * width;
                    for (int x = 0; x < width; ++x) {
                        int n = _data[_offset] = rawData[_srcPtr] < alphaEntries.length ? alphaEntries[rawData[_srcPtr]] << 24 : -16777216;
                        if (rawData[_srcPtr] < rgbEntries.length) {
                            int n8 = _offset;
                            _data[n8] = _data[n8] | rgbEntries[rawData[_srcPtr]][0] << 16 & 0xFF0000;
                            int n9 = _offset;
                            _data[n9] = _data[n9] | rgbEntries[rawData[_srcPtr]][1] << 8 & 0xFF00;
                            int n10 = _offset;
                            _data[n10] = _data[n10] | rgbEntries[rawData[_srcPtr]][2] & 0xFF;
                        } else {
                            _data[_offset] = 0;
                        }
                        ++_srcPtr;
                        if ((transform & 4) == 0) {
                            --_offset;
                            continue;
                        }
                        ++_offset;
                    }
                }
                break;
            }
            case 3: {
                for (int y = height; y > 0; --y) {
                    int _offset = (transform & 4) == 0 ? width * height - y : width * height - (height - y) - 1;
                    for (int x = 0; x < width; ++x) {
                        int n = _data[_offset] = rawData[_srcPtr] < alphaEntries.length ? alphaEntries[rawData[_srcPtr]] << 24 : -16777216;
                        if (rawData[_srcPtr] < rgbEntries.length) {
                            int n11 = _offset;
                            _data[n11] = _data[n11] | rgbEntries[rawData[_srcPtr]][0] << 16 & 0xFF0000;
                            int n12 = _offset;
                            _data[n12] = _data[n12] | rgbEntries[rawData[_srcPtr]][1] << 8 & 0xFF00;
                            int n13 = _offset;
                            _data[n13] = _data[n13] | rgbEntries[rawData[_srcPtr]][2] & 0xFF;
                        } else {
                            _data[_offset] = 0;
                        }
                        ++_srcPtr;
                        _offset -= height;
                    }
                }
                break;
            }
        }
        if ((transform & 1) == 0) {
            return Image.createRGBImage((int[])_data, (int)width, (int)height, (boolean)true);
        }
        return Image.createRGBImage((int[])_data, (int)height, (int)width, (boolean)true);
    }

    private static Image[] _loadImagesBGS(MIDlet midlet, String name, int palettesSetNumber, boolean[] isImage) {
        Image[] images;
        block18: {
            InputStream is = null;
            DataInputStream dis = null;
            images = null;
            int _tmp1 = 0;
            try {
                is = midlet.getClass().getResourceAsStream(name);
                dis = new DataInputStream(is);
                dis.readByte();
                dis.readByte();
                dis.readByte();
                dis.readByte();
                if (dis.readUnsignedByte() <= palettesSetNumber) {
                    throw new Exception("Plik nie zawiera podanego w parametrze zestawu palet");
                }
                int _palGroups = dis.readUnsignedByte();
                short[] _palettesIndices = new short[_palGroups];
                for (int i = 0; i < _palGroups; ++i) {
                    _palettesIndices[i] = (short)dis.readUnsignedByte();
                    if (_palettesIndices[i] <= _tmp1) continue;
                    _tmp1 = _palettesIndices[i];
                }
                byte[][][] _rgbEntries = new byte[++_tmp1][][];
                byte[][] _alphaEntries = new byte[_tmp1][];
                int _palettesInFile = dis.readUnsignedByte();
                block7: for (int i = 0; i < _palettesInFile; ++i) {
                    for (int g = 0; g < _palGroups; ++g) {
                        int c;
                        if (_palettesIndices[i] != (short)g) continue;
                        _tmp1 = dis.readUnsignedByte() + 1;
                        _rgbEntries[i] = new byte[_tmp1][3];
                        for (c = 0; c < _tmp1; ++c) {
                            _rgbEntries[i][c][0] = dis.readByte();
                            _rgbEntries[i][c][1] = dis.readByte();
                            _rgbEntries[i][c][2] = dis.readByte();
                        }
                        _tmp1 = dis.readUnsignedByte() + 1;
                        _alphaEntries[i] = new byte[_tmp1];
                        for (c = 0; c < _tmp1; ++c) {
                            _alphaEntries[i][c] = dis.readByte();
                        }
                        continue block7;
                    }
                }
                int _imagesNumber = dis.readUnsignedByte();
                images = new Image[_imagesNumber];
                byte[] _imagesTransformations = new byte[_imagesNumber];
                short[] _imagesDataIndices = new short[_imagesNumber];
                short[] _imagesGroupIndices = new short[_imagesNumber];
                for (int i = 0; i < _imagesNumber; ++i) {
                    _imagesTransformations[i] = dis.readByte();
                    _imagesGroupIndices[i] = (short)dis.readUnsignedByte();
                    _imagesDataIndices[i] = (short)dis.readUnsignedByte();
                }
                _tmp1 = dis.readUnsignedByte();
                short[] _rawDataSetsWidths = new short[_tmp1];
                short[] _rawDataSetsHeights = new short[_tmp1];
                byte[] _rawDataSetsFormats = new byte[_tmp1];
                int i = 0;
                while (i < _tmp1) {
                    _rawDataSetsWidths[i] = (short)dis.readUnsignedShort();
                    _rawDataSetsHeights[i] = (short)dis.readUnsignedShort();
                    _rawDataSetsFormats[i] = dis.readByte();
                    int n = i++;
                    _rawDataSetsFormats[n] = (byte)(_rawDataSetsFormats[n] + 1);
                }
                for (int i2 = 0; i2 < _tmp1; ++i2) {
                    int rawSize = _rawDataSetsWidths[i2] * _rawDataSetsHeights[i2] * (short)_rawDataSetsFormats[i2];
                    boolean _isDataLoaded = false;
                    byte[] _rawData = null;
                    for (int im = 0; im < _imagesNumber; ++im) {
                        if (isImage != null && !isImage[im] || _imagesDataIndices[im] != (short)i2) continue;
                        if (!_isDataLoaded) {
                            _rawData = new byte[rawSize];
                            dis.read(_rawData);
                            _isDataLoaded = true;
                        }
                        images[im] = GameAnimation.createFromBGSCreateRGBImageVersion(_rawDataSetsWidths[i2], _rawDataSetsHeights[i2], _rawDataSetsFormats[i2], _imagesTransformations[im], _rawData, _rgbEntries[_palettesIndices[_imagesGroupIndices[im]]], _alphaEntries[_palettesIndices[_imagesGroupIndices[im]]]);
                    }
                    if (_isDataLoaded) continue;
                    dis.skipBytes(rawSize);
                }
                dis.close();
                dis = null;
                is = null;
            }
            catch (Exception e) {
                images = null;
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception ed) {
                        // empty catch block
                    }
                    is = null;
                }
                if (dis == null) break block18;
                try {
                    dis.close();
                }
                catch (Exception ed) {
                    // empty catch block
                }
                dis = null;
            }
        }
        return images;
    }

    public static Image[] loadImagesBGS(MIDlet midlet, String name, int palettesSetNumber, boolean[] isImage) {
        Image[] img = GameAnimation._loadImagesBGS(midlet, name, palettesSetNumber, isImage);
        return img;
    }

    public byte correctFrame(int _animationNumber, int _animationFrameNumber, int _animationPlayType) {
        if (_animationNumber >= this.animationFrameNumber.length) {
            _animationNumber = 0;
        }
        if (_animationPlayType == 0) {
            if (_animationFrameNumber >= this.animationFrameNumber[_animationNumber].length) {
                _animationFrameNumber %= this.animationFrameNumber[_animationNumber].length;
            }
        } else if (_animationPlayType == 1 && _animationFrameNumber >= this.animationFrameNumber[_animationNumber].length) {
            _animationFrameNumber = this.animationFrameNumber[_animationNumber].length - 1;
        }
        return (byte)_animationFrameNumber;
    }

    public byte moveAnimationX(int _animationNumber, int _animationFrameNumber, int _previousAnimationFrameNumber) {
        if (_animationNumber >= this.animationFrameNumber.length) {
            _animationNumber = 0;
        }
        int _animationLength = _animationFrameNumber >= this.animationPositionX[_animationNumber].length ? this.animationPositionX[_animationNumber].length - 1 : _animationFrameNumber;
        int _animationLength1 = _previousAnimationFrameNumber < 0 ? 0 : _previousAnimationFrameNumber;
        return (byte)(this.animationPositionX[_animationNumber][_animationLength] - this.animationPositionX[_animationNumber][_animationLength1]);
    }

    public byte moveAnimationY(int _animationNumber, int _animationFrameNumber, int _previousAnimationFrameNumber) {
        if (_animationNumber >= this.animationFrameNumber.length) {
            _animationNumber = 0;
        }
        int _animationLength = _animationFrameNumber >= this.animationPositionY[_animationNumber].length ? this.animationPositionY[_animationNumber].length - 1 : _animationFrameNumber;
        int _animationLength1 = _previousAnimationFrameNumber < 0 ? 0 : _previousAnimationFrameNumber;
        return (byte)(this.animationPositionY[_animationNumber][_animationLength] - this.animationPositionY[_animationNumber][_animationLength1]);
    }

    public void paintAnimation(int _animationNumber, int _animationFrameNumber, int _positionX, int _positionY, boolean _clipping, Graphics _g) {
        if (_animationNumber >= this.animationFrameNumber.length) {
            _animationNumber = 0;
        }
        if (_animationFrameNumber >= this.animationFrameNumber[_animationNumber].length) {
            _animationFrameNumber %= this.animationFrameNumber[_animationNumber].length;
        }
        this.AnimationFrame = this.animationFrameNumber[_animationNumber][_animationFrameNumber];
        this.AnimationPositionX = this.animationPositionX[_animationNumber][_animationFrameNumber];
        this.AnimationPositionY = this.animationPositionY[_animationNumber][_animationFrameNumber];
        int positionX = _positionX + this.AnimationPositionX;
        int positionY = _positionY + this.AnimationPositionY;
        if (_clipping && (positionX + this.animationFrameLeft[this.AnimationFrame] >= this.screenWidth || positionX + this.animationFrameRight[this.AnimationFrame] <= 0 || positionY + this.animationFrameDown[this.AnimationFrame] >= this.screenHeight || positionY + this.animationFrameUp[this.AnimationFrame] <= 0)) {
            return;
        }
        this.AnimationFrameParts = this.animationFrameFileNumber[this.AnimationFrame].length;
        for (int i = 0; i < this.AnimationFrameParts; ++i) {
            this.AnimationFrameFileNumber = this.animationFrameFileNumber[this.AnimationFrame][i];
            this.AnimationFramePositionX = this.animationFramePositionX[this.AnimationFrame][i];
            this.AnimationFramePositionY = this.animationFramePositionY[this.AnimationFrame][i];
            int x = positionX + this.AnimationFramePositionX;
            int y = positionY + this.AnimationFramePositionY;
            if (x >= this.screenWidth || x + this.animationImage[this.AnimationFrameFileNumber].getWidth() <= 0 || y >= this.screenHeight || y + this.animationImage[this.AnimationFrameFileNumber].getHeight() <= 0) continue;
            MainCanvas.drawImage(this.animationImage[this.AnimationFrameFileNumber], x, y, 0, _g, Game.isDoublePixel);
        }
    }

    public void paintAnimationQuick(int _animationNumber, int _positionX, int _positionY, Graphics _g) {
        this.AnimationFrame = this.animationFrameNumber[_animationNumber][0];
        if (_positionX >= this.screenWidth || _positionX + this.animationFrameRight[this.AnimationFrame] <= 0 || _positionY >= this.screenHeight || _positionY + this.animationFrameUp[this.AnimationFrame] <= 0) {
            return;
        }
        this.AnimationFrameFileNumber = this.animationFrameFileNumber[this.AnimationFrame][0];
        MainCanvas.drawImage(this.animationImage[this.AnimationFrameFileNumber], _positionX, _positionY, 0, _g, Game.isDoublePixel);
    }
}

