/*
 * Decompiled with CFR 0.152.
 */
package com.mobilepostproduction.j2j.javax.microedition.lcdui;

import com.mobilepostproduction.j2j.Core;
import com.mobilepostproduction.j2j.javax.microedition.lcdui.CommandListener;
import com.mobilepostproduction.j2j.javax.microedition.lcdui.Font;
import com.mobilepostproduction.j2j.javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Ticker;
import javax.microedition.lcdui.game.GameCanvas;

public abstract class Displayable {
    public static final int J2J_KEY_DPAD_UP = -1;
    public static final int J2J_KEY_DPAD_DOWN = -2;
    public static final int J2J_KEY_DPAD_LEFT = -3;
    public static final int J2J_KEY_DPAD_RIGHT = -4;
    public static final int J2J_KEY_DPAD_MIDDLE = -5;
    public static final int J2J_KEY_LSK = -6;
    public static final int J2J_KEY_RSK = -7;
    public static final int J2J_KEY_0 = 48;
    public static final int J2J_KEY_1 = 49;
    public static final int J2J_KEY_2 = 50;
    public static final int J2J_KEY_3 = 51;
    public static final int J2J_KEY_4 = 52;
    public static final int J2J_KEY_5 = 53;
    public static final int J2J_KEY_6 = 54;
    public static final int J2J_KEY_7 = 55;
    public static final int J2J_KEY_8 = 56;
    public static final int J2J_KEY_9 = 57;
    public static final int J2J_KEY_STAR = 42;
    public static final int J2J_KEY_POUND = 35;
    public static final int J2J_KEY_ACTION_SK = -6;
    public static final int J2J_KEY_BACK_SK = -7;
    public static final int J2J_DISPLAYABLE_COLOR_BACKGROUND = 0xFFFFFF;
    public static final int J2J_DISPLAYABLE_COLOR_HIGHLIGHTED_BACKGROUND = 986895;
    public static final int J2J_DISPLAYABLE_COLOR_FOREGROUND = 0;
    public static final int J2J_DISPLAYABLE_COLOR_HIGHLIGHTED_FOREGROUND = 0xFFFFFF;
    public static final int J2J_DISPLAYABLE_COLOR_BORDER = 0xDDDDFF;
    public static final int J2J_DISPLAYABLE_COLOR_HIGHLIGHTED_BORDER = 8959;
    public static final int J2J_DISPLAYABLE_COLOR_TITLE_BACKGROUND = 8959;
    public static final int J2J_DISPLAYABLE_COLOR_TITLE_FOREGROUND = 0xFFFFFF;
    public static final int J2J_DISPLAYABLE_COLOR_HOT_FOREGROUND = 0xFF1111;
    public static final int J2J_CANVAS_COMMAND_DRAW_V_GAP = 2;
    public static final int J2J_CANVAS_COMMAND_DRAW_H_GAP = 2;
    public static final int _X = 0;
    public static final int _Y = 1;
    public static final int _WIDTH = 2;
    public static final int _HEIGHT = 3;
    public static final int UP = 1;
    public static final int DOWN = 6;
    public static final int LEFT = 2;
    public static final int RIGHT = 5;
    public static final int FIRE = 8;
    public static final int GAME_A = 9;
    public static final int GAME_B = 10;
    public static final int GAME_C = 11;
    public static final int GAME_D = 12;
    public static final int KEY_NUM0 = 48;
    public static final int KEY_NUM1 = 49;
    public static final int KEY_NUM2 = 50;
    public static final int KEY_NUM3 = 51;
    public static final int KEY_NUM4 = 52;
    public static final int KEY_NUM5 = 53;
    public static final int KEY_NUM6 = 54;
    public static final int KEY_NUM7 = 55;
    public static final int KEY_NUM8 = 56;
    public static final int KEY_NUM9 = 57;
    public static final int KEY_STAR = 42;
    public static final int KEY_POUND = 35;
    private static Object mutex;
    private final Repainter repainter = new Repainter();
    private volatile int[] repaintsClipRect = null;
    private volatile int repaintsScheduled = 0;
    protected volatile int j2j_keyHeld = 0;
    private String title = null;
    private boolean bIsCurrent = false;
    private CommandListener commandListener = null;
    private boolean bFullScreenMode = false;
    private Command cmdLSK = null;
    private Command cmdRSK = null;
    protected static Proxy j2j_proxy;

    protected Displayable() {
        if (mutex == null) {
            mutex = new Object();
        }
        if (j2j_proxy == null) {
            j2j_proxy = new Proxy();
        }
    }

    public final javax.microedition.lcdui.Displayable getNativeDisplayable() {
        return j2j_proxy;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String s) {
        this.title = s;
        if (this.isShown()) {
            this.repaint();
        }
    }

    public Ticker getTicker() {
        return null;
    }

    public void setTicker(Ticker ticker) {
    }

    public int getWidth() {
        return Displayable.j2j_proxy.iScreenWidth;
    }

    public int getHeight() {
        int result = this.bFullScreenMode ? Displayable.j2j_proxy.iFullScreenHeight : Displayable.j2j_proxy.iScreenHeight;
        return result;
    }

    public final boolean isShown() {
        return this.j2j_isCurrent();
    }

    public final boolean j2j_isCurrent() {
        return Core.getCurrent() == this && !Core.isPaused();
    }

    protected Graphics getGraphics() {
        return j2j_proxy.proxyGetGraphics();
    }

    public void setFullScreenMode(boolean bFull) {
        this.bFullScreenMode = bFull;
        if (this.j2j_isCurrent()) {
            this.repaint();
        }
    }

    public void setCommandListener(CommandListener l) {
        this.commandListener = l;
    }

    public void addCommand(Command c) {
        if (c == null) {
            return;
        }
        if (Displayable._isAction(c)) {
            this.cmdLSK = c;
        } else {
            this.cmdRSK = c;
        }
        this._commandsChanged();
    }

    public void removeCommand(Command c) {
        if (this.cmdLSK == c) {
            this.cmdLSK = null;
        } else if (this.cmdRSK == c) {
            this.cmdRSK = null;
        } else {
            return;
        }
        this._commandsChanged();
    }

    public void j2j_setCommands(Command c1, Command c2) {
        if (Displayable._isAction(c1)) {
            this.cmdLSK = c1;
            this.cmdRSK = c2;
        } else {
            this.cmdRSK = c1;
            this.cmdLSK = c2;
        }
        this._commandsChanged();
    }

    public final void j2j_setCommandLabels(String actionSkLbl, String backSkLbl) {
        Command cAction = actionSkLbl == null ? null : new Command(actionSkLbl, 4, 1);
        Command cBack = backSkLbl == null ? null : new Command(backSkLbl, 2, 1);
        this.j2j_setCommands(cAction, cBack);
    }

    public void j2j_removeCommands() {
        this.j2j_setCommands(null, null);
    }

    public Command[] j2j_getCommands() {
        if (this.cmdLSK != null && this.cmdRSK != null) {
            return new Command[]{this.cmdLSK, this.cmdRSK};
        }
        if (this.cmdLSK != null) {
            return new Command[]{this.cmdLSK};
        }
        if (this.cmdRSK != null) {
            return new Command[]{this.cmdRSK};
        }
        return new Command[0];
    }

    protected final boolean j2j_launchCommand(Command c) {
        CommandListener l = this.commandListener;
        if (c != null && l != null) {
            try {
                l.commandAction(c, this);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public int getGameAction(int key) {
        int gan = 0;
        try {
            gan = j2j_proxy.getGameAction(key);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return gan;
    }

    public int getKeyCode(int gameAction) {
        return j2j_proxy.getKeyCode(gameAction);
    }

    public boolean isDoubleBuffered() {
        return true;
    }

    public boolean hasPointerEvents() {
        return false;
    }

    public boolean hasRepeatEvents() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void repaint() {
        if (this.isShown()) {
            Repainter repainter = this.repainter;
            synchronized (repainter) {
                this.repaintsClipRect = null;
                if (this.repaintsScheduled++ == 0) {
                    Core.callSerially(this.repainter);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void repaint(int x, int y, int width, int height) {
        if (x < 0) {
            width += x;
            x = 0;
        }
        if (y < 0) {
            height += y;
            y = 0;
        }
        if (width <= 0 || height <= 0 || x >= Displayable.j2j_proxy.iScreenWidth || y >= Displayable.j2j_proxy.iFullScreenHeight) {
            return;
        }
        if (x + width > Displayable.j2j_proxy.iScreenWidth) {
            width = Displayable.j2j_proxy.iScreenWidth - x;
        }
        if (y + height > Displayable.j2j_proxy.iFullScreenHeight) {
            height = Displayable.j2j_proxy.iFullScreenHeight - y;
        }
        if (this.isShown()) {
            Repainter repainter = this.repainter;
            synchronized (repainter) {
                if (this.repaintsClipRect == null) {
                    this.repaintsClipRect = new int[]{x, y, width, height};
                } else {
                    Core.unionRect(this.repaintsClipRect, x, y, width, height);
                }
                if (this.repaintsScheduled++ == 0) {
                    Core.callSerially(this.repainter);
                }
            }
        }
    }

    public void serviceRepaints() {
        this.repainter.run();
    }

    protected void hideNotify() {
    }

    protected void showNotify() {
    }

    protected void keyPressed(int key) {
    }

    protected void keyRepeated(int key) {
    }

    protected void keyReleased(int key) {
    }

    protected void sizeChanged(int w, int h) {
    }

    protected abstract void paint(Graphics var1);

    protected final void j2j_setTitle(String title) {
        this.title = title;
    }

    private final void _commandsChanged() {
        if (this.isShown()) {
            this.repaint();
        }
    }

    private final void _restoreProxyState() {
        Displayable.j2j_proxy.stub = this;
    }

    private final void _clearProxyState() {
        Displayable.j2j_proxy.stub = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void j2j_onShowNotify(boolean fromPause) {
        Object object = mutex;
        synchronized (object) {
            if (!this.bIsCurrent) {
                this.bIsCurrent = true;
                this._restoreProxyState();
                this.showNotify();
                if (!fromPause) {
                    this.j2j_onPaint(this.getGraphics(), null);
                    j2j_proxy.repaint();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void j2j_onHideNotify(boolean fromPause) {
        Object object = mutex;
        synchronized (object) {
            if (this.bIsCurrent) {
                this.bIsCurrent = false;
                this.hideNotify();
                this._clearProxyState();
            }
        }
    }

    protected final int j2j_onPrePaint(Graphics g2) {
        int iHeight = 0;
        if (!this.bFullScreenMode) {
            iHeight = this.getHeight();
        }
        return iHeight;
    }

    protected final void j2j_onPostPaint(Graphics g2, int iHeight, int[] r) {
        if (iHeight != 0) {
            int iWidth = this.getWidth();
            int iBarTop = iHeight;
            int iBarWidth = iWidth;
            int iBarHeight = Displayable._getCommandBarHeight();
            int iTextTop = iBarTop + 2;
            g2.translate(-g2.getTranslateX(), -g2.getTranslateY());
            if (r != null) {
                g2.setClip(r[0], r[1], r[2], r[3]);
                g2.clipRect(0, iBarTop, iBarWidth, iBarHeight);
            } else {
                g2.setClip(0, iBarTop, iBarWidth, iBarHeight);
            }
            g2.setColor(8959);
            g2.fillRect(0, iBarTop, iBarWidth, iBarHeight);
            g2.setFont(Displayable.j2j_getDefaultFont());
            g2.setColor(0xFFFFFF);
            Command cmdLSK = this.cmdLSK;
            Command cmdRSK = this.cmdRSK;
            if (cmdLSK != null) {
                g2.drawString(cmdLSK.getLabel(), 2, iTextTop, 4 | 0x10);
            }
            if (cmdRSK != null) {
                g2.drawString(cmdRSK.getLabel(), iWidth - 2, iTextTop, 8 | 0x10);
            }
        }
    }

    public final void j2j_onPaint(Graphics g2, int[] r) {
        try {
            this.paint(g2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void j2j_onKeyPressed(int key) {
        Object object = mutex;
        synchronized (object) {
            if (!this.isShown() || key == 0) {
                return;
            }
            this._releaseHeldKey();
            if (key == -5) {
                if (Displayable._isOK(this.cmdLSK) && this.j2j_launchCommand(this.cmdLSK)) {
                    return;
                }
                if (Displayable._isOK(this.cmdRSK) && this.j2j_launchCommand(this.cmdRSK)) {
                    return;
                }
            }
            if (key == -6) {
                if (this.j2j_launchCommand(this.cmdLSK)) {
                    return;
                }
            } else if (key == -7 && this.j2j_launchCommand(this.cmdRSK)) {
                return;
            }
            this.j2j_keyHeld = key;
            try {
                this.keyPressed(key);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void j2j_onKeyReleased(int key) {
        Object object = mutex;
        synchronized (object) {
            if (this.isShown() && key != 0 && this.j2j_keyHeld == key) {
                boolean release = key == this.j2j_keyHeld;
                this.j2j_keyHeld = 0;
                if (release) {
                    try {
                        this.keyReleased(key);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void _releaseHeldKey() {
        Object object = mutex;
        synchronized (object) {
            if (this.j2j_keyHeld != 0) {
                int keyHeld = this.j2j_keyHeld;
                this.j2j_keyHeld = 0;
                this.keyReleased(keyHeld);
            }
        }
    }

    protected static final Font j2j_getDefaultFont() {
        return Font.getDefaultFont();
    }

    private static final int _getCommandBarHeight() {
        return Displayable.j2j_getDefaultFont().getHeight() + 4;
    }

    private static final boolean _isDifferentLabel(String s, Command c) {
        return c == null || !s.equals(c.getLabel());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean _isAction(Command c) {
        if (c == null) {
            return false;
        }
        int type = c.getCommandType();
        if (type == 1) return true;
        if (type == 4) return true;
        if (type != 8) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean _isOK(Command c) {
        if (c == null) return false;
        if (c.getCommandType() != 4) return false;
        return true;
    }

    static /* synthetic */ int[] access$102(Displayable x0, int[] x1) {
        x0.repaintsClipRect = x1;
        return x1;
    }

    protected static final class Proxy
    extends GameCanvas {
        public volatile Displayable stub = null;
        public final int iScreenWidth;
        public final int iScreenHeight;
        public int iFullScreenHeight;
        private final int[] _saveClip = new int[4];
        private boolean bFullScreenMode = false;

        public Proxy() {
            super(false);
            this.iScreenWidth = 128;
            this.iScreenHeight = 96;
            this.setFullScreenMode(true);
            this.iFullScreenHeight = 128;
        }

        protected void hideNotify() {
            Core.j2j_onHideNotify((javax.microedition.lcdui.Displayable)this);
        }

        protected void showNotify() {
            Core.j2j_onShowNotify((javax.microedition.lcdui.Displayable)this);
        }

        protected void keyPressed(int keyCode) {
            Displayable stub = this.stub;
            if (stub == null) {
                return;
            }
            stub.j2j_onKeyPressed(keyCode);
        }

        protected void keyReleased(int keyCode) {
            Displayable stub = this.stub;
            if (stub == null) {
                return;
            }
            stub.j2j_onKeyReleased(keyCode);
        }

        public Graphics proxyGetGraphics() {
            return new Graphics(this.getGraphics());
        }

        final void nativeSetFullScreenMode(boolean bFullScreenMode) {
            if (bFullScreenMode != this.bFullScreenMode) {
                this.bFullScreenMode = bFullScreenMode;
                this.setFullScreenMode(bFullScreenMode);
            }
        }

        private final void _saveClip(javax.microedition.lcdui.Graphics g2) {
            this._saveClip[0] = g2.getClipX();
            this._saveClip[1] = g2.getClipY();
            this._saveClip[2] = g2.getClipWidth();
            this._saveClip[3] = g2.getClipHeight();
        }
    }

    private final class Repainter
    implements Runnable {
        private Repainter() {
        }

        public synchronized void run() {
            int[] r = Displayable.this.repaintsClipRect;
            Displayable.access$102(Displayable.this, null);
            if (Displayable.this.repaintsScheduled == 0) {
                return;
            }
            Displayable.this.repaintsScheduled = 0;
            if (Displayable.this.isShown()) {
                Graphics g2 = Displayable.this.getGraphics();
                if (r != null) {
                    g2.setClip(r[0], r[1], r[2], r[3]);
                }
                Displayable.this.j2j_onPaint(g2, r);
                if (Displayable.this.isShown()) {
                    if (r != null) {
                        j2j_proxy.flushGraphics(r[0], r[1], r[2], r[3]);
                    } else {
                        j2j_proxy.flushGraphics();
                    }
                }
            }
        }
    }
}

