/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class Game {
    public static final byte FASE_ACCION = 0;
    public static final byte SCORE_ALCANZADO = 1;
    public static final byte GAME_OVER = 2;
    public static final byte GAMEPLAY_SUPERADO = 3;
    public static final byte MENU_PAUSA = 4;
    public static final byte EDITAR_NOMBRE_USUARIO = 5;
    public static final byte NO_POSICION_DENTRO_DEL_RANKING = 6;
    public static final byte TUTORIAL = 7;
    public static boolean fromIngameMenu;
    public static int oldGameplayState;
    public static int currentGameplayState;
    public static boolean needGameplayStateConfig;
    public static final byte SOLEADO = 0;
    public static final byte ATARDECER = 1;
    public static final byte NOCHE = 2;
    public static final byte NUBLADO = 3;
    public static final int[] imagenesDeGameOver;
    public static final int[] imagenesDeGameVictory;
    public static final byte puntosPorVidaRestante = 5;
    public static final byte[][] puntosPorNivel;
    public static final byte[][] ambienteEnLosNiveles;
    public static final int[] imagenesParaElBackground;
    public static final int[] imagenesParaLosPisos;
    public static final short[][] posicionDeLosAgujerosEnElPiso;
    public static int backgroundActual;
    public static corredor freeRunner;
    public static final int[][] imagenesDeLosEdificiosPorNivel;
    public static final short[][] colisionesDeLosNivelesEdificios;
    public static final short[][] colisionesDeLosNivelesNubes;
    public static int[] menuPause;
    public static int currentTutorialState;
    public static int posicionDentroDelRanking;

    public static void loadEdificiosNivelActualMasCuatro() {
        int n = coreGame.nivelActual - coreGame.nivelActual % 4;
        int n2 = n + 4;
        for (int i = n; i < n2; ++i) {
            for (int j = 0; j < imagenesDeLosEdificiosPorNivel[i].length; ++j) {
                coreGame.loadImage(imagenesDeLosEdificiosPorNivel[i][j]);
            }
        }
    }

    public static void unloadEdificios() {
        for (int i = 0; i < imagenesDeLosEdificiosPorNivel.length; ++i) {
            for (int j = 0; j < imagenesDeLosEdificiosPorNivel[i].length; ++j) {
                coreGame.unloadImage(imagenesDeLosEdificiosPorNivel[i][j]);
            }
        }
    }

    public static void loadCurrentPisoParaCuatroNiveles() {
        coreGame.loadImage(imagenesParaLosPisos[coreGame.nivelActual / 4]);
    }

    public static void unloadCurrentPisoParaCuatroNiveles() {
        coreGame.unloadImage(imagenesParaLosPisos[coreGame.nivelActual / 4]);
    }

    public static void unloadAllPisos() {
        for (int i = 0; i < imagenesParaLosPisos.length; ++i) {
            coreGame.unloadImage(imagenesParaLosPisos[i]);
        }
    }

    public static void loadCorredor() {
        freeRunner = new corredor(coreGame.corredorActual, coreGame.nivelActual);
    }

    public static void unloadCorredor() {
        freeRunner.unload();
        freeRunner = null;
    }

    public static void loadBackground() {
        backgroundActual = imagenesParaElBackground[ambienteEnLosNiveles[coreGame.nivelActual / ambienteEnLosNiveles[0].length][0]];
        coreGame.loadImage(backgroundActual);
    }

    public static void unloadCurrentBackground() {
        coreGame.unloadImage(backgroundActual);
    }

    public static void unloadAllBackgrounds() {
        for (int i = 0; i < imagenesParaElBackground.length; ++i) {
            coreGame.unloadImage(imagenesParaElBackground[i]);
        }
    }

    public static void unloadAllForCurrentLevels() {
        Game.unloadAllBackgrounds();
        Game.unloadCurrentPisoParaCuatroNiveles();
        Game.unloadEdificios();
        System.gc();
    }

    public static void loadAllForCurrentLevels() {
        Game.loadBackground();
        Game.loadCurrentPisoParaCuatroNiveles();
        Game.loadEdificiosNivelActualMasCuatro();
    }

    public static void iniciarValoresNuevaPartida() {
        coreGame.nivelActual = 0;
        coreGame.score = 0;
        coreGame.corredorActual = (byte)coreGame.corredorActualParaElegir;
        coreGame.numeroDeVidas = (byte)10;
    }

    public static void setGameplayState(int n) {
        if (!fromIngameMenu) {
            oldGameplayState = currentGameplayState;
        }
        currentGameplayState = n;
        needGameplayStateConfig = true;
    }

    public static void updateGame(Graphics graphics) {
        switch (currentGameplayState) {
            case 7: {
                if (needGameplayStateConfig) {
                    coreGame.setTimer(3000);
                    coreGame.startTimer();
                    currentTutorialState = 0;
                    needGameplayStateConfig = false;
                }
                Game.drawBackground(graphics);
                Game.drawNubes(graphics);
                Game.drawPiso(graphics);
                Game.drawEdificios(graphics);
                freeRunner.update();
                freeRunner.paint(graphics);
                graphics.setColor(0xFF0000);
                int n = screenConstants.SCREEN_QUARTER_HEIGHT + (coreGame.imagesForGame[imagenesParaLosPisos[0]].getHeight() >> 3) + 5;
                graphics.drawRect(5, n, screenConstants.SCREEN_WIDTH - 10, screenConstants.SCREEN_HEIGHT - 5 - n);
                graphics.drawRect(2, n - 3, screenConstants.SCREEN_WIDTH - 4, screenConstants.SCREEN_HEIGHT + 1 - n);
                FontSystem.setFont(0);
                FontSystem.drawPage(graphics, coreGame.Strings[41], 6, n, screenConstants.SCREEN_WIDTH - 12, screenConstants.SCREEN_HEIGHT - 5 - n, 1);
                coreGame.drawSoftKeys(graphics, -1, 1);
                if (coreGame.WasKeyPressed(262144)) {
                    freeRunner.reiniciarCorredorEnElNivel(true);
                    Game.setGameplayState(0);
                }
                return;
            }
            case 0: {
                if (needGameplayStateConfig) {
                    needGameplayStateConfig = false;
                }
                Game.drawBackground(graphics);
                Game.drawNubes(graphics);
                Game.drawPiso(graphics);
                Game.drawEdificios(graphics);
                Game.drawScoreyVidas(graphics);
                freeRunner.update();
                freeRunner.paint(graphics);
                graphics.drawImage(coreGame.imagesForGame[116], 2, screenConstants.SCREEN_HEIGHT - coreGame.imagesForGame[116].getHeight(), 0);
                if (!coreGame.WasKeyPressed(131072)) break;
                Game.setGameplayState(4);
                return;
            }
            case 4: {
                if (needGameplayStateConfig) {
                    Game.unloadAllBackgrounds();
                    coreGame.loadImage(8);
                    Menu.setMenu(menuPause, 0, -1);
                    SaltosExtremosMidlet.myGame.sonidos.stopSound();
                    fromIngameMenu = true;
                    needGameplayStateConfig = false;
                }
                if (Menu.updateMenu(graphics)) {
                    switch (Menu.optionMenu) {
                        case 0: {
                            Game.loadBackground();
                            Game.setGameplayState(0);
                            SaltosExtremosMidlet.myGame.sonidos.PlaySound(-1, true);
                            break;
                        }
                        case 1: {
                            coreGame.setState(13);
                            break;
                        }
                        case 2: {
                            coreGame.setState(22);
                            break;
                        }
                        case 3: {
                            coreGame.setState(15);
                        }
                    }
                }
                if (coreGame.WasKeyPressed(262144)) {
                    Menu.pasoActualEnElMenu = 3;
                }
                if (Menu.cancelacionEnElMenuTerminada) {
                    Game.loadBackground();
                    Game.setGameplayState(0);
                    SaltosExtremosMidlet.myGame.sonidos.PlaySound(-1, true);
                }
                coreGame.drawSoftKeys(graphics, 0, 3);
                return;
            }
            case 1: {
                if (needGameplayStateConfig) {
                    Game.unloadAllForCurrentLevels();
                    coreGame.loadImage(8);
                    SaltosExtremosMidlet.myGame.sonidos.PlaySound(2, false);
                    needGameplayStateConfig = false;
                }
                coreGame.drawDefaultBackGround(graphics);
                int n = screenConstants.SCREEN_QUARTER_HEIGHT;
                FontSystem.setFont(0);
                FontSystem.drawString(graphics, coreGame.Strings[29], 20, n, 20);
                FontSystem.drawString(graphics, Integer.toString(coreGame.nivelActual + 1), screenConstants.SCREEN_WIDTH - 20, n, 24);
                FontSystem.drawString(graphics, coreGame.Strings[32], 20, n += FontSystem.FONT_HEIGHT[FontSystem.currentFont] + FontSystem.FONT_SPACE_BEETWEN_LINES[FontSystem.currentFont], 20);
                FontSystem.drawString(graphics, Integer.toString(coreGame.numeroDeVidas), screenConstants.SCREEN_WIDTH - 20, n, 24);
                FontSystem.setFont(1);
                FontSystem.drawString(graphics, coreGame.Strings[31], 20, n += FontSystem.FONT_HEIGHT[FontSystem.currentFont] << 1, 20);
                FontSystem.drawString(graphics, Integer.toString(coreGame.score), screenConstants.SCREEN_WIDTH - 20, n, 24);
                n += FontSystem.FONT_HEIGHT[FontSystem.currentFont] + FontSystem.FONT_SPACE_BEETWEN_LINES[FontSystem.currentFont];
                if (coreGame.frameCounter % 10 >= 5) {
                    FontSystem.setFont(0);
                    FontSystem.drawPage(graphics, coreGame.Strings[11], 5, n, screenConstants.SCREEN_WIDTH - 10, screenConstants.SCREEN_HEIGHT - n, 1);
                }
                if (coreGame.WasAnyKeyPressed()) {
                    coreGame.unloadImage(8);
                    coreGame.nivelActual = (byte)(coreGame.nivelActual + 1);
                    Game.loadAllForCurrentLevels();
                    freeRunner.reiniciarCorredorEnElNivel(true);
                    Game.setGameplayState(0);
                }
                return;
            }
            case 2: {
                if (needGameplayStateConfig) {
                    coreGame.partidaPendiente = (byte)-1;
                    Game.unloadAllForCurrentLevels();
                    coreGame.loadImage(8);
                    coreGame.loadImage(imagenesDeGameOver[coreGame.corredorActual]);
                    SaltosExtremosMidlet.myGame.sonidos.PlaySound(3, false);
                    needGameplayStateConfig = false;
                }
                coreGame.drawDefaultBackGround(graphics);
                graphics.drawImage(coreGame.imagesForGame[imagenesDeGameOver[coreGame.corredorActual]], screenConstants.SCREEN_HALF_WIDTH, screenConstants.SCREEN_HALF_HEIGHT, 3);
                if (coreGame.frameCounter % 10 >= 5) {
                    FontSystem.setFont(1);
                    FontSystem.drawPage(graphics, coreGame.Strings[11], 10, 0, screenConstants.SCREEN_WIDTH - 20, screenConstants.SCREEN_HEIGHT, 1);
                }
                if (!coreGame.WasAnyKeyPressed()) break;
                coreGame.unloadImage(imagenesDeGameOver[coreGame.corredorActual]);
                if (Game.jugadorDentroDelRanking()) {
                    Game.setGameplayState(5);
                    return;
                }
                Game.setGameplayState(6);
                return;
            }
            case 3: {
                if (needGameplayStateConfig) {
                    coreGame.partidaPendiente = (byte)-1;
                    Game.unloadAllForCurrentLevels();
                    coreGame.loadImage(114);
                    coreGame.loadImage(imagenesDeGameVictory[coreGame.corredorActual]);
                    SaltosExtremosMidlet.myGame.sonidos.PlaySound(2, false);
                    needGameplayStateConfig = false;
                }
                graphics.drawImage(coreGame.imagesForGame[114], screenConstants.SCREEN_HALF_WIDTH, screenConstants.SCREEN_HALF_HEIGHT, 3);
                graphics.drawImage(coreGame.imagesForGame[imagenesDeGameVictory[coreGame.corredorActual]], screenConstants.SCREEN_HALF_WIDTH, screenConstants.SCREEN_HALF_HEIGHT, 3);
                if (coreGame.frameCounter % 10 >= 5) {
                    FontSystem.setFont(1);
                    FontSystem.drawPage(graphics, coreGame.Strings[11], 10, 0, screenConstants.SCREEN_WIDTH - 20, screenConstants.SCREEN_HEIGHT, 1);
                }
                if (!coreGame.WasAnyKeyPressed()) break;
                coreGame.unloadImage(114);
                coreGame.unloadImage(imagenesDeGameVictory[coreGame.corredorActual]);
                coreGame.score += coreGame.numeroDeVidas * 5;
                if (Game.jugadorDentroDelRanking()) {
                    Game.setGameplayState(5);
                    return;
                }
                Game.setGameplayState(6);
                return;
            }
            case 5: {
                SaltosExtremosMidlet.myGame.updateEditarNombreDeUsuario(graphics);
                return;
            }
            case 6: {
                if (needGameplayStateConfig) {
                    coreGame.loadImage(8);
                    needGameplayStateConfig = false;
                }
                coreGame.drawDefaultBackGround(graphics);
                FontSystem.setFont(0);
                FontSystem.drawPage(graphics, coreGame.Strings[37], 10, 0, screenConstants.SCREEN_WIDTH - 20, screenConstants.SCREEN_HEIGHT, 1);
                if (coreGame.WasKeyPressed(196640)) {
                    coreGame.setState(21);
                }
                coreGame.drawSoftKeys(graphics, 0, -1);
            }
        }
    }

    public static void drawBackground(Graphics graphics) {
        graphics.drawImage(coreGame.imagesForGame[backgroundActual], screenConstants.SCREEN_HALF_WIDTH, 0, 17);
        if (currentGameplayState != 7) {
            graphics.drawImage(coreGame.imagesForGame[backgroundActual], screenConstants.SCREEN_HALF_WIDTH, screenConstants.SCREEN_QUARTER_HEIGHT, 17);
            graphics.drawImage(coreGame.imagesForGame[backgroundActual], screenConstants.SCREEN_HALF_WIDTH, screenConstants.SCREEN_HALF_HEIGHT, 17);
            graphics.drawImage(coreGame.imagesForGame[backgroundActual], screenConstants.SCREEN_HALF_WIDTH, screenConstants.SCREEN_HEIGHT - screenConstants.SCREEN_QUARTER_HEIGHT, 17);
            return;
        }
        graphics.setColor(0);
        graphics.fillRect(0, screenConstants.SCREEN_QUARTER_HEIGHT, screenConstants.SCREEN_WIDTH, screenConstants.SCREEN_HEIGHT - screenConstants.SCREEN_QUARTER_HEIGHT);
    }

    public static void drawPiso(Graphics graphics) {
        int n = coreGame.nivelActual / 4;
        graphics.drawRegion(coreGame.imagesForGame[imagenesParaLosPisos[n]], 0, 0, coreGame.imagesForGame[imagenesParaLosPisos[n]].getWidth(), coreGame.imagesForGame[imagenesParaLosPisos[n]].getHeight() >> 2, 0, screenConstants.SCREEN_HALF_WIDTH, screenConstants.SCREEN_QUARTER_HEIGHT, 3);
        if (currentGameplayState != 7) {
            graphics.drawRegion(coreGame.imagesForGame[imagenesParaLosPisos[n]], 0, coreGame.imagesForGame[imagenesParaLosPisos[n]].getHeight() >> 2, coreGame.imagesForGame[imagenesParaLosPisos[n]].getWidth(), coreGame.imagesForGame[imagenesParaLosPisos[n]].getHeight() >> 2, 0, screenConstants.SCREEN_HALF_WIDTH, screenConstants.SCREEN_HALF_HEIGHT, 3);
            graphics.drawRegion(coreGame.imagesForGame[imagenesParaLosPisos[n]], 0, coreGame.imagesForGame[imagenesParaLosPisos[n]].getHeight() >> 1, coreGame.imagesForGame[imagenesParaLosPisos[n]].getWidth(), coreGame.imagesForGame[imagenesParaLosPisos[n]].getHeight() >> 2, 0, screenConstants.SCREEN_HALF_WIDTH, screenConstants.SCREEN_HEIGHT - screenConstants.SCREEN_QUARTER_HEIGHT, 3);
            graphics.drawRegion(coreGame.imagesForGame[imagenesParaLosPisos[n]], 0, coreGame.imagesForGame[imagenesParaLosPisos[n]].getHeight() - (coreGame.imagesForGame[imagenesParaLosPisos[n]].getHeight() >> 2), coreGame.imagesForGame[imagenesParaLosPisos[n]].getWidth(), coreGame.imagesForGame[imagenesParaLosPisos[n]].getHeight() >> 2, 0, screenConstants.SCREEN_HALF_WIDTH, screenConstants.SCREEN_HEIGHT, 3);
        }
    }

    public static boolean colisionConElPiso(corredor corredor2) {
        if (posicionDeLosAgujerosEnElPiso[coreGame.nivelActual].length <= 1) {
            return true;
        }
        for (int i = 0; i < posicionDeLosAgujerosEnElPiso[coreGame.nivelActual].length; i += 2) {
            if (posicionDeLosAgujerosEnElPiso[coreGame.nivelActual][i] == -1000) continue;
            int n = screenConstants.SCREEN_HALF_WIDTH + posicionDeLosAgujerosEnElPiso[coreGame.nivelActual][i] + 1;
            int n2 = screenConstants.SCREEN_HALF_WIDTH + posicionDeLosAgujerosEnElPiso[coreGame.nivelActual][i + 1] - 1;
            if (n >= corredor2.X - 3 || n2 <= corredor2.X + 3) continue;
            return false;
        }
        return true;
    }

    public static void drawEdificios(Graphics graphics) {
        int n = coreGame.nivelActual - coreGame.nivelActual % 4;
        int n2 = n + 4;
        if (currentGameplayState == 7) {
            n2 = n + 1;
        }
        for (int i = n; i < n2; ++i) {
            for (int j = 0; j < imagenesDeLosEdificiosPorNivel[i].length; ++j) {
                if (imagenesDeLosEdificiosPorNivel[i][j] == -1) continue;
                graphics.drawImage(coreGame.imagesForGame[imagenesDeLosEdificiosPorNivel[i][j]], screenConstants.SCREEN_HALF_WIDTH + colisionesDeLosNivelesEdificios[i][j * 3], i % 4 == 0 ? screenConstants.SCREEN_QUARTER_HEIGHT + -2 : (i % 4 == 1 ? screenConstants.SCREEN_HALF_HEIGHT + -2 : (i % 4 == 2 ? screenConstants.SCREEN_HEIGHT - screenConstants.SCREEN_QUARTER_HEIGHT + -2 : screenConstants.SCREEN_HEIGHT + -2)), 36);
            }
        }
    }

    public static boolean colisionConLosEdificios(corredor corredor2) {
        if (colisionesDeLosNivelesEdificios[coreGame.nivelActual][0] == -1000) {
            return false;
        }
        switch (corredor2.currentState) {
            case 1: {
                for (int i = 0; i < colisionesDeLosNivelesEdificios[coreGame.nivelActual].length; i += 3) {
                    int n = screenConstants.SCREEN_HALF_WIDTH + colisionesDeLosNivelesEdificios[coreGame.nivelActual][i];
                    int n2 = screenConstants.SCREEN_HALF_WIDTH + colisionesDeLosNivelesEdificios[coreGame.nivelActual][i + 1];
                    if (corredor2.X + 3 <= n || corredor2.X - 3 >= n2) continue;
                    return true;
                }
                break;
            }
            case 2: {
                int n = corredor2.spriteCorredor.getCurrentFrameInAnim();
                for (int i = 0; i < screenConstants.COLISIONES_FRAMES_SALTO_CHICO[n].length; ++i) {
                    int n3 = corredor2.X + screenConstants.COLISIONES_FRAMES_SALTO_CHICO[n][i][0];
                    int n4 = corredor2.Y + screenConstants.COLISIONES_FRAMES_SALTO_CHICO[n][i][1];
                    for (int j = 0; j < colisionesDeLosNivelesEdificios[coreGame.nivelActual].length; j += 3) {
                        int n5 = screenConstants.SCREEN_HALF_WIDTH + colisionesDeLosNivelesEdificios[coreGame.nivelActual][j];
                        int n6 = screenConstants.SCREEN_HALF_WIDTH + colisionesDeLosNivelesEdificios[coreGame.nivelActual][j + 1];
                        int n7 = corredor2.YPisoActual - colisionesDeLosNivelesEdificios[coreGame.nivelActual][j + 2];
                        int n8 = corredor2.YPisoActual;
                        if (!Game.esPuntoDentroDelCuadrado(n3, n4, n5, n6, n7, n8)) continue;
                        return true;
                    }
                }
                break;
            }
            case 3: {
                int n = corredor2.spriteCorredor.getCurrentFrameInAnim();
                for (int i = 0; i < screenConstants.COLISIONES_FRAMES_SALTO_GRANDE[n].length; ++i) {
                    int n9 = corredor2.X + screenConstants.COLISIONES_FRAMES_SALTO_GRANDE[n][i][0];
                    int n10 = corredor2.Y + screenConstants.COLISIONES_FRAMES_SALTO_GRANDE[n][i][1];
                    for (int j = 0; j < colisionesDeLosNivelesEdificios[coreGame.nivelActual].length; j += 3) {
                        int n11 = screenConstants.SCREEN_HALF_WIDTH + colisionesDeLosNivelesEdificios[coreGame.nivelActual][j];
                        int n12 = screenConstants.SCREEN_HALF_WIDTH + colisionesDeLosNivelesEdificios[coreGame.nivelActual][j + 1];
                        int n13 = corredor2.YPisoActual - colisionesDeLosNivelesEdificios[coreGame.nivelActual][j + 2];
                        int n14 = corredor2.YPisoActual;
                        if (!Game.esPuntoDentroDelCuadrado(n9, n10, n11, n12, n13, n14)) continue;
                        return true;
                    }
                }
                break;
            }
        }
        return false;
    }

    public static boolean esPuntoDentroDelCuadrado(int n, int n2, int n3, int n4, int n5, int n6) {
        return n > n3 && n < n4 && n2 > n5 + 1 && n2 < n6;
    }

    public static void drawNubes(Graphics graphics) {
        int n = coreGame.nivelActual - coreGame.nivelActual % 4;
        int n2 = n + 4;
        if (currentGameplayState == 7) {
            n2 = n + 1;
        }
        for (int i = n; i < n2; ++i) {
            if (colisionesDeLosNivelesNubes[i].length <= 1) continue;
            for (int j = 0; j < colisionesDeLosNivelesNubes[i].length; j += 8) {
                graphics.drawImage(coreGame.imagesForGame[47], screenConstants.SCREEN_HALF_WIDTH + colisionesDeLosNivelesNubes[i][j], (i % 4 == 0 ? screenConstants.SCREEN_QUARTER_HEIGHT + -2 : (i % 4 == 1 ? screenConstants.SCREEN_HALF_HEIGHT + -2 : (i % 4 == 2 ? screenConstants.SCREEN_HEIGHT - screenConstants.SCREEN_QUARTER_HEIGHT + -2 : screenConstants.SCREEN_HEIGHT + -2))) + colisionesDeLosNivelesNubes[i][j + 1], 0);
            }
        }
    }

    public static boolean colisionConLasNubes(corredor corredor2) {
        if (colisionesDeLosNivelesNubes[coreGame.nivelActual][0] == -1000) {
            return false;
        }
        switch (corredor2.currentState) {
            case 2: {
                int n = corredor2.spriteCorredor.getCurrentFrameInAnim();
                for (int i = 0; i < screenConstants.COLISIONES_FRAMES_SALTO_CHICO[n].length; ++i) {
                    int n2 = corredor2.X + screenConstants.COLISIONES_FRAMES_SALTO_CHICO[n][i][0];
                    int n3 = corredor2.Y + screenConstants.COLISIONES_FRAMES_SALTO_CHICO[n][i][1];
                    for (int j = 0; j < colisionesDeLosNivelesNubes[coreGame.nivelActual].length; j += 4) {
                        int n4 = screenConstants.SCREEN_HALF_WIDTH + colisionesDeLosNivelesNubes[coreGame.nivelActual][j];
                        int n5 = n4 + colisionesDeLosNivelesNubes[coreGame.nivelActual][j + 2];
                        int n6 = corredor2.YPisoActual + colisionesDeLosNivelesNubes[coreGame.nivelActual][j + 1];
                        int n7 = n6 + colisionesDeLosNivelesNubes[coreGame.nivelActual][j + 3];
                        if (!Game.esPuntoDentroDelCuadrado(n2, n3, n4, n5, n6, n7)) continue;
                        return true;
                    }
                }
                break;
            }
            case 3: {
                int n = corredor2.spriteCorredor.getCurrentFrameInAnim();
                for (int i = 0; i < screenConstants.COLISIONES_FRAMES_SALTO_GRANDE[n].length; ++i) {
                    int n8 = corredor2.X + screenConstants.COLISIONES_FRAMES_SALTO_GRANDE[n][i][0];
                    int n9 = corredor2.Y + screenConstants.COLISIONES_FRAMES_SALTO_GRANDE[n][i][1];
                    for (int j = 0; j < colisionesDeLosNivelesNubes[coreGame.nivelActual].length; j += 4) {
                        int n10 = screenConstants.SCREEN_HALF_WIDTH + colisionesDeLosNivelesNubes[coreGame.nivelActual][j];
                        int n11 = n10 + colisionesDeLosNivelesNubes[coreGame.nivelActual][j + 2];
                        int n12 = corredor2.YPisoActual + colisionesDeLosNivelesNubes[coreGame.nivelActual][j + 1];
                        int n13 = n12 + colisionesDeLosNivelesNubes[coreGame.nivelActual][j + 3];
                        if (!Game.esPuntoDentroDelCuadrado(n8, n9, n10, n11, n12, n13)) continue;
                        return true;
                    }
                }
                break;
            }
        }
        return false;
    }

    public static void drawScoreyVidas(Graphics graphics) {
        FontSystem.setFont(0);
        FontSystem.drawString(graphics, coreGame.Strings[31] + ": " + Integer.toString(coreGame.score), 4, 2, 0);
        String string = " X " + Integer.toString(coreGame.numeroDeVidas);
        FontSystem.drawString(graphics, string, screenConstants.SCREEN_WIDTH - 4, 2, 24);
        graphics.drawImage(coreGame.imagesForGame[115], screenConstants.SCREEN_WIDTH - 4 - FontSystem.getStringWidth(string), 2, 24);
    }

    public static boolean jugadorDentroDelRanking() {
        for (int i = 0; i < coreGame.puntosRecordDelJugador.length; ++i) {
            if (coreGame.puntosRecordDelJugador[i] > coreGame.score) continue;
            for (int j = coreGame.puntosRecordDelJugador.length - 2; j >= i; --j) {
                coreGame.nivelRecordDelJugador[j + 1] = coreGame.nivelRecordDelJugador[j];
                coreGame.puntosRecordDelJugador[j + 1] = coreGame.puntosRecordDelJugador[j];
                coreGame.nombresDeLosJugadores[j + 1] = coreGame.nombresDeLosJugadores[j];
            }
            coreGame.nivelRecordDelJugador[i] = coreGame.nivelActual + 1;
            coreGame.puntosRecordDelJugador[i] = coreGame.score;
            posicionDentroDelRanking = i;
            return true;
        }
        return false;
    }

    static {
        imagenesDeGameOver = new int[]{106, 107, 108, 109};
        imagenesDeGameVictory = new int[]{110, 111, 112, 113};
        puntosPorNivel = new byte[][]{{2, 3}, {2, 3}, {2, 3}, {4, 3}, {4, 4}, {4, 4}, {5, 4}, {5, 4}, {5, 5}, {5, 5}, {6, 5}, {6, 5}, {6, 6}, {6, 6}, {7, 6}, {7, 6}, {7, 7}, {7, 7}, {8, 7}, {8, 7}, {8, 8}, {8, 8}, {9, 8}, {9, 9}, {10, 9}, {10, 9}, {11, 10}, {11, 10}, {11, 11}, {12, 11}, {12, 12}, {12, 12}, {13, 13}, {15, 14}, {17, 15}, {19, 16}, {21, 18}, {24, 20}, {27, 23}, {30, 30}};
        ambienteEnLosNiveles = new byte[][]{{0, 0, 0, 0}, {1, 1, 1, 1}, {2, 2, 2, 2}, {3, 3, 3, 3}, {1, 1, 1, 1}, {2, 2, 2, 2}, {0, 0, 0, 0}, {1, 1, 1, 1}, {2, 2, 2, 2}, {3, 3, 3, 3}};
        imagenesParaElBackground = new int[]{18, 19, 20, 21};
        imagenesParaLosPisos = new int[]{22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
        posicionDeLosAgujerosEnElPiso = new short[][]{{18, 38}, {-1000}, {-38, -20}, {-1000}, {52, 64}, {-1000}, {-63, -49, -36, -24, -8, 5, 36, 47, 60, 72}, {-1000}, {12, 30}, {9, 40}, {-3, 18}, {19, 33}, {7, 36}, {-1000}, {-26, 5, 20, 41}, {-1000}, {0, 24, 42, 62}, {31, 45}, {11, 31, 51, 70}, {-42, -27, -13, 7, 56, 74}, {-1000}, {-1000}, {-68, -42, 0, 11}, {-58, -44, -29, -7, 9, 31, 47, 56}, {21, 54}, {-18, -7, 54, 74}, {-1000}, {-56, -43, -23, -8, 4, 18, 34, 52}, {-1000}, {12, 44}, {-73, -60, 33, 63}, {-1000}, {-1000}, {-56, -45, 20, 50}, {9, 40}, {-1000}, {-1000}, {-68, -44, -17, 9}, {-3, 11, 33, 55}, {-67, -54, -35, -12, 2, 14, 27, 42, 56, 74}};
        imagenesDeLosEdificiosPorNivel = new int[][]{{32}, {33, 34}, {35}, {36, 38}, {39, 40}, {41, 42, 43}, {-1}, {44, 46}, {48, 49}, {50}, {51, 52}, {53, 54, 55}, {56}, {57, 58}, {59}, {60, 61, 62}, {63, 64}, {65, 66}, {67}, {68}, {69, 70, 71}, {72, 73, 74}, {75, 76}, {-1}, {77}, {78, 79}, {80, 81, 82}, {-1}, {83, 84, 85}, {86, 87, 88}, {89}, {90, 90, 90, 90, 90}, {91, 91, 91, 91, 91, 91, 91}, {92}, {93, 94}, {95, 96, 97}, {98, 99, 100}, {101, 102, 103}, {104, 105}, {-1}};
        colisionesDeLosNivelesEdificios = new short[][]{{-31, -23, 14}, {-41, -25, 14, 12, 21, 26}, {32, 48, 20}, {-37, -29, 13, 30, 39, 20, 39, 45, 28}, {-49, -20, 3, 33, 40, 10, -45, -23, 13, -41, -25, 21, -36, -31, 25}, {-53, -43, 24, 9, 18, 14, 55, 64, 14}, {-1000}, {-45, -36, 4, 14, 28, 25, -42, -39, 25}, {-56, -42, 20, 58, 62, 26}, {-48, -28, 25}, {-59, -32, 14, 48, 72, 3, 54, 67, 12, 58, 62, 23}, {-58, -53, 21, -2, 16, 6, 63, 72, 14, 3, 10, 29}, {-35, -16, 8, -29, -23, 30}, {-43, -34, 20, 31, 40, 14}, {79, 87, 28}, {-53, -35, 9, 1, 19, 9, 53, 63, 9, -49, -39, 19, 7, 13, 29}, {-49, -39, 12, -14, -3, 13}, {-52, -38, 29, 67, 75, 18}, {-37, -19, 7, -30, -25, 30}, {-61, -45, 4, -55, -50, 28}, {-62, -54, 8, -6, 2, 29, 34, 60, 5, 42, 51, 24}, {-60, -47, 16, -13, 10, 10, 46, 59, 16, -7, 3, 25}, {-12, -1, 27, 48, 63, 25}, {-1000}, {-60, -36, 4, -56, -41, 11, -51, -47, 23}, {-56, -47, 31, 42, 53, 27, -47, -40, 13}, {-58, -39, 7, -2, 13, 28, 55, 62, 18, -52, -47, 30}, {-1000}, {-67, -43, 8, -17, 8, 19, 42, 57, 11, -60, -49, 14, -13, -5, 24}, {-64, -57, 19, -47, -36, 19, 66, 73, 20}, {-17, 5, 4, -9, -4, 30}, {-63, -54, 12, -27, -18, 12, 2, 11, 12, 33, 42, 12, 61, 70, 12}, {-70, -61, 11, -58, -49, 11, -28, -19, 11, -15, -6, 11, 3, 12, 11, 33, 42, 11, 62, 71, 11}, {-26, 2, 16}, {-61, -53, 14, 60, 79, 6, 66, 71, 30}, {-60, -47, 26, 20, 26, 14, 67, 77, 25}, {-56, -47, 31, -8, 6, 12, 43, 65, 5, -48, -39, 12, 52, 57, 31}, {-44, -37, 17, 9, 18, 16, 65, 72, 29}, {-53, -48, 29, 74, 94, 10, 82, 86, 30}, {-1000}};
        colisionesDeLosNivelesNubes = new short[][]{{-1000}, {-1000}, {-1000}, {-1000}, {-1000}, {-1000}, {-1000}, {-1000}, {-1000}, {-1000}, {-1000}, {-1000}, {-1000}, {-76, -42, 18, 17, -58, -38, 5, 13, 54, -42, 18, 17, 72, -38, 5, 13}, {-57, -42, 18, 17, -39, -38, 5, 13}, {-1000}, {-1000}, {-1000}, {-80, -42, 18, 17, -62, -38, 5, 13}, {24, -42, 18, 17, 42, -38, 5, 13}, {-1000}, {76, -42, 18, 17, 94, -38, 5, 13}, {-1000}, {-1000}, {-21, -42, 18, 17, -3, -38, 5, 13, 61, -42, 18, 17, 79, -38, 5, 13}, {-1000}, {-1000}, {-1000}, {-1000}, {-18, -42, 18, 17, 0, -38, 5, 13}, {-1000}, {-1000}, {-1000}, {66, -42, 18, 17, 84, -38, 5, 13}, {-31, -42, 18, 17, -13, -38, 5, 13}, {-18, -42, 18, 17, 0, -38, 5, 13}, {-1000}, {-1000}, {-1000}, {-1000}};
        menuPause = new int[]{13, 14, 38, 40};
    }
}

