/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.lcdui.Image;

public class Player {
    public static final byte FACE_DOWN = 0;
    public static final byte FACE_LEFT = 1;
    public static final byte FACE_UP = 2;
    public static final byte FACE_RIGHT = 3;
    public static final int[] STEPS;
    public static final int NONE = 0;
    public static final byte MODE_NORMAL = 0;
    public static final byte MODE_DYING = 1;
    public static final byte MODE_DEAD = 2;
    GameScreen gameScreen;
    int x;
    int y;
    int fx;
    int fy;
    int face;
    int step;
    int startX;
    int startY;
    int lastFX;
    int lastFY;
    int lives;
    int bombs;
    int flames;
    int speed;
    int points;
    int bonus;
    int invinc;
    byte mode;
    byte extra;
    byte exCnt;
    boolean moveUp;
    boolean moveDown;
    boolean moveLeft;
    boolean moveRight;
    boolean fire;
    boolean fireExtra;
    boolean powerUp;
    boolean moveUpOnce;
    boolean moveDownOnce;
    boolean moveLeftOnce;
    boolean moveRightOnce;
    boolean fireOnce;
    boolean fireExtraOnce;
    public Playfield playfield;
    Image images;

    public boolean encode(OutputStream outputStream) {
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            dataOutputStream.writeInt(this.x);
            dataOutputStream.writeInt(this.y);
            dataOutputStream.writeInt(this.fx);
            dataOutputStream.writeInt(this.fy);
            dataOutputStream.writeInt(this.face);
            dataOutputStream.writeInt(this.step);
            dataOutputStream.writeInt(this.startX);
            dataOutputStream.writeInt(this.startY);
            dataOutputStream.writeInt(this.lastFX);
            dataOutputStream.writeInt(this.lastFY);
            dataOutputStream.writeInt(this.lives);
            dataOutputStream.writeInt(this.bombs);
            dataOutputStream.writeInt(this.flames);
            dataOutputStream.writeInt(this.speed);
            dataOutputStream.writeInt(this.points);
            dataOutputStream.writeInt(this.bonus);
            dataOutputStream.writeInt(this.invinc);
            dataOutputStream.writeByte(this.mode);
            dataOutputStream.writeByte(this.extra);
            dataOutputStream.writeByte(this.exCnt);
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
    }

    public boolean decode(InputStream inputStream) {
        try {
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            this.x = dataInputStream.readInt();
            this.y = dataInputStream.readInt();
            this.fx = dataInputStream.readInt();
            this.fy = dataInputStream.readInt();
            this.face = dataInputStream.readInt();
            this.step = dataInputStream.readInt();
            this.startX = dataInputStream.readInt();
            this.startY = dataInputStream.readInt();
            this.lastFX = dataInputStream.readInt();
            this.lastFY = dataInputStream.readInt();
            this.lives = dataInputStream.readInt();
            this.bombs = dataInputStream.readInt();
            this.flames = dataInputStream.readInt();
            this.speed = dataInputStream.readInt();
            this.points = dataInputStream.readInt();
            this.bonus = dataInputStream.readInt();
            this.invinc = dataInputStream.readInt();
            this.mode = dataInputStream.readByte();
            this.extra = dataInputStream.readByte();
            this.exCnt = dataInputStream.readByte();
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
    }

    public Player(GameScreen gameScreen) {
        this.gameScreen = gameScreen;
        this.images = GameMidlet.getImage("aikia");
    }

    public Image getImage() {
        return this.images;
    }

    public void givePoints(int n) {
        this.bonus = 20;
        this.points += n;
    }

    public void reset() {
        this.points = 0;
        this.startX = 0;
        this.startY = 0;
        this.lives = 3;
        this.bombs = 3;
        this.flames = 2;
        this.speed = 6;
        this.extra = (byte)28;
        this.exCnt = (byte)2;
        this.resetPos();
    }

    public void resetPos() {
        this.x = this.startX;
        this.y = this.startY;
        this.fx = this.lastFX = this.playfield.getGridX(this.x);
        this.fy = this.lastFY = this.playfield.getGridY(this.y);
        this.face = 0;
        this.step = 0;
        this.speed = 6;
        this.mode = 0;
        this.powerUp = false;
        this.fireExtra = false;
        this.fire = false;
        this.moveRight = false;
        this.moveLeft = false;
        this.moveDown = false;
        this.moveUp = false;
        this.fireExtraOnce = false;
        this.fireOnce = false;
        this.moveRightOnce = false;
        this.moveLeftOnce = false;
        this.moveDownOnce = false;
        this.moveUpOnce = false;
    }

    public void kill() {
        if (this.invinc > 0) {
            return;
        }
        Effects.playSound2();
        Effects.vibrate();
        this.mode = 1;
        this.step = 0;
    }

    public void update() {
        int n;
        block56: {
            block58: {
                block57: {
                    if (this.mode == 2) {
                        this.gameScreen.mode = 5;
                        return;
                    }
                    if (this.mode == 1) {
                        ++this.step;
                        if (this.step == 28) {
                            --this.lives;
                            if (this.lives > 0) {
                                this.extra = 0;
                                this.exCnt = 0;
                                this.playfield.trace[this.fy][this.fx] = -1;
                                this.resetPos();
                                this.invinc = 40;
                            } else {
                                this.mode = (byte)2;
                                this.gameScreen.mode = 5;
                            }
                        }
                        return;
                    }
                    if (this.invinc > 0) {
                        --this.invinc;
                    }
                    n = 5;
                    this.fx = this.playfield.getGridX(this.x + n);
                    this.fy = this.playfield.getGridY(this.y + n);
                    int n2 = (this.x + n) % 10;
                    int n3 = (this.y + n) % 10;
                    boolean bl = false;
                    byte by = this.playfield.passThrough(this.fx, this.fy, true);
                    if (by == 31 && this.flames < 7) {
                        ++this.flames;
                    } else if (by == 30 && this.bombs < 7) {
                        ++this.bombs;
                    } else if (by == 11) {
                        this.gameScreen.levelClear();
                    } else if (by == 10) {
                        if (!this.gameScreen.godmode) {
                            this.kill();
                        }
                    } else if (by == 37) {
                        this.givePoints(50);
                    } else if (by >= 32 && by <= 35) {
                        if (this.extra == by) {
                            this.exCnt = (byte)(this.exCnt + 3);
                        } else {
                            this.exCnt = (byte)3;
                            this.extra = (byte)(by - 6);
                        }
                    }
                    if (this.powerUp) {
                        ++this.bombs;
                        ++this.flames;
                        this.powerUp = false;
                    }
                    if (this.moveDown || this.moveDownOnce) {
                        this.face = 0;
                        this.moveDownOnce = false;
                        this.moveUpOnce = false;
                        this.moveLeftOnce = false;
                        this.moveRightOnce = false;
                        if (n2 == n && n3 < n) {
                            this.y += Math.min(this.speed, n - n3);
                            bl = true;
                        } else if (this.playfield.isPassable(this.fx, this.fy + 1, -2)) {
                            if (n2 == n) {
                                this.y += this.speed;
                            } else {
                                this.x = n2 > n ? (this.x -= Math.min(this.speed, n2 - n)) : (this.x += Math.min(this.speed, n - n2));
                            }
                            bl = true;
                        }
                    }
                    if ((this.moveUp || this.moveUpOnce) && !bl) {
                        this.face = 2;
                        this.moveDownOnce = false;
                        this.moveUpOnce = false;
                        this.moveLeftOnce = false;
                        this.moveRightOnce = false;
                        if (n2 == n && n3 > n) {
                            this.y -= Math.min(this.speed, n3 - n);
                            bl = true;
                        } else if (this.playfield.isPassable(this.fx, this.fy - 1, -2)) {
                            if (n2 == n) {
                                this.y -= this.speed;
                            } else {
                                this.x = n2 > n ? (this.x -= Math.min(this.speed, n2 - n)) : (this.x += Math.min(this.speed, n - n2));
                            }
                            bl = true;
                        }
                    }
                    if ((this.moveRight || this.moveRightOnce) && !bl) {
                        this.face = 3;
                        this.moveDownOnce = false;
                        this.moveUpOnce = false;
                        this.moveLeftOnce = false;
                        this.moveRightOnce = false;
                        if (n3 == n && n2 < n) {
                            this.x += Math.min(this.speed, n - n2);
                            bl = true;
                        } else if (this.playfield.isPassable(this.fx + 1, this.fy, -2)) {
                            if (n3 == n) {
                                this.x += this.speed;
                            } else {
                                this.y = n3 > n ? (this.y -= Math.min(this.speed, n3 - n)) : (this.y += Math.min(this.speed, n - n3));
                            }
                            bl = true;
                        }
                    }
                    if ((this.moveLeft || this.moveLeftOnce) && !bl) {
                        this.face = 1;
                        this.moveDownOnce = false;
                        this.moveUpOnce = false;
                        this.moveLeftOnce = false;
                        this.moveRightOnce = false;
                        if (n3 == n && n2 > n) {
                            this.x -= Math.min(this.speed, n2 - n);
                            bl = true;
                        } else if (this.playfield.isPassable(this.fx - 1, this.fy, -2)) {
                            if (n3 == n) {
                                this.x -= this.speed;
                            } else {
                                this.y = n3 > n ? (this.y -= Math.min(this.speed, n3 - n)) : (this.y += Math.min(this.speed, n - n3));
                            }
                            bl = true;
                        }
                    }
                    if (bl) {
                        ++this.step;
                        if (this.step == 8) {
                            this.step = 0;
                        }
                    }
                    if (this.fire || this.fireOnce) {
                        this.playfield.setBomb((byte)25, this.fx, this.fy, 32);
                        this.fireOnce = false;
                    }
                    if (!this.fireExtra && !this.fireExtraOnce) break block56;
                    if (this.extra == 27) break block57;
                    if (this.extra == 26) break block57;
                    if (this.extra == 28) break block57;
                    if (this.extra != 29) break block58;
                }
                if (this.playfield.setBomb(this.extra, this.fx, this.fy, 32)) {
                    this.exCnt = (byte)(this.exCnt - 1);
                }
                if (this.exCnt == 0) {
                    this.extra = 0;
                }
            }
            this.fireExtraOnce = false;
        }
        this.fx = this.playfield.getGridX(this.x + n);
        this.fy = this.playfield.getGridY(this.y + n);
        if (this.fx != this.lastFX) {
            int n4 = this.playfield.trace[this.lastFY][this.lastFX] = this.lastFX < this.fx ? 3 : 1;
        }
        if (this.fy != this.lastFY) {
            this.playfield.trace[this.lastFY][this.lastFX] = this.lastFY < this.fy ? 0 : 2;
        }
        this.lastFX = this.fx;
        this.lastFY = this.fy;
    }

    static {
        FACE_DOWN = 0;
        FACE_LEFT = 1;
        FACE_UP = (byte)2;
        FACE_RIGHT = (byte)3;
        STEPS = new int[]{0, 1, 2, 1, 0, 3, 4, 3};
        NONE = 0;
        MODE_NORMAL = 0;
        MODE_DYING = 1;
        MODE_DEAD = (byte)2;
    }
}

