/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;

class TruckCanvas
extends GameCanvas
implements Runnable {
    private static final int MILLIS_PER_TICK = 50;
    private final TruckMIDlet midlet;
    public final Depo depo;
    private final Truck truck;
    private final LayerManager layerManager;
    private final Graphics graphics;
    private final Font font;
    private long gameDuration;
    private long startTime;
    private long TT;
    private volatile Thread animationThread = null;
    private long time;
    private long timeLeft;
    private long fullTime;
    private static final int BLACK = 0;
    private static final int WHITE = 0xFFFFFF;
    private static final int RED = 0xFF0000;
    private static final int GREEN = 65280;
    private static final int PINK = 0xFF5555;
    private static final int BLUE = 255;
    private static final int YELLOW = 0xFFFF00;
    private static final int GRAY = 0x888888;
    private boolean gameOver;
    private int gameOverTick;
    private int userOffsetX;
    private int userOffsetY;
    private int maxUserOffset;
    private boolean scrollMode;
    private Image eyePic;
    private int key;
    private boolean againtsBestTime;
    private int currentLevel;
    private int vibrationTick = 0;

    TruckCanvas(TruckMIDlet truckMIDlet) {
        super(true);
        this.midlet = truckMIDlet;
        this.setFullScreenMode(true);
        this.graphics = this.getGraphics();
        this.font = Font.getFont((int)0, (int)0, (int)8);
        this.graphics.setFont(this.font);
        this.eyePic = TruckMIDlet.createImage("/eye2.png");
        this.layerManager = new LayerManager();
        this.depo = new Depo();
        this.truck = new Truck(this);
        this.layerManager.append((Layer)this.depo);
        this.init();
    }

    public void keyPressed(int n) {
        if (n < 0) {
            this.stop();
            if (this.gameOver) {
                if (this.truck.getLevelDone() && !this.midlet.againstBestTime) {
                    this.midlet.showNextLevelMenuList();
                } else {
                    this.midlet.showGameMenuListWithoutResume();
                }
            } else {
                this.midlet.showGameMenuListWithResume();
            }
        } else if (n == 42) {
            this.scrollMode = true;
        } else if (n == 35) {
            this.scrollMode = false;
        }
    }

    void init() {
        if (this.midlet.againstBestTime) {
            this.currentLevel = this.midlet.hitBestTimeLevel;
            this.depo.init(this.currentLevel);
            this.fullTime = this.midlet.bestTimes[this.midlet.hitBestTimeLevel - 1];
        } else {
            this.currentLevel = this.midlet.currentLevel;
            this.depo.init(this.currentLevel);
            this.fullTime = this.depo.getFullTime();
        }
        this.truck.setStartPosition(this.depo);
        this.gameDuration = 0L;
        this.gameOver = false;
        this.scrollMode = false;
        this.userOffsetX = 0;
        this.userOffsetY = 0;
        this.maxUserOffset = (int)(this.truck.coachLength * 1.3);
    }

    public synchronized void start() {
        this.animationThread = new Thread(this);
        this.animationThread.start();
        this.startTime = System.currentTimeMillis() - this.gameDuration;
    }

    public synchronized void stop() {
        this.gameDuration = System.currentTimeMillis() - this.startTime;
        this.animationThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread thread = Thread.currentThread();
        try {
            while (thread == this.animationThread) {
                long l;
                long l2 = System.currentTimeMillis();
                if (this.isShown()) {
                    if (!this.gameOver) {
                        this.tick();
                    }
                    this.draw();
                    this.flushGraphics();
                }
                this.TT = l = System.currentTimeMillis() - l2;
                if (l < 50L) {
                    TruckCanvas truckCanvas = this;
                    synchronized (truckCanvas) {
                        this.wait(50L - l);
                        continue;
                    }
                }
                thread.yield();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void tick() {
        int n = this.getKeyStates();
        if ((n & 4) != 0) {
            if (this.scrollMode) {
                this.userOffsetX -= 5;
            } else {
                this.truck.goLeft();
            }
        }
        if ((n & 0x20) != 0) {
            if (this.scrollMode) {
                this.userOffsetX += 5;
            } else {
                this.truck.goRight();
            }
        }
        if ((n & 2) != 0) {
            if (this.scrollMode) {
                this.userOffsetY -= 5;
            } else {
                this.truck.forward();
            }
        }
        if ((n & 0x40) != 0) {
            if (this.scrollMode) {
                this.userOffsetY += 5;
            } else {
                this.truck.back();
            }
        }
        if ((n & 0x100) != 0) {
            if (this.scrollMode) {
                this.userOffsetX = 0;
                this.userOffsetY = 0;
            } else {
                this.truck.brake();
            }
        }
        if ((n & 0x800) != 0) {
            this.scrollMode = true;
        }
        if ((n & 0x1000) != 0) {
            this.scrollMode = false;
        }
        this.key = n;
        this.truck.tick();
        this.depo.tick(this.truck.getPercentLoaded() == 100);
        this.time = (System.currentTimeMillis() - this.startTime) / 1000L;
        this.timeLeft = this.fullTime - this.time;
        if (this.truck.checkCollision(this.depo) || this.timeLeft <= 0L) {
            this.gameOver = true;
        }
        if (this.truck.getLevelDone()) {
            this.midlet.setBestTimes(this.currentLevel, this.time);
            this.gameOver = true;
        }
        if (this.midlet.vibrationOn && this.truck.collision) {
            if (this.vibrationTick++ % 8 == 0) {
                this.vibrate(200);
            }
        } else {
            this.vibrationTick = 0;
        }
    }

    Depo getDepo() {
        return this.depo;
    }

    Truck getTruck() {
        return this.truck;
    }

    void vibrate(int n) {
        this.midlet.vibrate(n);
    }

    private void draw() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = this.font.getHeight() - 1;
        this.graphics.setColor(0x8888FF);
        this.graphics.fillRect(0, 0, n, n2);
        if (this.userOffsetX > this.maxUserOffset) {
            this.userOffsetX = this.maxUserOffset;
        }
        if (this.userOffsetX < -this.maxUserOffset) {
            this.userOffsetX = -this.maxUserOffset;
        }
        if (this.userOffsetY > this.maxUserOffset) {
            this.userOffsetY = this.maxUserOffset;
        }
        if (this.userOffsetY < -this.maxUserOffset) {
            this.userOffsetY = -this.maxUserOffset;
        }
        int n4 = this.origin(this.truck.getMiddleX() + this.userOffsetX, this.depo.getCurrentWidth(), n);
        int n5 = this.origin(this.truck.getMiddleY() + this.userOffsetY, this.depo.getCurrentHeight(), n2 - 11 - n3);
        this.graphics.setClip(n4, n5, this.depo.getCurrentWidth(), this.depo.getCurrentHeight());
        this.graphics.translate(n4, n5);
        this.layerManager.paint(this.graphics, 0, 0);
        this.truck.drawTruck(this.graphics, n, n2);
        if (this.scrollMode) {
            this.graphics.drawImage(this.eyePic, this.truck.getMiddleX() + this.userOffsetX, this.truck.getMiddleY() + this.userOffsetY, 3);
        }
        this.graphics.translate(-n4, -n5);
        this.graphics.setClip(0, 0, n, n2);
        this.truck.drawLoadingText(this.graphics, n, n2);
        this.drawStrips(n, n2);
    }

    public void drawStrips(int n, int n2) {
        int n3 = this.font.getHeight() - 1;
        double d = this.truck.getSteerAngle();
        double d2 = this.truck.getSpeed();
        double d3 = this.truck.getCollisionValue();
        this.graphics.setColor(0x8888FF);
        this.graphics.fillRect(0, n2 - 11 - n3, n, n2);
        this.graphics.setColor(0xFFFFFF);
        double d4 = n / 2 - 20;
        this.graphics.fillRect(10, n2 - 9 - n3, (int)d4, 3);
        this.graphics.fillRect(10, n2 - 4 - n3, (int)d4, 3);
        this.graphics.fillRect((int)((double)(n - 10) - d4), n2 - 9 - n3, (int)d4, 3);
        this.graphics.fillRect((int)((double)(n - 10) - d4), n2 - 4 - n3, (int)d4, 3);
        this.graphics.setColor(65280);
        double d5 = d * d4 / 2.0 + d4 / 2.0;
        this.graphics.fillRect((int)Math.min(10.0 + d5, 10.0 + d4 / 2.0), n2 - 9 - n3, Math.abs((int)d5 - (int)(d4 / 2.0)), 3);
        d5 = d2 * d4 / 2.0 + d4 / 2.0;
        this.graphics.fillRect((int)Math.min((double)(n - 10) - d4 + d5, (double)(n - 10) - d4 + d4 / 2.0), n2 - 9 - n3, Math.abs((int)d5 - (int)(d4 / 2.0)), 3);
        if (d3 < 0.75) {
            this.graphics.setColor(0xFF5555);
        } else {
            this.graphics.setColor(0xFF0000);
        }
        d5 = d3 * d4;
        this.graphics.fillRect(10, n2 - 4 - n3, (int)d5, 3);
        if (this.timeLeft > 25L) {
            this.graphics.setColor(0xFF5555);
        } else {
            this.graphics.setColor(0xFF0000);
        }
        d4 = n / 2 - 20;
        d5 = (double)this.timeLeft / (double)this.fullTime * d4;
        this.graphics.fillRect((int)((double)(n - 10) - d4), n2 - 4 - n3, (int)d5, 3);
        this.graphics.setColor(0);
        this.graphics.drawLine((int)(10.0 + d4 / 2.0), n2 - 9 - n3, (int)(10.0 + d4 / 2.0), n2 - 6 - n3);
        this.graphics.drawLine((int)((double)(n - 10) - d4 + d4 / 2.0), n2 - 9 - n3, (int)((double)(n - 10) - d4 + d4 / 2.0), n2 - 6 - n3);
        if (this.gameOver) {
            if (this.truck.getLevelDone()) {
                String string;
                String string2;
                String string3;
                if (this.midlet.againstBestTime) {
                    string3 = this.timeLeft == 0L ? "Same best time!" : "New best time!";
                    string2 = "elapsed time:" + Integer.toString((int)(this.fullTime - this.timeLeft)) + "s";
                    string = "Press a soft-key";
                } else {
                    string3 = "Level done!";
                    string2 = "elapsed time:" + Integer.toString((int)(this.fullTime - this.timeLeft)) + "s";
                    string = "Press a soft-key";
                }
                int n4 = Math.max(this.font.stringWidth(string3), this.font.stringWidth(string2));
                n4 = Math.max(n4, this.font.stringWidth(string));
                this.graphics.setColor(0x8888FF);
                this.graphics.fillRect((int)((double)n / 2.0 - (double)n4 / 2.0 - 5.0), (int)((double)n2 / 2.0 - (double)n3 - 3.0), n4 + 10, 3 * n3 + 10);
                this.graphics.setColor(0xFFFFFF);
                this.graphics.drawString(string3, (int)((double)n) / 2, (int)((double)n2) / 2, 65);
                this.graphics.drawString(string2, (int)((double)n) / 2, (int)((double)n2) / 2 + 2, 17);
                this.graphics.drawString(string, (int)((double)n) / 2, (int)((double)n2) / 2 + this.font.getHeight() + 2, 17);
            } else {
                this.graphics.setColor(0x8888FF);
                this.graphics.fillRect((int)((double)n / 2.0 - (double)this.font.stringWidth("Press a soft-key") / 2.0 - 5.0), (int)((double)n2 / 2.0 - (double)n3 - 3.0), this.font.stringWidth("Press a soft-key") + 10, 2 * n3 + 10);
                this.graphics.setColor(0xFFFFFF);
                this.graphics.drawString("GAME OVER", (int)((double)n) / 2, (int)((double)n2) / 2, 65);
                this.graphics.drawString("Press a soft-key", (int)((double)n) / 2, (int)((double)n2) / 2 + 2, 17);
            }
        }
        this.graphics.setColor(0xFFFFFF);
        if (this.timeLeft == 0L && ++this.gameOverTick % 8 < 4) {
            this.graphics.setColor(0xFF0000);
        }
        this.graphics.drawString("time:" + Integer.toString((int)this.timeLeft) + "s", (int)((double)(n - 10) - d4 / 2.0), n2, 33);
        this.graphics.setColor(0xFFFFFF);
        if (d3 == 1.0 && ++this.gameOverTick % 8 < 4) {
            this.graphics.setColor(0xFF0000);
        }
        this.graphics.drawString("damage:" + Integer.toString((int)(d3 * 100.0)) + "%", (int)(10.0 + d4 / 2.0), n2, 33);
    }

    private int origin(int n, int n2, int n3) {
        int n4 = n3 >= n2 ? (n3 - n2) / 2 : (n <= n3 / 2 ? 0 : (n >= n2 - n3 / 2 ? n3 - n2 : n3 / 2 - n));
        return n4;
    }
}

